/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.learn;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.BZWaveThermostat;
import com.tridium.zwave.association.BZWaveAssociationDeviceExt;
import com.tridium.zwave.cmdclass.BNodeInformation;
import com.tridium.zwave.comm.serial.BZWaveSerialPlugIn;
import com.tridium.zwave.enums.BGenericDeviceEnum;
import com.tridium.zwave.learn.BZWaveDeviceEntry;
import com.tridium.zwave.messages.SerialApiRequest;
import com.tridium.zwave.messages.SerialGetNodeProtocolInfo;
import com.tridium.zwave.messages.SerialIsFailedNode;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.messages.ZWaveSerialApiRequest;
import com.tridium.zwave.messages.ZWaveSerialFrame;
import com.tridium.zwave.util.BZWaveApiParam;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.log.Log;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveLearnDevicesJob
extends BSimpleJob
implements ZWaveMessageConst {
    public static final Property learnedDevices = BZWaveLearnDevicesJob.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Type TYPE;
    public static boolean isRunning;
    public static boolean DEVICE_SCAN_ONLY;
    public static Log ldLog;
    boolean jobCanceled;
    BZWaveNetwork network;
    byte[] nodesBitMap;
    boolean isDeviceScanOnly;
    static /* synthetic */ Class class$com$tridium$zwave$learn$BZWaveLearnDevicesJob;
    static /* synthetic */ Class class$com$tridium$zwave$BZWaveDevice;
    static /* synthetic */ Class class$com$tridium$zwave$association$BZWaveAssociationDeviceExt;

    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    public void setLearnedDevices(BFolder bFolder) {
        this.set(learnedDevices, (BValue)bFolder, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doCancel(Context context) {
        super.doCancel(context);
        this.jobCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run(Context var1_1) throws Exception {
        if (BZWaveLearnDevicesJob.isRunning) {
            throw new RuntimeException("Learn Job already running.");
        }
        try {
            BZWaveLearnDevicesJob.isRunning = true;
            this.getLearnedDevices().removeAll();
            var4_2 = null;
            var5_4 = null;
            var6_5 = null;
            this.network.doSendSerialApiRequest(new BZWaveApiParam(5));
            try {
                Thread.sleep(200L);
            }
            catch (Exception v0) {}
            var6_5 = new ZWaveSerialApiRequest(0, 2, null);
            var7_6 = (ZWaveSerialFrame)this.network.sendZWaveSync(new ZWaveSerialFrame(var6_5, true));
            var8_7 = new ZWaveInputStream(var7_6.getData(), 0, var7_6.getLength());
            var8_7.read();
            var8_7.read();
            var9_8 = var8_7.readByte();
            var8_7.readByte();
            var10_9 = var8_7.readByte();
            v1 = false;
            if ((var10_9 & 4) == 0) {
                v1 = true;
            }
            this.network.setIsPrimaryController(v1);
            var8_7.readByte();
            var11_10 = 0;
            while (true) {
                block49: {
                    if (var11_10 < 29) break block49;
                    var6_5 = new ZWaveSerialApiRequest(0, 32, null);
                    var7_6 = (ZWaveSerialFrame)this.network.sendZWaveSync(new ZWaveSerialFrame(var6_5, true));
                    var8_7 = new ZWaveInputStream(var7_6.getData(), 0, var7_6.getLength());
                    var8_7.read();
                    var8_7.read();
                    var9_8 = var8_7.readByte();
                    var11_11 = var8_7.readU32();
                    var13_12 = var8_7.readByte();
                    this.network.setHomeId(var11_11);
                    this.network.setInterfaceNodeId(var13_12);
                    BZWaveLearnDevicesJob.ldLog.trace("homeId = 0x" + Long.toHexString(var11_11));
                    BZWaveLearnDevicesJob.ldLog.trace("nodeId = 0x" + Integer.toHexString(var13_12));
                    this.log().message("scanning interface for devices");
                    var14_13 = 1;
                    if (true) ** GOTO lbl136
                }
                this.nodesBitMap[var11_10] = (byte)var8_7.readByte();
                ++var11_10;
            }
            do {
                block48: {
                    if (this.jobCanceled) {
                        this.log().message("Job Canceled");
                        throw new JobCancelException();
                    }
                    this.progress(50 * var14_13 / 232);
                    try {
                        if (var14_13 == var13_12) {
                            BZWaveLearnDevicesJob.ldLog.trace("installing node is not included: " + var14_13);
                            this.log().message("     " + var14_13 + ": interface node not included");
                            this.clearNodeMap(var14_13 - 1);
                            break block48;
                        }
                        if (!this.isNodeMapped(var14_13 - 1)) break block48;
                        var4_2 = new SerialGetNodeProtocolInfo(var14_13);
                        var7_6 = (ZWaveSerialFrame)this.network.sendZWaveSync(new ZWaveSerialFrame(var4_2, true));
                        var8_7 = new ZWaveInputStream(var7_6.getData(), 0, var7_6.getLength());
                        var8_7.read();
                        var8_7.read();
                        var9_8 = var8_7.read() & 255;
                        v2 = 0;
                        if ((var8_7.read() & 128) != 0) {
                            v2 = 1;
                        }
                        var15_15 = v2;
                        v3 = false;
                        if ((var8_7.read() & 128) != 0) {
                            v3 = true;
                        }
                        var16_17 = v3;
                        var8_7.read();
                        var17_20 = new BNodeInformation();
                        var17_20.setIsListening((boolean)var15_15);
                        var17_20.setOptionalFunctionality(var16_17);
                        var17_20.readData(var8_7);
                        var18_21 /* !! */  = null;
                        if (var17_20.getGenericDeviceClass().equals((Object)BGenericDeviceEnum.genericThermostat)) {
                            var18_21 /* !! */  = (byte[])new BZWaveThermostat();
                        } else {
                            if (!var17_20.isControlledDevice()) {
                                this.log().message("     " + var14_13 + ": " + var17_20 + ": Controller device not included");
                                this.clearNodeMap(var14_13 - 1);
                                break block48;
                            }
                            var18_21 /* !! */  = (byte[])new BZWaveDevice();
                        }
                        this.log().message("     " + var14_13 + ": " + var17_20);
                        var18_21 /* !! */ .setNodeId(var14_13);
                        var18_21 /* !! */ .setNodeInfo((BNodeInformation)var17_20);
                        if (var18_21 /* !! */ .getNodeInfo().isDefined()) {
                            BZWaveLearnDevicesJob.ldLog.trace("processing device: " + var14_13 + " nodeInfo = " + var17_20.toString(null));
                            var5_4 = new SerialIsFailedNode(var14_13);
                            var7_6 = (ZWaveSerialFrame)this.network.sendZWaveSync(new ZWaveSerialFrame(var5_4, true));
                            var8_7 = new ZWaveInputStream(var7_6.getData(), 0, var7_6.getLength());
                            var8_7.read();
                            var8_7.read();
                            var8_7.read();
                            var19_22 = var8_7.read() & 255;
                            v4 = false;
                            if (var19_22 != 0) {
                                v4 = var20_23 = true;
                            }
                            if (!this.isDeviceScanOnly) {
                                var21_25 = this.network.getDevice(var14_13);
                                if (var21_25 != null) {
                                    var21_25.getNodeInfo().copyFrom((BComplex)var18_21 /* !! */ .getNodeInfo());
                                } else {
                                    this.network.add("node_" + var14_13, (BValue)((BZWaveDevice)var18_21 /* !! */ .newCopy()));
                                    this.log().message("     " + var14_13 + ": added device to station.");
                                }
                            }
                            this.getLearnedDevices().add("node_" + var14_13, (BValue)new BZWaveDeviceEntry(var14_13, (BNodeInformation)var17_20, var20_23));
                        } else {
                            var18_21 /* !! */  = null;
                        }
                    }
                    catch (Exception var15_16) {
                        var15_16.printStackTrace();
                    }
                }
                ++var14_13;
lbl136:
                // 2 sources

            } while (var14_13 <= 232);
            this.log().message("scanning interface for devices complete.");
            this.log().message("read nodeInfo from station devices.");
            v5 = BZWaveLearnDevicesJob.class$com$tridium$zwave$BZWaveDevice;
            if (v5 == null) {
                v5 = BZWaveLearnDevicesJob.class$com$tridium$zwave$BZWaveDevice = BZWaveLearnDevicesJob.class("[Lcom.tridium.zwave.BZWaveDevice;", false);
            }
            var14_14 = (BZWaveDevice[])this.network.getChildren(v5);
            var15_15 = 0;
            while (var15_15 < var14_14.length) {
                if (this.jobCanceled) {
                    this.log().message("Job Canceled");
                    throw new JobCancelException();
                }
                if (!this.isNodeMapped(var14_14[var15_15].getNodeId() - 1)) {
                    var14_14[var15_15].configFail("Device not known by network");
                } else {
                    var14_14[var15_15].configOk();
                }
                if (!var14_14[var15_15].isDisabled() && !var14_14[var15_15].isDown() && var14_14[var15_15].getNodeId() > 0) {
                    this.log().message("     " + var14_14[var15_15].getDisplayName(var1_1));
                    var16_18 = this.network.getCommPlugIn();
                    if (var16_18 instanceof BZWaveSerialPlugIn && (var17_20 = (BZWaveSerialPlugIn)var16_18).isFunctionSupported(128)) {
                        var18_21 /* !! */  = new byte[]{(byte)var14_14[var15_15].getNodeId(), 1, 1};
                        var6_5 = new SerialApiRequest(128, var18_21 /* !! */ );
                        var7_6 = (ZWaveSerialFrame)this.network.sendZWaveSync(new ZWaveSerialFrame(var6_5, true));
                        if (var7_6 == null) {
                            this.log().message("unable to read routing table from device: " + var14_14[var15_15].getName());
                        } else {
                            var8_7 = new ZWaveInputStream(var7_6.getData(), 0, var7_6.getLength());
                            var8_7.read();
                            var8_7.read();
                            var9_8 = var8_7.readByte();
                            var14_14[var15_15].setNeighborInfo(BBlob.make((byte[])var7_6.getData(), (int)3, (int)var8_7.available()));
                        }
                    }
                    this.progress(50 + 25 * var15_15 / var14_14.length);
                    var14_14[var15_15].getNodeInfo().set(BNodeInformation.cmdClassesRaw, (BValue)BBlob.DEFAULT, Context.decoding);
                    var14_14[var15_15].doRequestNodeInfo((BJob)this);
                    if (var14_14[var15_15].isFault()) {
                        var17_20 = "unable read nodeInfo from device: " + var14_14[var15_15].getName();
                        this.log().message("     " + (String)var17_20);
                        BZWaveLearnDevicesJob.ldLog.trace((String)var17_20);
                    } else {
                        var17_20 = BZWaveDevice.createCmdClassComponentsLock;
                        v6 = var17_20;
                        var18_21 /* !! */  = (byte[])v6;
                        // MONITORENTER : v6
                        BZWaveLearnDevicesJob.ldLog.trace("==============================");
                        BZWaveLearnDevicesJob.ldLog.trace("started wait(60Seconds) on createCmdClassComponentsLock: " + Clock.ticks());
                        var20_24 = Clock.ticks();
                        var17_20.wait(60000L);
                        BZWaveLearnDevicesJob.ldLog.trace("ended wait(60Seconds) on createCmdClassComponentsLock: deltaT = " + (Clock.ticks() - var20_24));
                        BZWaveLearnDevicesJob.ldLog.trace("==============================");
                        // MONITOREXIT : var18_21 /* !! */ 
                    }
                }
                ++var15_15;
            }
            this.log().message("read nodeInfo from station devices complete.");
            if (this.isDeviceScanOnly) {
                var3_26 = null;
                BZWaveLearnDevicesJob.isRunning = false;
                return;
            }
            this.log().message("read associations from station devices.");
            var15_15 = 0;
            while (var15_15 < var14_14.length) {
                if (this.jobCanceled) {
                    this.log().message("Job Canceled");
                    throw new JobCancelException();
                }
                if (!var14_14[var15_15].isDisabled()) {
                    this.progress(75 + 25 * var15_15 / var14_14.length);
                    v8 = var14_14[var15_15];
                    v9 = BZWaveLearnDevicesJob.class$com$tridium$zwave$association$BZWaveAssociationDeviceExt;
                    if (v9 == null) {
                        v9 = BZWaveLearnDevicesJob.class("[Lcom.tridium.zwave.association.BZWaveAssociationDeviceExt;", false);
                    }
                    if ((var16_19 = (BZWaveAssociationDeviceExt[])v8.getChildren(v9)) != null && var16_19.length > 0) {
                        this.log().message("     " + var14_14[var15_15].getDisplayName(var1_1));
                        var16_19[0].doReadGroup(BInteger.make((int)0));
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception v10) {}
                }
                ++var15_15;
            }
            this.log().message("read associations complete.");
            var3_28 = null;
            BZWaveLearnDevicesJob.isRunning = false;
            return;
        }
        catch (Throwable var2_29) {
            var3_27 = null;
            BZWaveLearnDevicesJob.isRunning = false;
            throw var2_29;
        }
    }

    public boolean isNodeMapped(int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        int n4 = 1 << n % 8;
        boolean bl = false;
        if ((this.nodesBitMap[n2] & n4) != 0) {
            bl = true;
        }
        return bl;
    }

    public void clearNodeMap(int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        int n4 = 1 << n % 8;
        this.nodesBitMap[n2] = (byte)(this.nodesBitMap[n2] & ~n4);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.jobCanceled = false;
        this.nodesBitMap = new byte[29];
        this.isDeviceScanOnly = false;
    }

    public BZWaveLearnDevicesJob() {
        this.this();
        this.network = null;
    }

    public BZWaveLearnDevicesJob(BZWaveNetwork bZWaveNetwork) {
        this.this();
        this.network = bZWaveNetwork;
        this.isDeviceScanOnly = false;
    }

    public BZWaveLearnDevicesJob(BZWaveNetwork bZWaveNetwork, boolean bl) {
        this.this();
        this.network = bZWaveNetwork;
        this.isDeviceScanOnly = bl;
    }

    static {
        Class clazz = class$com$tridium$zwave$learn$BZWaveLearnDevicesJob;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$learn$BZWaveLearnDevicesJob = BZWaveLearnDevicesJob.class("[Lcom.tridium.zwave.learn.BZWaveLearnDevicesJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        isRunning = false;
        DEVICE_SCAN_ONLY = true;
        ldLog = Log.getLog((String)"zwave.learnDevices");
    }
}

