/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.config;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.cmdclass.ZwCommandClass;
import com.tridium.zwave.messages.SerialSendData;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.util.BZWaveConfigData;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveConfigDeviceExt
extends BDeviceExt
implements ZWaveMessageConst,
BIDeviceFolder {
    public static final Property maxNumberConfigProperties = BZWaveConfigDeviceExt.newProperty((int)0, (int)10, (BFacets)BFacets.makeInt((int)1, (int)255));
    public static final Property request = BZWaveConfigDeviceExt.newProperty((int)3, (String)"", null);
    public static final Property response = BZWaveConfigDeviceExt.newProperty((int)3, (String)"", null);
    public static final Action readConfigData = BZWaveConfigDeviceExt.newAction((int)16, null);
    public static final Action writeConfigData = BZWaveConfigDeviceExt.newAction((int)20, (BValue)BZWaveConfigData.make(0, 0, 0), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private boolean readConfigDataPosted;
    static /* synthetic */ Class class$com$tridium$zwave$config$BZWaveConfigDeviceExt;

    public int getMaxNumberConfigProperties() {
        return this.getInt(maxNumberConfigProperties);
    }

    public void setMaxNumberConfigProperties(int n) {
        this.setInt(maxNumberConfigProperties, n, null);
    }

    public String getRequest() {
        return this.getString(request);
    }

    public void setRequest(String string) {
        this.setString(request, string, null);
    }

    public String getResponse() {
        return this.getString(response);
    }

    public void setResponse(String string) {
        this.setString(response, string, null);
    }

    public void readConfigData() {
        this.invoke(readConfigData, null, null);
    }

    public void writeConfigData(BZWaveConfigData bZWaveConfigData) {
        this.invoke(writeConfigData, (BValue)bZWaveConfigData, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BZWaveDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return null;
    }

    public final BZWaveConfigDeviceExt getDeviceExt() {
        return this;
    }

    public static void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        if (bZWaveDevice.get("configuration") == null) {
            bZWaveDevice.add("configuration", (BValue)new BZWaveConfigDeviceExt());
        }
    }

    public static void processConfiguration(BZWaveDevice bZWaveDevice, int n, ZWaveInputStream zWaveInputStream) {
        int n2 = zWaveInputStream.readByte();
        if (n2 != 6) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ":  Unsupported command for CommandClassConfiguration: 0x" + Integer.toHexString(n2));
            return;
        }
        BZWaveConfigDeviceExt bZWaveConfigDeviceExt = bZWaveDevice.getConfigDeviceExt();
        if (bZWaveConfigDeviceExt == null) {
            return;
        }
        bZWaveConfigDeviceExt.readConfigData(zWaveInputStream);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        BValue bValue = this.get(property);
        if (bValue.getType().is(BZWaveConfigData.TYPE) && context != null) {
            this.writeConfigData((BZWaveConfigData)bValue);
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BZWaveNetwork bZWaveNetwork;
        BZWaveDevice bZWaveDevice;
        if ((action.equals((Object)writeConfigData) || action.equals((Object)readConfigData)) && (bZWaveDevice = (BZWaveDevice)this.getDevice()) != null && (bZWaveNetwork = (BZWaveNetwork)bZWaveDevice.getNetwork()) != null) {
            return bZWaveNetwork.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doWriteConfigData(BZWaveConfigData bZWaveConfigData) {
        BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)this.getNetwork();
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDevice();
        SerialSendData serialSendData = null;
        try {
            this.setRequest("write configData " + bZWaveConfigData.getIndex());
            int n = bZWaveConfigData.getIndex();
            serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), ZwCommandClass.ZW_ConfigurationSetFrame((byte)bZWaveConfigData.getIndex(), bZWaveConfigData.getInt()), 5, false);
            int n2 = bZWaveNetwork.sendDataReq(serialSendData);
            serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), ZwCommandClass.ZW_ConfigurationGetFrame((byte)n), 5);
            n2 = bZWaveNetwork.sendDataReq(serialSendData);
            if (n2 < 0 && !bZWaveDevice.isNodeListening()) {
                this.setResponse("Battery device is not awake, posted request: 0x" + Integer.toHexString(n2));
                bZWaveConfigData.setWriteValue(true);
            } else {
                this.setResponse("Device did not respond to write: " + n);
            }
        }
        catch (Exception exception) {}
    }

    public void doReadConfigData() {
        boolean bl = false;
        BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)this.getNetwork();
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDevice();
        SerialSendData serialSendData = null;
        try {
            int n = 1;
            while (n <= this.getMaxNumberConfigProperties()) {
                this.setRequest("configData " + n + " requested");
                serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), ZwCommandClass.ZW_ConfigurationGetFrame((byte)n), 5);
                int n2 = bZWaveNetwork.sendDataReq(serialSendData);
                if (n2 < 0) {
                    if (n == 1 && !bZWaveDevice.isNodeListening()) {
                        this.setResponse("Battery device is not awake, posted request");
                        this.readConfigDataPosted = true;
                    } else {
                        this.setResponse("Device did not respond to request: " + n);
                    }
                    break;
                }
                this.setRequest("configData " + n + " requested: 0x" + Integer.toHexString(n2));
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    public void checkPostedAction() {
        int n = 1;
        while (n <= this.getMaxNumberConfigProperties()) {
            try {
                BZWaveConfigData bZWaveConfigData = (BZWaveConfigData)this.get("config" + n);
                if (bZWaveConfigData != null && bZWaveConfigData.getWriteValue()) {
                    this.doWriteConfigData(bZWaveConfigData);
                    bZWaveConfigData.setWriteValue(false);
                }
            }
            catch (Exception exception) {}
            ++n;
        }
        if (this.readConfigDataPosted) {
            this.doReadConfigData();
            this.readConfigDataPosted = false;
        }
    }

    public void readConfigData(ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        int n2 = zWaveInputStream.readByte();
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = zWaveInputStream.read();
                break;
            }
            case 2: {
                n3 = zWaveInputStream.read() << 8 | zWaveInputStream.readByte();
                break;
            }
            case 4: {
                n3 = zWaveInputStream.read() << 24 | zWaveInputStream.readByte() << 16 | zWaveInputStream.readByte() << 8 | zWaveInputStream.readByte();
                break;
            }
        }
        try {
            Property property = this.getProperty("config" + n);
            if (property == null) {
                property = this.add("config" + n, (BValue)BZWaveConfigData.make(n, n2, n3));
            } else {
                this.set(property, (BValue)BZWaveConfigData.make(n, n2, n3));
            }
            this.setResponse("configData " + n + " updated");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.readConfigDataPosted = false;
    }

    public BZWaveConfigDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$config$BZWaveConfigDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$config$BZWaveConfigDeviceExt = BZWaveConfigDeviceExt.class("[Lcom.tridium.zwave.config.BZWaveConfigDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"layers.png");
    }
}

