/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.comm.serial;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.comm.ZWaveCommReceiver;
import com.tridium.zwave.comm.ZWaveCommTransmitter;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.messages.ZWaveReceivedMessage;
import javax.baja.log.Log;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZWaveSerialCommReceiver
extends ZWaveCommReceiver
implements ZWaveMessageConst {
    private static final int IDLE = 0;
    private static final int WAIT_SOF = 1;
    private static final int RD_LENGTH = 2;
    private static final int RD_TYPE = 3;
    private static final int RD_COMMAND = 4;
    private static final int RD_DATA = 5;
    private static final int RD_FUNCT_ID = 6;
    private static final int RD_CKSUM = 7;
    private static Log rxLog = Log.getLog((String)"zwave.rx");
    int rxCanCount;
    int rxNakCount;
    int rxMsgCount;
    int rxLrcErrors;

    protected ReceivedMessage receive() throws Exception {
        try {
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 255;
            ZWaveCommTransmitter zWaveCommTransmitter = (ZWaveCommTransmitter)this.getComm().getCommTransmitter();
            block11: while (!bl) {
                int n6 = this.getInputStream().read();
                boolean bl2 = false;
                if (n6 != -1) {
                    bl2 = true;
                }
                boolean bl3 = bl2;
                n6 &= 0xFF;
                if (!bl3) continue;
                switch (this.state) {
                    case 0: {
                        if (n6 != 1) {
                            if (n6 == 24) {
                                ++this.rxCanCount;
                                rxLog.trace("****************************");
                                rxLog.trace("CAN received: transmitted data frame has been dropped.");
                                zWaveCommTransmitter.resendLastMessage();
                                rxLog.trace("****************************");
                                break;
                            }
                            if (n6 == 19) {
                                rxLog.message("0x13 received.");
                                break;
                            }
                            if (n6 == 6) {
                                rxLog.trace("ACK received: ");
                                break;
                            }
                            if (n6 != 21) continue block11;
                            ++this.rxNakCount;
                            rxLog.trace("NAK received: resending last message");
                            zWaveCommTransmitter.resendLastMessage();
                            break;
                        }
                        this.state = 2;
                        n = 0;
                        n5 = 255;
                        break;
                    }
                    case 2: {
                        n = n6 - 1;
                        this.state = 3;
                        this.receiveBuffer.write((int)((byte)n6));
                        n5 ^= n6;
                        break;
                    }
                    case 3: {
                        n2 = n6;
                        this.state = 4;
                        this.receiveBuffer.write((int)((byte)n6));
                        --n;
                        n5 ^= n6;
                        break;
                    }
                    case 4: {
                        n3 = n6;
                        this.state = 5;
                        if (n3 == 19) {
                            this.state = 6;
                        }
                        this.receiveBuffer.write((int)((byte)n6));
                        --n;
                        n5 ^= n6;
                        break;
                    }
                    case 6: {
                        n4 = n6;
                        this.state = 5;
                    }
                    case 5: {
                        this.receiveBuffer.write((int)((byte)n6));
                        if (--n <= 0) {
                            this.state = 7;
                        }
                        n5 ^= n6;
                        break;
                    }
                    case 7: {
                        int n7 = n6;
                        if (n7 != n5) {
                            ++this.rxLrcErrors;
                            rxLog.message("cksum err: 0x" + Integer.toHexString(n7) + " != 0x" + Integer.toHexString(n5));
                            rxLog.message("rxData = " + ByteArrayUtil.toHexString((byte[])this.getResponseBytes()));
                            this.resetBuffers();
                            ((ZWaveCommTransmitter)this.getComm().getCommTransmitter()).sendNak();
                            break;
                        }
                        ++this.rxMsgCount;
                        bl = true;
                        this.tag = new Integer(n3 * 256 + n4);
                    }
                }
            }
            ZWaveReceivedMessage zWaveReceivedMessage = this.getResponseMessage();
            ((ZWaveCommTransmitter)this.getComm().getCommTransmitter()).sendAck();
            return zWaveReceivedMessage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public synchronized byte[] getResponseBytes() {
        byte[] byArray = null;
        if (this.receiveBuffer.getLength() > 0) {
            byte[] byArray2 = this.receiveBuffer.getBytes();
            byArray = new byte[this.receiveBuffer.getLength()];
            int n = 0;
            while (n < this.receiveBuffer.getLength()) {
                byArray[n] = byArray2[n];
                ++n;
            }
        }
        return byArray;
    }

    public synchronized ZWaveReceivedMessage getResponseMessage() {
        byte[] byArray = this.getResponseBytes();
        rxLog.trace("rxData = " + ByteArrayUtil.toHexString((byte[])byArray));
        ZWaveReceivedMessage zWaveReceivedMessage = new ZWaveReceivedMessage(byArray, byArray.length);
        zWaveReceivedMessage.setTag(this.tag);
        this.resetBuffers();
        return zWaveReceivedMessage;
    }

    public int getRxCanCount() {
        return this.rxCanCount;
    }

    public int getRxNakCount() {
        return this.rxNakCount;
    }

    public int getRxLrcErrors() {
        return this.rxLrcErrors;
    }

    public int getRxMsgCount() {
        return this.rxMsgCount;
    }

    private final /* synthetic */ void this() {
        this.rxCanCount = 0;
        this.rxNakCount = 0;
        this.rxMsgCount = 0;
        this.rxLrcErrors = 0;
    }

    public ZWaveSerialCommReceiver() {
        this.this();
    }

    public ZWaveSerialCommReceiver(BZWaveNetwork bZWaveNetwork) {
        this.this();
        this.network = bZWaveNetwork;
    }
}

