/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.comm;

import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialComm;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.messages.ZWaveMessageConst;
import java.io.OutputStream;
import javax.baja.log.Log;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZWaveCommTransmitter
extends CommTransmitter
implements ZWaveMessageConst {
    public static Log imdLog = Log.getLog((String)"zwave.imd");
    public static Log txLog = Log.getLog((String)"zwave.tx");
    protected BZWaveNetwork network;
    private long nextSendTicks;
    private Message lastSentMessage;

    public void writeMessage(Message message) {
        long l = Clock.ticks();
        long l2 = ((BSerialComm)this.network.getCommPlugIn()).getInterMessageDelay().getMillis();
        if (l2 > 0L && l < this.nextSendTicks) {
            imdLog.trace("Intermessage delay invoked: " + (this.nextSendTicks - l));
            try {
                Thread.sleep(this.nextSendTicks - l);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.nextSendTicks = l + l2;
        this.lastSentMessage = message;
        txLog.trace("txData = " + message.toDebugString());
        super.writeMessage(message);
    }

    public void resendLastMessage() {
        if (this.lastSentMessage != null) {
            txLog.trace("resend msg: " + this.lastSentMessage.toDebugString());
            super.writeMessage(this.lastSentMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendAck() {
        txLog.trace("ACK sent:");
        OutputStream outputStream = this.getOutputStream();
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            try {
                outputStream.write(6);
            }
            catch (Exception exception) {}
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendNak() {
        txLog.trace("NAK sent:");
        OutputStream outputStream = this.getOutputStream();
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            try {
                outputStream.write(21);
            }
            catch (Exception exception) {}
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendCan() {
        txLog.trace("CAN sent:");
        OutputStream outputStream = this.getOutputStream();
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            try {
                outputStream.write(24);
            }
            catch (Exception exception) {}
            return;
        }
    }

    public Message getLastSent() {
        return this.lastSentMessage;
    }

    private final /* synthetic */ void this() {
        this.network = null;
        this.nextSendTicks = 0L;
    }

    public ZWaveCommTransmitter() {
        this.this();
    }

    public ZWaveCommTransmitter(BZWaveNetwork bZWaveNetwork) {
        this.this();
        this.network = bZWaveNetwork;
    }
}

