/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.enums.BBasicDeviceEnum;
import com.tridium.zwave.enums.BGenericDeviceEnum;
import com.tridium.zwave.enums.BSpecificDeviceEnum;
import com.tridium.zwave.enums.BZWaveCommandClass;
import com.tridium.zwave.learn.CreatCmdClassComponents;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.util.BCmdClassInfo;
import com.tridium.zwave.util.DeviceClassTable;
import javax.baja.control.BControlPoint;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNodeInformation
extends BCmdClassObject
implements ZWaveMessageConst {
    public static final Property isListening = BNodeInformation.newProperty((int)1, (boolean)true, null);
    public static final Property optionalFunctionality = BNodeInformation.newProperty((int)1, (boolean)true, null);
    public static final Property sensor250ms = BNodeInformation.newProperty((int)1, (boolean)false, null);
    public static final Property sensor1000ms = BNodeInformation.newProperty((int)1, (boolean)false, null);
    public static final Property basicDeviceClass = BNodeInformation.newProperty((int)1, (BValue)BBasicDeviceEnum.undefined, null);
    public static final Property genericDeviceClass = BNodeInformation.newProperty((int)1, (BValue)BGenericDeviceEnum.undefined, null);
    public static final Property specificDeviceClass = BNodeInformation.newProperty((int)1, (BValue)BSpecificDeviceEnum.none, null);
    public static final Property cmdClassesRaw = BNodeInformation.newProperty((int)1, (BValue)BBlob.DEFAULT, null);
    public static final Property cmdClasses = BNodeInformation.newProperty((int)1, (BValue)new BComponent(), null);
    public static final Property unsupportedCmdClasses = BNodeInformation.newProperty((int)1, (BValue)new BComponent(), null);
    public static final Action createCommandClasses = BNodeInformation.newAction((int)16, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BNodeInformation;
    static /* synthetic */ Class class$com$tridium$zwave$util$BCmdClassInfo;

    public boolean getIsListening() {
        return this.getBoolean(isListening);
    }

    public void setIsListening(boolean bl) {
        this.setBoolean(isListening, bl, null);
    }

    public boolean getOptionalFunctionality() {
        return this.getBoolean(optionalFunctionality);
    }

    public void setOptionalFunctionality(boolean bl) {
        this.setBoolean(optionalFunctionality, bl, null);
    }

    public boolean getSensor250ms() {
        return this.getBoolean(sensor250ms);
    }

    public void setSensor250ms(boolean bl) {
        this.setBoolean(sensor250ms, bl, null);
    }

    public boolean getSensor1000ms() {
        return this.getBoolean(sensor1000ms);
    }

    public void setSensor1000ms(boolean bl) {
        this.setBoolean(sensor1000ms, bl, null);
    }

    public BBasicDeviceEnum getBasicDeviceClass() {
        return (BBasicDeviceEnum)this.get(basicDeviceClass);
    }

    public void setBasicDeviceClass(BBasicDeviceEnum bBasicDeviceEnum) {
        this.set(basicDeviceClass, (BValue)bBasicDeviceEnum, null);
    }

    public BGenericDeviceEnum getGenericDeviceClass() {
        return (BGenericDeviceEnum)this.get(genericDeviceClass);
    }

    public void setGenericDeviceClass(BGenericDeviceEnum bGenericDeviceEnum) {
        this.set(genericDeviceClass, (BValue)bGenericDeviceEnum, null);
    }

    public BSpecificDeviceEnum getSpecificDeviceClass() {
        return (BSpecificDeviceEnum)this.get(specificDeviceClass);
    }

    public void setSpecificDeviceClass(BSpecificDeviceEnum bSpecificDeviceEnum) {
        this.set(specificDeviceClass, (BValue)bSpecificDeviceEnum, null);
    }

    public BBlob getCmdClassesRaw() {
        return (BBlob)this.get(cmdClassesRaw);
    }

    public void setCmdClassesRaw(BBlob bBlob) {
        this.set(cmdClassesRaw, (BValue)bBlob, null);
    }

    public BComponent getCmdClasses() {
        return (BComponent)this.get(cmdClasses);
    }

    public void setCmdClasses(BComponent bComponent) {
        this.set(cmdClasses, (BValue)bComponent, null);
    }

    public BComponent getUnsupportedCmdClasses() {
        return (BComponent)this.get(unsupportedCmdClasses);
    }

    public void setUnsupportedCmdClasses(BComponent bComponent) {
        this.set(unsupportedCmdClasses, (BValue)bComponent, null);
    }

    public void createCommandClasses() {
        this.invoke(createCommandClasses, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getCommandClass() {
        return -1;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
    }

    public int getCommandType() {
        return -1;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return BFacets.NULL;
    }

    public BStatusValue getValue() {
        return null;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)cmdClassesRaw) && context != Context.decoding) {
            this.createCommandClasses();
        } else if (property.equals((Object)isListening)) {
            BZWaveDevice bZWaveDevice = this.getDevice();
            boolean bl = this.getIsListening();
            bZWaveDevice.hideReadDeviceOnEventUpdate(bl);
            if (!bl && context != Context.decoding && !this.isFlirsDevice()) {
                bZWaveDevice.pingOk();
                BStatus bStatus = bZWaveDevice.getStatus();
                bZWaveDevice.setStatus(BStatus.makeStale((BStatus)bStatus, (boolean)true));
            }
        }
    }

    public void started() throws Exception {
        this.getDevice().hideReadDeviceOnEventUpdate(this.getIsListening());
        if (!this.getIsListening() && !this.isFlirsDevice()) {
            BStatus bStatus = this.getDevice().getStatus();
            this.getDevice().setStatus(BStatus.makeStale((BStatus)bStatus, (boolean)true));
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BZWaveNetwork bZWaveNetwork;
        if (action.equals((Object)createCommandClasses) && (bZWaveNetwork = this.getDevice().getZWaveNetwork()) != null) {
            return bZWaveNetwork.getInfoWorker().post((Runnable)new CreatCmdClassComponents(this.getDevice()));
        }
        return super.post(action, bValue, context);
    }

    public void doCreateCommandClasses() {
    }

    public void updateCmdClassesSupported() {
        this.getCmdClasses().removeAll();
        this.getUnsupportedCmdClasses().removeAll();
        BBlob bBlob = this.getCmdClassesRaw();
        BZWaveNetwork bZWaveNetwork = this.getDevice().getZWaveNetwork();
        int n = 0;
        while (n < bBlob.length()) {
            int n2 = bBlob.byteAt(n) & 0xFF;
            if (n2 == 239) break;
            if (bZWaveNetwork.getCommandClassInstance(n2) != null) {
                this.addSupportedClass(n2);
            } else {
                this.addUnsupportedClass(n2);
            }
            ++n;
        }
    }

    public void readData(ZWaveInputStream zWaveInputStream) {
        try {
            this.setBasicDeviceClass(BBasicDeviceEnum.make(zWaveInputStream.readByte()));
        }
        catch (Exception exception) {
            this.setBasicDeviceClass(BBasicDeviceEnum.invalid);
            exception.printStackTrace();
        }
        try {
            this.setGenericDeviceClass(BGenericDeviceEnum.make(zWaveInputStream.readByte()));
        }
        catch (Exception exception) {
            this.setGenericDeviceClass(BGenericDeviceEnum.invalid);
        }
        int n = zWaveInputStream.readByte();
        if (n != 0) {
            n = (this.getGenericDeviceClass().getOrdinal() << 8) + n;
        }
        try {
            this.setSpecificDeviceClass(BSpecificDeviceEnum.make(n));
        }
        catch (Exception exception) {
            this.setSpecificDeviceClass(BSpecificDeviceEnum.invalid);
        }
        byte[] byArray = new byte[zWaveInputStream.available()];
        try {
            zWaveInputStream.read(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (byArray.length > 0) {
            BBlob bBlob = BBlob.make((byte[])byArray);
            if (!this.getCmdClassesRaw().equivalent((Object)bBlob)) {
                this.setCmdClassesRaw(bBlob);
            }
        }
    }

    private final void addSupportedClass(int n) {
        BComponent bComponent = this.getCmdClasses();
        BValue bValue = bComponent.get("x" + Integer.toHexString(n));
        if (bValue != null) {
            return;
        }
        BCmdClassInfo bCmdClassInfo = new BCmdClassInfo(BZWaveCommandClass.make(n));
        bComponent.add("x" + Integer.toHexString(n), (BValue)bCmdClassInfo, 1);
    }

    private final void addUnsupportedClass(int n) {
        BComponent bComponent = this.getUnsupportedCmdClasses();
        BValue bValue = bComponent.get("x" + Integer.toHexString(n));
        if (bValue != null) {
            return;
        }
        try {
            bComponent.add("x" + Integer.toHexString(n), (BValue)BZWaveCommandClass.make(n), 1);
        }
        catch (Exception exception) {
            bComponent.add("x" + Integer.toHexString(n), (BValue)BZWaveCommandClass.invalid, 1);
        }
    }

    public BCmdClassInfo[] getSupportedClasses() {
        BComponent bComponent = this.getCmdClasses();
        Class clazz = class$com$tridium$zwave$util$BCmdClassInfo;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$util$BCmdClassInfo = BNodeInformation.class("[Lcom.tridium.zwave.util.BCmdClassInfo;", false);
        }
        return (BCmdClassInfo[])bComponent.getChildren(clazz);
    }

    public boolean isDefined() {
        boolean bl = false;
        if (this.getGenericDeviceClass().getOrdinal() != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isSupported(int n) {
        boolean bl = false;
        if (this.getCmdClasses().get("x" + Integer.toHexString(n)) != null) {
            bl = true;
        }
        return bl;
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getBasicDeviceClass());
        stringBuffer.append('.');
        stringBuffer.append((Object)this.getGenericDeviceClass());
        stringBuffer.append('.');
        stringBuffer.append(this.getSpecificDeviceClass());
        return stringBuffer.toString();
    }

    public static void setCmdClassVersion(BZWaveDevice bZWaveDevice, int n, int n2) {
        BCmdClassInfo[] bCmdClassInfoArray = BNodeInformation.getSupportedCmdClasses(bZWaveDevice);
        if (bCmdClassInfoArray == null) {
            return;
        }
        int n3 = 0;
        while (n3 < bCmdClassInfoArray.length) {
            if ((bCmdClassInfoArray[n3].getCmdClassType().getOrdinal() & 0xFF) == n) {
                bCmdClassInfoArray[n3].setVersion(n2);
                if (n == 96 && n2 == 2) {
                    bCmdClassInfoArray[n3].setCmdClassType(BZWaveCommandClass.MultiChannel);
                }
                if (n == 142 && n2 == 2) {
                    bCmdClassInfoArray[n3].setCmdClassType(BZWaveCommandClass.MultiChannelAssociation);
                }
            }
            ++n3;
        }
    }

    public static BCmdClassInfo[] getSupportedCmdClasses(BZWaveDevice bZWaveDevice) {
        BNodeInformation bNodeInformation = bZWaveDevice.getNodeInfo();
        BComponent bComponent = bNodeInformation.getCmdClasses();
        Class clazz = class$com$tridium$zwave$util$BCmdClassInfo;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$util$BCmdClassInfo = BNodeInformation.class("[Lcom.tridium.zwave.util.BCmdClassInfo;", false);
        }
        return (BCmdClassInfo[])bComponent.getChildren(clazz);
    }

    public static void setClassInstances(BZWaveDevice bZWaveDevice, int n, int n2) {
        BCmdClassInfo[] bCmdClassInfoArray = BNodeInformation.getSupportedCmdClasses(bZWaveDevice);
        if (bCmdClassInfoArray == null) {
            return;
        }
        int n3 = 0;
        while (n3 < bCmdClassInfoArray.length) {
            if (bCmdClassInfoArray[n3].getCmdClassType().getOrdinal() == n) {
                bCmdClassInfoArray[n3].setInstances(n2);
            }
            ++n3;
        }
    }

    public int getCommandClassVersion(int n) {
        try {
            BComponent bComponent = this.getCmdClasses();
            BValue bValue = bComponent.get("x" + Integer.toHexString(n));
            if (bValue != null) {
                return ((BCmdClassInfo)bValue).getVersion();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 1;
    }

    public boolean isFlirsDevice() {
        boolean bl = false;
        if (this.getSensor1000ms() || this.getSensor250ms()) {
            bl = true;
        }
        return bl;
    }

    public boolean isControlledDevice() {
        switch (this.getSpecificDeviceClass().getOrdinal()) {
            case -1: 
            case 257: 
            case 258: 
            case 513: 
            case 65280: {
                return false;
            }
            case 0: {
                if (this.getGenericDeviceClass().getOrdinal() != 2) break;
                return false;
            }
        }
        return true;
    }

    public Type getDefaultCmdClassPointType() {
        try {
            return DeviceClassTable.getDefaultBasicCommandPointType(this.getDevice(), this.getSpecificDeviceClass().getOrdinal());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public BControlPoint getDefaultCmdClassPoint() {
        try {
            return DeviceClassTable.getDefaultBasicCommandPoint(this.getDevice(), this.getSpecificDeviceClass().getOrdinal());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BNodeInformation;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BNodeInformation = BNodeInformation.class("[Lcom.tridium.zwave.cmdclass.BNodeInformation;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "";
    }
}

