/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.cmdclass.BNodeInformation;
import com.tridium.zwave.messages.SerialSendData;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWaveProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcWakeUp
extends BCmdClassObject
implements ZWaveMessageConst {
    public static final Property isAwake = BCcWakeUp.newProperty((int)3, (boolean)false, null);
    public static final Property request = BCcWakeUp.newProperty((int)3, (String)"", null);
    public static final Property interval = BCcWakeUp.newProperty((int)1, (int)0, (BFacets)BFacets.makeInt((BUnit)ZWaveMessageConst.SEC));
    public static final Property minInterval = BCcWakeUp.newProperty((int)1, (int)0, (BFacets)BFacets.makeInt((BUnit)ZWaveMessageConst.SEC));
    public static final Property maxInterval = BCcWakeUp.newProperty((int)1, (int)0, (BFacets)BFacets.makeInt((BUnit)ZWaveMessageConst.SEC));
    public static final Property defaultInterval = BCcWakeUp.newProperty((int)1, (int)0, (BFacets)BFacets.makeInt((BUnit)ZWaveMessageConst.SEC));
    public static final Property stepSize = BCcWakeUp.newProperty((int)1, (int)0, (BFacets)BFacets.makeInt((BUnit)ZWaveMessageConst.SEC));
    public static final Property lastWakeUp = BCcWakeUp.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property nextWakeUp = BCcWakeUp.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property nodeId = BCcWakeUp.newProperty((int)1, (int)0, null);
    public static final Action readWakeUpInterval = BCcWakeUp.newAction((int)20, null);
    public static final Action setWakeUpInterval = BCcWakeUp.newAction((int)16, (BValue)BInteger.make((int)-1), null);
    public static final Action sendSetWakeUpInterval = BCcWakeUp.newAction((int)20, (BValue)BInteger.make((int)-1), null);
    public static final Action readWakeUpCapabilities = BCcWakeUp.newAction((int)20, null);
    public static final Action postReadNodeInfo = BCcWakeUp.newAction((int)0, null);
    public static final Action readDeviceData = BCcWakeUp.newAction((int)20, null);
    public static final Action readPointData = BCcWakeUp.newAction((int)16, null);
    public static final Action readNonBasicPointData = BCcWakeUp.newAction((int)20, null);
    public static final Action stayAwakeTimeout = BCcWakeUp.newAction((int)20, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    public static Log log;
    boolean readNodeInfo;
    boolean setAssociation;
    BInteger setWakeUpIntervalValue;
    Clock.Ticket stayAwakeTicket;
    boolean wakeUpReadBasicPointPosted;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcWakeUp;

    public boolean getIsAwake() {
        return this.getBoolean(isAwake);
    }

    public void setIsAwake(boolean bl) {
        this.setBoolean(isAwake, bl, null);
    }

    public String getRequest() {
        return this.getString(request);
    }

    public void setRequest(String string) {
        this.setString(request, string, null);
    }

    public int getInterval() {
        return this.getInt(interval);
    }

    public void setInterval(int n) {
        this.setInt(interval, n, null);
    }

    public int getMinInterval() {
        return this.getInt(minInterval);
    }

    public void setMinInterval(int n) {
        this.setInt(minInterval, n, null);
    }

    public int getMaxInterval() {
        return this.getInt(maxInterval);
    }

    public void setMaxInterval(int n) {
        this.setInt(maxInterval, n, null);
    }

    public int getDefaultInterval() {
        return this.getInt(defaultInterval);
    }

    public void setDefaultInterval(int n) {
        this.setInt(defaultInterval, n, null);
    }

    public int getStepSize() {
        return this.getInt(stepSize);
    }

    public void setStepSize(int n) {
        this.setInt(stepSize, n, null);
    }

    public BAbsTime getLastWakeUp() {
        return (BAbsTime)this.get(lastWakeUp);
    }

    public void setLastWakeUp(BAbsTime bAbsTime) {
        this.set(lastWakeUp, (BValue)bAbsTime, null);
    }

    public BAbsTime getNextWakeUp() {
        return (BAbsTime)this.get(nextWakeUp);
    }

    public void setNextWakeUp(BAbsTime bAbsTime) {
        this.set(nextWakeUp, (BValue)bAbsTime, null);
    }

    public int getNodeId() {
        return this.getInt(nodeId);
    }

    public void setNodeId(int n) {
        this.setInt(nodeId, n, null);
    }

    public void readWakeUpInterval() {
        this.invoke(readWakeUpInterval, null, null);
    }

    public void setWakeUpInterval(BInteger bInteger) {
        this.invoke(setWakeUpInterval, (BValue)bInteger, null);
    }

    public void sendSetWakeUpInterval(BInteger bInteger) {
        this.invoke(sendSetWakeUpInterval, (BValue)bInteger, null);
    }

    public void readWakeUpCapabilities() {
        this.invoke(readWakeUpCapabilities, null, null);
    }

    public void postReadNodeInfo() {
        this.invoke(postReadNodeInfo, null, null);
    }

    public void readDeviceData() {
        this.invoke(readDeviceData, null, null);
    }

    public void readPointData() {
        this.invoke(readPointData, null, null);
    }

    public void readNonBasicPointData() {
        this.invoke(readNonBasicPointData, null, null);
    }

    public void stayAwakeTimeout() {
        this.invoke(stayAwakeTimeout, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getCommandType() {
        return -1;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return BFacets.NULL;
    }

    public BStatusValue getValue() {
        return null;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 132;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        if (bZWaveDevice.get(ADD_NAME) == null) {
            Property property = bZWaveDevice.add(ADD_NAME, (BValue)this);
            BCcWakeUp bCcWakeUp = (BCcWakeUp)bZWaveDevice.get(property);
            bCcWakeUp.setIsAwake(true);
            bCcWakeUp.readWakeUpCapabilities();
            bCcWakeUp.readWakeUpInterval();
        }
        this.readWakeUpInterval();
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        log.trace(bZWaveDevice.getNodeId() + ": command = 0x" + Integer.toHexString(n));
        if (n != 6 && n != 7 && n != 10) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassWakeUP: 0x" + Integer.toHexString(n));
            return;
        }
        try {
            BCcWakeUp bCcWakeUp = (BCcWakeUp)bZWaveDevice.get(ADD_NAME);
            bCcWakeUp.readData(bCcWakeUp, n, zWaveInputStream);
        }
        catch (Exception exception) {
            bZWaveDevice.readNonBasicPointData();
            log.trace(bZWaveDevice.getNodeId() + ": WakeUp object does not exist yet");
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals((Object)setWakeUpInterval)) {
            return BInteger.make((int)this.getInterval());
        }
        return super.getActionParameterDefault(action);
    }

    public void doPostReadNodeInfo() {
        this.readNodeInfo = true;
    }

    public void doReadWakeUpInterval() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{-124, 5};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void doReadWakeUpCapabilities() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{-124, 9};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void doSetWakeUpInterval(BInteger bInteger) {
        this.setRequest("setWakeUpInterval posted: " + bInteger);
        this.setWakeUpIntervalValue = bInteger;
    }

    public void doSendSetWakeUpInterval(BInteger bInteger) {
        BZWaveDevice bZWaveDevice = this.getDevice();
        int n = bInteger.getInt();
        int n2 = this.getMaxInterval();
        int n3 = this.getMinInterval();
        if (n2 > 0 && n > n2) {
            n = n2;
        } else if (n3 > 0 && n < n3) {
            n = n3;
        }
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[6];
            byArray[0] = -124;
            byArray[1] = 4;
            byArray[2] = (byte)(n >> 16 & 0xFF);
            byArray[3] = (byte)(n >> 8 & 0xFF);
            byArray[4] = (byte)(n & 0xFF);
            int n4 = this.getNetwork().getInterfaceNodeId();
            if (n4 > 2) {
                n4 = 255;
            }
            byArray[5] = (byte)n4;
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
            log.trace("setWakeUpInterval - " + ByteArrayUtil.toHexString((byte[])byArray));
            this.setRequest("wakeup interval written: " + bInteger + ' ' + BAbsTime.now());
        }
    }

    public void doSendNoMoreInfo() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{-124, 8};
            try {
                SerialSendData serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), byArray, 5, false);
                BZWaveNetwork bZWaveNetwork = this.getNetwork();
                if (bZWaveNetwork != null) {
                    bZWaveNetwork.sendDataReq(serialSendData);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            log.trace(bZWaveDevice.getNodeId() + ": no more info cmd sent");
        }
    }

    public void doReadPointData() {
        BControlPoint[] bControlPointArray = this.getDevice().getPoints().getPoints();
        int n = 0;
        while (n < bControlPointArray.length) {
            BZWaveProxyExt bZWaveProxyExt = (BZWaveProxyExt)bControlPointArray[n].getProxyExt();
            if (bZWaveProxyExt.getCommandClass() == 32) {
                this.wakeUpReadBasicPointPosted = true;
            }
            log.trace(this.getDevice().getNodeId() + ": " + bControlPointArray[n].getDisplayName(null) + " poll");
            bZWaveProxyExt.pollForData();
            ++n;
        }
    }

    public void doReadNonBasicPointData() {
        if (this.wakeUpReadBasicPointPosted) {
            this.wakeUpReadBasicPointPosted = false;
            return;
        }
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (!bZWaveDevice.getReadDeviceOnEventUpdate()) {
            return;
        }
        this.setIsAwake(true);
        BStatus bStatus = bZWaveDevice.getStatus();
        bZWaveDevice.setStatus(BStatus.makeStale((BStatus)bStatus, (boolean)false));
        BControlPoint[] bControlPointArray = this.getDevice().getPoints().getPoints();
        int n = 0;
        while (n < bControlPointArray.length) {
            BZWaveProxyExt bZWaveProxyExt = (BZWaveProxyExt)bControlPointArray[n].getProxyExt();
            if (bZWaveProxyExt.getCommandClass() != 32) {
                log.trace(this.getDevice().getNodeId() + ": " + bControlPointArray[n].getDisplayName(null) + " poll");
                ((BZWaveProxyExt)bControlPointArray[n].getProxyExt()).pollForData();
            }
            ++n;
        }
        if (this.stayAwakeTicket != null) {
            this.stayAwakeTicket.cancel();
        }
        this.stayAwakeTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)20000L), (Action)stayAwakeTimeout, null);
    }

    public void doReadDeviceData() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (this.readNodeInfo || bZWaveDevice.getNodeInfo().getCmdClassesRaw().length() == 0) {
            bZWaveDevice.getNodeInfo().set(BNodeInformation.cmdClassesRaw, (BValue)BBlob.DEFAULT, Context.decoding);
            bZWaveDevice.doRequestNodeInfo();
            this.readNodeInfo = false;
        }
        try {
            bZWaveDevice.getConfigDeviceExt().checkPostedAction();
        }
        catch (Exception exception) {}
        try {
            bZWaveDevice.getAssociationDeviceExt().checkPostedAssociations();
        }
        catch (Exception exception) {}
        bZWaveDevice.doReadManufacturerSpecific();
        this.doReadWakeUpCapabilities();
        this.doReadPointData();
        this.doReadWakeUpInterval();
        try {
            bZWaveDevice.getConfigDeviceExt().checkPostedAction();
        }
        catch (Exception exception) {}
        try {
            bZWaveDevice.getAssociationDeviceExt().checkPostedAssociations();
        }
        catch (Exception exception) {}
        if (this.setWakeUpIntervalValue != null) {
            this.doSendSetWakeUpInterval(this.setWakeUpIntervalValue);
            this.setWakeUpIntervalValue = null;
        }
        if (this.stayAwakeTicket != null) {
            this.stayAwakeTicket.cancel();
        }
        this.stayAwakeTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)20000L), (Action)stayAwakeTimeout, null);
    }

    public void doStayAwakeTimeout() {
        this.wakeUpReadBasicPointPosted = false;
        this.setIsAwake(false);
        BStatus bStatus = this.getDevice().getStatus();
        this.getDevice().setStatus(BStatus.makeStale((BStatus)bStatus, (boolean)true));
    }

    public void readData(BCcWakeUp bCcWakeUp, int n, ZWaveInputStream zWaveInputStream) {
        BZWaveDevice bZWaveDevice = bCcWakeUp.getDevice();
        if (n == 7) {
            this.setIsAwake(true);
            BStatus bStatus = bZWaveDevice.getStatus();
            bZWaveDevice.setStatus(BStatus.makeStale((BStatus)bStatus, (boolean)false));
            log.trace(bZWaveDevice.getNodeId() + ": WAKE_UP_NOTIFICATION");
            bCcWakeUp.setLastWakeUp(BAbsTime.make());
            int n2 = this.getInterval();
            BAbsTime bAbsTime = BAbsTime.NULL;
            if (n2 > 0) {
                bAbsTime = BAbsTime.make().add(BRelTime.makeSeconds((int)this.getInterval()));
            }
            bCcWakeUp.setNextWakeUp(bAbsTime);
            bCcWakeUp.readDeviceData();
            return;
        }
        if (n == 6) {
            log.trace(bZWaveDevice.getNodeId() + ": WAKE_UP_INTERVAL_REPORT");
            int n3 = zWaveInputStream.readByte();
            n3 = n3 << 8 | zWaveInputStream.readByte();
            n3 = n3 << 8 | zWaveInputStream.readByte();
            int n4 = zWaveInputStream.readByte();
            if (n3 != bCcWakeUp.getInterval()) {
                BAbsTime bAbsTime = BAbsTime.NULL;
                if (n3 > 0) {
                    bAbsTime = bCcWakeUp.getLastWakeUp().add(BRelTime.makeSeconds((int)n3));
                }
                bCcWakeUp.setNextWakeUp(bAbsTime);
            }
            bCcWakeUp.setInterval(n3);
            bCcWakeUp.setNodeId(n4);
            if (n4 != this.getNetwork().getInterfaceNodeId()) {
                log.trace(bZWaveDevice.getNodeId() + ": nodeId doesn't match, force setWakeUpInterval.");
                this.sendSetWakeUpInterval(BInteger.make((int)n3));
                bCcWakeUp.setNodeId(this.getNetwork().getInterfaceNodeId());
            }
            log.trace(bZWaveDevice.getNodeId() + ": interval = " + n3);
            return;
        }
        log.trace(bZWaveDevice.getNodeId() + ": WAKE_UP_INTERVAL_CAPABILITIES_GET");
        int n5 = zWaveInputStream.readByte();
        n5 = n5 << 8 | zWaveInputStream.readByte();
        n5 = n5 << 8 | zWaveInputStream.readByte();
        int n6 = zWaveInputStream.readByte();
        n6 = n6 << 8 | zWaveInputStream.readByte();
        n6 = n6 << 8 | zWaveInputStream.readByte();
        int n7 = zWaveInputStream.readByte();
        n7 = n7 << 8 | zWaveInputStream.readByte();
        n7 = n7 << 8 | zWaveInputStream.readByte();
        int n8 = zWaveInputStream.readByte();
        n8 = n8 << 8 | zWaveInputStream.readByte();
        n8 = n8 << 8 | zWaveInputStream.readByte();
        bCcWakeUp.setMinInterval(n5);
        bCcWakeUp.setMaxInterval(n6);
        bCcWakeUp.setDefaultInterval(n7);
        bCcWakeUp.setStepSize(n8);
    }

    public String toString(Context context) {
        return this.getInterval() + " sec";
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice == null) {
            return super.post(action, bValue, context);
        }
        BZWaveNetwork bZWaveNetwork = this.getDevice().getZWaveNetwork();
        if (bZWaveNetwork == null) {
            return super.post(action, bValue, context);
        }
        if (action.equals((Object)readDeviceData) || action.equals((Object)readNonBasicPointData)) {
            return bZWaveNetwork.getInfoWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        if (action.equals((Object)readWakeUpInterval) || action.equals((Object)setWakeUpInterval) || action.equals((Object)readWakeUpCapabilities) || action.equals((Object)stayAwakeTimeout)) {
            return bZWaveNetwork.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.readNodeInfo = false;
        this.setAssociation = true;
        this.setWakeUpIntervalValue = null;
        this.wakeUpReadBasicPointPosted = false;
    }

    public BCcWakeUp() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcWakeUp;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcWakeUp = BCcWakeUp.class("[Lcom.tridium.zwave.cmdclass.BCcWakeUp;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "wakeUp";
        log = Log.getLog((String)"zwave.wakeUp");
    }
}

