/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcTime
extends BCmdClassObject
implements ZWaveMessageConst {
    public static final Property dateTime = BCcTime.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property timeZoneOffset = BCcTime.newProperty((int)5, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)false)));
    public static final Property dstMinnuteOffset = BCcTime.newProperty((int)5, (int)0, (BFacets)BFacets.makeInt((BUnit)ZWaveMessageConst.MINUTE));
    public static final Property dstMonthStart = BCcTime.newProperty((int)5, (BValue)BMonth.april, null);
    public static final Property dstDayStart = BCcTime.newProperty((int)5, (int)1, (BFacets)BFacets.makeInt((int)1, (int)31));
    public static final Property dstHourStart = BCcTime.newProperty((int)5, (int)1, (BFacets)BFacets.makeInt((int)0, (int)23));
    public static final Property dstMonthEnd = BCcTime.newProperty((int)5, (BValue)BMonth.april, null);
    public static final Property dstDayEnd = BCcTime.newProperty((int)5, (int)1, (BFacets)BFacets.makeInt((int)1, (int)31));
    public static final Property dstHourEnd = BCcTime.newProperty((int)5, (int)1, (BFacets)BFacets.makeInt((int)0, (int)23));
    public static final Action read = BCcTime.newAction((int)16, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcTime;

    public BAbsTime getDateTime() {
        return (BAbsTime)this.get(dateTime);
    }

    public void setDateTime(BAbsTime bAbsTime) {
        this.set(dateTime, (BValue)bAbsTime, null);
    }

    public BRelTime getTimeZoneOffset() {
        return (BRelTime)this.get(timeZoneOffset);
    }

    public void setTimeZoneOffset(BRelTime bRelTime) {
        this.set(timeZoneOffset, (BValue)bRelTime, null);
    }

    public int getDstMinnuteOffset() {
        return this.getInt(dstMinnuteOffset);
    }

    public void setDstMinnuteOffset(int n) {
        this.setInt(dstMinnuteOffset, n, null);
    }

    public BMonth getDstMonthStart() {
        return (BMonth)this.get(dstMonthStart);
    }

    public void setDstMonthStart(BMonth bMonth) {
        this.set(dstMonthStart, (BValue)bMonth, null);
    }

    public int getDstDayStart() {
        return this.getInt(dstDayStart);
    }

    public void setDstDayStart(int n) {
        this.setInt(dstDayStart, n, null);
    }

    public int getDstHourStart() {
        return this.getInt(dstHourStart);
    }

    public void setDstHourStart(int n) {
        this.setInt(dstHourStart, n, null);
    }

    public BMonth getDstMonthEnd() {
        return (BMonth)this.get(dstMonthEnd);
    }

    public void setDstMonthEnd(BMonth bMonth) {
        this.set(dstMonthEnd, (BValue)bMonth, null);
    }

    public int getDstDayEnd() {
        return this.getInt(dstDayEnd);
    }

    public void setDstDayEnd(int n) {
        this.setInt(dstDayEnd, n, null);
    }

    public int getDstHourEnd() {
        return this.getInt(dstHourEnd);
    }

    public void setDstHourEnd(int n) {
        this.setInt(dstHourEnd, n, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getCommandType() {
        return -1;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return BFacets.NULL;
    }

    public BStatusValue getValue() {
        return null;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 138;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        if (bZWaveDevice.get(ADD_NAME) == null) {
            bZWaveDevice.add(ADD_NAME, (BValue)this);
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n != 2 && n != 4 && n != 7) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassTime: 0x" + Integer.toHexString(n));
            return;
        }
        try {
            BCcTime bCcTime = (BCcTime)bZWaveDevice.get(ADD_NAME);
            bCcTime.readData(bCcTime, n, zWaveInputStream);
        }
        catch (Exception exception) {
            System.out.println("!!!!!!! Time object does not exist !!!!!!!!!");
        }
    }

    public void doRead() {
        this.doReadDate();
        this.doReadTime();
        if (this.getVersion() > 1) {
            this.doReadOffset();
        }
    }

    public void doReadTime() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{-118, 1};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void doReadDate() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{-118, 3};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void doReadOffset() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{-118, 6};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void readData(BCcTime bCcTime, int n, ZWaveInputStream zWaveInputStream) {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (n == 2) {
            BTime bTime = BTime.make((int)zWaveInputStream.readByte(), (int)zWaveInputStream.readByte(), (int)zWaveInputStream.readByte());
            bCcTime.setDateTime(BAbsTime.make((BAbsTime)bCcTime.getDateTime(), (BTime)bTime));
        } else if (n == 4) {
            int n2 = zWaveInputStream.readWord();
            int n3 = zWaveInputStream.readByte();
            int n4 = zWaveInputStream.readByte();
            BMonth bMonth = BMonth.make((int)(n3 - 1));
            BAbsTime bAbsTime = BAbsTime.make((BAbsTime)BAbsTime.make((int)n2, (BMonth)bMonth, (int)n4), (BTime)BTime.make((BAbsTime)bCcTime.getDateTime()));
            bCcTime.setDateTime(bAbsTime);
        } else {
            int n5 = zWaveInputStream.readByte();
            int n6 = zWaveInputStream.readByte();
            int n7 = zWaveInputStream.readByte();
            int n8 = zWaveInputStream.readByte();
            int n9 = zWaveInputStream.readByte();
            int n10 = zWaveInputStream.readByte();
            int n11 = zWaveInputStream.readByte();
            int n12 = zWaveInputStream.readByte();
            int n13 = zWaveInputStream.readByte();
            boolean bl = false;
            if ((n5 & 0x80) != 0) {
                bl = true;
            }
            boolean bl2 = bl;
            n5 &= 0x7F;
            if (bl2) {
                n5 = -n5;
            }
            n5 = n5 * 60 + n6;
            BRelTime bRelTime = BRelTime.makeMinutes((int)n5);
            bCcTime.setTimeZoneOffset(bRelTime);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcTime;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcTime = BCcTime.class("[Lcom.tridium.zwave.cmdclass.BCcTime;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "time";
    }
}

