/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcScreenAttributes
extends BCmdClassObject
implements ZWaveMessageConst {
    public static final Property numberLines = BCcScreenAttributes.newProperty((int)1, (int)0, null);
    public static final Property charPerLine = BCcScreenAttributes.newProperty((int)1, (int)0, null);
    public static final Property lineBufferSize = BCcScreenAttributes.newProperty((int)1, (int)0, null);
    public static final Property charNumericalPresentations = BCcScreenAttributes.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"radix", (int)2));
    public static final Property escapeSequenceSupported = BCcScreenAttributes.newProperty((int)1, (boolean)false, null);
    public static final Property screenTimeout = BCcScreenAttributes.newProperty((int)1, (int)0, (BFacets)BFacets.makeInt((BUnit)ZWaveMessageConst.SEC));
    public static final Action read = BCcScreenAttributes.newAction((int)16, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcScreenAttributes;

    public int getNumberLines() {
        return this.getInt(numberLines);
    }

    public void setNumberLines(int n) {
        this.setInt(numberLines, n, null);
    }

    public int getCharPerLine() {
        return this.getInt(charPerLine);
    }

    public void setCharPerLine(int n) {
        this.setInt(charPerLine, n, null);
    }

    public int getLineBufferSize() {
        return this.getInt(lineBufferSize);
    }

    public void setLineBufferSize(int n) {
        this.setInt(lineBufferSize, n, null);
    }

    public int getCharNumericalPresentations() {
        return this.getInt(charNumericalPresentations);
    }

    public void setCharNumericalPresentations(int n) {
        this.setInt(charNumericalPresentations, n, null);
    }

    public boolean getEscapeSequenceSupported() {
        return this.getBoolean(escapeSequenceSupported);
    }

    public void setEscapeSequenceSupported(boolean bl) {
        this.setBoolean(escapeSequenceSupported, bl, null);
    }

    public int getScreenTimeout() {
        return this.getInt(screenTimeout);
    }

    public void setScreenTimeout(int n) {
        this.setInt(screenTimeout, n, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getCommandType() {
        return -1;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return BFacets.NULL;
    }

    public BStatusValue getValue() {
        return null;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 147;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        if (bZWaveDevice.get(ADD_NAME) == null) {
            bZWaveDevice.add(ADD_NAME, (BValue)this);
        }
        this.read();
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n != 2 && n != 3) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassScreenAttributes: 0x" + Integer.toHexString(n));
            return;
        }
        try {
            BCcScreenAttributes bCcScreenAttributes = (BCcScreenAttributes)bZWaveDevice.get(ADD_NAME);
            bCcScreenAttributes.readData(bCcScreenAttributes, n, zWaveInputStream);
        }
        catch (Exception exception) {
            System.out.println("!!!!!!! ScreenAttributes object does not exist !!!!!!!!!");
        }
    }

    public void doRead() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{(byte)this.getCommandClass(), 1};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void readData(BCcScreenAttributes bCcScreenAttributes, int n, ZWaveInputStream zWaveInputStream) {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (n == 2) {
            bCcScreenAttributes.setNumberLines(zWaveInputStream.readByte() & 0x1F);
            bCcScreenAttributes.setCharPerLine(zWaveInputStream.readByte());
            bCcScreenAttributes.setLineBufferSize(zWaveInputStream.readByte());
            bCcScreenAttributes.setCharNumericalPresentations(zWaveInputStream.readByte());
        } else if (n == 3) {
            int n2 = zWaveInputStream.readByte();
            bCcScreenAttributes.setNumberLines(n2 & 0x1F);
            boolean bl = false;
            if ((n2 & 0x20) != 0) {
                bl = true;
            }
            bCcScreenAttributes.setEscapeSequenceSupported(bl);
            bCcScreenAttributes.setCharPerLine(zWaveInputStream.readByte());
            bCcScreenAttributes.setLineBufferSize(zWaveInputStream.readByte());
            bCcScreenAttributes.setCharNumericalPresentations(zWaveInputStream.readByte());
            bCcScreenAttributes.setScreenTimeout(zWaveInputStream.readByte());
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcScreenAttributes;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcScreenAttributes = BCcScreenAttributes.class("[Lcom.tridium.zwave.cmdclass.BCcScreenAttributes;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "screenAttributes";
    }
}

