/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import com.tridium.zwave.point.BZWaveProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcMultilevelSensor
extends BPointCmdClassObject
implements ZWaveMessageConst {
    public static final Type TYPE;
    public static String ADD_NAME;
    int measureType;
    int scale;
    int precision;
    double value;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcMultilevelSensor;

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 49;
    }

    public Type getControlPointType() {
        return BNumericPoint.TYPE;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        BValue bValue;
        BZWavePointDeviceExt bZWavePointDeviceExt = bZWaveDevice.getPoints();
        String string = ADD_NAME;
        if (n > 1) {
            string = string + n;
        }
        if ((bValue = bZWavePointDeviceExt.get(string)) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, string, BNumericPoint.TYPE, 49, 4, -1, 5, -1, n, BPollFrequency.normal, BFacets.makeNumeric());
        } else {
            BControlPoint bControlPoint = (BControlPoint)bValue;
            ((BZWaveProxyExt)bControlPoint.getProxyExt()).setInstance(n);
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = zWaveInputStream.readByte();
        if (n != 5) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for processSensorMultilevel: 0x" + Integer.toHexString(n));
            return;
        }
        this.measureType = zWaveInputStream.readByte();
        int n2 = zWaveInputStream.readByte();
        int n3 = n2 & 7;
        this.scale = n2 >> 3 & 3;
        this.precision = n2 >> 5 & 7;
        long l = 0L;
        if (n3 == 1) {
            l = zWaveInputStream.read();
        } else if (n3 == 2) {
            l = zWaveInputStream.read() << 8 | zWaveInputStream.readByte();
        } else if (n3 == 4) {
            l = (long)zWaveInputStream.read() << 32 | (long)zWaveInputStream.readByte() | (long)zWaveInputStream.readByte() | (long)zWaveInputStream.readByte();
        }
        this.value = (double)l / Math.pow(10.0, this.precision);
        this.updatePoint(bZWaveDevice);
    }

    public int getCommandType() {
        return 5;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        switch (this.measureType) {
            case 1: 
            case 11: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.DEG_C, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.DEG_F, (int)this.precision);
            }
            case 2: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.PERCENT, (int)this.precision);
                }
                return BFacets.makeNumeric((int)this.precision);
            }
            case 3: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.PERCENT, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.LUX, (int)this.precision);
            }
            case 4: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.WATT, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.BTU_H, (int)this.precision);
            }
            case 5: {
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.PERCENT, (int)this.precision);
            }
            case 6: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.METERS_PER_SECOND, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.MILES_PER_HOUR, (int)this.precision);
            }
            case 7: {
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.DIRECTION, (int)this.precision);
            }
            case 8: 
            case 9: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.PRESSURE_KPA, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.PRESSURE_INHG, (int)this.precision);
            }
            case 10: {
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.SOLAR_RADIATION, (int)this.precision);
            }
            case 12: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.MM_PER_HR, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.IN_PER_HR, (int)this.precision);
            }
            case 13: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.METER, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.FEET, (int)this.precision);
            }
            case 14: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.KG, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.POUND, (int)this.precision);
            }
            case 15: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.VOLT, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.MILLI_VOLT, (int)this.precision);
            }
            case 16: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.AMP, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.MILLI_AMP, (int)this.precision);
            }
            case 17: {
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.PPM, (int)this.precision);
            }
            case 18: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.CMH, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.CFM, (int)this.precision);
            }
            case 19: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.LITER, (int)this.precision);
                }
                if (this.scale == 1) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.CBM, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.GALLON, (int)this.precision);
            }
            case 20: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.METER, (int)this.precision);
                }
                if (this.scale == 1) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.CENTIMETER, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.FEET, (int)this.precision);
            }
        }
        return BFacets.makeNumeric((int)this.precision);
    }

    public int getMeasureType() {
        return this.measureType;
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public BStatusValue getValue() {
        return new BStatusNumeric(this.value);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcMultilevelSensor;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcMultilevelSensor = BCcMultilevelSensor.class("[Lcom.tridium.zwave.cmdclass.BCcMultilevelSensor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "multiLevelSensor";
    }
}

