/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.cmdclass.BNodeInformation;
import com.tridium.zwave.learn.BZWaveLearnDevicesJob;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.messages.ZWaveOutputStream;
import com.tridium.zwave.point.BZWaveProxyExt;
import com.tridium.zwave.util.BCmdClassInfo;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcMultiInstance
extends BCmdClassObject
implements ZWaveMessageConst {
    public static final Property dynamic = BCcMultiInstance.newProperty((int)1, (boolean)false, null);
    public static final Property identical = BCcMultiInstance.newProperty((int)1, (boolean)false, null);
    public static final Property numberEndPoints = BCcMultiInstance.newProperty((int)1, (int)0, null);
    public static final Action readInstances = BCcMultiInstance.newAction((int)16, null);
    public static final Action readEndPoints = BCcMultiInstance.newAction((int)16, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcMultiInstance;

    public boolean getDynamic() {
        return this.getBoolean(dynamic);
    }

    public void setDynamic(boolean bl) {
        this.setBoolean(dynamic, bl, null);
    }

    public boolean getIdentical() {
        return this.getBoolean(identical);
    }

    public void setIdentical(boolean bl) {
        this.setBoolean(identical, bl, null);
    }

    public int getNumberEndPoints() {
        return this.getInt(numberEndPoints);
    }

    public void setNumberEndPoints(int n) {
        this.setInt(numberEndPoints, n, null);
    }

    public void readInstances() {
        this.invoke(readInstances, null, null);
    }

    public void readEndPoints() {
        this.invoke(readEndPoints, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getCommandType() {
        return -1;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return BFacets.NULL;
    }

    public BStatusValue getValue() {
        return null;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 96;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        BCcMultiInstance bCcMultiInstance = (BCcMultiInstance)bZWaveDevice.get(ADD_NAME);
        if (bCcMultiInstance == null) {
            bCcMultiInstance = (BCcMultiInstance)bZWaveDevice.get(bZWaveDevice.add(ADD_NAME, (BValue)this));
        } else {
            bCcMultiInstance.setVersion(this.getVersion());
        }
        bCcMultiInstance.readInstances();
        this.setVersion(bZWaveDevice.getCommandClassVersion(this.getCommandClass()));
        if (bCcMultiInstance.getVersion() == 2) {
            bCcMultiInstance.readEndPoints();
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        int n = -1;
        int n2 = zWaveInputStream.readByte();
        switch (n2) {
            case 5: {
                try {
                    BCcMultiInstance bCcMultiInstance = (BCcMultiInstance)bZWaveDevice.get(ADD_NAME);
                    bCcMultiInstance.readMultiInstanceReport(bCcMultiInstance, n2, zWaveInputStream);
                }
                catch (Exception exception) {
                    System.out.println("!!!!!!! MultiInstace object does not exist !!!!!!!!!");
                }
                break;
            }
            case 13: {
                int n3 = zWaveInputStream.readByte();
                zWaveInputStream.readByte();
                n = n3;
            }
            case 6: {
                if (n == -1) {
                    n = zWaveInputStream.readByte();
                }
                int n4 = zWaveInputStream.readByte();
                BCmdClassObject bCmdClassObject = ((BZWaveNetwork)bZWaveDevice.getNetwork()).getCommandClassInstance(n4);
                if (bCmdClassObject == null) {
                    return;
                }
                bCmdClassObject.setMultiInstance(n);
                bCmdClassObject.processUpdate(bZWaveDevice, zWaveInputStream);
                break;
            }
            case 8: {
                BCcMultiInstance bCcMultiInstance = (BCcMultiInstance)bZWaveDevice.get(ADD_NAME);
                bCcMultiInstance.readEndPointReport(bCcMultiInstance, n2, zWaveInputStream);
                int n5 = 1;
                while (n5 <= bCcMultiInstance.getNumberEndPoints()) {
                    BValue bValue = bZWaveDevice.get("assocInEp" + n5);
                    if (bValue == null) {
                        bValue = bZWaveDevice.get(bZWaveDevice.add("assocInEp" + n5, (BValue)BInteger.make((int)(200 + n5)), 1032));
                    }
                    ++n5;
                }
                break;
            }
            default: {
                BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassMultiInstance: 0x" + Integer.toHexString(n2));
            }
        }
    }

    public void doReadInstances() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            BCmdClassInfo[] bCmdClassInfoArray = BNodeInformation.getSupportedCmdClasses(bZWaveDevice);
            if (bCmdClassInfoArray == null) {
                return;
            }
            int n = 0;
            while (n < bCmdClassInfoArray.length) {
                byte[] byArray = new byte[]{96, 4, (byte)bCmdClassInfoArray[n].getCmdClassType().getOrdinal()};
                this.sendCmd(bZWaveDevice.getNodeId(), byArray);
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {}
                ++n;
            }
        }
    }

    public static void doReadInstances(BZWaveDevice bZWaveDevice) {
        if (bZWaveDevice != null) {
            BCmdClassInfo[] bCmdClassInfoArray = BNodeInformation.getSupportedCmdClasses(bZWaveDevice);
            if (bCmdClassInfoArray == null) {
                return;
            }
            int n = 0;
            while (n < bCmdClassInfoArray.length) {
                byte[] byArray = new byte[]{96, 4, (byte)bCmdClassInfoArray[n].getCmdClassType().getOrdinal()};
                BCcMultiInstance.sendCmd(bZWaveDevice, byArray);
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {}
                ++n;
            }
        }
    }

    public void doReadEndPoints() {
        BZWaveDevice bZWaveDevice = this.getDevice();
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{96, 7};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {}
        }
    }

    public void readMultiInstanceReport(BCcMultiInstance bCcMultiInstance, int n, ZWaveInputStream zWaveInputStream) {
        int n2 = zWaveInputStream.readByte();
        int n3 = zWaveInputStream.readByte();
        BZWaveDevice bZWaveDevice = bCcMultiInstance.getDevice();
        if (bZWaveDevice == null) {
            return;
        }
        BNodeInformation.setClassInstances(bZWaveDevice, n2, n3);
        if (bZWaveDevice.getReadInstanceInfoJob() != null && bZWaveDevice.getInstanceInfoUpdateLastCmdClass() == n2) {
            BZWaveLearnDevicesJob.ldLog.trace("   notifyInstanceInfoUpdate()");
            bZWaveDevice.getReadInstanceInfoJob().notifyInstanceInfoUpdate();
        }
    }

    public void readEndPointReport(BCcMultiInstance bCcMultiInstance, int n, ZWaveInputStream zWaveInputStream) {
        int n2 = zWaveInputStream.readByte();
        boolean bl = false;
        if ((n2 & 0x80) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if ((n2 & 0x40) != 0) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        int n3 = zWaveInputStream.readByte() & 0x7F;
        bCcMultiInstance.setDynamic(bl2);
        bCcMultiInstance.setIdentical(bl4);
        bCcMultiInstance.setNumberEndPoints(n3);
    }

    public static byte[] getReadInstanceFrame(BZWaveProxyExt bZWaveProxyExt) {
        byte[] byArray = new byte[]{96, 6, (byte)bZWaveProxyExt.getInstance(), (byte)bZWaveProxyExt.getCommandClass(), (byte)bZWaveProxyExt.getReadCommand()};
        return byArray;
    }

    public static byte[] getWriteInstanceFrame(byte[] byArray, BZWaveProxyExt bZWaveProxyExt) {
        ZWaveOutputStream zWaveOutputStream = new ZWaveOutputStream();
        zWaveOutputStream.write(96);
        zWaveOutputStream.write(6);
        zWaveOutputStream.write((byte)bZWaveProxyExt.getInstance());
        zWaveOutputStream.write(byArray, 0, byArray.length);
        return zWaveOutputStream.toByteArray();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcMultiInstance;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcMultiInstance = BCcMultiInstance.class("[Lcom.tridium.zwave.cmdclass.BCcMultiInstance;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "multiInstance";
    }
}

