/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import com.tridium.zwave.point.BZWaveProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcHrvStatus
extends BPointCmdClassObject
implements ZWaveMessageConst {
    public static final Action readStatusSupported = BCcHrvStatus.newAction((int)16, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    int statusSupported;
    int statusParameter;
    int precScaleSize;
    int precision;
    int scale;
    int command;
    long value;
    BFacets facets;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcHrvStatus;

    public void readStatusSupported() {
        this.invoke(readStatusSupported, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 55;
    }

    public Type getControlPointType() {
        return BNumericPoint.TYPE;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        if (n > 0) {
            return;
        }
        BCcHrvStatus bCcHrvStatus = (BCcHrvStatus)bZWaveDevice.get(ADD_NAME);
        if (bCcHrvStatus == null) {
            bCcHrvStatus = (BCcHrvStatus)bZWaveDevice.add(ADD_NAME, (BValue)this);
        }
        bCcHrvStatus.readStatusSupported();
    }

    public void doReadStatusSupported() {
        this.doReadStatusSupported(this.getDevice());
    }

    public void doReadStatusSupported(BZWaveDevice bZWaveDevice) {
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{(byte)this.getCommandClass(), 3};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        this.command = zWaveInputStream.readByte();
        if (this.command != 4 && this.command != 2) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassHrvStatus: 0x" + Integer.toHexString(this.command));
            return;
        }
        if (this.command == 2) {
            this.statusParameter = zWaveInputStream.read() & 0xF;
            this.precScaleSize = zWaveInputStream.readByte();
            this.precision = this.precScaleSize >> 5 & 7;
            this.scale = this.precScaleSize >> 3 & 3;
            int n = this.precScaleSize & 7;
            this.value = 0L;
            if (n == 1) {
                this.value = zWaveInputStream.read();
            } else if (n == 2) {
                this.value = zWaveInputStream.read() << 8 | zWaveInputStream.readByte();
            } else if (n == 4) {
                this.value = (long)zWaveInputStream.read() << 32 | (long)zWaveInputStream.readByte() | (long)zWaveInputStream.readByte() | (long)zWaveInputStream.readByte();
            }
            this.updatePoint(bZWaveDevice);
        } else {
            this.statusSupported = zWaveInputStream.readByte();
            if (zWaveInputStream.available() > 0) {
                this.statusSupported += zWaveInputStream.readByte() << 8;
            }
            this.addPoints(bZWaveDevice.getPoints());
        }
    }

    public void updatePoint(BZWaveDevice bZWaveDevice) {
        BZWaveProxyExt bZWaveProxyExt = bZWaveDevice.getProxyExt(this.getCommandClass(), this.getCommandType(), this.getAuxSelector());
        if (bZWaveProxyExt == null) {
            ptLog.trace("could not find proxy for: " + bZWaveDevice.getName() + ".HrvStatus");
            return;
        }
        bZWaveProxyExt.setPrecisionScaleSize(this.getPrecScaleSize());
        BFacets bFacets = this.getReportFacets();
        if (bFacets != null) {
            bZWaveProxyExt.setDeviceFacets(this.getReportFacets());
            bZWaveProxyExt.getParentPoint().setFacets(bZWaveProxyExt.getDeviceFacets());
        }
        bZWaveProxyExt.readOk(this.getValue());
    }

    public int getPrecScaleSize() {
        return this.precScaleSize;
    }

    public void addPoints(BZWavePointDeviceExt bZWavePointDeviceExt) {
        if (this.command != 4) {
            return;
        }
        int n = 0;
        while (n < 7) {
            if ((this.statusSupported & 1 << n) != 0 && bZWavePointDeviceExt.get(ZWaveMessageConst.HRV_STATUS_NAMES[n]) == null) {
                BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, ZWaveMessageConst.HRV_STATUS_NAMES[n], BNumericPoint.TYPE, 55, 1, 0, 2, n, 0, BPollFrequency.normal, BFacets.makeNumeric((BUnit)ZWaveMessageConst.DEG_F, (int)0));
            }
            ++n;
        }
    }

    public int getCommandType() {
        return 2;
    }

    public int getAuxSelector() {
        return this.statusParameter;
    }

    public BFacets getReportFacets() {
        switch (this.statusParameter) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.scale == 0) {
                    return BFacets.makeNumeric((BUnit)ZWaveMessageConst.DEG_C, (int)this.precision);
                }
                return BFacets.makeNumeric((BUnit)ZWaveMessageConst.DEG_F, (int)this.precision);
            }
        }
        return BFacets.makeNumeric((BUnit)ZWaveMessageConst.PERCENT, (int)this.precision);
    }

    public BStatusValue getValue() {
        return new BStatusNumeric((double)this.value / Math.pow(10.0, this.precision));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcHrvStatus;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcHrvStatus = BCcHrvStatus.class("[Lcom.tridium.zwave.cmdclass.BCcHrvStatus;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "hrvStatus";
    }
}

