/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BHrvAutoAction;
import com.tridium.zwave.cmdclass.BHrvModulateAction;
import com.tridium.zwave.cmdclass.BHrvOpenCloseAction;
import com.tridium.zwave.cmdclass.BHrvVentRateAction;
import com.tridium.zwave.cmdclass.BPointCmdClassObject;
import com.tridium.zwave.enums.BZWaveHrvControlMode;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.point.BZWavePointDeviceExt;
import com.tridium.zwave.point.BZWaveProxyExt;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAction;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcHrvControl
extends BPointCmdClassObject
implements ZWaveMessageConst {
    public static final Action readModeSupported = BCcHrvControl.newAction((int)16, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    public static String VENT_RATE_NAME;
    public static String BYPASS_NAME;
    public static String BYPASS_OPEN_CLOSE_ACTION;
    public static String BYPASS_AUTO_ACTION;
    public static String BYPASS_MODULATE_ACTION;
    public static String BYPASS_VENT_RATE_ACTION;
    int manualControlSupported;
    int modesSupported;
    int precScaleSize;
    int precision;
    int scale;
    int command;
    long value;
    BFacets hrvControlFacets;
    BFacets ventRateFacets;
    BFacets bypassFacets;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcHrvControl;

    public void readModeSupported() {
        this.invoke(readModeSupported, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public int getCommandClass() {
        return 57;
    }

    public Type getControlPointType() {
        return BNumericPoint.TYPE;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        BControlPoint bControlPoint;
        BValue bValue;
        BZWavePointDeviceExt bZWavePointDeviceExt = bZWaveDevice.getPoints();
        String string = this.getInstanceName(ADD_NAME, n);
        BCcHrvControl bCcHrvControl = (BCcHrvControl)bZWaveDevice.get(string);
        if (bCcHrvControl == null) {
            bCcHrvControl = (BCcHrvControl)bZWaveDevice.add(string, (BValue)this);
        }
        if ((bValue = bZWavePointDeviceExt.get(string)) == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, string, BEnumWritable.TYPE, 57, 2, 1, 3, -1, n, BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BZWaveHrvControlMode.TYPE)));
        } else {
            bControlPoint = (BControlPoint)bValue;
            ((BZWaveProxyExt)bControlPoint.getProxyExt()).setInstance(n);
        }
        string = this.getInstanceName(VENT_RATE_NAME, n);
        bValue = bZWavePointDeviceExt.get(string);
        if (bValue == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, string, BNumericPoint.TYPE, 57, 8, 7, 9, -1, n, BFacets.makeNumeric((int)0));
        } else {
            bControlPoint = (BControlPoint)bValue;
            ((BZWaveProxyExt)bControlPoint.getProxyExt()).setInstance(n);
        }
        string = this.getInstanceName(BYPASS_NAME, n);
        bValue = bZWavePointDeviceExt.get(string);
        if (bValue == null) {
            BZWavePointDeviceExt.addPoint(bZWavePointDeviceExt, string, BNumericPoint.TYPE, 57, 5, 4, 6, -1, n, BFacets.makeNumeric((int)0));
        } else {
            bControlPoint = (BControlPoint)bValue;
            ((BZWaveProxyExt)bControlPoint.getProxyExt()).setInstance(n);
        }
        bCcHrvControl.readModeSupported();
    }

    public void doReadModeSupported() {
        this.doReadModeSupported(this.getDevice());
    }

    public void doReadModeSupported(BZWaveDevice bZWaveDevice) {
        if (bZWaveDevice != null) {
            byte[] byArray = new byte[]{(byte)this.getCommandClass(), 10};
            this.sendCmd(bZWaveDevice.getNodeId(), byArray);
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        this.command = zWaveInputStream.readByte();
        switch (this.command) {
            case 11: {
                this.processModeSupported(bZWaveDevice, zWaveInputStream);
                break;
            }
            case 6: 
            case 9: {
                this.value = zWaveInputStream.readByte();
                this.updatePoint(bZWaveDevice);
                break;
            }
            case 3: {
                this.value = zWaveInputStream.readByte() & 0x1F;
                this.updatePoint(bZWaveDevice);
                break;
            }
            default: {
                BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassHrvControl: 0x" + Integer.toHexString(this.command));
                return;
            }
        }
    }

    private final void processModeSupported(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        this.manualControlSupported = zWaveInputStream.readByte();
        this.modesSupported = zWaveInputStream.readByte();
        if (zWaveInputStream.available() > 0) {
            this.modesSupported += zWaveInputStream.readByte() << 8;
        }
        ArrayList<BZWaveHrvControlMode> arrayList = new ArrayList<BZWaveHrvControlMode>();
        int n = 1;
        int n2 = 0;
        while (n2 < 5) {
            if ((this.modesSupported & n) != 0) {
                try {
                    arrayList.add(BZWaveHrvControlMode.make(n2));
                }
                catch (Exception exception) {
                    System.out.println(" invalid mode ordinal: " + n2);
                }
            }
            n <<= 1;
            ++n2;
        }
        int[] nArray = new int[arrayList.size()];
        String[] stringArray = new String[nArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            nArray[n3] = ((BZWaveHrvControlMode)((Object)arrayList.get(n3))).getOrdinal();
            stringArray[n3] = TextUtil.capitalize((String)((BZWaveHrvControlMode)((Object)arrayList.get(n3))).getTag());
            ++n3;
        }
        BEnumRange bEnumRange = BEnumRange.make((int[])nArray, (String[])stringArray);
        this.hrvControlFacets = BFacets.makeEnum((BEnumRange)bEnumRange);
        this.updatePointFacets(bZWaveDevice, this.hrvControlFacets);
        if ((this.manualControlSupported & 1) != 0) {
            this.addManualOpenCloseAction(bZWaveDevice);
        }
        if ((this.manualControlSupported & 2) != 0) {
            this.addManualAutoAction(bZWaveDevice);
        }
        if ((this.manualControlSupported & 4) != 0) {
            this.addManualModulateAction(bZWaveDevice);
        }
        if ((this.manualControlSupported & 8) != 0) {
            this.addManualVentRateAction(bZWaveDevice);
        }
    }

    private final void addManualOpenCloseAction(BZWaveDevice bZWaveDevice) {
        this.addPointAction(bZWaveDevice, BYPASS_NAME, BYPASS_OPEN_CLOSE_ACTION, new BHrvOpenCloseAction(), null);
    }

    private final void addManualAutoAction(BZWaveDevice bZWaveDevice) {
        this.addPointAction(bZWaveDevice, BYPASS_NAME, BYPASS_AUTO_ACTION, new BHrvAutoAction(), null);
    }

    private final void addManualModulateAction(BZWaveDevice bZWaveDevice) {
        this.addPointAction(bZWaveDevice, BYPASS_NAME, BYPASS_MODULATE_ACTION, new BHrvModulateAction(), BFacets.makeInt((int)0, (int)99));
    }

    private final void addManualVentRateAction(BZWaveDevice bZWaveDevice) {
        this.addPointAction(bZWaveDevice, VENT_RATE_NAME, BYPASS_VENT_RATE_ACTION, new BHrvVentRateAction(), BFacets.makeInt((int)0, (int)99));
    }

    private final void addPointAction(BZWaveDevice bZWaveDevice, String string, String string2, BAction bAction, BFacets bFacets) {
        Slot slot;
        String string3;
        BZWavePointDeviceExt bZWavePointDeviceExt = bZWaveDevice.getPoints();
        BControlPoint bControlPoint = (BControlPoint)bZWavePointDeviceExt.get(string3 = this.getInstanceName(string, this.getInstance()));
        if (bControlPoint != null && bControlPoint instanceof BControlPoint && (slot = bControlPoint.getSlot(string2)) == null) {
            bControlPoint.add(string2, (BValue)bAction, 0, bFacets, null);
        }
    }

    public int getCommandType() {
        return this.command;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        switch (this.command) {
            case 6: {
                return this.bypassFacets;
            }
            case 9: {
                return this.ventRateFacets;
            }
            case 3: {
                return this.hrvControlFacets;
            }
        }
        return BFacets.DEFAULT;
    }

    public BStatusValue getValue() {
        return new BStatusNumeric((double)this.value);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.bypassFacets = this.ventRateFacets = BFacets.makeNumeric((int)0);
    }

    public BCcHrvControl() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcHrvControl;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcHrvControl = BCcHrvControl.class("[Lcom.tridium.zwave.cmdclass.BCcHrvControl;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "hrvControl";
        VENT_RATE_NAME = "ventilationRate";
        BYPASS_NAME = "bypass";
        BYPASS_OPEN_CLOSE_ACTION = "openClose";
        BYPASS_AUTO_ACTION = "auto";
        BYPASS_MODULATE_ACTION = "set";
        BYPASS_VENT_RATE_ACTION = "set";
    }
}

