/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.cmdclass;

import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.enums.BZWaveApplicationStatusEnum;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCcApplicationStatus
extends BCmdClassObject
implements ZWaveMessageConst {
    public static final Property status = BCcApplicationStatus.newProperty((int)1, (BValue)BZWaveApplicationStatusEnum.none, null);
    public static final Property waitTime = BCcApplicationStatus.newProperty((int)1, (BValue)BRelTime.makeSeconds((int)0), null);
    public static final Property timestamp = BCcApplicationStatus.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Type TYPE;
    public static String ADD_NAME;
    int command;
    static /* synthetic */ Class class$com$tridium$zwave$cmdclass$BCcApplicationStatus;

    public BZWaveApplicationStatusEnum getStatus() {
        return (BZWaveApplicationStatusEnum)this.get(status);
    }

    public void setStatus(BZWaveApplicationStatusEnum bZWaveApplicationStatusEnum) {
        this.set(status, (BValue)bZWaveApplicationStatusEnum, null);
    }

    public BRelTime getWaitTime() {
        return (BRelTime)this.get(waitTime);
    }

    public void setWaitTime(BRelTime bRelTime) {
        this.set(waitTime, (BValue)bRelTime, null);
    }

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime bAbsTime) {
        this.set(timestamp, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int getCommandType() {
        return -1;
    }

    public int getAuxSelector() {
        return -1;
    }

    public BFacets getReportFacets() {
        return BFacets.NULL;
    }

    public BStatusValue getValue() {
        return null;
    }

    public int getCommandClass() {
        return 34;
    }

    public String getDefaultAddName() {
        return ADD_NAME;
    }

    public void addCmdClass(BZWaveDevice bZWaveDevice, int n) {
        if (bZWaveDevice.get(ADD_NAME) == null) {
            bZWaveDevice.add(ADD_NAME, (BValue)this);
        }
    }

    public void processUpdate(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream) {
        this.command = zWaveInputStream.readByte();
        if (this.command != 1 && this.command != 2) {
            BZWaveDevice.usLog.trace(bZWaveDevice.getNodeId() + ": Unsupported command for CommandClassApplicationStatus: 0x" + Integer.toHexString(this.command));
            return;
        }
        try {
            BCcApplicationStatus bCcApplicationStatus = (BCcApplicationStatus)bZWaveDevice.get(ADD_NAME);
            bCcApplicationStatus.readData(zWaveInputStream);
        }
        catch (Exception exception) {
            System.out.println("!!!!!!! applicationStatus object does not exist !!!!!!!!!");
        }
    }

    public void readData(ZWaveInputStream zWaveInputStream) {
        if (this.command == 1) {
            try {
                this.setStatus(BZWaveApplicationStatusEnum.make(zWaveInputStream.readByte()));
            }
            catch (Exception exception) {
                this.setStatus(BZWaveApplicationStatusEnum.invalid);
            }
            this.setWaitTime(BRelTime.makeSeconds((int)zWaveInputStream.readByte()));
            this.setTimestamp(BAbsTime.now());
        } else if (this.command == 2) {
            this.setStatus(BZWaveApplicationStatusEnum.requestRejected);
            this.setWaitTime(BRelTime.makeSeconds((int)0));
            this.setTimestamp(BAbsTime.now());
        }
    }

    public String toString(Context context) {
        return "" + (Object)((Object)this.getStatus()) + ':' + this.getWaitTime() + ' ' + this.getTimestamp();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.command = 0;
    }

    public BCcApplicationStatus() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$cmdclass$BCcApplicationStatus;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$cmdclass$BCcApplicationStatus = BCcApplicationStatus.class("[Lcom.tridium.zwave.cmdclass.BCcApplicationStatus;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ADD_NAME = "applicationStatus";
    }
}

