/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave.association;

import com.tridium.zwave.BLonLink;
import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveNetwork;
import com.tridium.zwave.association.BZWaveAssociationDeviceExt;
import com.tridium.zwave.cmdclass.BNodeInformation;
import com.tridium.zwave.messages.SerialSendData;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.messages.ZWaveOutputStream;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveAssociationGroup
extends BComponent
implements ZWaveMessageConst {
    public static final Property request = BZWaveAssociationGroup.newProperty((int)3, (String)"", null);
    public static final Property groupId = BZWaveAssociationGroup.newProperty((int)1, (int)0, null);
    public static final Property maxNodesSupported = BZWaveAssociationGroup.newProperty((int)1, (int)0, null);
    public static final Property nodes = BZWaveAssociationGroup.newProperty((int)1, (BValue)BBlob.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"zwave:ZWaveBlobFE")));
    public static final Property nodesString = BZWaveAssociationGroup.newProperty((int)1, (String)"", null);
    public static final Property multiInstanceNodes = BZWaveAssociationGroup.newProperty((int)1, (BValue)BBlob.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"zwave:ZWaveBlobFE")));
    public static final Property multiInstanceNodesString = BZWaveAssociationGroup.newProperty((int)1, (String)"", null);
    public static final Property readAssociations = BZWaveAssociationGroup.newProperty((int)7, (boolean)false, null);
    public static final Action read = BZWaveAssociationGroup.newAction((int)16, null);
    public static final Action addNode = BZWaveAssociationGroup.newAction((int)16, (BValue)BString.make((String)""), null);
    public static final Action addNodeNow = BZWaveAssociationGroup.newAction((int)20, (BValue)BString.make((String)""), null);
    public static final Action removeNode = BZWaveAssociationGroup.newAction((int)16, (BValue)BString.make((String)""), null);
    public static final Type TYPE;
    public static Log assocLog;
    public static final int SIMPLE_TYPE = 1;
    public static final int INSTANCE_TYPE = 2;
    public static final int END_POINT_TYPE = 3;
    private boolean firstRun;
    private boolean readPosted;
    private boolean awaitingFirstRead;
    private Vector postVector;
    private boolean linkAdded;
    private boolean multiInstanceLinkAdded;
    static /* synthetic */ Class class$com$tridium$zwave$association$BZWaveAssociationGroup;
    static /* synthetic */ Class class$java$lang$Integer;

    public String getRequest() {
        return this.getString(request);
    }

    public void setRequest(String string) {
        this.setString(request, string, null);
    }

    public int getGroupId() {
        return this.getInt(groupId);
    }

    public void setGroupId(int n) {
        this.setInt(groupId, n, null);
    }

    public int getMaxNodesSupported() {
        return this.getInt(maxNodesSupported);
    }

    public void setMaxNodesSupported(int n) {
        this.setInt(maxNodesSupported, n, null);
    }

    public BBlob getNodes() {
        return (BBlob)this.get(nodes);
    }

    public void setNodes(BBlob bBlob) {
        this.set(nodes, (BValue)bBlob, null);
    }

    public String getNodesString() {
        return this.getString(nodesString);
    }

    public void setNodesString(String string) {
        this.setString(nodesString, string, null);
    }

    public BBlob getMultiInstanceNodes() {
        return (BBlob)this.get(multiInstanceNodes);
    }

    public void setMultiInstanceNodes(BBlob bBlob) {
        this.set(multiInstanceNodes, (BValue)bBlob, null);
    }

    public String getMultiInstanceNodesString() {
        return this.getString(multiInstanceNodesString);
    }

    public void setMultiInstanceNodesString(String string) {
        this.setString(multiInstanceNodesString, string, null);
    }

    public boolean getReadAssociations() {
        return this.getBoolean(readAssociations);
    }

    public void setReadAssociations(boolean bl) {
        this.setBoolean(readAssociations, bl, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public void addNode(BString bString) {
        this.invoke(addNode, (BValue)bString, null);
    }

    public void addNodeNow(BString bString) {
        this.invoke(addNodeNow, (BValue)bString, null);
    }

    public void removeNode(BString bString) {
        this.invoke(removeNode, (BValue)bString, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice();
        BZWaveNetwork bZWaveNetwork = bZWaveDevice.getZWaveNetwork();
        boolean bl = false;
        if (bZWaveNetwork.getAutoAssociate() || !bZWaveDevice.isNodeListening()) {
            int n = bZWaveNetwork.getInterfaceNodeId();
            if (bZWaveNetwork.getEnableMultiChannelSwitchAssoication()) {
                BNodeInformation bNodeInformation = bZWaveDevice.getNodeInfo();
                if (bNodeInformation.isSupported(37) || bNodeInformation.isSupported(38)) {
                    if (this.getGroupId() == 0) {
                        return;
                    }
                    if (!this.getReadAssociations() && this.getNodesString().length() == 0 && this.getMultiInstanceNodesString().length() == 0) {
                        this.awaitingFirstRead = true;
                        this.doRead();
                        return;
                    }
                    bZWaveDevice.setUsingMultiChannelSwitchAssoication(true);
                    bZWaveDevice.setRemapBasicsToSwitches(true);
                    bZWaveDevice.setNoReadAfterBasicSet(true);
                    if (bNodeInformation.isSupported(142) && bNodeInformation.getCommandClassVersion(142) == 2) {
                        if (!this.isNodeMultiInstanceAssoicated(n, 1)) {
                            if (assocLog.isTraceOn()) {
                                assocLog.trace("" + bZWaveDevice.getNodeId() + '[' + this.getGroupId() + "] - Running switch multi-channel association : " + BString.make((String)(Integer.toString(n) + ";1")).toString());
                            }
                            this.addNodeNow(BString.make((String)(Integer.toString(n) + ";1")));
                            this.readPosted = true;
                        }
                        bl = true;
                    } else if (assocLog.isTraceOn()) {
                        assocLog.trace("" + bZWaveDevice.getNodeId() + '[' + this.getGroupId() + "] - Did not locate device support for multi instance association level 2");
                    }
                } else if (assocLog.isTraceOn()) {
                    assocLog.trace("" + bZWaveDevice.getNodeId() + '[' + this.getGroupId() + "] Did not locate the definition for a switch");
                }
            }
            if (assocLog.isTraceOn()) {
                assocLog.trace(bZWaveDevice.getNodeId() + "   isNodeAssociated = " + this.isNodeAssociated(n));
            }
            if (!this.isNodeAssociated(n) && !bl) {
                if (assocLog.isTraceOn()) {
                    assocLog.trace(bZWaveDevice.getNodeId() + " Requesting association " + BString.make((String)Integer.toString(n)));
                }
                this.addNodeNow(BString.make((String)Integer.toString(n)));
                this.readPosted = true;
            }
        }
        this.updateNodesString();
    }

    public BDeviceExt getDeviceExt() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BDeviceExt) {
                return (BDeviceExt)bComplex;
            }
            bComplex = this.getParent();
        }
        return null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)nodes)) {
            if (assocLog.isTraceOn()) {
                assocLog.trace("Assocation nodes updated");
            }
            this.processAssociationChange();
        } else if (property.equals((Object)multiInstanceNodes)) {
            if (assocLog.isTraceOn()) {
                assocLog.trace("Multi-instance / channel assocation nodes updated");
            }
            this.processMultiInstanceAssociationChange();
        } else if (property.equals((Object)groupId) || property.equals((Object)readAssociations) && this.awaitingFirstRead) {
            BZWaveNetwork bZWaveNetwork = ((BZWaveDevice)this.getDeviceExt().getDevice()).getZWaveNetwork();
            if (bZWaveNetwork.getEnableMultiChannelSwitchAssoication()) {
                try {
                    this.started();
                }
                catch (Exception exception) {}
            }
        } else if (property.equals((Object)readAssociations) && this.awaitingFirstRead) {
            this.awaitingFirstRead = false;
            BZWaveNetwork bZWaveNetwork = ((BZWaveDevice)this.getDeviceExt().getDevice()).getZWaveNetwork();
            if (bZWaveNetwork.getEnableMultiChannelSwitchAssoication()) {
                try {
                    this.started();
                }
                catch (Exception exception) {}
            }
        }
    }

    private final void processAssociationChange() {
        byte[] byArray = this.getNodes().copyBytes();
        this.updateAssociationLinks(byArray, 1);
    }

    private final void processMultiInstanceAssociationChange() {
        byte[] byArray = this.getMultiInstanceNodes().copyBytes();
        BZWaveAssociationDeviceExt bZWaveAssociationDeviceExt = (BZWaveAssociationDeviceExt)this.getDeviceExt();
        int n = bZWaveAssociationDeviceExt.getAssociationType();
        this.updateAssociationLinks(byArray, n);
    }

    private final void updateAssociationLinks(byte[] byArray, int n) {
        int n2 = 1;
        if (n != 1) {
            n2 = 2;
        }
        BZWaveAssociationDeviceExt bZWaveAssociationDeviceExt = (BZWaveAssociationDeviceExt)this.getDeviceExt();
        BDevice bDevice = bZWaveAssociationDeviceExt.getDevice();
        Slot slot = bDevice.getSlot("group" + this.getGroupId());
        int n3 = 0;
        while (n3 < byArray.length) {
            BZWaveDevice bZWaveDevice = ((BZWaveNetwork)this.getDeviceExt().getNetwork()).getDevice(byArray[n3] & 0xFF);
            if (bZWaveDevice != null) {
                int n4 = 0;
                if (n != 1) {
                    n4 = byArray[n3 + 1];
                }
                Slot slot2 = bZWaveDevice.getSlot(this.getTargetSlotName(n, n4));
                if (slot != null && slot2 != null) {
                    if (assocLog.isTraceOn()) {
                        assocLog.trace("SourceDev = " + bDevice.getName());
                        assocLog.trace("TargetDev = " + bZWaveDevice.getName());
                    }
                    BLonLink bLonLink = new BLonLink(bDevice.getHandleOrd(), slot.getName(), slot2.getName(), true);
                    if (assocLog.isTraceOn()) {
                        assocLog.trace("  newLink = " + (Object)((Object)bLonLink));
                    }
                    BLink[] bLinkArray = bZWaveDevice.getLinks();
                    boolean bl = false;
                    int n5 = 0;
                    while (n5 < bLinkArray.length) {
                        if (bLinkArray[n5].equivalent((Object)bLonLink)) {
                            bl = true;
                        }
                        ++n5;
                    }
                    if (!bl) {
                        if (assocLog.isTraceOn()) {
                            assocLog.trace("  adding new link");
                        }
                        bZWaveDevice.add("asLink?", (BValue)bLonLink);
                    } else if (assocLog.isTraceOn()) {
                        assocLog.trace("  link alreadyExist");
                    }
                }
            }
            n3 += n2;
        }
        this.cleanUpAssociationLinks(bDevice);
    }

    public void cleanUpAssociationLinks(BDevice bDevice) {
        Slot slot;
        if (assocLog.isTraceOn()) {
            assocLog.trace("Cleaning up association links");
        }
        if ((slot = bDevice.getSlot("group" + this.getGroupId())) == null) {
            return;
        }
        Knob[] knobArray = bDevice.getKnobs(slot);
        boolean[] blArray = new boolean[knobArray.length];
        blArray = this.getValidMembers(1, this.getNodes().copyBytes(), knobArray, blArray);
        blArray = this.getValidMembers(2, this.getMultiInstanceNodes().copyBytes(), knobArray, blArray);
        int n = 0;
        while (n < blArray.length) {
            if (!blArray[n] && (knobArray[n].getTargetSlotName().startsWith(this.getTargetSlotName(1)) || knobArray[n].getTargetSlotName().startsWith(this.getTargetSlotName(2)))) {
                BComponent bComponent = knobArray[n].getTargetComponent();
                if (assocLog.isTraceOn()) {
                    assocLog.trace("  removing link from : " + bComponent.getName());
                    assocLog.trace("    link = " + knobArray[n].getLink());
                }
                bComponent.remove((BComplex)knobArray[n].getLink());
            }
            ++n;
        }
    }

    private final boolean[] getValidMembers(int n, byte[] byArray, Knob[] knobArray, boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        int n2 = 2;
        if (n == 1) {
            n2 = 1;
        }
        String string = this.getTargetSlotName(n);
        int n3 = 0;
        while (n3 < knobArray.length) {
            if (assocLog.isTraceOn()) {
                assocLog.trace("  knob[" + n3 + "] = " + knobArray[n3]);
            }
            BComponent bComponent = knobArray[n3].getTargetComponent();
            if (knobArray[n3].getTargetComponent() instanceof BZWaveDevice) {
                BZWaveDevice bZWaveDevice = (BZWaveDevice)bComponent;
                int n4 = 0;
                while (n4 < byArray.length) {
                    if (assocLog.isTraceOn()) {
                        assocLog.trace("Checking target " + n4);
                        assocLog.trace("Target device " + bZWaveDevice.getNodeId());
                        assocLog.trace("Extracted address " + (byArray[n4] & 0xFF));
                        assocLog.trace("Target slot name " + knobArray[n3].getTargetSlotName());
                        assocLog.trace("Name being searched for : " + string);
                    }
                    if (bZWaveDevice.getNodeId() == (byArray[n4] & 0xFF) && knobArray[n3].getTargetSlotName().startsWith(string)) {
                        blArray[n3] = true;
                    }
                    n4 += n2;
                }
            }
            ++n3;
        }
        return blArray;
    }

    private final String getTargetSlotName(int n) {
        if (n == 3) {
            return "assocInEp";
        }
        return "assocIn";
    }

    private final String getTargetSlotName(int n, int n2) {
        String string = this.getTargetSlotName(n);
        if (n == 1) {
            return string;
        }
        return string + n2;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        BZWaveNetwork bZWaveNetwork;
        BZWaveDevice bZWaveDevice;
        if ((action.equals((Object)addNode) || action.equals((Object)addNodeNow) || action.equals((Object)removeNode) || action.equals((Object)read)) && (bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice()) != null && (bZWaveNetwork = (BZWaveNetwork)bZWaveDevice.getNetwork()) != null) {
            return bZWaveNetwork.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doRead() {
        if (this.postVector.size() > 0) {
            return;
        }
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice();
        if (!bZWaveDevice.isNodeListening()) {
            this.readPosted = true;
            this.setRequest("battery device, read posted");
            return;
        }
        this.sendReadAssociations();
    }

    private final void sendReadAssociations() {
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice();
        SerialSendData serialSendData = null;
        byte[] byArray = null;
        int n = ((BZWaveAssociationDeviceExt)this.getDeviceExt()).getAssociationType();
        int n2 = 133;
        int n3 = 2;
        switch (n) {
            case 2: {
                n2 = 142;
                n3 = 2;
                break;
            }
            case 3: {
                n2 = 142;
                n3 = 2;
                break;
            }
        }
        byArray = new byte[]{(byte)n2, (byte)n3, (byte)this.getGroupId()};
        try {
            serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), byArray, 5);
            BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)bZWaveDevice.getNetwork();
            bZWaveNetwork.sendDataReq(serialSendData);
        }
        catch (Exception exception) {}
    }

    private final int[] parseAddNodeArg(String string) {
        try {
            int[] nArray = new int[3];
            int n = string.indexOf(58);
            int n2 = string.indexOf(59);
            if (n <= 0 && n2 <= 0) {
                nArray[0] = 1;
                nArray[1] = Integer.parseInt(string);
            } else if (n > 0) {
                nArray[0] = 2;
                nArray[1] = Integer.parseInt(string.substring(0, n));
                nArray[2] = Integer.parseInt(string.substring(n + 1));
            } else {
                nArray[0] = 3;
                nArray[1] = Integer.parseInt(string.substring(0, n2));
                nArray[2] = Integer.parseInt(string.substring(n2 + 1));
            }
            return nArray;
        }
        catch (Exception exception) {
            throw new RuntimeException("invalid format, must be #, #:#, or #;#");
        }
    }

    public void doAddNode(BString bString) {
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice();
        if (!bZWaveDevice.isNodeListening()) {
            this.postVector.add("+" + bString);
            this.setRequest("battery device, association add posted");
        } else {
            this.doAddNodeNow(bString);
        }
    }

    public void doAddNodeNow(BString bString) {
        if (assocLog.isTraceOn()) {
            assocLog.trace("Add Node to group: " + bString);
        }
        String string = bString.getString();
        int[] nArray = this.parseAddNodeArg(string);
        this.doAddNode(nArray[0], nArray[1], nArray[2]);
    }

    public void doAddNode(int n, int n2, int n3) {
        byte[] byArray = null;
        switch (n) {
            case 1: {
                byArray = this.getAssociationCmdFrame(n2, 1);
                if (!assocLog.isTraceOn()) break;
                assocLog.trace("add Node to group: " + ByteArrayUtil.toHexString((byte[])byArray));
                break;
            }
            case 2: {
                byArray = this.getMultiInstanceAssociationCmdFrame(n2, n3, 1);
                if (!assocLog.isTraceOn()) break;
                assocLog.trace("add MultiInstanceNode to group: " + ByteArrayUtil.toHexString((byte[])byArray));
                break;
            }
            case 3: {
                byArray = this.getMultiChannelAssociationCmdFrame(n2, n3, 1);
                if (!assocLog.isTraceOn()) break;
                assocLog.trace("add MultiChannelNode to group: " + ByteArrayUtil.toHexString((byte[])byArray));
            }
        }
        if (byArray == null) {
            return;
        }
        SerialSendData serialSendData = null;
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice();
        try {
            serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), byArray, 5, false);
            BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)bZWaveDevice.getNetwork();
            bZWaveNetwork.sendDataReq(serialSendData);
            Thread.sleep(1000L);
            this.sendReadAssociations();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doRemoveNode(BString bString) {
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice();
        if (!bZWaveDevice.isNodeListening()) {
            this.postVector.add("-" + bString);
            this.setRequest("battery device, association remove posted");
        } else {
            if (assocLog.isTraceOn()) {
                assocLog.trace("remove Node from group: " + bString);
            }
            String string = bString.getString();
            int[] nArray = this.parseAddNodeArg(string);
            this.doRemoveNode(nArray[0], nArray[1], nArray[2]);
        }
    }

    public void doRemoveNode(int n, int n2, int n3) {
        byte[] byArray = null;
        switch (n) {
            case 1: {
                byArray = this.getAssociationCmdFrame(n2, 4);
                if (!assocLog.isTraceOn()) break;
                assocLog.trace("remove Node from group: " + ByteArrayUtil.toHexString((byte[])byArray));
                break;
            }
            case 2: {
                byArray = this.getMultiInstanceAssociationCmdFrame(n2, n3, 4);
                if (!assocLog.isTraceOn()) break;
                assocLog.trace("remove MultiInstanceNode from group: " + ByteArrayUtil.toHexString((byte[])byArray));
                break;
            }
            case 3: {
                byArray = this.getMultiChannelAssociationCmdFrame(n2, n3, 4);
                if (!assocLog.isTraceOn()) break;
                assocLog.trace("remove MultiChannelNode from group: " + ByteArrayUtil.toHexString((byte[])byArray));
                break;
            }
        }
        if (byArray == null) {
            return;
        }
        SerialSendData serialSendData = null;
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice();
        try {
            serialSendData = new SerialSendData(bZWaveDevice.getNodeId(), byArray, 5, false);
            BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)bZWaveDevice.getNetwork();
            bZWaveNetwork.sendDataReq(serialSendData);
            Thread.sleep(1000L);
            this.doRead();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void checkPostedAssociations() {
        BZWaveDevice bZWaveDevice = (BZWaveDevice)this.getDeviceExt().getDevice();
        BZWaveNetwork bZWaveNetwork = (BZWaveNetwork)bZWaveDevice.getNetwork();
        int n = bZWaveNetwork.getInterfaceNodeId();
        if (this.firstRun || !this.isNodeAssociated(n)) {
            this.doAddNode(1, n, 0);
            this.firstRun = false;
            this.readPosted = true;
        }
        boolean bl = this.postVector.isEmpty() ^ true;
        while (!this.postVector.isEmpty()) {
            int[] nArray;
            String string = (String)this.postVector.remove(0);
            boolean bl2 = string.startsWith("+");
            String string2 = string.substring(1);
            if (bl2) {
                if (assocLog.isTraceOn()) {
                    assocLog.trace("add Node to group: " + string2);
                }
                nArray = this.parseAddNodeArg(string2);
                this.doAddNode(nArray[0], nArray[1], nArray[2]);
                continue;
            }
            if (assocLog.isTraceOn()) {
                assocLog.trace("remove Node from group: " + string2);
            }
            nArray = this.parseAddNodeArg(string2);
            this.doRemoveNode(nArray[0], nArray[1], nArray[2]);
        }
        if (bl) {
            this.setRequest("processed posted associations - " + BAbsTime.now());
        } else if (this.readPosted) {
            this.readPosted = false;
            this.setRequest("Read processed - " + BAbsTime.now());
            this.sendReadAssociations();
        }
    }

    public static byte[] getAssociationCmdFrame(int n, int n2, int n3) {
        byte[] byArray = null;
        byArray = new byte[]{-123, (byte)n3, (byte)n2, (byte)n};
        return byArray;
    }

    protected byte[] getAssociationCmdFrame(int n, int n2) {
        byte[] byArray = null;
        byArray = new byte[]{-123, (byte)n2, (byte)this.getGroupId(), (byte)n};
        return byArray;
    }

    protected byte[] getMultiInstanceAssociationCmdFrame(int n, int n2, int n3) {
        byte[] byArray = new byte[]{-114, (byte)n3, (byte)this.getGroupId(), 0, (byte)n, (byte)n2};
        return byArray;
    }

    protected byte[] getMultiChannelAssociationCmdFrame(int n, int n2, int n3) {
        if (n2 > 127) {
            if (assocLog.isTraceOn()) {
                assocLog.message("MultiChannelAssociation EndPoint > 127; not supported.");
            }
            return null;
        }
        if (n2 == 0) {
            if (assocLog.isTraceOn()) {
                assocLog.message("MultiChannelAssociation EndPoint == 0; not supported.");
            }
            return null;
        }
        byte[] byArray = new byte[]{-114, (byte)n3, (byte)this.getGroupId(), 0, (byte)n, (byte)n2};
        return byArray;
    }

    public void readData(BZWaveDevice bZWaveDevice, ZWaveInputStream zWaveInputStream, int n) {
        this.readPosted = false;
        this.setGroupId(zWaveInputStream.readByte());
        this.setMaxNodesSupported(zWaveInputStream.readByte());
        zWaveInputStream.readByte();
        ZWaveOutputStream zWaveOutputStream = new ZWaveOutputStream();
        while (zWaveInputStream.available() > 0) {
            int n2 = zWaveInputStream.readByte();
            if (n2 == 0) break;
            zWaveOutputStream.write(n2);
        }
        byte[] byArray = zWaveOutputStream.toByteArray();
        this.setNodes(BBlob.make((byte[])byArray));
        this.updateNodesString();
        byte[] byArray2 = new byte[]{};
        if (n != 1) {
            byArray2 = new byte[zWaveInputStream.available()];
            try {
                zWaveInputStream.read(byArray2);
            }
            catch (Exception exception) {}
            this.setMultiInstanceNodes(BBlob.make((byte[])byArray2));
        }
        if (n == 2) {
            this.updateMultiInstanceNodesString();
        } else {
            this.updateMultiChannelNodesString();
        }
        this.setReadAssociations(true);
    }

    private final void updateNodesString() {
        byte[] byArray = this.getNodes().copyBytes();
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(TextUtil.byteToString((int)byArray[n]));
            if (n != byArray.length - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        this.setNodesString(stringBuffer.toString());
    }

    private final void updateMultiInstanceNodesString() {
        byte[] byArray = this.getMultiInstanceNodes().copyBytes();
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(TextUtil.byteToString((int)byArray[n]));
            stringBuffer.append('-');
            stringBuffer.append(TextUtil.byteToString((int)byArray[n + 1]));
            if (n != byArray.length - 2) {
                stringBuffer.append(',');
            }
            n += 2;
        }
        this.setMultiInstanceNodesString(stringBuffer.toString());
    }

    private final void updateMultiChannelNodesString() {
        byte[] byArray = this.getMultiInstanceNodes().copyBytes();
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(TextUtil.byteToString((int)byArray[n]));
            int n2 = byArray[n + 1] & 0xFF;
            if (n2 >= 128) {
                int n3 = 1;
                int n4 = 0;
                while (n4 < 7) {
                    if ((n2 & n3) != 0) {
                        stringBuffer.append('.');
                        stringBuffer.append(n4 + 1);
                        n3 <<= 1;
                    }
                    ++n4;
                }
            } else {
                stringBuffer.append('.');
                stringBuffer.append(n2);
            }
            if (n != byArray.length - 2) {
                stringBuffer.append(',');
            }
            n += 2;
        }
        this.setMultiInstanceNodesString(stringBuffer.toString());
    }

    public static String getAddRemoveArgument(int n, int n2, int n3) {
        String string = Integer.toString(n2);
        switch (n) {
            case 2: {
                string = "" + n2 + ':' + n3;
                break;
            }
            case 3: {
                string = "" + n2 + ';' + n3;
                break;
            }
        }
        return string;
    }

    public boolean isNodeAssociated(int n) {
        byte[] byArray = this.getNodes().copyBytes();
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isNodeMultiInstanceAssoicated(int n, int n2) {
        byte[] byArray = this.getMultiInstanceNodes().copyBytes();
        int n3 = 0;
        while (n3 < byArray.length) {
            if (byArray[n3] == n && byArray[n3 + 1] == n2) {
                return true;
            }
            n3 += 2;
        }
        return false;
    }

    public int[] getEndPointsMultiAssocatedTo(int n) {
        Class clazz = class$java$lang$Integer;
        if (clazz == null) {
            clazz = class$java$lang$Integer = BZWaveAssociationGroup.class("[Ljava.lang.Integer;", false);
        }
        Array array = new Array(clazz);
        byte[] byArray = this.getMultiInstanceNodes().copyBytes();
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] == n) {
                array.add((Object)new Integer(byArray[n2 + 1]));
            }
            n2 += 2;
        }
        int[] nArray = new int[array.size()];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = (Integer)array.get(n3);
            ++n3;
        }
        return nArray;
    }

    public void setLinkAdded(boolean bl) {
        this.linkAdded = bl;
    }

    public boolean getLinkAdded() {
        return this.linkAdded;
    }

    public void setMultiInstanceLinkAdded(boolean bl) {
        this.multiInstanceLinkAdded = bl;
    }

    public boolean getMultiInstanceLinkAdded() {
        return this.multiInstanceLinkAdded;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.firstRun = true;
        this.readPosted = false;
        this.awaitingFirstRead = false;
        this.postVector = new Vector();
        this.linkAdded = false;
        this.multiInstanceLinkAdded = false;
    }

    public BZWaveAssociationGroup() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$association$BZWaveAssociationGroup;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$association$BZWaveAssociationGroup = BZWaveAssociationGroup.class("[Lcom.tridium.zwave.association.BZWaveAssociationGroup;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        assocLog = Log.getLog((String)"zwave.association");
    }
}

