/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.zwave;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.BCommPlugIn;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.util.BBasicCoalescingWorker;
import com.tridium.basicdriver.util.BBasicWorker;
import com.tridium.zwave.BZWaveDevice;
import com.tridium.zwave.BZWaveDeviceFolder;
import com.tridium.zwave.BZWaveThermostat;
import com.tridium.zwave.BZWaveTuningPolicy;
import com.tridium.zwave.cmdclass.BCcSwitchAll;
import com.tridium.zwave.cmdclass.BCmdClassObject;
import com.tridium.zwave.cmdclass.BNodeInformation;
import com.tridium.zwave.cmdclass.ZwCommandClass;
import com.tridium.zwave.comm.BControllerCapabilities;
import com.tridium.zwave.comm.BZWaveUnsolicitedReceive;
import com.tridium.zwave.comm.ZWaveCommTransaction;
import com.tridium.zwave.comm.serial.BZWaveSerialPlugIn;
import com.tridium.zwave.comm.serial.ZWaveSerialCommReceiver;
import com.tridium.zwave.enums.BGenericDeviceEnum;
import com.tridium.zwave.enums.BSpecificDeviceEnum;
import com.tridium.zwave.enums.BZWaveCommandClass;
import com.tridium.zwave.learn.BZWaveLearnDevicesJob;
import com.tridium.zwave.learn.BZWaveOptimizeNetworkJob;
import com.tridium.zwave.learn.BZWaveReplicateReceiveJob;
import com.tridium.zwave.learn.BZWaveTransferPrimaryJob;
import com.tridium.zwave.messages.SerialApiRequest;
import com.tridium.zwave.messages.SerialApiSetTimeouts;
import com.tridium.zwave.messages.SerialSendData;
import com.tridium.zwave.messages.ZWaveInputStream;
import com.tridium.zwave.messages.ZWaveMessageConst;
import com.tridium.zwave.messages.ZWaveSerialApiRequest;
import com.tridium.zwave.messages.ZWaveSerialFrame;
import com.tridium.zwave.scene.BZWaveSceneId;
import com.tridium.zwave.scene.BZWaveSceneNetworkExt;
import com.tridium.zwave.util.BZWaveApiParam;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.BNetworkExt;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BZWaveNetwork
extends BBasicNetwork
implements ZWaveMessageConst {
    public static final Action upload = BZWaveNetwork.newAction((int)20, (BValue)new BUploadParameters(), null);
    public static final Action download = BZWaveNetwork.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Property retryCount = BZWaveNetwork.newProperty((int)0, (int)0, null);
    public static final Property responseTimeout = BZWaveNetwork.newProperty((int)0, (BValue)BRelTime.make((long)3000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property infoWorker = BZWaveNetwork.newProperty((int)4, (BValue)new BBasicCoalescingWorker(), null);
    public static final Property commPlugIn = BZWaveNetwork.newProperty((int)0, (BValue)new BZWaveSerialPlugIn(), null);
    public static final Property configureAsSis = BZWaveNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property homeId = BZWaveNetwork.newProperty((int)1, (long)0L, (BFacets)BFacets.make((String)"radix", (int)16));
    public static final Property interfaceNodeId = BZWaveNetwork.newProperty((int)1, (int)0, null);
    public static final Property isPrimaryController = BZWaveNetwork.newProperty((int)1, (boolean)false, null);
    public static final Property interfaceCapabilites = BZWaveNetwork.newProperty((int)1, (BValue)new BControllerCapabilities(), null);
    public static final Property useNodeNames = BZWaveNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property autoAssociate = BZWaveNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property autoRoute = BZWaveNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property removeExcludedDevices = BZWaveNetwork.newProperty((int)4, (boolean)false, null);
    public static final Property readBackTime = BZWaveNetwork.newProperty((int)0, (int)2000, (BFacets)BFacets.makeInt((BUnit)ZWaveMessageConst.MILLI_SEC, (int)0, (int)5000));
    public static final Property scenes = BZWaveNetwork.newProperty((int)0, (BValue)new BZWaveSceneNetworkExt(), null);
    public static final Property unsolicitedReceiveHandler = BZWaveNetwork.newProperty((int)0, (BValue)new BZWaveUnsolicitedReceive(), null);
    public static final Property enableMultiChannelSwitchAssoication = BZWaveNetwork.newProperty((int)4, (boolean)false, null);
    public static final Action sendSerialApiRequest = BZWaveNetwork.newAction((int)4, (BValue)new BZWaveApiParam(21), null);
    public static final Action activateScene = BZWaveNetwork.newAction((int)0, (BValue)new BZWaveSceneId(), null);
    public static final Action submitDeviceDiscoveryJob = BZWaveNetwork.newAction((int)0, null);
    public static final Action replicateReceive = BZWaveNetwork.newAction((int)132, null);
    public static final Action transferPrimary = BZWaveNetwork.newAction((int)4, null);
    public static final Action optimizeNetwork = BZWaveNetwork.newAction((int)4, null);
    public static final Action scanForDevices = BZWaveNetwork.newAction((int)4, null);
    public static final Action setAllOn = BZWaveNetwork.newAction((int)272, null);
    public static final Action setAllOff = BZWaveNetwork.newAction((int)272, null);
    public static final Action setSerialApiTimeouts = BZWaveNetwork.newAction((int)4, null);
    public static final Action setInterfaceDefault = BZWaveNetwork.newAction((int)128, null);
    public static final Action saveDeviceProfiles = BZWaveNetwork.newAction((int)16, null);
    public static final Action loadDeviceProfiles = BZWaveNetwork.newAction((int)16, null);
    public static final Action initInterface = BZWaveNetwork.newAction((int)20, null);
    public static final Action dumpNeighborMap = BZWaveNetwork.newAction((int)20, null);
    public static final Action readInterfaceCapabilities = BZWaveNetwork.newAction((int)20, null);
    public static final Action dumpKnownNodes = BZWaveNetwork.newAction((int)20, null);
    public static final Topic switchAllOn = BZWaveNetwork.newTopic((int)0, null);
    public static final Topic switchAllOff = BZWaveNetwork.newTopic((int)0, null);
    public static final Type TYPE;
    public static Log transactionLog;
    private BStatus lastStatus;
    public Object commLock1;
    public Object commLock;
    public ZWaveCommTransaction transaction;
    public boolean replicationInProcess;
    public boolean isAddNodeDone;
    public boolean isControllerChangeDone;
    private TypeInfo[] registeredCommandClasses;
    private String[] routingTable;
    static /* synthetic */ Class class$com$tridium$zwave$BZWaveNetwork;
    static /* synthetic */ Class class$com$tridium$zwave$BZWaveDevice;

    public BBasicWorker getInfoWorker() {
        return (BBasicWorker)this.get(infoWorker);
    }

    public void setInfoWorker(BBasicWorker bBasicWorker) {
        this.set(infoWorker, (BValue)bBasicWorker, null);
    }

    public BCommPlugIn getCommPlugIn() {
        return (BCommPlugIn)this.get(commPlugIn);
    }

    public void setCommPlugIn(BCommPlugIn bCommPlugIn) {
        this.set(commPlugIn, (BValue)bCommPlugIn, null);
    }

    public boolean getConfigureAsSis() {
        return this.getBoolean(configureAsSis);
    }

    public void setConfigureAsSis(boolean bl) {
        this.setBoolean(configureAsSis, bl, null);
    }

    public long getHomeId() {
        return this.getLong(homeId);
    }

    public void setHomeId(long l) {
        this.setLong(homeId, l, null);
    }

    public int getInterfaceNodeId() {
        return this.getInt(interfaceNodeId);
    }

    public void setInterfaceNodeId(int n) {
        this.setInt(interfaceNodeId, n, null);
    }

    public boolean getIsPrimaryController() {
        return this.getBoolean(isPrimaryController);
    }

    public void setIsPrimaryController(boolean bl) {
        this.setBoolean(isPrimaryController, bl, null);
    }

    public BControllerCapabilities getInterfaceCapabilites() {
        return (BControllerCapabilities)this.get(interfaceCapabilites);
    }

    public void setInterfaceCapabilites(BControllerCapabilities bControllerCapabilities) {
        this.set(interfaceCapabilites, (BValue)bControllerCapabilities, null);
    }

    public boolean getUseNodeNames() {
        return this.getBoolean(useNodeNames);
    }

    public void setUseNodeNames(boolean bl) {
        this.setBoolean(useNodeNames, bl, null);
    }

    public boolean getAutoAssociate() {
        return this.getBoolean(autoAssociate);
    }

    public void setAutoAssociate(boolean bl) {
        this.setBoolean(autoAssociate, bl, null);
    }

    public boolean getAutoRoute() {
        return this.getBoolean(autoRoute);
    }

    public void setAutoRoute(boolean bl) {
        this.setBoolean(autoRoute, bl, null);
    }

    public boolean getRemoveExcludedDevices() {
        return this.getBoolean(removeExcludedDevices);
    }

    public void setRemoveExcludedDevices(boolean bl) {
        this.setBoolean(removeExcludedDevices, bl, null);
    }

    public int getReadBackTime() {
        return this.getInt(readBackTime);
    }

    public void setReadBackTime(int n) {
        this.setInt(readBackTime, n, null);
    }

    public BZWaveSceneNetworkExt getScenes() {
        return (BZWaveSceneNetworkExt)this.get(scenes);
    }

    public void setScenes(BZWaveSceneNetworkExt bZWaveSceneNetworkExt) {
        this.set(scenes, (BValue)bZWaveSceneNetworkExt, null);
    }

    public BZWaveUnsolicitedReceive getUnsolicitedReceiveHandler() {
        return (BZWaveUnsolicitedReceive)this.get(unsolicitedReceiveHandler);
    }

    public void setUnsolicitedReceiveHandler(BZWaveUnsolicitedReceive bZWaveUnsolicitedReceive) {
        this.set(unsolicitedReceiveHandler, (BValue)bZWaveUnsolicitedReceive, null);
    }

    public boolean getEnableMultiChannelSwitchAssoication() {
        return this.getBoolean(enableMultiChannelSwitchAssoication);
    }

    public void setEnableMultiChannelSwitchAssoication(boolean bl) {
        this.setBoolean(enableMultiChannelSwitchAssoication, bl, null);
    }

    public void sendSerialApiRequest(BZWaveApiParam bZWaveApiParam) {
        this.invoke(sendSerialApiRequest, (BValue)bZWaveApiParam, null);
    }

    public void activateScene(BZWaveSceneId bZWaveSceneId) {
        this.invoke(activateScene, (BValue)bZWaveSceneId, null);
    }

    public BOrd submitDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, null, null);
    }

    public BOrd replicateReceive() {
        return (BOrd)this.invoke(replicateReceive, null, null);
    }

    public BOrd transferPrimary() {
        return (BOrd)this.invoke(transferPrimary, null, null);
    }

    public BOrd optimizeNetwork() {
        return (BOrd)this.invoke(optimizeNetwork, null, null);
    }

    public BOrd scanForDevices() {
        return (BOrd)this.invoke(scanForDevices, null, null);
    }

    public void setAllOn() {
        this.invoke(setAllOn, null, null);
    }

    public void setAllOff() {
        this.invoke(setAllOff, null, null);
    }

    public void setSerialApiTimeouts() {
        this.invoke(setSerialApiTimeouts, null, null);
    }

    public void setInterfaceDefault() {
        this.invoke(setInterfaceDefault, null, null);
    }

    public void saveDeviceProfiles() {
        this.invoke(saveDeviceProfiles, null, null);
    }

    public void loadDeviceProfiles() {
        this.invoke(loadDeviceProfiles, null, null);
    }

    public void initInterface() {
        this.invoke(initInterface, null, null);
    }

    public void dumpNeighborMap() {
        this.invoke(dumpNeighborMap, null, null);
    }

    public void readInterfaceCapabilities() {
        this.invoke(readInterfaceCapabilities, null, null);
    }

    public void dumpKnownNodes() {
        this.invoke(dumpKnownNodes, null, null);
    }

    public void fireSwitchAllOn(BBoolean bBoolean) {
        this.fire(switchAllOn, (BValue)bBoolean, null);
    }

    public void fireSwitchAllOff(BBoolean bBoolean) {
        this.fire(switchAllOff, (BValue)bBoolean, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "zwave");
    }

    public boolean isParentLegal(BComponent bComponent) {
        Type type = bComponent.getType();
        return type.is(BDriverContainer.TYPE);
    }

    public BINavNode[] getNavChildren() {
        BComponent bComponent;
        this.loadSlots();
        BComponent[] bComponentArray = new BComponent[this.getSlotCount()];
        SlotCursor slotCursor = this.getProperties();
        int n = 0;
        while (slotCursor.nextComponent()) {
            bComponent = (BComponent)slotCursor.get();
            if (Flags.isHidden((BComplex)this, (Slot)slotCursor.property()) || !bComponent.isNavChild() || !(bComponent instanceof BNetworkExt) && bComponent.getPropertyInParent().isFrozen()) continue;
            bComponentArray[n++] = bComponent;
        }
        bComponent = new BComponent[n];
        System.arraycopy(bComponentArray, 0, bComponent, 0, n);
        return bComponent;
    }

    public String getDisplayName(Slot slot, Context context) {
        if (!this.getUseNodeNames()) {
            return super.getDisplayName(slot, context);
        }
        if (!slot.isProperty()) {
            return super.getDisplayName(slot, context);
        }
        BValue bValue = this.get((Property)slot);
        if (!(bValue instanceof BZWaveDevice)) {
            return super.getDisplayName(slot, context);
        }
        BZWaveDevice bZWaveDevice = (BZWaveDevice)bValue;
        String string = "_" + bZWaveDevice.getNodeId();
        String string2 = bZWaveDevice.getNameLocation().trim();
        if (string2.length() != 0) {
            return string2 + string;
        }
        String string3 = bZWaveDevice.getDeviceProfile().trim();
        if (string3.length() != 0) {
            return string3 + string;
        }
        BSpecificDeviceEnum bSpecificDeviceEnum = bZWaveDevice.getNodeInfo().getSpecificDeviceClass();
        if (!bSpecificDeviceEnum.equals(BSpecificDeviceEnum.none)) {
            return bSpecificDeviceEnum.getTag() + string;
        }
        return super.getDisplayName(slot, context);
    }

    public Type getDeviceType() {
        return BZWaveDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BZWaveDeviceFolder.TYPE;
    }

    public void doPing() throws Exception {
        ZWaveSerialApiRequest zWaveSerialApiRequest = new ZWaveSerialApiRequest(0, 32, null);
        ZWaveSerialFrame zWaveSerialFrame = (ZWaveSerialFrame)this.sendZWaveSync(new ZWaveSerialFrame(zWaveSerialApiRequest, true));
        if (zWaveSerialFrame == null) {
            this.pingFail("unable to communicate to interface");
        } else {
            this.pingOk();
        }
    }

    public void started() throws Exception {
        super.started();
        BTuningPolicyMap bTuningPolicyMap = this.getTuningPolicies();
        BValue bValue = bTuningPolicyMap.get("flirsPolicy");
        if (bValue == null) {
            bTuningPolicyMap.add("flirsPolicy", (BValue)new BZWaveTuningPolicy(BRelTime.makeHours((int)1)));
        }
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void atSteadyState() {
        this.initInterface();
    }

    public void changed(Property property, Context context) {
        if (property.equals((Object)status)) {
            BStatus bStatus = this.getStatus();
            if (!bStatus.isFault() && this.lastStatus.isFault()) {
                this.lastStatus = bStatus;
                return;
            }
            this.lastStatus = bStatus;
        }
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    protected Comm makeComm() {
        return this.getCommPlugIn().makeComm();
    }

    public void startComm() throws Exception {
        super.startComm();
        if (Sys.atSteadyState()) {
            this.initInterface();
        }
    }

    public void notifyNodeAdded(int n, ZWaveInputStream zWaveInputStream) {
        zWaveInputStream.read();
        BNodeInformation bNodeInformation = new BNodeInformation();
        bNodeInformation.readData(zWaveInputStream);
        BZWaveDevice bZWaveDevice = null;
        if (bNodeInformation.getGenericDeviceClass().equals((Object)BGenericDeviceEnum.genericThermostat)) {
            bZWaveDevice = new BZWaveThermostat();
        } else {
            if (!bNodeInformation.isControlledDevice()) {
                return;
            }
            bZWaveDevice = new BZWaveDevice();
        }
        bZWaveDevice.setNodeId(n);
        bZWaveDevice.setNodeInfo(bNodeInformation);
        if (bZWaveDevice.getNodeInfo().isDefined()) {
            BZWaveDevice bZWaveDevice2 = this.getDevice(n);
            if (bZWaveDevice2 != null) {
                bZWaveDevice2.getNodeInfo().copyFrom((BComplex)bZWaveDevice.getNodeInfo());
                bZWaveDevice2.requestProtocolInfo();
            } else {
                byte[] byArray = bZWaveDevice.getNodeInfo().getCmdClassesRaw().copyBytes();
                bZWaveDevice.getNodeInfo().setCmdClassesRaw(BBlob.DEFAULT);
                Property property = this.add("node_" + n, (BValue)((BZWaveDevice)bZWaveDevice.newCopy()));
                bZWaveDevice2 = (BZWaveDevice)this.get(property);
                bZWaveDevice2.requestProtocolInfo();
                bZWaveDevice2.getNodeInfo().setCmdClassesRaw(BBlob.make((byte[])byArray));
            }
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)initInterface) || action.equals((Object)dumpNeighborMap) || action.equals((Object)setAllOn) || action.equals((Object)setAllOff) || action.equals((Object)dumpKnownNodes)) {
            return this.postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doInitInterface() {
        this.doSetSerialApiTimeouts();
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {}
        this.doSendSerialApiRequest(new BZWaveApiParam(21));
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {}
        this.doSendSerialApiRequest(new BZWaveApiParam(7));
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {}
        this.doEnableSuc();
        this.doSetSucNodeId();
        this.doSendSerialApiRequest(new BZWaveApiParam(5));
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {}
        ZWaveSerialApiRequest zWaveSerialApiRequest = new ZWaveSerialApiRequest(0, 32, null);
        this.sendZWaveSync(new ZWaveSerialFrame(zWaveSerialApiRequest, false));
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {}
    }

    public void doReadInterfaceCapabilities() {
        this.doSendSerialApiRequest(new BZWaveApiParam(5));
    }

    public void doEnableSuc() {
        byte[] byArray = new byte[]{1, this.getConfigureAsSis() ? (byte)1 : 0};
        SerialApiRequest serialApiRequest = new SerialApiRequest(82, byArray);
        ZWaveSerialFrame zWaveSerialFrame = (ZWaveSerialFrame)this.sendZWaveSync(new ZWaveSerialFrame(serialApiRequest, true));
        if (zWaveSerialFrame == null) {
            this.pingFail("unable to communicate to interface");
        } else {
            this.pingOk();
        }
    }

    public void doSetSucNodeId() {
        byte[] byArray = new byte[]{(byte)this.getInterfaceNodeId(), 1, 0, this.getConfigureAsSis() ? (byte)1 : 0, -103};
        SerialApiRequest serialApiRequest = new SerialApiRequest(84, byArray);
        this.sendZWaveSync(new ZWaveSerialFrame(serialApiRequest, true));
    }

    public void doSaveDeviceProfiles() {
        BDevice[] bDeviceArray = this.getDevices();
        int n = 0;
        while (n < bDeviceArray.length) {
            if (bDeviceArray[n].getType().is(BZWaveDevice.TYPE)) {
                ((BZWaveDevice)bDeviceArray[n]).doSaveDeviceProfile();
            }
            ++n;
        }
    }

    public void doLoadDeviceProfiles() {
        BDevice[] bDeviceArray = this.getDevices();
        int n = 0;
        while (n < bDeviceArray.length) {
            if (bDeviceArray[n].getType().is(BZWaveDevice.TYPE)) {
                ((BZWaveDevice)bDeviceArray[n]).doLoadDeviceProfile();
            }
            ++n;
        }
    }

    public void doActivateScene(BZWaveSceneId bZWaveSceneId) {
        SerialSendData serialSendData = null;
        byte[] byArray = null;
        byArray = new byte[]{43, 1, (byte)bZWaveSceneId.getSceneId(), -1};
        try {
            serialSendData = new SerialSendData(255, byArray, 5, false);
            this.sendDataReq(serialSendData);
        }
        catch (Exception exception) {}
    }

    public void doSendSerialApiRequest(BZWaveApiParam bZWaveApiParam) {
        SerialApiRequest serialApiRequest = null;
        try {
            int n = bZWaveApiParam.getCmd();
            int n2 = bZWaveApiParam.getNodeId();
            if (n2 <= 0) {
                serialApiRequest = new SerialApiRequest(n);
            } else {
                byte[] byArray = new byte[]{(byte)n2};
                serialApiRequest = new SerialApiRequest(n, byArray);
            }
            this.sendZWaveSync(new ZWaveSerialFrame(serialApiRequest));
        }
        catch (Exception exception) {}
    }

    public void doSetSerialApiTimeouts() {
        SerialApiSetTimeouts serialApiSetTimeouts = null;
        try {
            BZWaveSerialPlugIn bZWaveSerialPlugIn = (BZWaveSerialPlugIn)this.getCommPlugIn();
            int n = bZWaveSerialPlugIn.getZwAckTimeout();
            int n2 = bZWaveSerialPlugIn.getZwByteTimeout();
            serialApiSetTimeouts = new SerialApiSetTimeouts(n, n2);
            this.sendZWaveSync(new ZWaveSerialFrame(serialApiSetTimeouts));
        }
        catch (Exception exception) {}
    }

    public BOrd doReplicateReceive() {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BZWaveReplicateReceiveJob bZWaveReplicateReceiveJob = new BZWaveReplicateReceiveJob(this);
        return bZWaveReplicateReceiveJob.submit(null);
    }

    public BOrd doOptimizeNetwork() {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BZWaveOptimizeNetworkJob bZWaveOptimizeNetworkJob = new BZWaveOptimizeNetworkJob(this);
        return bZWaveOptimizeNetworkJob.submit(null);
    }

    public BZWaveDevice getDevice(int n) {
        Class clazz = class$com$tridium$zwave$BZWaveDevice;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$BZWaveDevice = BZWaveNetwork.class("[Lcom.tridium.zwave.BZWaveDevice;", false);
        }
        BZWaveDevice[] bZWaveDeviceArray = (BZWaveDevice[])this.getChildren(clazz);
        int n2 = 0;
        while (n2 < bZWaveDeviceArray.length) {
            if (bZWaveDeviceArray[n2].getNodeId() == n) {
                return bZWaveDeviceArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public BOrd doSubmitDeviceDiscoveryJob() {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BZWaveLearnDevicesJob bZWaveLearnDevicesJob = new BZWaveLearnDevicesJob(this);
        return bZWaveLearnDevicesJob.submit(null);
    }

    public BOrd doTransferPrimary() {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BZWaveTransferPrimaryJob bZWaveTransferPrimaryJob = new BZWaveTransferPrimaryJob(this);
        return bZWaveTransferPrimaryJob.submit(null);
    }

    public BOrd doScanForDevices() {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BZWaveLearnDevicesJob bZWaveLearnDevicesJob = new BZWaveLearnDevicesJob(this, BZWaveLearnDevicesJob.DEVICE_SCAN_ONLY);
        return bZWaveLearnDevicesJob.submit(null);
    }

    public void doSetInterfaceDefault() {
        Object object;
        SerialApiRequest serialApiRequest = null;
        try {
            object = new byte[]{-103};
            serialApiRequest = new SerialApiRequest(66, (byte[])object);
            this.sendZWaveSync(new ZWaveSerialFrame(serialApiRequest, true));
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        this.doReadInterfaceCapabilities();
        object = new ZWaveSerialApiRequest(0, 32, null);
        this.sendZWaveSync(new ZWaveSerialFrame((ZWaveSerialApiRequest)object, false));
    }

    public void doSetInterfaceLearnMode(boolean bl) {
        this.setAddNodeDone(false);
        SerialApiRequest serialApiRequest = null;
        try {
            byte[] byArray = new byte[]{bl ? (byte)1 : 0};
            serialApiRequest = new SerialApiRequest(80, byArray);
            this.sendZWaveSync(new ZWaveSerialFrame(serialApiRequest));
        }
        catch (Exception exception) {}
    }

    public void doSetInterfaceControllerChange() {
        this.setControllerChangeDone(false);
        SerialApiRequest serialApiRequest = null;
        try {
            byte[] byArray = new byte[]{2};
            serialApiRequest = new SerialApiRequest(77, byArray);
            this.sendZWaveSync(new ZWaveSerialFrame(serialApiRequest));
        }
        catch (Exception exception) {}
    }

    public void processApplicationCommand(ZWaveInputStream zWaveInputStream) {
        BCmdClassObject bCmdClassObject;
        zWaveInputStream.readByte();
        int n = zWaveInputStream.readByte();
        if (BZWaveUnsolicitedReceive.usLog.isTraceOn()) {
            BZWaveUnsolicitedReceive.usLog.trace((Object)((Object)BZWaveCommandClass.getTag(n)) + "(0x" + Integer.toHexString(n) + ')');
        }
        if ((bCmdClassObject = this.getCommandClassInstance(n)) != null && bCmdClassObject instanceof BCcSwitchAll) {
            int n2 = zWaveInputStream.readByte();
            if (BZWaveUnsolicitedReceive.usLog.isTraceOn()) {
                BZWaveUnsolicitedReceive.usLog.trace("Network: Switch all from unknown (Primary Controller likely) device - state 0x" + Integer.toHexString(n2));
            }
            switch (n2) {
                case 4: {
                    this.fireSwitchAllOn(BBoolean.TRUE);
                    break;
                }
                case 5: {
                    this.fireSwitchAllOff(BBoolean.FALSE);
                    break;
                }
                default: {
                    if (!BZWaveUnsolicitedReceive.usLog.isTraceOn()) break;
                    BZWaveUnsolicitedReceive.usLog.trace("Network: Switch all unknown state " + n2);
                }
            }
        }
    }

    public void doSetAllOn() {
        this.setAllOnOff(false);
    }

    public void doSetAllOff() {
        this.setAllOnOff(true);
    }

    public void setAllOnOff(boolean bl) {
        int[] nArray = BZWaveNetwork.getNodeIds(this);
        byte[] byArray = ZwCommandClass.ZW_AllSwitchOnFrame();
        if (bl) {
            byArray = ZwCommandClass.ZW_AllSwitchOffFrame();
        }
        SerialSendData serialSendData = null;
        try {
            serialSendData = new SerialSendData(nArray, byArray, 5);
            this.sendDataReq(serialSendData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doDumpNeighborMap() {
        Vector<String> vector = new Vector<String>();
        vector.add("Neighbor Routing Map");
        vector.add(BAbsTime.now().toString());
        vector.add("              1         2         3         4         5         6    ");
        vector.add("     1234567890123456789012345678901234567890123456789012345678901234");
        boolean bl = false;
        int n = 1;
        while (n < 65) {
            byte[] byArray = this.getRoutingTable(n);
            if (byArray.length != 0) {
                boolean bl2 = true;
                int n2 = 0;
                while (n2 < byArray.length) {
                    if (byArray[n2] != 0) {
                        bl2 = false;
                        break;
                    }
                    ++n2;
                }
                if (!bl2) {
                    String string = "00" + n;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string.substring(string.length() - 3));
                    stringBuffer.append(": ");
                    int n3 = 0;
                    while (n3 < byArray.length) {
                        int n4 = 1;
                        int n5 = 0;
                        while (n5 < 8) {
                            int n6 = n3 * 8 + n5 + 1;
                            if ((byArray[n3] & n4) == 0) {
                                stringBuffer.append(' ');
                            } else {
                                stringBuffer.append(n6 % 10);
                            }
                            n4 <<= 1;
                            ++n5;
                        }
                        ++n3;
                    }
                    vector.add(stringBuffer.toString().trim());
                }
            }
            ++n;
        }
        this.routingTable = new String[vector.size()];
        vector.toArray(this.routingTable);
        n = 0;
        while (n < this.routingTable.length) {
            System.out.println(this.routingTable[n]);
            ++n;
        }
    }

    public void doDumpKnownNodes() {
        System.out.println("Nodes known about");
        System.out.println("Our node id : " + this.getInterfaceNodeId());
        byte[] byArray = this.getKnownNodes();
        int n = 1;
        while (n <= 232) {
            int n2 = n - 1;
            int n3 = n2 / 8;
            int n4 = 1 << n2 % 8;
            System.out.println("Node id : " + n + " = " + ((byArray[n3] & n4) != 0 ? "known" : "unknown"));
            ++n;
        }
    }

    public byte[] getKnownNodes() {
        ZWaveSerialApiRequest zWaveSerialApiRequest = new ZWaveSerialApiRequest(0, 2, null);
        ZWaveSerialFrame zWaveSerialFrame = (ZWaveSerialFrame)this.sendZWaveSync(new ZWaveSerialFrame(zWaveSerialApiRequest, true));
        ZWaveInputStream zWaveInputStream = new ZWaveInputStream(zWaveSerialFrame.getData(), 0, zWaveSerialFrame.getLength());
        zWaveInputStream.read();
        zWaveInputStream.read();
        int n = zWaveInputStream.readByte();
        zWaveInputStream.readByte();
        int n2 = zWaveInputStream.readByte();
        zWaveInputStream.readByte();
        byte[] byArray = new byte[29];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[n3] = (byte)zWaveInputStream.readByte();
            ++n3;
        }
        return byArray;
    }

    public String[] getRoutingTable() {
        return this.routingTable;
    }

    public byte[] getRoutingTable(int n) {
        byte[] byArray = new byte[]{(byte)n, 1, 1};
        SerialApiRequest serialApiRequest = new SerialApiRequest(128, byArray);
        ZWaveSerialFrame zWaveSerialFrame = (ZWaveSerialFrame)this.sendZWaveSync(new ZWaveSerialFrame(serialApiRequest, true));
        if (zWaveSerialFrame == null || zWaveSerialFrame.getData() == null) {
            throw new RuntimeException("Get Routing Table not supported by interface");
        }
        return BBlob.make((byte[])zWaveSerialFrame.getData(), (int)3, (int)(zWaveSerialFrame.getLength() - 3)).copyBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message sendZWaveSync(Message message) {
        Object object = this.commLock1;
        synchronized (object) {
            return this.sendSync(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendDataReq(SerialSendData serialSendData) {
        Object object;
        if (this.getLog().isTraceOn() && (object = Thread.currentThread().getName()) != null) {
            if (((String)object).equals("Nre:Engine") || ((String)object).startsWith("Fox")) {
                this.getLog().warning("!!!!! RUNNING DATA REQUEST ON ENGINE / FOX THREAD - DUMP START !!!!!!");
                Thread.dumpStack();
                this.getLog().warning("!!!!! RUNNING DATA REQUEST ON ENGINE / FOX THREAD - DUMP END !!!!!!");
            } else {
                this.getLog().trace("Running data request on thread : \"" + (String)object + '\"');
            }
        }
        object = this.commLock;
        synchronized (object) {
            try {
                ZWaveCommTransaction zWaveCommTransaction = this.transaction;
                synchronized (zWaveCommTransaction) {
                    transactionLog.trace(serialSendData.getDestinations()[0] + ": Transaction start");
                    if (this.getAutoRoute()) {
                        serialSendData.setTxOptions(serialSendData.getTxOptions() | 4);
                    } else {
                        serialSendData.setTxOptions(serialSendData.getTxOptions() & 0xFFFFFFFB);
                    }
                    int n = -1;
                    this.transaction.setRequestMessage(serialSendData);
                    this.transaction.setComplete(false);
                    this.transaction.setTxStatus(-1);
                    BRelTime bRelTime = this.getResponseTimeout();
                    this.sendZWaveSync(new ZWaveSerialFrame(serialSendData, true));
                    if (serialSendData.isAppResponseExpected()) {
                        n = this.waitResponse(this.transaction, BRelTime.make((long)(bRelTime.getMillis() + 1000L)));
                    }
                    this.transaction.setRequestMessage(null);
                    transactionLog.trace(serialSendData.getDestinations()[0] + ": Transaction ended");
                    return n;
                }
            }
            catch (Exception exception) {
                System.out.println("BZWaveNetwork.sendSync caught exception: " + exception);
                exception.printStackTrace();
                return -1;
            }
        }
    }

    protected int waitResponse(ZWaveCommTransaction zWaveCommTransaction, BRelTime bRelTime) {
        try {
            if (!zWaveCommTransaction.isComplete()) {
                zWaveCommTransaction.wait(bRelTime.getMillis());
                if (!zWaveCommTransaction.isComplete()) {
                    if (this.getLog().isTraceOn()) {
                        this.getLog().trace("CommTransaction timed out " + this.getName());
                    }
                    transactionLog.trace(zWaveCommTransaction.getRequestMessage().getDestinations()[0] + ": Transaction timed out");
                    this.incrementTimeouts();
                }
                zWaveCommTransaction.setComplete(true);
            }
        }
        catch (InterruptedException interruptedException) {}
        return zWaveCommTransaction.getTxStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void messageComplete(int n) {
        ZWaveCommTransaction zWaveCommTransaction = this.transaction;
        synchronized (zWaveCommTransaction) {
            if (this.transaction.getRequestMessage() == null) {
                return;
            }
            this.transaction.setTxStatus(n);
            this.transaction.setComplete(true);
            transactionLog.trace(this.transaction.getRequestMessage().getDestinations()[0] + ": Transaction.notify() via messageComplete");
            this.transaction.notify();
            return;
        }
    }

    public void initRegisteredCommandClasses() {
        if (this.registeredCommandClasses == null) {
            this.registeredCommandClasses = Sys.getRegistry().getTypes(BCmdClassObject.TYPE.getTypeInfo());
        }
    }

    public BCmdClassObject getCommandClassInstance(int n) {
        BCmdClassObject bCmdClassObject = null;
        this.initRegisteredCommandClasses();
        int n2 = 0;
        while (n2 < this.registeredCommandClasses.length) {
            try {
                if (!this.registeredCommandClasses[n2].isAbstract() && (bCmdClassObject = (BCmdClassObject)this.registeredCommandClasses[n2].getInstance()) != null && bCmdClassObject.getCommandClass() == n) {
                    return bCmdClassObject;
                }
            }
            catch (Exception exception) {
                System.out.println(" trying to create an instance for command class 0x" + Integer.toHexString(n));
                exception.printStackTrace();
            }
            ++n2;
        }
        return null;
    }

    public static int[] getNodeIds(BZWaveNetwork bZWaveNetwork) {
        Class clazz = class$com$tridium$zwave$BZWaveDevice;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$BZWaveDevice = BZWaveNetwork.class("[Lcom.tridium.zwave.BZWaveDevice;", false);
        }
        BZWaveDevice[] bZWaveDeviceArray = (BZWaveDevice[])bZWaveNetwork.getChildren(clazz);
        int[] nArray = new int[bZWaveDeviceArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = bZWaveDeviceArray[n].getNodeId();
            ++n;
        }
        return nArray;
    }

    public boolean isAddNodeDone() {
        return this.isAddNodeDone;
    }

    public void setAddNodeDone(boolean bl) {
        this.isAddNodeDone = bl;
    }

    public boolean isControllerChangeDone() {
        return this.isControllerChangeDone;
    }

    public void setControllerChangeDone(boolean bl) {
        this.isControllerChangeDone = bl;
    }

    public boolean isReplicationInProcess() {
        return this.replicationInProcess;
    }

    public void setReplicationInProcess(boolean bl) {
        this.replicationInProcess = bl;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        this.dumpNeighborMap();
        spyWriter.startTable(false);
        spyWriter.trTitle((Object)"ZWaveNetwork", 1);
        spyWriter.endTable();
        spyWriter.startProps();
        ZWaveSerialCommReceiver zWaveSerialCommReceiver = (ZWaveSerialCommReceiver)this.getComm().getCommReceiver();
        int n = zWaveSerialCommReceiver.getRxMsgCount();
        int n2 = zWaveSerialCommReceiver.getRxCanCount();
        int n3 = zWaveSerialCommReceiver.getRxNakCount();
        int n4 = zWaveSerialCommReceiver.getRxLrcErrors();
        spyWriter.prop((Object)"Total Received Messages", (Object)new Long(n));
        spyWriter.prop((Object)"CAN frames received", (Object)new Long(n2));
        spyWriter.prop((Object)"NAK frames received", (Object)new Long(n3));
        spyWriter.prop((Object)"Lrc receive errors", (Object)new Long(n4));
        spyWriter.endProps();
        String[] stringArray = this.getRoutingTable();
        if (stringArray != null) {
            spyWriter.startTable(false);
            spyWriter.trTitle((Object)"Z-Wave interface routing table", 1);
            spyWriter.endTable();
            spyWriter.w((Object)"<pre>\n");
            int n5 = 0;
            while (n5 < stringArray.length) {
                spyWriter.safe(stringArray[n5], false).w((Object)"\n");
                ++n5;
            }
        }
    }

    public static String getTxResultString(int n) {
        switch (n) {
            case 0: {
                return "TxOK";
            }
            case 1: {
                return "Tx Ack Not Received";
            }
            case 2: {
                return "Tx Ack Not Received";
            }
            case 4: {
                return "Tx No Route found";
            }
            case 128: {
                return "Tx Queue Overflow";
            }
            case -1: {
                return "Tx Ack Timeout";
            }
        }
        return "txResults = 0x" + Integer.toHexString(n);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastStatus = BStatus.ok;
        this.commLock1 = new Object();
        this.commLock = new Object();
        this.transaction = new ZWaveCommTransaction();
        this.replicationInProcess = false;
        this.isAddNodeDone = false;
        this.isControllerChangeDone = false;
        this.routingTable = null;
    }

    public BZWaveNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$zwave$BZWaveNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$zwave$BZWaveNetwork = BZWaveNetwork.class("[Lcom.tridium.zwave.BZWaveNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        transactionLog = Log.getLog((String)"zwave.transaction");
    }
}

