/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.HelpSystem;
import com.tridium.help.ui.HelpTreeNode;
import com.tridium.help.ui.TocNode;
import java.io.BufferedInputStream;
import java.io.InputStream;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.tree.TreeModel;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class TocRootNode
extends HelpTreeNode {
    private static BImage icon = BImage.make((String)"module://icons/x16/file.png");
    private String moduleName;
    private String name;

    public TocRootNode(TreeModel treeModel, String string) {
        super(treeModel, BOrd.make((String)("local:|module://" + string + "/doc/index.html")));
        this.moduleName = string;
        this.name = TextUtil.toFriendly((String)string);
    }

    public String getText() {
        return this.name;
    }

    public BImage getIcon() {
        return icon;
    }

    protected HelpTreeNode[] buildChildNodes() {
        if (this.kids == null) {
            this.populate();
        }
        return this.kids;
    }

    private void populate() {
        BufferedInputStream bufferedInputStream = HelpSystem.getJarEntryInputStream(this.moduleName, "doc/toc.xml");
        if (bufferedInputStream == null) {
            throw new IllegalStateException();
        }
        try {
            XElem xElem = XParser.make((InputStream)bufferedInputStream).parse();
            this.loadNodes(this.moduleName, this, xElem);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    private void loadNodes(String string, HelpTreeNode helpTreeNode, XElem xElem) {
        XElem[] xElemArray = xElem.elems();
        HelpTreeNode[] helpTreeNodeArray = new HelpTreeNode[xElemArray.length];
        for (int i = 0; i < xElemArray.length; ++i) {
            try {
                XElem xElem2 = xElemArray[i];
                String string2 = xElem2.get("target", null);
                String string3 = xElem2.get("text", null);
                if (string2 == null || string3 == null) continue;
                BOrd bOrd = BOrd.make((String)("local:|module://" + string + "/doc/" + string2));
                helpTreeNodeArray[i] = new TocNode(this, bOrd, string3);
                this.loadNodes(string, (TocNode)helpTreeNodeArray[i], xElem2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (helpTreeNode == this) {
            this.kids = helpTreeNodeArray;
        } else {
            ((TocNode)helpTreeNode).setChildren(helpTreeNodeArray);
        }
    }
}

