/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.parser.BajadocParser;
import com.tridium.help.ui.DocClassNode;
import com.tridium.help.ui.DocModuleNode;
import com.tridium.help.ui.HelpTreeNode;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BIcon;

public class DocPackageNode
extends HelpTreeNode {
    private static BImage icon = BImage.make((BIcon)PackageDoc.ICON);
    private static BImage classIcon = BImage.make((BIcon)ClassDoc.defaultIcon);
    private String moduleName;
    private String packageName;

    public DocPackageNode(HelpTreeNode helpTreeNode, BOrd bOrd, String string, String string2) {
        super(helpTreeNode, bOrd);
        this.moduleName = string;
        this.packageName = string2;
    }

    public String getText() {
        return this.packageName;
    }

    public BImage getIcon() {
        return icon;
    }

    protected HelpTreeNode[] buildChildNodes() {
        if (this.kids == null) {
            this.populate();
        }
        return this.kids;
    }

    private void populate() {
        this.kids = new HelpTreeNode[0];
        try {
            BIFile bIFile = (BIFile)this.getContentOrd().resolve().get();
            BajadocParser bajadocParser = new BajadocParser();
            PackageDoc packageDoc = (PackageDoc)bajadocParser.parse(bIFile.getInputStream());
            ClassSummary[] classSummaryArray = packageDoc.classesSorted();
            this.kids = new HelpTreeNode[classSummaryArray.length];
            for (int i = 0; i < classSummaryArray.length; ++i) {
                this.kids[i] = new DocClassNode(this, DocModuleNode.getClassOrd(this.moduleName, classSummaryArray[i]), DocModuleNode.getClassName(classSummaryArray[i]), classIcon);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

