/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.HelpSystem;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.parser.BajadocParser;
import com.tridium.help.ui.DocClassNode;
import com.tridium.help.ui.DocGroupingNode;
import com.tridium.help.ui.DocPackageNode;
import com.tridium.help.ui.DocTreeModel;
import com.tridium.help.ui.HelpTreeNode;
import java.io.BufferedInputStream;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;

public class DocModuleNode
extends HelpTreeNode {
    private static BImage icon = BImage.make((BIcon)ModuleDoc.ICON);
    private static BImage classIcon = BImage.make((BIcon)ClassDoc.defaultIcon);
    private String moduleName;

    public DocModuleNode(DocTreeModel docTreeModel, String string) {
        super(docTreeModel);
        this.moduleName = string;
        this.setContentOrd(BOrd.make((String)("local:|module://" + string + "/doc/module-index.bajadoc")));
    }

    public String getText() {
        return this.moduleName;
    }

    public BImage getIcon() {
        return icon;
    }

    protected HelpTreeNode[] buildChildNodes() {
        if (this.kids == null) {
            this.populate();
        }
        return this.kids;
    }

    private void populate() {
        this.kids = new HelpTreeNode[0];
        try {
            BufferedInputStream bufferedInputStream = HelpSystem.getJarEntryInputStream(this.moduleName, "doc/module-index.bajadoc");
            if (bufferedInputStream == null) {
                throw new IllegalStateException();
            }
            BajadocParser bajadocParser = new BajadocParser();
            ModuleDoc moduleDoc = (ModuleDoc)bajadocParser.parse(bufferedInputStream);
            ArrayList arrayList = new ArrayList();
            this.addPackages(moduleDoc.packagesSorted(), arrayList);
            this.addClasses("Types", moduleDoc.typesSorted(), arrayList);
            this.kids = new HelpTreeNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.kids[i] = (HelpTreeNode)((Object)arrayList.get(i));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    private void addPackages(PackageDoc[] packageDocArray, ArrayList arrayList) {
        if (packageDocArray != null && packageDocArray.length > 0) {
            DocGroupingNode docGroupingNode = new DocGroupingNode(this, this.getContentOrd(), "Packages");
            HelpTreeNode[] helpTreeNodeArray = new HelpTreeNode[packageDocArray.length];
            for (int i = 0; i < packageDocArray.length; ++i) {
                String string = packageDocArray[i].name();
                helpTreeNodeArray[i] = new DocPackageNode(docGroupingNode, this.getPackageOrd(string), this.moduleName, string);
            }
            docGroupingNode.setChildren(helpTreeNodeArray);
            arrayList.add(docGroupingNode);
        }
    }

    private BOrd getPackageOrd(String string) {
        String string2 = string.replace('.', '/');
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("local:|module://");
        stringBuffer.append(this.moduleName);
        stringBuffer.append("/doc/");
        stringBuffer.append(string2);
        stringBuffer.append("/package-index.bajadoc");
        return BOrd.make((String)stringBuffer.toString());
    }

    private void addClasses(String string, ClassSummary[] classSummaryArray, ArrayList arrayList) {
        if (classSummaryArray != null && classSummaryArray.length > 0) {
            DocGroupingNode docGroupingNode = new DocGroupingNode(this, this.getContentOrd(), string);
            HelpTreeNode[] helpTreeNodeArray = new HelpTreeNode[classSummaryArray.length];
            for (int i = 0; i < classSummaryArray.length; ++i) {
                ClassSummary classSummary = classSummaryArray[i];
                helpTreeNodeArray[i] = new DocClassNode(docGroupingNode, DocModuleNode.getClassOrd(this.moduleName, classSummary), DocModuleNode.getClassName(classSummary), classIcon);
            }
            docGroupingNode.setChildren(helpTreeNodeArray);
            arrayList.add(docGroupingNode);
        }
    }

    static BOrd getClassOrd(String string, ClassSummary classSummary) {
        String string2 = classSummary.qualifiedName();
        String string3 = TextUtil.getClassName((String)string2).replace('$', '.');
        String string4 = classSummary.packageName().replace('.', '/');
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("local:|module://");
        stringBuffer.append(string);
        stringBuffer.append("/doc/");
        stringBuffer.append(string4);
        stringBuffer.append("/");
        stringBuffer.append(string3);
        stringBuffer.append(".bajadoc");
        return BOrd.make((String)stringBuffer.toString());
    }

    static String getClassName(ClassSummary classSummary) {
        String string = classSummary.qualifiedName();
        String string2 = TextUtil.getClassName((String)string).replace('$', '.');
        return string2;
    }
}

