/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.ui;

import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.html.HtmlCompiler;
import com.tridium.help.bajadoc.ui.BBajadocViewer;
import com.tridium.help.bajadoc.ui.Segment;
import com.tridium.html.canvas.BHtmlCanvas;
import com.tridium.html.canvas.HtmlCanvasContainer;
import com.tridium.html.canvas.HtmlController;
import com.tridium.ui.theme.Theme;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

public abstract class BDocPane
extends BWidget
implements HtmlCanvasContainer {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$help$bajadoc$ui$BDocPane == null ? (class$com$tridium$help$bajadoc$ui$BDocPane = BDocPane.class$("com.tridium.help.bajadoc.ui.BDocPane")) : class$com$tridium$help$bajadoc$ui$BDocPane));
    static BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    static int EXPANDER_DIM = 11;
    private final BInsets margin = BInsets.make((double)(this.getInset() + 5.0), (double)(this.getInset() + 5.0), (double)this.getInset(), (double)this.getInset());
    private final BBrush detailsFill = BBrush.make((String)"#ddd");
    BBajadocViewer viewer;
    String packageName;
    Doc doc;
    BImage icon;
    BHtmlCanvas[] labels;
    BWidget details;
    int expanderX;
    int expanderY;
    private boolean expanded = false;
    static /* synthetic */ Class class$com$tridium$help$bajadoc$ui$BDocPane;

    public Type getType() {
        return TYPE;
    }

    protected BDocPane(BBajadocViewer bBajadocViewer, String string, Doc doc) {
        BIcon bIcon;
        this.viewer = bBajadocViewer;
        this.packageName = string;
        this.doc = doc;
        if (doc != null && (bIcon = doc.icon()) != null) {
            this.icon = BImage.make((BIcon)bIcon);
        }
    }

    protected void initLabels(ArrayList arrayList) {
        this.labels = arrayList.toArray(new BHtmlCanvas[arrayList.size()]);
        for (int i = 0; i < this.labels.length; ++i) {
            this.add("label" + i, (BValue)this.labels[i]);
        }
    }

    private BWidget buildDetails() {
        StringWriter stringWriter = new StringWriter();
        if (this.doc != null) {
            new HtmlCompiler(stringWriter).printDetails(this.doc);
        }
        BHtmlCanvas bHtmlCanvas = new BHtmlCanvas(stringWriter.toString(), new HtmlController(this.viewer.getWbShell(), this.viewer.baseOrd));
        bHtmlCanvas.useInsets(false);
        return bHtmlCanvas;
    }

    public void computePreferredSize() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].computePreferredSize();
            d = Math.max(d, this.labels[i].getPreferredWidth());
            d2 += this.labels[i].getPreferredHeight();
        }
        if (this.expanded) {
            this.details.computePreferredSize();
            d = Math.max(d, this.details.getPreferredWidth() + 10.0);
            d2 += this.details.getPreferredHeight() + 10.0;
        }
        if (this.doc != null) {
            d += 14.0;
        }
        if (this.icon != null) {
            d += 18.0;
        }
        double d3 = this.getInset();
        d += d3 * 2.0;
        d = Math.max(d, this.viewer.getContentWidth());
        this.setPreferredSize(d, d2 += d3 * 2.0);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getInset();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = 2.0;
        if (this.doc != null) {
            d4 += 14.0;
        }
        if (this.icon != null) {
            d4 += 18.0;
        }
        double d5 = d;
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].computePreferredSize();
            double d6 = this.labels[i].getPreferredWidth();
            double d7 = this.labels[i].getPreferredHeight();
            this.labels[i].setBounds(d4 + d, d5, Math.max(d6, d2 - d4 - d), d7);
            d5 += d7;
        }
        this.expanderX = 2;
        this.expanderY = 3;
        if (this.expanded) {
            this.details.setBounds(d + 5.0, d5 + 5.0, d2 - d * 2.0 - 5.0, d3 - d5 - 5.0);
        }
    }

    protected double getInset() {
        return 0.0;
    }

    public void paint(Graphics graphics) {
        double d = this.getInset();
        if (this.doc != null) {
            Theme.tree().paintExpander(graphics, (BWidget)this, (double)this.expanderX + d, (double)this.expanderY + d, this.expanded);
            if (this.icon != null) {
                graphics.setBrush(BColor.black);
                graphics.drawImage(this.icon, 15.0 + d, 0.0 + d);
            }
        }
        for (int i = 0; i < this.labels.length; ++i) {
            this.paintChild(graphics, (BWidget)this.labels[i]);
        }
        if (this.expanded) {
            graphics.setBrush(this.detailsFill);
            graphics.fillRect(40.0, this.details.getY(), this.details.getWidth(), this.details.getHeight());
            this.paintChild(graphics, this.details);
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        RectGeom rectGeom = new RectGeom((double)this.expanderX, (double)this.expanderY, (double)(EXPANDER_DIM + 2), (double)(EXPANDER_DIM + 2));
        if (rectGeom.contains(bMouseEvent.getX(), bMouseEvent.getY())) {
            this.setExpanded(!this.getExpanded());
            this.relayout();
        }
    }

    void typeSegments(ArrayList arrayList, JavaType javaType) {
        arrayList.add(new Segment(javaType.name(), 0, javaType.bajadocOrd()));
        if (javaType.dimension() > 0) {
            arrayList.add(new Segment(javaType.dimensionString(), 0, null));
        }
    }

    boolean getExpanded() {
        return this.expanded;
    }

    void setExpanded(boolean bl) {
        this.expanded = bl;
        if (this.expanded && this.details == null) {
            this.details = this.buildDetails();
            this.add("details", (BValue)this.details);
        }
    }

    public BInsets getMargin() {
        return this.margin;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

