/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.html;

import com.tridium.help.bajadoc.ActionDoc;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.ConstructorDoc;
import com.tridium.help.bajadoc.Description;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.ExecutableDoc;
import com.tridium.help.bajadoc.FieldDoc;
import com.tridium.help.bajadoc.FrameworkDoc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.MemberDoc;
import com.tridium.help.bajadoc.MethodDoc;
import com.tridium.help.bajadoc.ModifierDoc;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.Parameter;
import com.tridium.help.bajadoc.PropertyDoc;
import com.tridium.help.bajadoc.Returns;
import com.tridium.help.bajadoc.SlotDoc;
import com.tridium.help.bajadoc.Throws;
import com.tridium.help.bajadoc.TopicDoc;
import com.tridium.help.bajadoc.html.UriPath;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Flags;

public class HtmlCompiler
extends HtmlWriter {
    private boolean moduleBased;
    private UriPath htmlBaseUri;
    private String extension;

    public HtmlCompiler(Writer writer) {
        super(writer);
        this.moduleBased = true;
        this.htmlBaseUri = null;
        this.extension = "bajadoc";
    }

    public HtmlCompiler(Writer writer, UriPath uriPath) {
        super(writer);
        this.moduleBased = false;
        this.htmlBaseUri = uriPath;
        this.extension = "html";
    }

    public static void compile(Writer writer, Doc doc, boolean bl) {
        HtmlCompiler htmlCompiler;
        HtmlCompiler htmlCompiler2 = htmlCompiler = bl ? new HtmlCompiler(writer) : new HtmlCompiler(writer, UriPath.makeDocURI(doc));
        if (doc instanceof FrameworkDoc) {
            htmlCompiler.doCompileFramework((FrameworkDoc)doc);
        } else if (doc instanceof ModuleDoc) {
            htmlCompiler.doCompileModule((ModuleDoc)doc);
        } else if (doc instanceof PackageDoc) {
            htmlCompiler.doCompilePackage((PackageDoc)doc);
        } else if (doc instanceof ClassDoc) {
            htmlCompiler.doCompileClass((ClassDoc)doc, false);
        } else {
            throw new IllegalStateException(doc.toString());
        }
    }

    public static void compileModule(Writer writer, FrameworkDoc frameworkDoc, boolean bl) {
        HtmlCompiler htmlCompiler = bl ? new HtmlCompiler(writer) : new HtmlCompiler(writer, UriPath.makeFrameworkURI());
        htmlCompiler.doCompileFramework(frameworkDoc);
    }

    public static void compileModule(Writer writer, ModuleDoc moduleDoc, boolean bl) {
        HtmlCompiler htmlCompiler = bl ? new HtmlCompiler(writer) : new HtmlCompiler(writer, UriPath.makeDocURI(moduleDoc));
        htmlCompiler.doCompileModule(moduleDoc);
    }

    public static void compilePackage(Writer writer, PackageDoc packageDoc, boolean bl) {
        HtmlCompiler htmlCompiler = bl ? new HtmlCompiler(writer) : new HtmlCompiler(writer, UriPath.makeDocURI(packageDoc));
        htmlCompiler.doCompilePackage(packageDoc);
    }

    public static void compileClass(Writer writer, ClassDoc classDoc, boolean bl, boolean bl2) {
        HtmlCompiler htmlCompiler = bl2 ? new HtmlCompiler(writer) : new HtmlCompiler(writer, UriPath.makeDocURI(classDoc));
        htmlCompiler.doCompileClass(classDoc, bl);
    }

    private void doCompileFramework(FrameworkDoc frameworkDoc) {
        this.printHeader("Niagara Framework");
        this.printTitleBlockStart("", "Niagara Framework", false, null);
        this.printTitleBlockEnd();
        this.println();
        this.printTableStart();
        this.println();
        ModuleDoc[] moduleDocArray = frameworkDoc.modules();
        for (int i = 0; i < moduleDocArray.length; ++i) {
            String string = moduleDocArray[i].name();
            String string2 = moduleDocArray[i].description();
            this.w("<tr><td align='left' width='15%'>");
            this.a(this.getModuleHref(string), string);
            this.w("</td><td>").w((Object)string2).w((Object)"</td></tr>").println();
        }
        this.printTableEnd();
        this.println();
        this.printFooter();
    }

    private void doCompileModule(ModuleDoc moduleDoc) {
        this.printHeader("Module " + moduleDoc.name());
        this.printModuleTitleBlock(moduleDoc);
        this.printModuleIndex(moduleDoc);
        this.printFooter();
    }

    private void printModuleTitleBlock(ModuleDoc moduleDoc) {
        this.printTitleBlockStart("module", moduleDoc.name(), false, null);
        this.printTitleBlockEnd();
    }

    private void printModuleIndex(ModuleDoc moduleDoc) {
        this.printTableStart();
        this.printTableHeaderBar("Packages", 2);
        PackageDoc[] packageDocArray = moduleDoc.packages();
        Arrays.sort(packageDocArray, new Comparator(){

            public int compare(Object object, Object object2) {
                PackageDoc packageDoc = (PackageDoc)object;
                PackageDoc packageDoc2 = (PackageDoc)object2;
                return packageDoc.name().compareTo(packageDoc2.name());
            }
        });
        for (int i = 0; i < packageDocArray.length; ++i) {
            PackageDoc packageDoc = packageDocArray[i];
            this.w("<tr><td align='left' width='15%'><a href='");
            this.w(packageDoc.name().replace('.', '/'));
            this.w("/package-index.").w((Object)this.extension).w((Object)"'>");
            this.w(packageDoc.name()).w((Object)"</a></td><td align='left' nowrap='true'>\n");
            String string = packageDoc.summary();
            if (string.length() == 0) {
                string = "&nbsp;";
            }
            this.w(string);
            this.w("</td></tr>\n");
        }
        this.printTableEnd();
    }

    private void doCompilePackage(PackageDoc packageDoc) {
        this.printHeader("Package " + packageDoc.name());
        this.printPackageTitleBlock(packageDoc);
        this.printPackageIndex(packageDoc);
        this.printFooter();
    }

    private void printPackageTitleBlock(PackageDoc packageDoc) {
        this.printTitleBlockStart("package", packageDoc.name(), true, packageDoc.module());
        this.printTitleBlockEnd();
    }

    private void printPackageIndex(PackageDoc packageDoc) {
        ClassSummary[] classSummaryArray;
        ClassSummary[] classSummaryArray2;
        this.printTableStart();
        ClassSummary[] classSummaryArray3 = packageDoc.interfacesSorted();
        if (classSummaryArray3.length > 0) {
            this.printTableHeaderBar("Interfaces", 2);
            for (int i = 0; i < classSummaryArray3.length; ++i) {
                this.printPackageClassSummary(classSummaryArray3[i]);
            }
        }
        if ((classSummaryArray2 = packageDoc.normalSorted()).length > 0) {
            this.printTableHeaderBar("Classes", 2);
            for (int i = 0; i < classSummaryArray2.length; ++i) {
                this.printPackageClassSummary(classSummaryArray2[i]);
            }
        }
        if ((classSummaryArray = packageDoc.exceptionsSorted()).length > 0) {
            this.printTableHeaderBar("Exceptions", 2);
            for (int i = 0; i < classSummaryArray.length; ++i) {
                this.printPackageClassSummary(classSummaryArray[i]);
            }
        }
        this.printTableEnd();
    }

    private void printPackageClassSummary(ClassSummary classSummary) {
        this.w("<tr><td align='left' width='15%'><a href='");
        this.w(classSummary.name()).w((Object)".").w((Object)this.extension).w((Object)"'>");
        this.w(classSummary.name()).w((Object)"</a></td><td align='left' nowrap='true'>\n");
        String string = classSummary.summary();
        if (string == null || string.length() == 0) {
            string = "&nbsp;";
        }
        this.w(string);
        this.w("</td></tr>\n");
    }

    private void doCompileClass(ClassDoc classDoc, boolean bl) {
        this.printHeader(classDoc.qualifiedName());
        this.printClassTitleBlock(classDoc);
        this.printAncestors(classDoc);
        this.printClassDetails(classDoc);
        this.printMemberIndex(classDoc, bl);
        this.printMemberDetails(classDoc, bl);
        this.printFooter();
    }

    private void printAncestors(ClassDoc classDoc) {
        JavaType[] javaTypeArray = classDoc.ancestors();
        if (javaTypeArray.length == 0) {
            return;
        }
        this.w("<pre>").nl();
        for (int i = 0; i < javaTypeArray.length; ++i) {
            if (i > 0) {
                if (i > 1) {
                    this.w(TextUtil.getSpaces((int)((i - 1) * 5)));
                }
                this.w("  |").nl();
                if (i > 1) {
                    this.w(TextUtil.getSpaces((int)((i - 1) * 5)));
                }
                this.w("  +--");
            }
            this.a(this.getTypeHref(javaTypeArray[i]), javaTypeArray[i].name()).nl();
        }
        this.w("</pre><br>").nl();
    }

    private void printClassTitleBlock(ClassDoc classDoc) {
        JavaType[] javaTypeArray;
        int n;
        Object object;
        JavaType[] javaTypeArray2;
        String string = classDoc.modifiersToString();
        string = string + (classDoc.isInterface() ? "interface " : "class ");
        String string2 = classDoc.module();
        String string3 = "<a href='#classDetails'>" + classDoc.name() + "</a>";
        this.printTitleBlockStart(string, string3, true, string2);
        String string4 = classDoc.packageName();
        this.w("&nbsp;&nbsp;&nbsp;<b>Package </b>");
        this.w("<a href='").w((Object)this.getPackageHref(string2, string4)).w((Object)"'>");
        this.w(string4);
        this.w("</a><br>\n");
        JavaType javaType = classDoc.superClass();
        if (javaType != null) {
            this.w("&nbsp;&nbsp;&nbsp;<b>Extends </b>");
            this.printType(javaType);
            this.w("<br>\n");
        }
        if ((javaTypeArray2 = classDoc.interfaces()).length > 0) {
            object = classDoc.isInterface() ? "Extends " : "Implements ";
            this.w("&nbsp;&nbsp;&nbsp;<b>").w(object).w((Object)"</b>");
            for (int i = 0; i < javaTypeArray2.length; ++i) {
                if (i > 0) {
                    this.w(", ");
                }
                this.printType(javaTypeArray2[i]);
            }
            this.w("<br>\n");
        }
        if (((JavaType[])(object = classDoc.extenders())).length > 0) {
            String string5 = classDoc.isInterface() ? "Known Subinterfaces " : "Known Subclasses ";
            this.w("&nbsp;&nbsp;&nbsp;<b>").w((Object)string5).w((Object)"</b>");
            for (n = 0; n < ((JavaType[])object).length; ++n) {
                if (n > 0) {
                    this.w(", ");
                }
                this.printType(object[n]);
            }
            this.w("<br>\n");
        }
        if ((javaTypeArray = classDoc.implementors()).length > 0) {
            this.w("&nbsp;&nbsp;&nbsp;<b>Known Implementing Classes </b>");
            for (n = 0; n < javaTypeArray.length; ++n) {
                if (n > 0) {
                    this.w(", ");
                }
                this.printType(javaTypeArray[n]);
            }
            this.w("<br>\n");
        }
        this.printTitleBlockEnd();
    }

    private void printMemberIndex(ClassDoc classDoc, boolean bl) {
        Object object;
        int n;
        Object object2;
        int n2;
        int n3;
        TopicDoc[] topicDocArray;
        int n4;
        ActionDoc[] actionDocArray;
        int n5;
        this.printTableStart();
        boolean bl2 = true;
        PropertyDoc[] propertyDocArray = classDoc.propertiesSorted();
        for (n5 = 0; n5 < propertyDocArray.length; ++n5) {
            actionDocArray = propertyDocArray[n5];
            if (bl2) {
                this.printTableHeaderBar("Properties", 1);
                bl2 = false;
            }
            this.w("<tr><td>");
            this.printPropertySummary((PropertyDoc)actionDocArray, true);
            this.w("</td></tr>\n");
        }
        n5 = 1;
        actionDocArray = classDoc.actionsSorted();
        for (n4 = 0; n4 < actionDocArray.length; ++n4) {
            topicDocArray = actionDocArray[n4];
            if (n5 != 0) {
                this.printTableHeaderBar("Actions", 1);
                n5 = 0;
            }
            this.w("<tr><td>");
            this.printActionSummary((ActionDoc)topicDocArray, true);
            this.w("</td></tr>\n");
        }
        n4 = 1;
        topicDocArray = classDoc.topicsSorted();
        for (n3 = 0; n3 < topicDocArray.length; ++n3) {
            TopicDoc topicDoc = topicDocArray[n3];
            if (n4 != 0) {
                this.printTableHeaderBar("Topics", 1);
                n4 = 0;
            }
            this.w("<tr><td>");
            this.printTopicSummary(topicDoc, true);
            this.w("</td></tr>\n");
        }
        n3 = 1;
        for (n2 = 0; !bl && n2 < classDoc.constructors().length; ++n2) {
            object2 = classDoc.constructors()[n2];
            if (!HtmlCompiler.isDocAccess(classDoc, ((ModifierDoc)object2).modifiers())) continue;
            if (n3 != 0) {
                this.printTableHeaderBar("Constructors", 1);
                n3 = 0;
            }
            this.w("<tr><td>");
            this.printConstructorSummary((ConstructorDoc)object2, true);
            this.w("</td></tr>\n");
        }
        n2 = 1;
        object2 = classDoc.methodsSorted();
        for (n = 0; !bl && n < ((MethodDoc[])object2).length; ++n) {
            object = object2[n];
            if (!HtmlCompiler.isDocAccess(classDoc, ((ModifierDoc)object).modifiers())) continue;
            if (n2 != 0) {
                this.printTableHeaderBar("Methods", 1);
                n2 = 0;
            }
            this.w("<tr><td>");
            this.printMethodSummary((MethodDoc)object, true);
            this.w("</td></tr>\n");
        }
        n = 1;
        object = classDoc.fieldsSorted();
        for (int i = 0; !bl && i < ((Object)object).length; ++i) {
            Object object3 = object[i];
            if (!HtmlCompiler.isDocAccess(classDoc, ((ModifierDoc)object3).modifiers())) continue;
            if (n != 0) {
                this.printTableHeaderBar("Fields", 1);
                n = 0;
            }
            this.w("<tr><td>");
            this.printFieldSummary((FieldDoc)object3, true);
            this.w("</td></tr>\n");
        }
        this.printTableEnd();
    }

    private void printClassDetails(ClassDoc classDoc) {
        this.w("<hr><a name='classDetails'></a>\n");
        this.w("<b>").w((Object)classDoc.modifiersToString());
        this.w(classDoc.isInterface() ? " interface " : " class ");
        this.w("<font size='+2'>" + classDoc.name());
        this.w("</font></b>");
        this.printDetails(classDoc);
        this.w("<hr>");
    }

    private void printMemberDetails(ClassDoc classDoc, boolean bl) {
        MemberDoc memberDoc;
        int n;
        this.w("<hr>\n");
        for (n = 0; n < classDoc.properties().length; ++n) {
            memberDoc = classDoc.properties()[n];
            this.printPropertyDetail((PropertyDoc)memberDoc);
        }
        for (n = 0; n < classDoc.actions().length; ++n) {
            memberDoc = classDoc.actions()[n];
            this.printActionDetail((ActionDoc)memberDoc);
        }
        for (n = 0; n < classDoc.topics().length; ++n) {
            memberDoc = classDoc.topics()[n];
            this.printTopicDetail((TopicDoc)memberDoc);
        }
        for (n = 0; !bl && n < classDoc.constructors().length; ++n) {
            memberDoc = classDoc.constructors()[n];
            if (!HtmlCompiler.isDocAccess(classDoc, memberDoc.modifiers())) continue;
            this.printConstructorDetail((ConstructorDoc)memberDoc);
        }
        for (n = 0; !bl && n < classDoc.methods().length; ++n) {
            memberDoc = classDoc.methods()[n];
            if (!HtmlCompiler.isDocAccess(classDoc, memberDoc.modifiers())) continue;
            this.printMethodDetail((MethodDoc)memberDoc);
        }
        for (n = 0; !bl && n < classDoc.fields().length; ++n) {
            memberDoc = classDoc.fields()[n];
            if (!HtmlCompiler.isDocAccess(classDoc, memberDoc.modifiers())) continue;
            this.printFieldDetail((FieldDoc)memberDoc);
        }
    }

    private void printPropertySummary(PropertyDoc propertyDoc, boolean bl) {
        this.printType(propertyDoc.type());
        this.w(" <b>");
        if (bl) {
            this.w("<a href='#").w((Object)propertyDoc.anchor()).w((Object)"'>");
        }
        this.w(propertyDoc.name());
        if (bl) {
            this.w("</a>");
        }
        this.w("</b>");
    }

    private void printPropertyDetail(PropertyDoc propertyDoc) {
        this.w("<a name='").w((Object)propertyDoc.anchor()).w((Object)"'></a>\n");
        this.w("<b>property</b> ");
        this.printPropertySummary(propertyDoc, false);
        this.printDetails(propertyDoc);
        this.w("<hr>\n");
    }

    private void printActionSummary(ActionDoc actionDoc, boolean bl) {
        if (actionDoc.returns() != null) {
            this.printType(actionDoc.returns().type());
            this.w(' ');
        } else {
            this.w("<b>");
        }
        if (bl) {
            this.w("<a href='#").w((Object)actionDoc.anchor()).w((Object)"'>");
        }
        this.w(actionDoc.name());
        if (bl) {
            this.w("</a>");
        }
        this.w("</b>");
        if (actionDoc.parameter() != null) {
            this.w('(');
            this.printType(actionDoc.parameter().type());
            this.w(' ').w((Object)actionDoc.parameter().name()).w(')');
        } else {
            this.w("()");
        }
    }

    private void printActionDetail(ActionDoc actionDoc) {
        this.w("<a name='").w((Object)actionDoc.anchor()).w((Object)"'></a>\n");
        this.w("<b>action</b> ");
        this.printActionSummary(actionDoc, false);
        this.printDetails(actionDoc);
        this.w("<hr>\n");
    }

    private void printTopicSummary(TopicDoc topicDoc, boolean bl) {
        this.printType(topicDoc.eventType());
        this.w(" <b>");
        if (bl) {
            this.w("<a href='#").w((Object)topicDoc.anchor()).w((Object)"'>");
        }
        this.w(topicDoc.name());
        if (bl) {
            this.w("</a>");
        }
        this.w("</b>");
    }

    private void printTopicDetail(TopicDoc topicDoc) {
        this.w("<a name='").w((Object)topicDoc.anchor()).w((Object)"'></a>\n");
        this.w("<b>topic</b> ");
        this.printTopicSummary(topicDoc, false);
        this.printDetails(topicDoc);
        this.w("<hr>\n");
    }

    private void printConstructorSummary(ConstructorDoc constructorDoc, boolean bl) {
        this.w(constructorDoc.modifiersToString());
        this.w("<b>");
        if (bl) {
            this.w("<a href='#").w((Object)constructorDoc.anchor()).w((Object)"'>");
        }
        this.w(constructorDoc.name());
        if (bl) {
            this.w("</a>");
        }
        this.w("</b>");
        this.printParams(constructorDoc.parameters());
    }

    private void printConstructorDetail(ConstructorDoc constructorDoc) {
        this.w("<a name='").w((Object)constructorDoc.anchor()).w((Object)"'></a>\n");
        this.printConstructorSummary(constructorDoc, false);
        this.printThrows(constructorDoc.exceptions());
        this.printDetails(constructorDoc);
        this.w("<hr>\n");
    }

    private void printMethodSummary(MethodDoc methodDoc, boolean bl) {
        this.w(methodDoc.modifiersToString());
        this.printType(methodDoc.returns().type());
        this.w(" <b>");
        if (bl) {
            this.w("<a href='#").w((Object)methodDoc.anchor()).w((Object)"'>");
        }
        this.w(methodDoc.name());
        if (bl) {
            this.w("</a>");
        }
        this.w("</b>");
        this.printParams(methodDoc.parameters());
    }

    private void printMethodDetail(MethodDoc methodDoc) {
        this.w("<a name='").w((Object)methodDoc.anchor()).w((Object)"'></a>\n");
        this.printMethodSummary(methodDoc, false);
        this.printThrows(methodDoc.exceptions());
        this.printDetails(methodDoc);
        this.w("<hr>\n");
    }

    private void printFieldSummary(FieldDoc fieldDoc, boolean bl) {
        this.w(fieldDoc.modifiersToString());
        this.printType(fieldDoc.type());
        this.w(" <b>");
        if (bl) {
            this.w("<a href='#").w((Object)fieldDoc.anchor()).w((Object)"'>");
        }
        this.w(fieldDoc.name());
        if (bl) {
            this.w("</a>");
        }
        this.w("</b>");
    }

    private void printFieldDetail(FieldDoc fieldDoc) {
        this.w("<a name='").w((Object)fieldDoc.anchor()).w((Object)"'></a>\n");
        this.printFieldSummary(fieldDoc, false);
        this.printDetails(fieldDoc);
        this.w("<hr>\n");
    }

    public void printDetails(Doc doc) {
        String string;
        this.w("<dl>\n");
        if (doc instanceof SlotDoc) {
            int n = ((SlotDoc)doc).flags();
            this.w("<dl><dt><b>Flags:</b> " + Flags.toDisplayString((int)n, null) + "</dt></dl>\n");
        }
        if ((string = doc.description()) != null) {
            this.w("<dd>\n");
            this.w(string);
            this.w("</dd>\n");
        }
        if (doc instanceof ExecutableDoc) {
            this.printExecutableDetails((ExecutableDoc)doc);
        }
        this.w("</dl>\n");
    }

    private void printExecutableDetails(ExecutableDoc executableDoc) {
        Throws[] throwsArray;
        Returns returns;
        Object object;
        Object object2;
        Parameter[] parameterArray = executableDoc.parameters();
        if (parameterArray.length > 0) {
            this.w("<dl><dt><b>Parameters:</b></dt>");
            for (int i = 0; i < parameterArray.length; ++i) {
                object2 = parameterArray[i];
                this.w("<dd>");
                this.printType(((Parameter)object2).type());
                this.w(" <b> ");
                this.w(((Parameter)object2).name());
                object = ((Description)object2).description();
                this.w("</b>");
                if (object != null) {
                    this.w(" - ").w(object);
                }
                this.w("</dd>\n");
            }
            this.w("</dl>\n");
        }
        if (executableDoc instanceof MethodDoc && (object2 = (returns = ((MethodDoc)executableDoc).returns()).description()) != null) {
            this.w("<dl><dt><b>Returns:</b></dt>");
            this.w("<dd>").w(object2).w((Object)"</dd></dl>\n");
        }
        if ((throwsArray = executableDoc.exceptions()).length > 0) {
            this.w("<dl><dt><b>Exceptions:</b></dt>");
            for (int i = 0; i < throwsArray.length; ++i) {
                object = throwsArray[i];
                this.w("<dd>");
                this.printType(((Throws)object).type());
                String string = ((Description)object).description();
                if (string != null) {
                    this.w(" - ").w((Object)string);
                }
                this.w("</dd>\n");
            }
            this.w("</dl>\n");
        }
    }

    private void printThrows(Throws[] throwsArray) {
        if (throwsArray.length == 0) {
            return;
        }
        this.w("<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;throws ");
        for (int i = 0; i < throwsArray.length; ++i) {
            if (i > 0) {
                this.w(", ");
            }
            this.printType(throwsArray[i].type());
        }
    }

    private void printParams(Parameter[] parameterArray) {
        this.w("(");
        for (int i = 0; i < parameterArray.length; ++i) {
            if (i > 0) {
                this.w(", ");
            }
            this.printType(parameterArray[i].type());
            this.w(' ');
            this.w(parameterArray[i].name());
        }
        this.w(")\n");
    }

    private void printType(JavaType javaType) {
        if (javaType.isPrimitive() || !javaType.isResolved()) {
            this.w(javaType.name());
        } else {
            this.w("<a href='").w((Object)this.getTypeHref(javaType)).w((Object)"'>").w((Object)javaType.name()).w((Object)"</a>");
        }
        if (javaType.dimension() > 0) {
            this.w(javaType.dimensionString());
        }
    }

    public void printTableStart() {
        this.w("<table border='1' width='100%' bordercolor='#505050' cellspacing='0'>\n");
    }

    private void printTableHeaderBar(String string, int n) {
        this.w("<tr><th align='left' bgcolor='#666699' colspan='").w(n);
        this.w("'><font size='+1' color='#ffffff'>");
        this.w(string);
        this.w("</font></th></tr>\n");
    }

    public void printTableEnd() {
        this.w("</table>\n");
    }

    public void printTitleBlockStart(String string, String string2, boolean bl, String string3) {
        this.printTableStart();
        this.w("<tr><td align='left' bgcolor='#d0d0d0'><b>");
        this.w(string);
        this.w("&nbsp;");
        this.w("<font size='+2'>");
        this.w(string2);
        this.w("</font></b><br>\n");
        if (!this.moduleBased) {
            this.w("&nbsp;&nbsp;&nbsp;<b>Framework </b>");
            this.w("<a href='").w((Object)this.htmlBaseUri.getFrameworkHref()).w((Object)"'>");
            this.w("Niagara Framework</a>\n");
            this.w("<br>\n");
        }
        if (bl) {
            this.w("&nbsp;&nbsp;&nbsp;<b>Module </b>");
            String string4 = string3;
            if (string3 == null) {
                string4 = "JDK";
                string3 = "docJdk";
            }
            this.w("<a href='").w((Object)this.getModuleHref(string3)).w((Object)"'>");
            this.w(string4);
            this.w("</a><br>\n");
        }
    }

    public void printTitleBlockEnd() {
        this.w("</td></tr>\n");
        this.printTableEnd();
        this.w("<br>");
    }

    public void printHeader(String string) {
        this.w("<html><head><title>");
        this.w(string);
        this.w("</title></head><body bgcolor='#ffffff'>\n");
    }

    public void printFooter() {
        this.w("</body></html>\n");
    }

    private static boolean isDocAccess(ClassDoc classDoc, int n) {
        return classDoc.isInterface() || Modifier.isPublic(n) || Modifier.isProtected(n);
    }

    public String getTypeDef(JavaType javaType) {
        if (!javaType.isResolved()) {
            return null;
        }
        return this.getTypeDef(javaType.module(), javaType.packageName(), javaType.name());
    }

    public String getTypeDef(String string, String string2, String string3) {
        return (string == null ? "docJdk" : string) + ":" + string2 + ":" + string3;
    }

    private String getModuleHref(String string) {
        if (this.moduleBased) {
            return "module://" + (string == null ? "docJdk" : string) + "/doc/" + "module-index.bajadoc";
        }
        return this.htmlBaseUri.getModuleHref(string, "module-index.html");
    }

    private String getPackageHref(String string, String string2) {
        if (this.moduleBased) {
            return "module://" + (string == null ? "docJdk" : string) + "/doc/" + string2.replace('.', '/') + "/package-index.bajadoc";
        }
        return this.htmlBaseUri.getPackageHref(string, string2, "package-index.html");
    }

    private String getTypeHref(JavaType javaType) {
        return this.moduleBased ? javaType.ord(this.extension) : this.htmlBaseUri.getTypeHref(javaType);
    }

    public UriPath getBase() {
        return this.htmlBaseUri;
    }
}

