/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.Tag;
import java.util.ArrayList;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BIcon;

public class PackageDoc
extends Doc {
    public static final BIcon ICON = BIcon.std((String)"folder.png");
    protected String module;
    protected String name;
    protected ClassSummary[] classes;
    protected ClassSummary[] classesSorted;
    private ClassSummary[] interfaces;
    private ClassSummary[] interfacesSorted;
    private ClassSummary[] normal;
    private ClassSummary[] normalSorted;
    private ClassSummary[] exceptions;
    private ClassSummary[] exceptionsSorted;

    public PackageDoc(String string, String string2, ClassSummary[] classSummaryArray, String string3, Tag[] tagArray) {
        super(string3, tagArray);
        this.module = string;
        this.name = string2;
        this.classes = classSummaryArray;
    }

    public BIcon icon() {
        return ICON;
    }

    public String module() {
        return this.module;
    }

    public String name() {
        return this.name;
    }

    public ClassSummary[] classes() {
        return this.classes;
    }

    public String toString() {
        return "package " + this.name;
    }

    public ClassSummary[] interfaces() {
        if (this.interfaces == null) {
            ArrayList<ClassSummary> arrayList = new ArrayList<ClassSummary>();
            for (int i = 0; i < this.classes.length; ++i) {
                if (!this.classes[i].isInterface()) continue;
                arrayList.add(this.classes[i]);
            }
            this.interfaces = arrayList.toArray(new ClassSummary[arrayList.size()]);
        }
        return this.interfaces;
    }

    public ClassSummary[] normal() {
        if (this.normal == null) {
            ArrayList<ClassSummary> arrayList = new ArrayList<ClassSummary>();
            for (int i = 0; i < this.classes.length; ++i) {
                if (this.classes[i].isInterface() || this.classes[i].isException()) continue;
                arrayList.add(this.classes[i]);
            }
            this.normal = arrayList.toArray(new ClassSummary[arrayList.size()]);
        }
        return this.normal;
    }

    public ClassSummary[] exceptions() {
        if (this.exceptions == null) {
            ArrayList<ClassSummary> arrayList = new ArrayList<ClassSummary>();
            for (int i = 0; i < this.classes.length; ++i) {
                if (!this.classes[i].isException()) continue;
                arrayList.add(this.classes[i]);
            }
            this.exceptions = arrayList.toArray(new ClassSummary[arrayList.size()]);
        }
        return this.exceptions;
    }

    public ClassSummary[] interfacesSorted() {
        if (this.interfacesSorted == null) {
            this.interfacesSorted = PackageDoc.sort(this.interfaces());
        }
        return this.interfacesSorted;
    }

    public ClassSummary[] normalSorted() {
        if (this.normalSorted == null) {
            this.normalSorted = PackageDoc.sort(this.normal());
        }
        return this.normalSorted;
    }

    public ClassSummary[] exceptionsSorted() {
        if (this.exceptionsSorted == null) {
            this.exceptionsSorted = PackageDoc.sort(this.exceptions());
        }
        return this.exceptionsSorted;
    }

    public ClassSummary[] classesSorted() {
        if (this.classesSorted == null) {
            this.classesSorted = PackageDoc.sort(this.classes());
        }
        return this.classesSorted;
    }

    private static ClassSummary[] sort(ClassSummary[] classSummaryArray) {
        int n = classSummaryArray.length;
        Object[] objectArray = new String[n];
        Object[] objectArray2 = new ClassSummary[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = classSummaryArray[i].name();
            objectArray2[i] = classSummaryArray[i];
        }
        SortUtil.sort((Object[])objectArray, (Object[])objectArray2);
        return objectArray2;
    }
}

