/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.Tag;
import java.lang.reflect.Modifier;

public abstract class ModifierDoc
extends Doc {
    protected int modifiers;

    protected ModifierDoc(int n, String string, Tag[] tagArray) {
        super(string, tagArray);
        this.modifiers = n;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public String modifiersToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (Modifier.isPrivate(this.modifiers)) {
            stringBuffer.append("private ");
        }
        if (Modifier.isProtected(this.modifiers)) {
            stringBuffer.append("protected ");
        }
        if (Modifier.isPublic(this.modifiers)) {
            stringBuffer.append("public ");
        }
        if (Modifier.isAbstract(this.modifiers)) {
            stringBuffer.append("abstract ");
        }
        if (Modifier.isFinal(this.modifiers)) {
            stringBuffer.append("final ");
        }
        if (Modifier.isStatic(this.modifiers)) {
            stringBuffer.append("static ");
        }
        if (Modifier.isTransient(this.modifiers)) {
            stringBuffer.append("transient ");
        }
        return stringBuffer.toString();
    }
}

