/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.ClassDoc;
import java.util.HashMap;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;

public class JavaType
implements Comparable {
    public static final JavaType[] NONE = new JavaType[0];
    static HashMap primitives = new HashMap();
    protected String typespec;
    protected String module;
    protected String qualifiedName;
    protected String name;
    protected String displayName;
    protected String packageName;
    protected int dimension;
    protected String dimensionString;
    protected boolean primitive;
    protected BOrd bajadocOrd;

    public JavaType(String string, String string2, int n) {
        this.typespec = string + ":" + string2;
        this.module = string;
        this.qualifiedName = string2;
        this.name = TextUtil.getClassName((String)string2).replace('$', '.');
        this.packageName = TextUtil.getPackageName((String)string2);
        this.primitive = primitives.get(string2) != null;
        this.dimension = n;
        this.dimensionString = "";
        for (int i = 0; i < n; ++i) {
            this.dimensionString = this.dimensionString + "[]";
        }
        this.displayName = this.name + this.dimensionString;
    }

    public JavaType(ClassDoc classDoc) {
        this(classDoc.module(), classDoc.qualifiedName(), 0);
    }

    protected JavaType() {
    }

    public String module() {
        return this.module;
    }

    public String name() {
        return this.name;
    }

    public String qualifiedName() {
        return this.qualifiedName;
    }

    public String packageName() {
        return this.packageName;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public int dimension() {
        return this.dimension;
    }

    public String dimensionString() {
        return this.dimensionString;
    }

    public String displayName() {
        return this.displayName;
    }

    public boolean isResolved() {
        return this.packageName != null;
    }

    public String ord(String string) {
        if (!this.isResolved()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("local:|module://");
        stringBuffer.append(this.module == null ? "docJdk" : this.module);
        stringBuffer.append("/doc/");
        stringBuffer.append(this.packageName.replace('.', '/'));
        stringBuffer.append('/').append(this.name).append('.').append(string);
        return stringBuffer.toString();
    }

    public BOrd bajadocOrd() {
        if (this.primitive) {
            return null;
        }
        if (this.bajadocOrd == null) {
            this.bajadocOrd = BOrd.make((String)this.ord("bajadoc"));
        }
        return this.bajadocOrd;
    }

    public int compareTo(Object object) {
        JavaType javaType = (JavaType)object;
        int n = this.name.compareTo(javaType.name);
        return n == 0 ? this.typespec.compareTo(javaType.typespec) : n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        JavaType javaType = (JavaType)object;
        return this.typespec.equals(javaType.typespec);
    }

    public int hashCode() {
        return this.typespec.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.module != null) {
            stringBuffer.append(this.module).append(':');
        }
        stringBuffer.append(this.qualifiedName);
        for (int i = 0; i < this.dimension; ++i) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    static {
        primitives.put("boolean", primitives);
        primitives.put("byte", primitives);
        primitives.put("char", primitives);
        primitives.put("float", primitives);
        primitives.put("double", primitives);
        primitives.put("int", primitives);
        primitives.put("long", primitives);
        primitives.put("short", primitives);
        primitives.put("void", primitives);
    }
}

