/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.ActionDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.ConstructorDoc;
import com.tridium.help.bajadoc.FieldDoc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.MemberDoc;
import com.tridium.help.bajadoc.MethodDoc;
import com.tridium.help.bajadoc.ModifierDoc;
import com.tridium.help.bajadoc.PropertyDoc;
import com.tridium.help.bajadoc.Tag;
import com.tridium.help.bajadoc.TopicDoc;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;

public class ClassDoc
extends ModifierDoc {
    public static final int INTERFACE = 1;
    public static final int EXCEPTION = 2;
    public static final int BAJA_TYPE = 4;
    public static final BIcon defaultIcon = BIcon.std((String)"object.png");
    protected String module;
    protected String name;
    protected String qualifiedName;
    protected String packageName;
    protected JavaType superClass;
    protected JavaType[] interfaces;
    protected JavaType[] ancestors;
    protected JavaType[] extenders;
    protected JavaType[] implementors;
    protected ConstructorDoc[] constructors;
    protected MethodDoc[] methods;
    protected FieldDoc[] fields;
    protected ClassDoc[] innerClasses;
    protected PropertyDoc[] properties;
    protected ActionDoc[] actions;
    protected TopicDoc[] topics;
    protected int classCategory;
    protected boolean isInnerClass;
    protected BIcon icon;
    private MethodDoc[] methodsSorted;
    private FieldDoc[] fieldsSorted;
    private PropertyDoc[] propertiesSorted;
    private ActionDoc[] actionsSorted;
    private TopicDoc[] topicsSorted;

    public ClassDoc(String string, String string2, int n, JavaType javaType, JavaType[] javaTypeArray, JavaType[] javaTypeArray2, JavaType[] javaTypeArray3, JavaType[] javaTypeArray4, PropertyDoc[] propertyDocArray, ActionDoc[] actionDocArray, TopicDoc[] topicDocArray, FieldDoc[] fieldDocArray, ConstructorDoc[] constructorDocArray, MethodDoc[] methodDocArray, ClassDoc[] classDocArray, int n2, boolean bl, String string3, Tag[] tagArray) {
        super(n, string3, tagArray);
        this.module = string;
        this.qualifiedName = string2;
        this.name = TextUtil.getClassName((String)string2).replace('$', '.');
        this.packageName = TextUtil.getPackageName((String)string2);
        this.superClass = javaType;
        this.interfaces = javaTypeArray;
        this.ancestors = javaTypeArray2;
        this.extenders = javaTypeArray3;
        this.implementors = javaTypeArray4;
        this.properties = propertyDocArray;
        this.initDeclaring(propertyDocArray);
        this.actions = actionDocArray;
        this.initDeclaring(actionDocArray);
        this.topics = topicDocArray;
        this.initDeclaring(topicDocArray);
        this.fields = fieldDocArray;
        this.initDeclaring(fieldDocArray);
        this.constructors = constructorDocArray;
        this.initDeclaring(constructorDocArray);
        this.methods = methodDocArray;
        this.initDeclaring(methodDocArray);
        this.innerClasses = classDocArray;
        this.classCategory = n2;
        this.isInnerClass = bl;
        this.icon = defaultIcon;
    }

    private void initDeclaring(MemberDoc[] memberDocArray) {
        for (int i = 0; i < memberDocArray.length; ++i) {
            MemberDoc memberDoc = memberDocArray[i];
            if (memberDoc.declaringClass != null) continue;
            memberDoc.declaringClass = this;
        }
    }

    public String module() {
        return this.module;
    }

    public String name() {
        return this.name;
    }

    public String qualifiedName() {
        return this.qualifiedName;
    }

    public String packageName() {
        return this.packageName;
    }

    public boolean isInnerClass() {
        return this.isInnerClass;
    }

    public JavaType superClass() {
        return this.superClass;
    }

    public JavaType[] interfaces() {
        return this.interfaces;
    }

    public JavaType[] ancestors() {
        return this.ancestors;
    }

    public JavaType[] extenders() {
        return this.extenders;
    }

    public JavaType[] implementors() {
        return this.implementors;
    }

    public PropertyDoc[] properties() {
        return this.properties;
    }

    public ActionDoc[] actions() {
        return this.actions;
    }

    public TopicDoc[] topics() {
        return this.topics;
    }

    public FieldDoc[] fields() {
        return this.fields;
    }

    public ConstructorDoc[] constructors() {
        return this.constructors;
    }

    public MethodDoc[] methods() {
        return this.methods;
    }

    public ClassDoc[] innerClasses() {
        return this.innerClasses;
    }

    public BIcon icon() {
        return this.icon;
    }

    public ClassSummary classSummary() {
        return new ClassSummary(this.qualifiedName, this.classCategory, this.summary());
    }

    public int classCategory() {
        return this.classCategory;
    }

    public boolean isBajaType() {
        return (this.classCategory & 4) != 0;
    }

    public boolean isInterface() {
        return (this.classCategory & 1) != 0;
    }

    public boolean isException() {
        return (this.classCategory & 2) != 0;
    }

    public static String categoryToString(int n) {
        if ((n & 1) != 0) {
            return "interface";
        }
        if ((n & 2) != 0) {
            return "exception";
        }
        return null;
    }

    public static int stringToCategory(String string) {
        if (string.equals("interface")) {
            return 1;
        }
        if (string.equals("exception")) {
            return 2;
        }
        return 0;
    }

    public PropertyDoc[] propertiesSorted() {
        if (this.propertiesSorted == null) {
            this.propertiesSorted = new PropertyDoc[this.properties.length];
            this.sort(this.properties, this.propertiesSorted);
        }
        return this.propertiesSorted;
    }

    public ActionDoc[] actionsSorted() {
        if (this.actionsSorted == null) {
            this.actionsSorted = new ActionDoc[this.actions.length];
            this.sort(this.actions, this.actionsSorted);
        }
        return this.actionsSorted;
    }

    public TopicDoc[] topicsSorted() {
        if (this.topicsSorted == null) {
            this.topicsSorted = new TopicDoc[this.topics.length];
            this.sort(this.topics, this.topicsSorted);
        }
        return this.topicsSorted;
    }

    public MethodDoc[] methodsSorted() {
        if (this.methodsSorted == null) {
            this.methodsSorted = new MethodDoc[this.methods.length];
            this.sort(this.methods, this.methodsSorted);
        }
        return this.methodsSorted;
    }

    public FieldDoc[] fieldsSorted() {
        if (this.fieldsSorted == null) {
            this.fieldsSorted = new FieldDoc[this.fields.length];
            this.sort(this.fields, this.fieldsSorted);
        }
        return this.fieldsSorted;
    }

    private void sort(MemberDoc[] memberDocArray, MemberDoc[] memberDocArray2) {
        int n = memberDocArray.length;
        Object[] objectArray = new String[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = memberDocArray[i].name();
            memberDocArray2[i] = memberDocArray[i];
        }
        SortUtil.sort((Object[])objectArray, (Object[])memberDocArray2);
    }

    public String toString() {
        return this.isInterface() ? "interface " + this.qualifiedName : "class " + this.qualifiedName;
    }

    public void dump() {
        int n;
        String string = this.isInterface() ? "interface" : "class";
        System.out.println(this.modifiersToString() + " " + string + " " + this.qualifiedName);
        System.out.println("  extends " + this.superClass);
        if (this.interfaces.length > 0) {
            System.out.println("  implements " + this.interfaces[0]);
            for (n = 1; n < this.interfaces.length; ++n) {
                System.out.println("             " + this.interfaces[n]);
            }
        }
        System.out.println("{");
        if (this.constructors.length > 0) {
            System.out.println();
            System.out.println("// Constructors");
            for (n = 0; n < this.constructors.length; ++n) {
                System.out.println("  " + this.constructors[n]);
            }
        }
        if (this.methods.length > 0) {
            System.out.println();
            System.out.println("// Methods");
            for (n = 0; n < this.methods.length; ++n) {
                System.out.println("  " + this.methods[n]);
            }
        }
        if (this.fields.length > 0) {
            System.out.println();
            System.out.println("// Fields");
            for (n = 0; n < this.fields.length; ++n) {
                System.out.println("  " + this.fields[n]);
            }
        }
        for (n = 0; n < this.innerClasses.length; ++n) {
            System.out.println();
            System.out.println("//////////////////////////////////////////////");
            System.out.println("// Inner Class " + this.innerClasses[n].name());
            this.innerClasses[n].dump();
            System.out.println("// Inner Class " + this.innerClasses[n].name());
            System.out.println("//////////////////////////////////////////////");
            System.out.println();
        }
        System.out.println("}");
    }
}

