/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.Hierarchy;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.JavaType;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class HierarchyBuilder {
    private Map upwards = new HashMap();
    private Map downwards = new HashMap();
    private Hierarchy.Entry root = null;

    HierarchyBuilder() {
    }

    void loadBajadoc(Doc doc) throws Exception {
        if (doc instanceof ClassDoc) {
            ClassDoc classDoc = (ClassDoc)doc;
            JavaType javaType = classDoc.superClass();
            if (!classDoc.isInterface()) {
                if (javaType == null) {
                    this.upwards.put(new Hierarchy.Entry(classDoc.module(), classDoc.packageName(), classDoc.name()), new Hierarchy.Entry());
                    this.root = new Hierarchy.Entry(classDoc.module(), classDoc.packageName(), classDoc.name());
                    this.downwardsPut(new Hierarchy.Entry(), this.root);
                } else {
                    this.upwards.put(new Hierarchy.Entry(classDoc.module(), classDoc.packageName(), classDoc.name()), new Hierarchy.Entry(javaType.module(), javaType.packageName(), javaType.name()));
                    this.downwardsPut(new Hierarchy.Entry(javaType.module(), javaType.packageName(), javaType.name()), new Hierarchy.Entry(classDoc.module(), classDoc.packageName(), classDoc.name()));
                }
            }
        }
    }

    private void downwardsPut(Hierarchy.Entry entry, Hierarchy.Entry entry2) {
        ArrayList<Hierarchy.Entry> arrayList = (ArrayList<Hierarchy.Entry>)this.downwards.get(entry);
        if (arrayList == null) {
            arrayList = new ArrayList<Hierarchy.Entry>();
            this.downwards.put(entry, arrayList);
        }
        arrayList.add(entry2);
    }

    private void dump(Writer writer, Hierarchy.Entry entry, int n) throws Exception {
        List list = (List)this.downwards.get(entry);
        if (list == null) {
            if (!entry.isRoot) {
                for (int i = 0; i < n; ++i) {
                    writer.write("  ");
                }
                writer.write("<c m=\"" + entry.module + "\" p=\"" + entry.pkg + "\" n=\"" + entry.name + "\"/>\n");
            }
        } else {
            int n2;
            int n3 = n;
            if (!entry.isRoot) {
                ++n3;
                for (n2 = 0; n2 < n; ++n2) {
                    writer.write("  ");
                }
                writer.write("<c m=\"" + entry.module + "\" p=\"" + entry.pkg + "\" n=\"" + entry.name + "\">\n");
            }
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.dump(writer, (Hierarchy.Entry)list.get(n2), n3);
            }
            if (!entry.isRoot) {
                for (n2 = 0; n2 < n; ++n2) {
                    writer.write("  ");
                }
                writer.write("</c>\n");
            }
        }
    }

    void persist() throws Exception {
        Object object;
        Object object2;
        Object object3 = this.downwards.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (Hierarchy.Entry)object3.next();
            object = (List)this.downwards.get(object2);
            Collections.sort(object);
        }
        object3 = this.upwards.keySet();
        object2 = new HashSet(this.upwards.values());
        object2.removeAll(this.upwards.keySet());
        object = new BufferedWriter(new FileWriter(Hierarchy.FILE));
        ((Writer)object).write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        ((Writer)object).write("<hierarchy>\n");
        ArrayList arrayList = new ArrayList(object2);
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.dump((Writer)object, (Hierarchy.Entry)arrayList.get(i), 1);
        }
        ((Writer)object).write("</hierarchy>\n");
        ((BufferedWriter)object).close();
    }
}

