/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.HelpSystem;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.baja.naming.BOrd;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class Hierarchy {
    private static Hierarchy h;
    static File FILE;
    private boolean depersisted = false;
    private Map entryHash;

    private Hierarchy() {
    }

    public static Hierarchy instance() {
        if (h == null) {
            h = new Hierarchy();
        }
        return h;
    }

    private void loadEntryHash(XElem xElem, XElem xElem2) {
        if (!xElem2.equals((Object)xElem)) {
            this.entryHash.put(this.toEntry(xElem2), xElem2);
        }
        XElem[] xElemArray = xElem2.elems();
        for (int i = 0; i < xElemArray.length; ++i) {
            this.loadEntryHash(xElem, xElemArray[i]);
        }
    }

    private Entry toEntry(XElem xElem) {
        int n = xElem.attrIndex("m");
        int n2 = xElem.attrIndex("p");
        int n3 = xElem.attrIndex("n");
        return new Entry(xElem.attrValue(n).intern(), xElem.attrValue(n2).intern(), xElem.attrValue(n3).intern());
    }

    private void depersist() throws Exception {
        XElem xElem = XParser.make((File)FILE).parse();
        this.entryHash = new HashMap();
        this.loadEntryHash(xElem, xElem);
        this.depersisted = true;
    }

    public boolean hasSubEntries(Entry entry) {
        try {
            if (!this.depersisted) {
                this.depersist();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        XElem xElem = (XElem)this.entryHash.get(entry);
        if (xElem == null) {
            return false;
        }
        return xElem.elems().length > 0;
    }

    public Entry[] getSubEntries(Entry entry) {
        try {
            if (!this.depersisted) {
                this.depersist();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        XElem xElem = (XElem)this.entryHash.get(entry);
        XElem[] xElemArray = xElem.elems();
        Entry[] entryArray = new Entry[xElemArray.length];
        for (int i = 0; i < xElemArray.length; ++i) {
            entryArray[i] = this.toEntry(xElemArray[i]);
        }
        return entryArray;
    }

    static {
        FILE = new File(HelpSystem.HELP, "hierarchy.xml");
    }

    public static class Entry
    implements Comparable {
        boolean isRoot;
        String module;
        String pkg;
        String name;
        private BOrd bajadocOrd = null;

        Entry() {
            this.isRoot = true;
        }

        public Entry(String string, String string2, String string3) {
            this.module = string == null ? "docJdk" : string;
            this.pkg = string2;
            this.name = string3;
            this.isRoot = false;
        }

        public String toString() {
            return this.module + ":" + this.pkg + "." + this.name;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.isRoot) {
                return entry.isRoot;
            }
            if (entry.isRoot) {
                return false;
            }
            return this.module.equals(entry.module) && this.pkg.equals(entry.pkg) && this.name.equals(entry.name);
        }

        public int hashCode() {
            if (this.isRoot) {
                return 0;
            }
            return this.module.hashCode() + this.pkg.hashCode() + this.name.hashCode();
        }

        public int compareTo(Object object) {
            Entry entry = (Entry)object;
            if (this.isRoot) {
                return entry.isRoot ? 0 : -1;
            }
            if (entry.isRoot) {
                return 1;
            }
            int n = this.module.compareTo(entry.module);
            if (n != 0) {
                return n;
            }
            n = this.pkg.compareTo(entry.pkg);
            if (n != 0) {
                return n;
            }
            return this.name.compareTo(entry.name);
        }

        public BOrd bajadocOrd() {
            if (this.bajadocOrd == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("local:|module://");
                stringBuffer.append(this.module);
                stringBuffer.append("/doc/");
                stringBuffer.append(this.pkg.replace('.', '/'));
                stringBuffer.append('/').append(this.name).append('.').append("bajadoc");
                this.bajadocOrd = BOrd.make((String)stringBuffer.toString());
            }
            return this.bajadocOrd;
        }

        public String module() {
            return this.module;
        }

        public String packageName() {
            return this.pkg;
        }

        public String name() {
            return this.name;
        }
    }
}

