/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.util.ObjectUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Sys;

public abstract class HelpVerifier {
    private static void checkModule(ModuleInfo moduleInfo, TypeInfo typeInfo) throws Exception {
        TypeInfo[] typeInfoArray = moduleInfo.getTypes();
        for (int i = 0; i < typeInfoArray.length; ++i) {
            TypeInfo typeInfo2 = typeInfoArray[i];
            if (typeInfo2.isAbstract() || !typeInfo2.is(typeInfo)) continue;
            BOrd bOrd = ObjectUtil.getGuideHelpOrd((TypeInfo)typeInfo2);
            String string = "OK     ";
            try {
                bOrd.resolve();
            }
            catch (UnresolvedException unresolvedException) {
                string = "missing";
            }
            System.out.println(string + "  " + typeInfo2);
        }
    }

    private static void usage() throws Exception {
        System.out.println("usage: ");
        System.out.println("  HelpVerifier <module> <isType>");
        System.out.println("  use 'all' to check every module");
        System.out.println("example:");
        System.out.println("  HelpVerifier all workbench:WbView");
        System.exit(-1);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println();
        if (stringArray.length != 2) {
            HelpVerifier.usage();
        }
        Registry registry = Sys.getRegistry();
        TypeInfo typeInfo = registry.getType(stringArray[1]);
        if (stringArray[0].equals("all")) {
            ModuleInfo[] moduleInfoArray = registry.getModules();
            for (int i = 0; i < moduleInfoArray.length; ++i) {
                HelpVerifier.checkModule(moduleInfoArray[i], typeInfo);
            }
        } else {
            HelpVerifier.checkModule(registry.getModule(stringArray[0]), typeInfo);
        }
        System.exit(0);
    }
}

