/*
 * Decompiled with CFR 0.152.
 */
package org.baja.ffmpeg.libavcodec;

import java.util.Hashtable;
import javax.baja.gx.Size;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.Type;
import org.baja.ffmpeg.Ffmpeg;
import org.baja.ffmpeg.FfmpegNativeStruct;
import org.baja.ffmpeg.enums.BCodecIdEnum;
import org.baja.ffmpeg.enums.BFfmpegLogLevel;
import org.baja.ffmpeg.enums.BPixelFormatEnum;
import org.baja.ffmpeg.libavcodec.FfmpegAVCodec;
import org.baja.ffmpeg.libavcodec.FfmpegAVCodecContext;
import org.baja.ffmpeg.libavcodec.FfmpegAVFrame;

public class FfmpegAvCodecUtil
extends Ffmpeg {
    private static Hashtable bajaEnumToNativeEnumTable = new Hashtable();

    public static void setLogLevel(BFfmpegLogLevel bFfmpegLogLevel) {
        FfmpegAvCodecUtil.av_log_set_level(bFfmpegLogLevel.getOrdinal());
    }

    public static native void av_log_set_level(int var0);

    public static native void av_register_all();

    public static FfmpegAVCodecContext avcodec_alloc_context() {
        long l = FfmpegAvCodecUtil.avcodec_alloc_context0();
        return new FfmpegAVCodecContext(l);
    }

    public static FfmpegAVFrame avcodec_alloc_frame() {
        long l = FfmpegAvCodecUtil.avcodec_alloc_frame0();
        return new FfmpegAVFrame(l);
    }

    public static int avcodec_decode_video(FfmpegAVCodecContext ffmpegAVCodecContext, FfmpegAVFrame ffmpegAVFrame, boolean[] blArray, byte[] byArray, int n) {
        if (ffmpegAVCodecContext == null) {
            throw new NullPointerException("The given avCodecContext cannot be null");
        }
        if (ffmpegAVCodecContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avCodecContext.isNull() = true. Please pass a fully allocated value for the avCodecContext");
        }
        if (ffmpegAVFrame == null) {
            throw new NullPointerException("The given avFrame cannot be null");
        }
        if (ffmpegAVFrame.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avFrame.isNull() = true. Please pass a fully allocated value for the avFrame");
        }
        if (byArray == null) {
            throw new NullPointerException("The given packetData cannot be null.");
        }
        if (byArray.length < n) {
            throw new IllegalArgumentException("Unsafe: The length of the given packetData(" + byArray.length + ") is less than the given packetSize(" + n + ").");
        }
        if (blArray == null) {
            throw new NullPointerException("The given frameFinished cannot be null.");
        }
        if (blArray.length < 1) {
            throw new IllegalArgumentException("Unsafe: The length of the given frameFinished(" + blArray.length + ") is less than 1.");
        }
        return FfmpegAvCodecUtil.avcodec_decode_video(ffmpegAVCodecContext.getNativeHandle(), ffmpegAVFrame.getNativeHandle(), blArray, byArray, n);
    }

    public static int avcodec_encode_video(FfmpegAVCodecContext ffmpegAVCodecContext, byte[] byArray, int n, FfmpegAVFrame ffmpegAVFrame) {
        if (ffmpegAVCodecContext == null) {
            throw new NullPointerException("The given avCodecContext cannot be null");
        }
        if (ffmpegAVCodecContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avCodecContext.isNull() = true. Please pass a fully allocated value for the avCodecContext");
        }
        if (byArray == null) {
            throw new NullPointerException("The given bitBuffer cannot be null.");
        }
        if (byArray.length < n) {
            throw new IllegalArgumentException("Unsafe: The length of the given bitBuffer(" + byArray.length + ") is less than the given bitBufferSize(" + n + ").");
        }
        if (ffmpegAVFrame == null) {
            throw new NullPointerException("The given avFrame cannot be null");
        }
        if (ffmpegAVFrame.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avFrame.isNull() = true. Please pass a fully allocated value for the avFrame");
        }
        return FfmpegAvCodecUtil.avcodec_encode_video(ffmpegAVCodecContext.getNativeHandle(), byArray, n, ffmpegAVFrame.getNativeHandle());
    }

    public static FfmpegAVCodec avcodec_find_decoder(BCodecIdEnum bCodecIdEnum) {
        if (bCodecIdEnum == null) {
            throw new NullPointerException("The given codecId cannot be null.");
        }
        int n = FfmpegAvCodecUtil.getFfmpegNativeID(bCodecIdEnum);
        long l = FfmpegAvCodecUtil.avcodec_find_decoder(n);
        return new FfmpegAVCodec(l);
    }

    public static void avcodec_close(FfmpegAVCodecContext ffmpegAVCodecContext) {
        FfmpegAvCodecUtil.avcodec_close(ffmpegAVCodecContext.getNativeHandle());
    }

    public static FfmpegAVCodec avcodec_find_encoder(BCodecIdEnum bCodecIdEnum) {
        if (bCodecIdEnum == null) {
            throw new NullPointerException("The given codecId cannot be null.");
        }
        int n = FfmpegAvCodecUtil.getFfmpegNativeID(bCodecIdEnum);
        long l = FfmpegAvCodecUtil.avcodec_find_encoder(n);
        return new FfmpegAVCodec(l);
    }

    public static Size avcodec_get_dimensions(FfmpegAVCodecContext ffmpegAVCodecContext) {
        if (ffmpegAVCodecContext == null) {
            throw new NullPointerException("The given codecContext cannot be null");
        }
        if (ffmpegAVCodecContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given codecContext.isNull() = true. Please pass a fully allocated value for the codecContext");
        }
        int[] nArray = new int[2];
        FfmpegAvCodecUtil.avcodec_get_dimensions(ffmpegAVCodecContext.getNativeHandle(), nArray);
        return new Size((double)nArray[0], (double)nArray[1]);
    }

    public static int avcodec_open(FfmpegAVCodecContext ffmpegAVCodecContext, FfmpegAVCodec ffmpegAVCodec) {
        if (ffmpegAVCodecContext == null) {
            throw new NullPointerException("The given ffmpegContext cannot be null");
        }
        if (ffmpegAVCodecContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given ffmpegContext.isNull() = true. Please pass a fully allocated value for the ffmpegContext.");
        }
        if (ffmpegAVCodec == null) {
            throw new NullPointerException("The given ffmpegCodec cannot be null");
        }
        if (ffmpegAVCodec.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given ffmpegCodec.isNull() = true. Please pass a fully allocated value for the ffmpegCodec.");
        }
        return FfmpegAvCodecUtil.avcodec_open(ffmpegAVCodecContext.getNativeHandle(), ffmpegAVCodec.getNativeHandle());
    }

    public static void avcodec_set_dimensions(FfmpegAVCodecContext ffmpegAVCodecContext, int n, int n2) {
        if (ffmpegAVCodecContext == null) {
            throw new NullPointerException("The given avCodecContext cannot be null");
        }
        if (ffmpegAVCodecContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avCodecContext.isNull() = true. Please pass a fully allocated value for the avCodecContext.");
        }
        FfmpegAvCodecUtil.avcodec_set_dimensions(ffmpegAVCodecContext.getNativeHandle(), n, n2);
    }

    public static void av_free(FfmpegNativeStruct ffmpegNativeStruct) {
        if (ffmpegNativeStruct != null && !ffmpegNativeStruct.isNull()) {
            FfmpegAvCodecUtil.av_free(ffmpegNativeStruct.getNativeHandle());
            ffmpegNativeStruct.setNativeHandle(0L);
        }
    }

    public static int avpicture_get_size(BPixelFormatEnum bPixelFormatEnum, int n, int n2) {
        int n3 = FfmpegAvCodecUtil.getFfmpegNativeID(bPixelFormatEnum);
        return FfmpegAvCodecUtil.avpicture_get_size(n3, n, n2);
    }

    public static int computePpmLength(int n, int n2) {
        String string = "P6\n" + n + ' ' + n2 + "\n255\n";
        int n3 = string.length();
        int n4 = n * 3 * n2;
        int n5 = n4 + n3;
        return n5;
    }

    public static int[] getPixels(FfmpegAVFrame ffmpegAVFrame, int n, int n2, int[] nArray) {
        if (ffmpegAVFrame == null) {
            throw new NullPointerException("The given avFrame cannot be null");
        }
        if (ffmpegAVFrame.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avFrame.isNull() = true. Please pass a fully allocated value for the avFrame");
        }
        if (nArray == null) {
            nArray = new int[n * n2];
        }
        FfmpegAvCodecUtil.getPixels(ffmpegAVFrame.getNativeHandle(), n, n2, nArray);
        return nArray;
    }

    private static final native void getPixels(long var0, int var2, int var3, int[] var4);

    public static byte[] convertRgbFrameToPpm(FfmpegAVFrame ffmpegAVFrame, int n, int n2, byte[] byArray) {
        if (ffmpegAVFrame == null) {
            throw new NullPointerException("The given avFrame cannot be null");
        }
        if (ffmpegAVFrame.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avFrame.isNull() = true. Please pass a fully allocated value for the avFrame");
        }
        if (byArray == null) {
            int n3 = FfmpegAvCodecUtil.computePpmLength(n, n2);
            byArray = new byte[n3];
        }
        FfmpegAvCodecUtil.convertRgbFrameToPpm(ffmpegAVFrame.getNativeHandle(), n, n2, byArray);
        return byArray;
    }

    public static FfmpegAVFrame allocateAndInitFormattedFrame(int n, int n2, BPixelFormatEnum bPixelFormatEnum) {
        return new FfmpegAVFrame(FfmpegAvCodecUtil.allocateAndInitFormattedFrame(n, n2, FfmpegAvCodecUtil.getFfmpegNativeID(bPixelFormatEnum)));
    }

    private static final native long allocateAndInitFormattedFrame(int var0, int var1, int var2);

    private static final native void convertRgbFrameToPpm(long var0, int var2, int var3, byte[] var4);

    public static int getFfmpegNativeID(BCodecIdEnum bCodecIdEnum) {
        if (bCodecIdEnum == null) {
            throw new NullPointerException("The given codecId cannot be null.");
        }
        return FfmpegAvCodecUtil.getFfmpegNativeID0(bCodecIdEnum);
    }

    public static int getFfmpegNativeID(BPixelFormatEnum bPixelFormatEnum) {
        if (bPixelFormatEnum == null) {
            throw new NullPointerException("The given pixelFormatEnum cannot be null.");
        }
        return FfmpegAvCodecUtil.getFfmpegNativeID0(bPixelFormatEnum);
    }

    private static final int getFfmpegNativeID0(BFrozenEnum bFrozenEnum) {
        BInteger bInteger = (BInteger)bajaEnumToNativeEnumTable.get(bFrozenEnum);
        if (bInteger == null) {
            throw new IllegalArgumentException("Native enum id not found for Baja Ffmpeg Enum: " + bFrozenEnum);
        }
        return bInteger.getInt();
    }

    public static void ffmpegSetEndodeOptions(FfmpegAVCodecContext ffmpegAVCodecContext, BPixelFormatEnum bPixelFormatEnum, int n, int n2) {
        if (ffmpegAVCodecContext == null) {
            throw new NullPointerException("The given avCodecContext cannot be null");
        }
        if (ffmpegAVCodecContext.isNull()) {
            throw new IllegalArgumentException("Unsupported: The given avCodecContext.isNull() = true. Please pass a fully allocated value for the avCodecContext.");
        }
        FfmpegAvCodecUtil.ffmpegSetEndodeOptions(ffmpegAVCodecContext.getNativeHandle(), FfmpegAvCodecUtil.getFfmpegNativeID(bPixelFormatEnum), n, n2);
    }

    private static final native void ffmpegSetEndodeOptions(long var0, int var2, int var3, int var4);

    private static final native void avcodec_get_dimensions(long var0, int[] var2);

    private static final native int avpicture_get_size(int var0, int var1, int var2);

    private static final native int getFfmpegCodecID0(String var0);

    private static final native int getFfmpegPixelFormat0(String var0);

    private static final native void avcodec_set_dimensions(long var0, int var2, int var3);

    private static final synchronized native long avcodec_alloc_context0();

    public static synchronized native long avcodec_alloc_frame0();

    private static final native long avcodec_find_decoder(int var0);

    private static final native long avcodec_find_encoder(int var0);

    private static final synchronized native int avcodec_open(long var0, long var2);

    private static final synchronized native void avcodec_close(long var0);

    private static final native void av_free(long var0);

    private static final native int avcodec_decode_video(long var0, long var2, boolean[] var4, byte[] var5, int var6);

    private static final native int avcodec_encode_video(long var0, byte[] var2, int var3, long var4);

    private static final void loadNativeIds(Type type) {
        BFrozenEnum bFrozenEnum = (BFrozenEnum)type.getInstance();
        BEnumRange bEnumRange = bFrozenEnum.getRange();
        int[] nArray = bEnumRange.getOrdinals();
        int n = 0;
        while (n < nArray.length) {
            int n2;
            int n3 = nArray[n];
            String string = bEnumRange.getTag(n3);
            String string2 = string.substring(7);
            if (type == BCodecIdEnum.TYPE) {
                n2 = FfmpegAvCodecUtil.getFfmpegCodecID0(string2);
            } else if (type == BPixelFormatEnum.TYPE) {
                n2 = FfmpegAvCodecUtil.getFfmpegPixelFormat0(string2);
            } else {
                throw new IllegalArgumentException("Unrecognized org.baja.ffmpeg.enums TYPE: " + type.getDisplayName(null));
            }
            BFrozenEnum bFrozenEnum2 = (BFrozenEnum)bEnumRange.get(string);
            bajaEnumToNativeEnumTable.put(bFrozenEnum2, BInteger.make((int)n2));
            ++n;
        }
    }

    static {
        FfmpegAvCodecUtil.loadNativeIds(BCodecIdEnum.TYPE);
        FfmpegAvCodecUtil.loadNativeIds(BPixelFormatEnum.TYPE);
    }
}

