/*
 * Decompiled with CFR 0.152.
 */
package org.baja.ffmpeg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import org.baja.ffmpeg.DynamicLoadException;

public class ClientSideNativeLibraryLoader {
    protected static Log log = Log.getLog((String)"ffmpeg.load");
    protected static String bajaBinDirStr;
    protected static File bajaBinDir;
    private static final String AVUTIL_VERSION = "51";
    private static final String AVCODEC_VERSION = "54";
    private static final String AVFORMAT_VERSION = "54";
    private static final String SWSCALE_VERSION = "2";
    public static final long NULL = 0L;

    protected static void findNreBin() {
        File file = Sys.getBajaHome();
        bajaBinDir = new File(file, "bin");
        bajaBinDir.mkdir();
        bajaBinDirStr = bajaBinDir.getAbsolutePath();
    }

    protected static void loadLibraryFromThisModule(String string) {
        if (log.isTraceOn()) {
            log.trace("Extracting:> " + string);
        }
        String string2 = ClientSideNativeLibraryLoader.extractLibraryFromThisModule(string);
        if (log.isTraceOn()) {
            log.trace("JNI Loading:> " + string);
        }
        System.load(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String extractLibraryFromThisModule(String string) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        InputStream inputStream;
        String string2 = "module://ffmpeg/nativeLib";
        String string3 = System.getProperty("sun.arch.data.model");
        if (string3.equals("32")) {
            string2 = string2 + "/x86_32/" + string;
        } else if (string3.equals("64")) {
            string2 = string2 + "/x86_64/" + string;
        }
        BOrd bOrd = BOrd.make((String)string2);
        BIFile bIFile = (BIFile)bOrd.get();
        File file = new File(bajaBinDir, string);
        if (file.exists()) {
            try {
                FileUtil.delete((File)file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            inputStream = bIFile.getInputStream();
            fileOutputStream = new FileOutputStream(file);
            byArray = new byte[40960];
            try {}
            catch (Throwable throwable) {
                Object var10_14 = null;
                fileOutputStream.flush();
                fileOutputStream.close();
                inputStream.close();
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("IO exception occurred while transferring " + string + " to client.", (Throwable)iOException);
            throw new DynamicLoadException("IO exception occurred while transferring " + string + " to client.", iOException);
        }
        while (true) {
            int n = inputStream.read(byArray);
            if (log.isTraceOn()) {
                log.trace("40K.");
            }
            if (n == -1) break;
            fileOutputStream.write(byArray, 0, n);
        }
        String string4 = file.getAbsolutePath();
        Object var10_13 = null;
        fileOutputStream.flush();
        fileOutputStream.close();
        inputStream.close();
        return string4;
    }

    static {
        ClientSideNativeLibraryLoader.findNreBin();
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("avutil-51.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("avcodec-54.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("avformat-54.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("swscale-2.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("ax-ffmpeg-wrapper.dll");
    }
}

