/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.util;

import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.link.LonIpLinkLayer;
import com.tridium.lonIp.messages.Acknowledge;
import com.tridium.lonIp.messages.ChannelMembership;
import com.tridium.lonIp.messages.ChannelRouting;
import com.tridium.lonIp.messages.DeviceRegistration;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonIp.messages.RequestMessage;
import com.tridium.lonIp.messages.StatisticsResp;
import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import javax.baja.log.Log;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.sys.BString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MemberAction
implements Runnable,
LonIp {
    private static boolean inuse = false;
    private static MemberAction ma = null;
    private BChannelMember cm;
    private BLonNetwork lonworks;
    private BIpChannel ipChan;
    private BIpLonNetworkConfig netCfg;
    private DatagramSocket udpPort;
    private LonIpLinkLayer link;
    private Log log;
    private boolean done;
    private Thread t;

    public static void init(BLonNetwork bLonNetwork, LonIpLinkLayer lonIpLinkLayer) {
        ma = new MemberAction(bLonNetwork, lonIpLinkLayer);
    }

    public static void getStatus(BChannelMember bChannelMember, boolean bl) {
        RequestMessage requestMessage = new RequestMessage(96);
        requestMessage.clear = bl;
        ma.send(requestMessage, bChannelMember);
    }

    public static void getDeviceConfig(BChannelMember bChannelMember) {
        RequestMessage requestMessage = new RequestMessage(99);
        ma.send(requestMessage, bChannelMember);
    }

    public static void getRoute(BChannelMember bChannelMember) {
        RequestMessage requestMessage = new RequestMessage(104);
        requestMessage.ipAddress = bChannelMember.getSegmentIp(MemberAction.ma.netCfg);
        ma.send(requestMessage, bChannelMember);
    }

    public static void getChannelMembership(BChannelMember bChannelMember) {
        RequestMessage requestMessage = new RequestMessage(100);
        ma.send(requestMessage, bChannelMember);
    }

    private final void processIpMessage(LonIpMessage lonIpMessage) {
        switch (lonIpMessage.packetType) {
            case 113: {
                this.rcvDeviceConfiguration((DeviceRegistration)lonIpMessage);
                break;
            }
            case 4: {
                this.rcvChannelMembership((ChannelMembership)lonIpMessage);
                break;
            }
            case 8: {
                this.rcvChannelRouting((ChannelRouting)lonIpMessage);
                break;
            }
            case 112: {
                this.rcvStatusResponse((StatisticsResp)lonIpMessage);
                break;
            }
            case 7: {
                this.rcvAcknowledge((Acknowledge)lonIpMessage);
                break;
            }
            default: {
                System.out.println("Packet type not implemented:" + Integer.toString(lonIpMessage.packetType, 16));
            }
        }
    }

    private final void rcvDeviceConfiguration(DeviceRegistration deviceRegistration) {
        String string = deviceRegistration.toString();
        this.ipChan.fireStatusResponse(BString.make((String)(this.cm.getCnName() + ',' + string)));
    }

    private final void rcvChannelMembership(ChannelMembership channelMembership) {
        String string = channelMembership.toString();
        this.ipChan.fireStatusResponse(BString.make((String)(this.cm.getCnName() + ',' + string)));
    }

    private final void rcvChannelRouting(ChannelRouting channelRouting) {
        String string = channelRouting.toString();
        this.ipChan.fireStatusResponse(BString.make((String)(this.cm.getCnName() + ',' + string)));
    }

    private final void rcvStatusResponse(StatisticsResp statisticsResp) {
        String string = statisticsResp.stats.toString();
        this.ipChan.fireStatusResponse(BString.make((String)(this.cm.getCnName() + ',' + string)));
    }

    private final void rcvAcknowledge(Acknowledge acknowledge) {
        String string = "";
        switch (acknowledge.ackType) {
            case 0: {
                string = "AckOk";
                break;
            }
            case 1: {
                string = "AckFixed";
                break;
            }
            case 2: {
                string = "AckBadMessage";
                break;
            }
            case 3: {
                string = "AckCantComply";
                break;
            }
            case 4: {
                string = "AckDeviceRefused";
                break;
            }
            case 5: {
                string = "AckNotSupported";
                break;
            }
        }
        this.ipChan.fireStatusResponse(BString.make((String)(this.cm.getCnName() + ", received ackType=" + string + "??")));
    }

    private final void send(LonIpMessage lonIpMessage, BChannelMember bChannelMember) {
        this.cm = bChannelMember;
        InetAddress inetAddress = bChannelMember.getSegmentIp(MemberAction.ma.netCfg).getInetAddress();
        int n = bChannelMember.getIpUcPort();
        int n2 = bChannelMember.getSequenceAndIncrement();
        if (this.netCfg.getUseExtendedNat()) {
            lonIpMessage.addExtendedNat(this.netCfg, false);
            lonIpMessage.ipPort = this.udpPort.getLocalPort();
        }
        lonIpMessage.sequenceNumber = n2;
        byte[] byArray = lonIpMessage.toNetworkBytes();
        if (this.log.isTraceOn()) {
            System.out.println();
            this.link.writeLinkDebug("MA Send " + inetAddress + ':' + n + ':', byArray, byArray.length);
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        try {
            this.udpPort.send(datagramPacket);
        }
        catch (Exception exception) {
            this.log.warning("Can not send to " + inetAddress + ':' + n);
        }
    }

    public void run() {
        block7: while (!this.done) {
            byte[] byArray = new byte[1600];
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 1600);
                try {
                    this.udpPort.receive(datagramPacket);
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                if (this.log.isTraceOn()) {
                    this.link.writeLinkDebug("MA Rcvd:" + datagramPacket.getAddress() + ':' + datagramPacket.getPort() + "  ", byArray, datagramPacket.getLength());
                }
                int n = datagramPacket.getLength();
                int n2 = 0;
                byte[] byArray2 = byArray;
                while (n2 < n) {
                    LonIpMessage lonIpMessage = LonIpMessage.make(byArray2);
                    lonIpMessage.setSrcAddress(datagramPacket.getAddress());
                    lonIpMessage.setSrcPort(datagramPacket.getPort());
                    this.processIpMessage(lonIpMessage);
                    if ((n2 += lonIpMessage.packetLength) >= n) continue;
                    int n3 = ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
                    if (n3 + n2 > n) continue block7;
                    byArray2 = new byte[n3];
                    System.arraycopy(byArray, n2, byArray2, 0, n3);
                }
            }
            catch (SocketException socketException) {
                if (this.done) continue;
                this.log.error("SocketException in MemberAction!", (Throwable)socketException);
            }
            catch (IOException iOException) {
                this.log.error("Error receiving LonIp packet!", (Throwable)iOException);
            }
            catch (ThreadDeath threadDeath) {
                this.done = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.log.error("MemberAction error", throwable);
                System.out.println(LonByteArrayUtil.toString((byte[])byArray));
            }
        }
    }

    private final /* synthetic */ void this() {
        this.done = false;
    }

    private MemberAction(BLonNetwork bLonNetwork, LonIpLinkLayer lonIpLinkLayer) {
        this.this();
        this.lonworks = bLonNetwork;
        this.link = lonIpLinkLayer;
        this.ipChan = (BIpChannel)bLonNetwork.get("ipChannel");
        this.netCfg = this.ipChan.getNetworkConfig();
        this.log = Log.getLog((String)(bLonNetwork.getLogName() + ".channelMonitor"));
        try {
            this.udpPort = new DatagramSocket();
        }
        catch (Throwable throwable) {
            this.log.error(throwable.toString());
        }
        if (this.udpPort == null) {
            String string = "DatagramSocket is null!  Socket " + this.netCfg.getConfigServerPort() + " may be in use by another process.";
            this.log.error(string);
            return;
        }
        this.done = false;
        this.t = new Thread((Runnable)this, bLonNetwork.getLogName() + ".LonIpMemberAction");
        this.t.start();
        this.t.setPriority(5);
    }
}

