/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.Statistics;
import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.messages.LonIpMessage;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class StatisticsResp
extends LonIpMessage {
    public Statistics stats;

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        this.stats.TimeSinceCounterReset = this.readStat(lonInputStream);
        this.stats.TimeOfLastCounterReset = BDateTime.fromInputStream(lonInputStream);
        this.stats.NumberOfChannelMembers = this.readStat(lonInputStream);
        this.stats.NumberOfMembersSentTo = this.readStat(lonInputStream);
        this.stats.LonPacketsRcvdFromLonChan = this.readStat(lonInputStream);
        this.stats.LonPacketsRcvdAndDiscarded = this.readStat(lonInputStream);
        this.stats.LonTotalBytesReceived = this.readStat(lonInputStream);
        this.stats.LonPacktsSentOnLonChan = this.readStat(lonInputStream);
        this.stats.LonTotalBytesSent = this.readStat(lonInputStream);
        this.stats.LonPacketsSentToIpChan = this.readStat(lonInputStream);
        this.stats.LonBytesSentToIpChan = this.readStat(lonInputStream);
        this.stats.LonPacketsFromIpChan = this.readStat(lonInputStream);
        this.stats.LonBytesFromIpChan = this.readStat(lonInputStream);
        this.stats.IPPacketsWithLonToIpChan = this.readStat(lonInputStream);
        this.stats.IPPacketsWithLonFromIp = this.readStat(lonInputStream);
        this.stats.AverageAggregateToIpChan = this.readStat(lonInputStream);
        this.stats.AverageAggregateFromIp = this.readStat(lonInputStream);
        this.stats.NumOfUDPPacketsSent = this.readStat(lonInputStream);
        this.stats.NumOfTCPPacketsSent = this.readStat(lonInputStream);
        this.stats.NumOfMcastPacketsSent = this.readStat(lonInputStream);
        this.stats.StaleIpDropped = this.readStat(lonInputStream);
        this.stats.TCPConnectionFailures = this.readStat(lonInputStream);
        this.stats.TCPHostFailures = this.readStat(lonInputStream);
        this.stats.RouterConfigMsgSent = this.readStat(lonInputStream);
        this.stats.RouterConfigMsgRcvd = this.readStat(lonInputStream);
        this.stats.ConfigurationChanges = this.readStat(lonInputStream);
        this.stats.AverageUdpPerSecSent = this.readStat(lonInputStream);
        this.stats.AverageUdpPerSecRcvd = this.readStat(lonInputStream);
        this.stats.AverageTcpPerSecSent = this.readStat(lonInputStream);
        this.stats.AverageTcpPerSecRcvd = this.readStat(lonInputStream);
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        long l = BDateTime.make().getSeconds() - this.stats.TimeOfLastCounterReset.getSeconds();
        this.writeStat(lonOutputStream, l);
        this.stats.TimeOfLastCounterReset.toOutputStream(lonOutputStream);
        this.writeStat(lonOutputStream, this.stats.NumberOfChannelMembers);
        this.writeStat(lonOutputStream, this.stats.NumberOfMembersSentTo);
        this.writeStat(lonOutputStream, this.stats.LonPacketsRcvdFromLonChan);
        this.writeStat(lonOutputStream, this.stats.LonPacketsRcvdAndDiscarded);
        this.writeStat(lonOutputStream, this.stats.LonTotalBytesReceived);
        this.writeStat(lonOutputStream, this.stats.LonPacktsSentOnLonChan);
        this.writeStat(lonOutputStream, this.stats.LonTotalBytesSent);
        this.writeStat(lonOutputStream, this.stats.LonPacketsSentToIpChan);
        this.writeStat(lonOutputStream, this.stats.LonBytesSentToIpChan);
        this.writeStat(lonOutputStream, this.stats.LonPacketsFromIpChan);
        this.writeStat(lonOutputStream, this.stats.LonBytesFromIpChan);
        this.writeStat(lonOutputStream, this.stats.IPPacketsWithLonToIpChan);
        this.writeStat(lonOutputStream, this.stats.IPPacketsWithLonFromIp);
        this.writeStat(lonOutputStream, this.stats.AverageAggregateToIpChan);
        this.writeStat(lonOutputStream, this.stats.AverageAggregateFromIp);
        this.writeStat(lonOutputStream, this.stats.NumOfUDPPacketsSent);
        this.writeStat(lonOutputStream, this.stats.NumOfTCPPacketsSent);
        this.writeStat(lonOutputStream, this.stats.NumOfMcastPacketsSent);
        this.writeStat(lonOutputStream, this.stats.StaleIpDropped);
        this.writeStat(lonOutputStream, this.stats.TCPConnectionFailures);
        this.writeStat(lonOutputStream, this.stats.TCPHostFailures);
        this.writeStat(lonOutputStream, this.stats.RouterConfigMsgSent);
        this.writeStat(lonOutputStream, this.stats.RouterConfigMsgRcvd);
        this.writeStat(lonOutputStream, this.stats.ConfigurationChanges);
        this.writeStat(lonOutputStream, l > 0L ? this.stats.NumOfUDPPacketsSent / l : 0L);
        this.writeStat(lonOutputStream, l > 0L ? this.stats.NumOfUDPPacketsRcvd / l : 0L);
        this.writeStat(lonOutputStream, this.stats.AverageTcpPerSecSent);
        this.writeStat(lonOutputStream, this.stats.AverageTcpPerSecRcvd);
    }

    long readStat(LonInputStream lonInputStream) {
        long l = lonInputStream.readUnsigned32();
        if (l == 0xFFFFFFFFL) {
            l = -1;
        } else if (l == 0xFFFFFFFEL) {
            l = -2L;
        }
        return l;
    }

    void writeStat(LonOutputStream lonOutputStream, long l) {
        if (l == (long)-1) {
            lonOutputStream.writeUnsigned32(0xFFFFFFFFL);
        } else if (l > 0xFFFFFFFDL) {
            lonOutputStream.writeUnsigned32(0xFFFFFFFEL);
        } else {
            lonOutputStream.writeUnsigned32(l);
        }
    }

    public StatisticsResp() {
        this.stats = new Statistics();
        this.packetType = 112;
    }

    public StatisticsResp(Statistics statistics) {
        this.stats = statistics;
        this.packetType = 112;
    }
}

