/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.enums.BIpLonCnFlagsEnum;
import com.tridium.lonIp.enums.BIpLonIpFlagsEnum;
import com.tridium.lonIp.enums.BIpLonNodeTypeEnum;
import com.tridium.lonIp.enums.BIpLonRouterTypeEnum;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeviceRegistration
extends LonIpMessage {
    public BDateTime dateTime;
    public BIpLonIpFlagsEnum ipFlags;
    public BIpLonRouterTypeEnum routerType;
    public BIpLonCnFlagsEnum cnFlags;
    public BIpLonNodeTypeEnum nodeType;
    public int channelTimeout;
    public int ucIpPort;
    public BIpAddress ucIpAdr;
    public BDateTime chanMembershipDt;
    public BDateTime sendlistDt;
    public BIpAddress configServerIp;
    public BIpAddress primaryTimeIp;
    public BIpAddress secondaryTimeIp;
    public int configServerPort;
    public int primaryTimePort;
    public int secondaryTimePort;
    public BIpAddress[] mcIps;
    public int[] mcPorts;
    public byte[] id;
    public String name;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("dateTime=").append((Object)this.dateTime).append("\n");
        stringBuffer.append((Object)this.ipFlags).append(":").append((Object)this.routerType).append(":").append((Object)this.cnFlags).append(":").append((Object)this.nodeType).append("\n");
        stringBuffer.append("ipAddress=").append((Object)this.ucIpAdr).append(":").append(this.ucIpPort).append("\n");
        if (!BIpAddress.DEFAULT.equals((Object)this.configServerIp)) {
            stringBuffer.append("configServer=").append((Object)this.configServerIp).append(":").append(this.configServerPort).append("\n");
        }
        if (!BIpAddress.DEFAULT.equals((Object)this.primaryTimeIp)) {
            stringBuffer.append("primaryTime=").append((Object)this.primaryTimeIp).append(":").append(this.primaryTimePort).append("\n");
        }
        if (!BIpAddress.DEFAULT.equals((Object)this.secondaryTimeIp)) {
            stringBuffer.append("secondaryTime=").append((Object)this.secondaryTimeIp).append(":").append(this.secondaryTimePort).append("\n");
        }
        stringBuffer.append("chanMembershipDt=").append((Object)this.chanMembershipDt).append("\n");
        stringBuffer.append("sendlistDt=").append((Object)this.sendlistDt).append("\n");
        stringBuffer.append("id=").append(LonByteArrayUtil.toString((byte[])this.id)).append("\n");
        return stringBuffer.toString();
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        this.dateTime = BDateTime.fromInputStream(lonInputStream);
        this.ipFlags = BIpLonIpFlagsEnum.makeValid(lonInputStream.readUnsigned8());
        this.routerType = BIpLonRouterTypeEnum.makeValid(lonInputStream.readUnsigned8());
        this.cnFlags = BIpLonCnFlagsEnum.makeValid(lonInputStream.readUnsigned8());
        this.nodeType = BIpLonNodeTypeEnum.makeValid(lonInputStream.readUnsigned8());
        int n = lonInputStream.readUnsigned8();
        lonInputStream.readUnsigned8();
        this.channelTimeout = lonInputStream.readUnsigned16();
        int n2 = lonInputStream.readUnsigned16();
        this.ucIpPort = lonInputStream.readUnsigned16();
        this.ucIpAdr = BIpAddress.fromInputStream(lonInputStream);
        this.chanMembershipDt = BDateTime.fromInputStream(lonInputStream);
        this.sendlistDt = BDateTime.fromInputStream(lonInputStream);
        this.configServerIp = BIpAddress.fromInputStream(lonInputStream);
        this.primaryTimeIp = BIpAddress.fromInputStream(lonInputStream);
        this.secondaryTimeIp = BIpAddress.fromInputStream(lonInputStream);
        this.configServerPort = lonInputStream.readUnsigned16();
        this.primaryTimePort = lonInputStream.readUnsigned16();
        this.secondaryTimePort = lonInputStream.readUnsigned16();
        lonInputStream.readUnsigned16();
        this.mcIps = new BIpAddress[n];
        this.mcPorts = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.mcIps[n3] = BIpAddress.fromInputStream(lonInputStream);
            this.mcPorts[n3] = lonInputStream.readUnsigned16();
            lonInputStream.readUnsigned16();
            ++n3;
        }
        this.id = lonInputStream.readByteArray(n2);
        n3 = lonInputStream.readUnsigned8();
        this.name = lonInputStream.readCharArray(n3);
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        int n = this.mcIps.length;
        this.dateTime.toOutputStream(lonOutputStream);
        lonOutputStream.writeUnsigned8(this.ipFlags.getOrdinal());
        lonOutputStream.writeUnsigned8(this.routerType.getOrdinal());
        lonOutputStream.writeUnsigned8(this.cnFlags.getOrdinal());
        lonOutputStream.writeUnsigned8(this.nodeType.getOrdinal());
        lonOutputStream.writeUnsigned8(n);
        lonOutputStream.writeUnsigned8(0);
        lonOutputStream.writeUnsigned16(this.channelTimeout);
        lonOutputStream.writeUnsigned16(this.id.length);
        lonOutputStream.writeUnsigned16(this.ucIpPort);
        this.ucIpAdr.toOutputStream(lonOutputStream);
        this.chanMembershipDt.toOutputStream(lonOutputStream);
        this.sendlistDt.toOutputStream(lonOutputStream);
        this.configServerIp.toOutputStream(lonOutputStream);
        this.primaryTimeIp.toOutputStream(lonOutputStream);
        this.secondaryTimeIp.toOutputStream(lonOutputStream);
        lonOutputStream.writeUnsigned16(this.configServerPort);
        lonOutputStream.writeUnsigned16(this.primaryTimePort);
        lonOutputStream.writeUnsigned16(this.secondaryTimePort);
        lonOutputStream.writeUnsigned16(0);
        int n2 = 0;
        while (n2 < n) {
            this.mcIps[n2].toOutputStream(lonOutputStream);
            lonOutputStream.writeUnsigned16(this.mcPorts[n2]);
            lonOutputStream.writeUnsigned16(0);
            ++n2;
        }
        lonOutputStream.writeByteArray(this.id);
        n2 = this.name.length() + 1;
        lonOutputStream.writeUnsigned8(n2);
        lonOutputStream.writeCharArray(this.name, n2);
    }

    private final /* synthetic */ void this() {
        this.dateTime = BDateTime.DEFAULT;
        this.ipFlags = LonIp.NIAGARA_IP_FLAG;
        this.routerType = LonIp.NIAGARA_ROUTER_TYPE;
        this.cnFlags = LonIp.NIAGARA_FLAG;
        this.nodeType = LonIp.NIAGARA_NODE_TYPE;
        this.channelTimeout = 0;
        this.ucIpAdr = BIpAddress.DEFAULT;
        this.chanMembershipDt = BDateTime.DEFAULT;
        this.sendlistDt = BDateTime.DEFAULT;
        this.configServerIp = BIpAddress.DEFAULT;
        this.primaryTimeIp = BIpAddress.DEFAULT;
        this.secondaryTimeIp = BIpAddress.DEFAULT;
        this.primaryTimePort = 0;
        this.secondaryTimePort = 0;
    }

    public DeviceRegistration() {
        this.this();
    }

    public DeviceRegistration(int n) {
        this.this();
        this.packetType = n;
    }
}

