/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.enums.BIpLonCnFlagsEnum;
import com.tridium.lonIp.enums.BIpLonIpFlagsEnum;
import com.tridium.lonIp.enums.BIpLonNodeTypeEnum;
import com.tridium.lonIp.enums.BIpLonRouterTypeEnum;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChannelRouting
extends LonIpMessage {
    public BDateTime dateTime;
    public int mcIpPort;
    public int ucIpPort;
    public BIpAddress mcIpAdr;
    public BIpAddress ucIpAdr;
    public BIpLonIpFlagsEnum ipFlags;
    public BIpLonRouterTypeEnum routerType;
    public BIpLonCnFlagsEnum cnFlags;
    public BIpLonNodeTypeEnum nodeType;
    public BNeuronId[] nids;
    public SubnetNodeRecord[] snRec;
    public DomainRecord[] domRec;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("dateTime=").append((Object)this.dateTime).append("\n");
        stringBuffer.append((Object)this.ipFlags).append(":").append((Object)this.routerType).append(":").append((Object)this.cnFlags).append(":").append((Object)this.nodeType).append("\n");
        stringBuffer.append("ucIpAdr=").append((Object)this.ucIpAdr).append(":").append(this.ucIpPort).append("\n");
        int n = 0;
        while (n < this.snRec.length) {
            Object object;
            SubnetNodeRecord subnetNodeRecord = this.snRec[n];
            stringBuffer.append("s\\n=").append(subnetNodeRecord.sn).append(":");
            if (this.nids.length > subnetNodeRecord.nidNdx) {
                object = this.nids[subnetNodeRecord.nidNdx];
                stringBuffer.append("id=").append(object.toString()).append("\n");
            }
            if (this.domRec.length > subnetNodeRecord.domainNdx) {
                object = this.domRec[subnetNodeRecord.domainNdx];
                stringBuffer.append("s\\n mask=").append(LonByteArrayUtil.toString((byte[])object.subnetMask)).append("\n");
                stringBuffer.append("grp mask=").append(LonByteArrayUtil.toString((byte[])object.groupMask)).append("\n");
                stringBuffer.append("domainId=").append(object.domainId).append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        Object object;
        this.dateTime = BDateTime.fromInputStream(lonInputStream);
        this.mcIpPort = lonInputStream.readUnsigned16();
        this.ucIpPort = lonInputStream.readUnsigned16();
        this.mcIpAdr = BIpAddress.fromInputStream(lonInputStream);
        this.ucIpAdr = BIpAddress.fromInputStream(lonInputStream);
        this.ipFlags = BIpLonIpFlagsEnum.makeValid(lonInputStream.readUnsigned8());
        this.routerType = BIpLonRouterTypeEnum.makeValid(lonInputStream.readUnsigned8());
        this.cnFlags = BIpLonCnFlagsEnum.makeValid(lonInputStream.readUnsigned8());
        this.nodeType = BIpLonNodeTypeEnum.makeValid(lonInputStream.readUnsigned8());
        int n = lonInputStream.readUnsigned16() / 6;
        lonInputStream.readUnsigned16();
        int n2 = lonInputStream.readUnsigned16() / 6;
        int n3 = lonInputStream.readUnsigned16() / 72;
        this.nids = new BNeuronId[n];
        int n4 = 0;
        while (n4 < n) {
            this.nids[n4] = BNeuronId.make((byte[])lonInputStream.readByteArray(6));
            ++n4;
        }
        this.snRec = new SubnetNodeRecord[n2];
        n4 = 0;
        while (n4 < n2) {
            object = new SubnetNodeRecord();
            ((SubnetNodeRecord)object).sn = BSubnetNode.make((int)lonInputStream.readUnsigned8(), (int)lonInputStream.readUnsigned8());
            ((SubnetNodeRecord)object).domainNdx = lonInputStream.readUnsigned16();
            ((SubnetNodeRecord)object).nidNdx = lonInputStream.readUnsigned16();
            this.snRec[n4] = object;
            ++n4;
        }
        this.domRec = new DomainRecord[n3];
        n4 = 0;
        while (n4 < n3) {
            object = new DomainRecord();
            ((DomainRecord)object).subnetMask = lonInputStream.readByteArray(32);
            ((DomainRecord)object).groupMask = lonInputStream.readByteArray(32);
            int n5 = lonInputStream.readUnsigned8();
            lonInputStream.readUnsigned8();
            ((DomainRecord)object).domainId = BDomainId.make((int)n5, (byte[])lonInputStream.readByteArray(6));
            this.domRec[n4] = object;
            ++n4;
        }
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        Object object;
        this.dateTime.toOutputStream(lonOutputStream);
        lonOutputStream.writeUnsigned16(this.mcIpPort);
        lonOutputStream.writeUnsigned16(this.ucIpPort);
        this.mcIpAdr.toOutputStream(lonOutputStream);
        this.ucIpAdr.toOutputStream(lonOutputStream);
        lonOutputStream.writeUnsigned8(this.ipFlags.getOrdinal());
        lonOutputStream.writeUnsigned8(this.routerType.getOrdinal());
        lonOutputStream.writeUnsigned8(this.cnFlags.getOrdinal());
        lonOutputStream.writeUnsigned8(this.nodeType.getOrdinal());
        int n = this.nids.length;
        int n2 = this.snRec.length;
        int n3 = this.domRec.length;
        lonOutputStream.writeUnsigned16(n * 6);
        lonOutputStream.writeUnsigned16(0);
        lonOutputStream.writeUnsigned16(n2 * 6);
        lonOutputStream.writeUnsigned16(n3 * 72);
        int n4 = 0;
        while (n4 < n) {
            lonOutputStream.writeByteArray(this.nids[n4].getByteArray(), 6);
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            object = this.snRec[n4];
            lonOutputStream.writeUnsigned8(((SubnetNodeRecord)object).sn.getSubnetId());
            lonOutputStream.writeUnsigned8(((SubnetNodeRecord)object).sn.getNodeId());
            lonOutputStream.writeUnsigned16(((SubnetNodeRecord)object).domainNdx);
            lonOutputStream.writeUnsigned16(((SubnetNodeRecord)object).nidNdx);
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            object = this.domRec[n4];
            lonOutputStream.writeByteArray(((DomainRecord)object).subnetMask, 32);
            lonOutputStream.writeByteArray(((DomainRecord)object).groupMask, 32);
            lonOutputStream.writeUnsigned8(((DomainRecord)object).domainId.getLength());
            lonOutputStream.writeUnsigned8(0);
            lonOutputStream.writeByteArray(((DomainRecord)object).domainId.getDomainId(), 6);
            ++n4;
        }
    }

    private final /* synthetic */ void this() {
        this.mcIpPort = 0;
        this.ucIpPort = 0;
        this.mcIpAdr = BIpAddress.DEFAULT;
        this.ucIpAdr = BIpAddress.DEFAULT;
        this.ipFlags = LonIp.NIAGARA_IP_FLAG;
        this.routerType = LonIp.NIAGARA_ROUTER_TYPE;
        this.cnFlags = LonIp.NIAGARA_FLAG;
        this.nodeType = LonIp.NIAGARA_NODE_TYPE;
    }

    public ChannelRouting() {
        this.this();
        this.packetType = 8;
    }

    public static class SubnetNodeRecord {
        public BSubnetNode sn;
        public int domainNdx;
        public int nidNdx;
    }

    public static class DomainRecord {
        public byte[] subnetMask;
        public byte[] groupMask;
        public BDomainId domainId;
    }
}

