/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BDateTime
extends BSimple {
    private static final int DATE_TIME_LENGTH = 4;
    public static final long SECONDS_NTP_TO_UTC = 2208988800L;
    public static final BDateTime DEFAULT = new BDateTime(new byte[4]);
    public static final Type TYPE;
    public static final BFacets DisplayFacets;
    private byte[] timeStamp;
    private BAbsTime absTime;
    static /* synthetic */ Class class$com$tridium$lonIp$datatypes$BDateTime;

    public static final BDateTime make() {
        long l = System.currentTimeMillis() / 1000L + 2208988800L;
        return BDateTime.make(l);
    }

    public static final BDateTime make(long l) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(l & 0xFFL);
        byArray[2] = (byte)(l >> 8 & 0xFFL);
        byArray[1] = (byte)(l >> 16 & 0xFFL);
        byArray[0] = (byte)(l >> 24 & 0xFFL);
        return new BDateTime(byArray);
    }

    public static final BDateTime make(BAbsTime bAbsTime) {
        long l = bAbsTime.getMillis() / 1000L;
        if (l == 0L) {
            return DEFAULT;
        }
        BDateTime bDateTime = BDateTime.make(l += 2208988800L);
        bDateTime.absTime = bAbsTime;
        return bDateTime;
    }

    public static final BDateTime make(byte[] byArray) {
        return new BDateTime(byArray);
    }

    public final byte[] getByteArray() {
        return this.timeStamp;
    }

    public final long getSeconds() {
        long l = this.timeStamp[3] & 0xFF | (this.timeStamp[2] & 0xFF) << 8 | (this.timeStamp[1] & 0xFF) << 16 | (this.timeStamp[0] & 0xFF) << 24;
        return l & 0xFFFFFFFFL;
    }

    public final long getMillis() {
        return this.getSeconds() * 1000L;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BDateTime)) {
            return false;
        }
        BDateTime bDateTime = (BDateTime)((Object)object);
        int n = 0;
        while (n < bDateTime.timeStamp.length) {
            if (this.timeStamp[n] != bDateTime.timeStamp[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final boolean isLaterThan(BDateTime bDateTime) {
        boolean bl = false;
        if (this.getSeconds() > bDateTime.getSeconds()) {
            bl = true;
        }
        return bl;
    }

    public final String toString(Context context) {
        return this.getAbsTime().toString((Context)DisplayFacets);
    }

    public final BAbsTime getAbsTime() {
        if (this.absTime == null) {
            long l = this.getSeconds();
            l = l > 2208988800L ? l - 2208988800L : 0L;
            this.absTime = BAbsTime.make((long)(l * 1000L));
        }
        return this.absTime;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.timeStamp);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        byte[] byArray = new byte[4];
        dataInput.readFully(byArray, 0, 4);
        return new BDateTime(byArray);
    }

    public final String encodeToString() {
        return LonByteArrayUtil.toString((byte[])this.timeStamp);
    }

    public final BObject decodeFromString(String string) throws IOException {
        return new BDateTime(LonByteArrayUtil.getBytes((String)string, (int)4));
    }

    public static final BDateTime fromInputStream(LonInputStream lonInputStream) throws LonException {
        byte[] byArray = lonInputStream.readByteArray(4);
        return new BDateTime(byArray);
    }

    public final void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeByteArray(this.timeStamp);
    }

    public final Type getType() {
        return TYPE;
    }

    public static final void main(String[] stringArray) {
        BDateTime.test(new byte[]{-51, -58, -40, -103});
        BDateTime.test(new byte[]{-51, -63, 68, -58});
    }

    private static final void test(byte[] byArray) {
        BDateTime bDateTime = BDateTime.make(byArray);
        System.out.println(LonByteArrayUtil.toString((byte[])byArray) + "  " + (Object)((Object)bDateTime));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.timeStamp = new byte[4];
        this.absTime = null;
    }

    private BDateTime(byte[] byArray) {
        this.this();
        this.timeStamp = byArray;
    }

    static {
        Class clazz = class$com$tridium$lonIp$datatypes$BDateTime;
        if (clazz == null) {
            clazz = class$com$tridium$lonIp$datatypes$BDateTime = BDateTime.class("[Lcom.tridium.lonIp.datatypes.BDateTime;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DisplayFacets = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showTimeZone", (BIDataValue)BBoolean.TRUE);
    }
}

