/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonIp.ChannelMonitor;
import com.tridium.lonIp.ConfigServer;
import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonIp.enums.BIpLonCnFlagsEnum;
import com.tridium.lonIp.enums.BIpLonIpFlagsEnum;
import com.tridium.lonIp.enums.BIpLonNodeTypeEnum;
import com.tridium.lonIp.enums.BIpLonRouterTypeEnum;
import com.tridium.lonIp.enums.BMemberStateEnum;
import com.tridium.lonIp.enums.BStatusAuxCommandEnum;
import com.tridium.lonIp.messages.ChannelRouting;
import com.tridium.lonIp.messages.DeviceRegistration;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonIp.util.MemberAction;
import com.tridium.lonworks.datatypes.BLonRouteTable;
import java.net.InetAddress;
import javax.baja.log.Log;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BChannelMember
extends BComponent
implements BIStatus {
    public static final Property cnName = BChannelMember.newProperty((int)0, (String)"", null);
    public static final Property ipUcAddress = BChannelMember.newProperty((int)0, (BValue)BIpAddress.DEFAULT, null);
    public static final Property ipUcPort = BChannelMember.newProperty((int)0, (int)1628, null);
    public static final Property natIpAddress = BChannelMember.newProperty((int)0, (BValue)BIpAddress.DEFAULT, null);
    public static final Property ipFlags = BChannelMember.newProperty((int)0, (BValue)BIpLonIpFlagsEnum.Udp, null);
    public static final Property routerType = BChannelMember.newProperty((int)0, (BValue)BIpLonRouterTypeEnum.Configured, null);
    public static final Property cnFlags = BChannelMember.newProperty((int)0, (BValue)BIpLonCnFlagsEnum.none, null);
    public static final Property nodeType = BChannelMember.newProperty((int)0, (BValue)BIpLonNodeTypeEnum.NonIpToIpRouter, null);
    public static final Property subnetNode = BChannelMember.newProperty((int)0, (BValue)BSubnetNode.DEFAULT, null);
    public static final Property subnetMask = BChannelMember.newProperty((int)0, (BValue)BLonRouteTable.DEFAULT, null);
    public static final Property groupMask = BChannelMember.newProperty((int)0, (BValue)BLonRouteTable.DEFAULT, null);
    public static final Property neuronId = BChannelMember.newProperty((int)0, (BValue)BNeuronId.DEFAULT, null);
    public static final Property domainId = BChannelMember.newProperty((int)0, (BValue)BDomainId.DEFAULT, null);
    public static final Property configTimeStamp = BChannelMember.newProperty((int)0, (BValue)BDateTime.DEFAULT, null);
    public static final Property routeTimeStamp = BChannelMember.newProperty((int)0, (BValue)BDateTime.DEFAULT, null);
    public static final Property sequence = BChannelMember.newProperty((int)0, (int)1, null);
    public static final Property iState = BChannelMember.newProperty((int)0, (BValue)BMemberStateEnum.NewMember, null);
    public static final Property faultCause = BChannelMember.newProperty((int)0, (String)"", null);
    public static final Action update = BChannelMember.newAction((int)0, null);
    public static final Action getStatistics = BChannelMember.newAction((int)0, null);
    public static final Action getStatusAux = BChannelMember.newAction((int)0, (BValue)BStatusAuxCommandEnum.StatusNoClear, null);
    public static final Type TYPE;
    private int retryCount;
    static /* synthetic */ Class class$com$tridium$lonIp$datatypes$BChannelMember;

    public String getCnName() {
        return this.getString(cnName);
    }

    public void setCnName(String string) {
        this.setString(cnName, string, null);
    }

    public BIpAddress getIpUcAddress() {
        return (BIpAddress)this.get(ipUcAddress);
    }

    public void setIpUcAddress(BIpAddress bIpAddress) {
        this.set(ipUcAddress, (BValue)bIpAddress, null);
    }

    public int getIpUcPort() {
        return this.getInt(ipUcPort);
    }

    public void setIpUcPort(int n) {
        this.setInt(ipUcPort, n, null);
    }

    public BIpAddress getNatIpAddress() {
        return (BIpAddress)this.get(natIpAddress);
    }

    public void setNatIpAddress(BIpAddress bIpAddress) {
        this.set(natIpAddress, (BValue)bIpAddress, null);
    }

    public BIpLonIpFlagsEnum getIpFlags() {
        return (BIpLonIpFlagsEnum)this.get(ipFlags);
    }

    public void setIpFlags(BIpLonIpFlagsEnum bIpLonIpFlagsEnum) {
        this.set(ipFlags, (BValue)bIpLonIpFlagsEnum, null);
    }

    public BIpLonRouterTypeEnum getRouterType() {
        return (BIpLonRouterTypeEnum)this.get(routerType);
    }

    public void setRouterType(BIpLonRouterTypeEnum bIpLonRouterTypeEnum) {
        this.set(routerType, (BValue)bIpLonRouterTypeEnum, null);
    }

    public BIpLonCnFlagsEnum getCnFlags() {
        return (BIpLonCnFlagsEnum)this.get(cnFlags);
    }

    public void setCnFlags(BIpLonCnFlagsEnum bIpLonCnFlagsEnum) {
        this.set(cnFlags, (BValue)bIpLonCnFlagsEnum, null);
    }

    public BIpLonNodeTypeEnum getNodeType() {
        return (BIpLonNodeTypeEnum)this.get(nodeType);
    }

    public void setNodeType(BIpLonNodeTypeEnum bIpLonNodeTypeEnum) {
        this.set(nodeType, (BValue)bIpLonNodeTypeEnum, null);
    }

    public BSubnetNode getSubnetNode() {
        return (BSubnetNode)this.get(subnetNode);
    }

    public void setSubnetNode(BSubnetNode bSubnetNode) {
        this.set(subnetNode, (BValue)bSubnetNode, null);
    }

    public BLonRouteTable getSubnetMask() {
        return (BLonRouteTable)this.get(subnetMask);
    }

    public void setSubnetMask(BLonRouteTable bLonRouteTable) {
        this.set(subnetMask, (BValue)bLonRouteTable, null);
    }

    public BLonRouteTable getGroupMask() {
        return (BLonRouteTable)this.get(groupMask);
    }

    public void setGroupMask(BLonRouteTable bLonRouteTable) {
        this.set(groupMask, (BValue)bLonRouteTable, null);
    }

    public BNeuronId getNeuronId() {
        return (BNeuronId)this.get(neuronId);
    }

    public void setNeuronId(BNeuronId bNeuronId) {
        this.set(neuronId, (BValue)bNeuronId, null);
    }

    public BDomainId getDomainId() {
        return (BDomainId)this.get(domainId);
    }

    public void setDomainId(BDomainId bDomainId) {
        this.set(domainId, (BValue)bDomainId, null);
    }

    public BDateTime getConfigTimeStamp() {
        return (BDateTime)this.get(configTimeStamp);
    }

    public void setConfigTimeStamp(BDateTime bDateTime) {
        this.set(configTimeStamp, (BValue)bDateTime, null);
    }

    public BDateTime getRouteTimeStamp() {
        return (BDateTime)this.get(routeTimeStamp);
    }

    public void setRouteTimeStamp(BDateTime bDateTime) {
        this.set(routeTimeStamp, (BValue)bDateTime, null);
    }

    public int getSequence() {
        return this.getInt(sequence);
    }

    public void setSequence(int n) {
        this.setInt(sequence, n, null);
    }

    public BMemberStateEnum getIState() {
        return (BMemberStateEnum)this.get(iState);
    }

    public void setIState(BMemberStateEnum bMemberStateEnum) {
        this.set(iState, (BValue)bMemberStateEnum, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public void getStatistics() {
        this.invoke(getStatistics, null, null);
    }

    public void getStatusAux(BStatusAuxCommandEnum bStatusAuxCommandEnum) {
        this.invoke(getStatusAux, (BValue)bStatusAuxCommandEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == iState) {
            this.retryCount = 0;
            if (this.getIState() != BMemberStateEnum.Error) {
                this.setFaultCause("");
            }
        }
        BIpChannel bIpChannel = (BIpChannel)this.getParent().getParent();
        if (property == ipUcAddress || property == ipUcPort || property == routerType || property == subnetNode || property == neuronId || property == domainId) {
            bIpChannel.getAddressManager().memberChanged(context);
        }
        if (context == BMemberTable.internalChange) {
            return;
        }
        BIpLonNetworkConfig bIpLonNetworkConfig = bIpChannel.getNetworkConfig();
        if (bIpLonNetworkConfig.getIsConfigServer()) {
            ConfigServer configServer = bIpChannel.getConfigServer();
            if (property == cnName || property == ipUcAddress || property == ipUcPort) {
                configServer.updateMember(this, true);
            }
            if (property == subnetNode || property == neuronId || property == subnetMask || property == groupMask) {
                configServer.updateMember(this, false);
            }
        } else if (bIpLonNetworkConfig.isLocal(this)) {
            ChannelMonitor channelMonitor = bIpChannel.getChannelMonitor();
            boolean bl = false;
            boolean bl2 = false;
            if (property == cnName || property == ipUcAddress || property == ipUcPort || property == neuronId) {
                bl = true;
            }
            if (property == subnetNode || property == neuronId || property == subnetMask || property == groupMask) {
                bl2 = true;
            }
            channelMonitor.localDataChanged(bl, bl2);
        }
    }

    public boolean isParentLegal(BComponent bComponent) {
        if (!(bComponent instanceof BMemberTable)) {
            return false;
        }
        return super.isParentLegal(bComponent);
    }

    public String toString(Context context) {
        return this.getCnName() + ':' + (Object)((Object)this.getIpUcAddress()) + ':' + this.getIpUcPort();
    }

    public synchronized int getSequenceAndIncrement() {
        int n = this.getSequence() + 1;
        this.setSequence(n);
        return n;
    }

    public boolean storeChannelRoute(ChannelRouting channelRouting, Log log) {
        Object object;
        ChannelRouting.SubnetNodeRecord subnetNodeRecord = null;
        if (channelRouting.snRec.length == 0) {
            log.trace("ChannelRouting message has no subnet records");
            return false;
        }
        subnetNodeRecord = channelRouting.snRec[0];
        if (!this.getSubnetNode().equals((Object)subnetNodeRecord.sn)) {
            this.set(subnetNode, (BValue)subnetNodeRecord.sn, BMemberTable.internalChange);
        }
        if (channelRouting.nids.length == 0) {
            log.trace("ChannelRouting message has no neuronId records");
        } else {
            object = channelRouting.nids[subnetNodeRecord.nidNdx];
            if (!this.getNeuronId().equals(object)) {
                this.set(neuronId, (BValue)object, BMemberTable.internalChange);
            }
        }
        if (channelRouting.domRec.length == 0) {
            log.trace("ChannelRouting message has no domain records");
        } else {
            object = channelRouting.domRec[0];
            BLonRouteTable bLonRouteTable = BLonRouteTable.make((byte[])object.subnetMask);
            if (!this.getSubnetMask().equals((Object)bLonRouteTable)) {
                this.set(subnetMask, (BValue)bLonRouteTable, BMemberTable.internalChange);
            }
            BLonRouteTable bLonRouteTable2 = BLonRouteTable.make((byte[])object.groupMask);
            if (!this.getGroupMask().equals((Object)bLonRouteTable2)) {
                this.set(groupMask, (BValue)bLonRouteTable2, BMemberTable.internalChange);
            }
            if (!this.getDomainId().equals((Object)object.domainId)) {
                this.set(domainId, (BValue)object.domainId, BMemberTable.internalChange);
            }
        }
        boolean bl = this.getRouteTimeStamp().equals((Object)channelRouting.dateTime) ^ true;
        this.setRouteTimeStamp(channelRouting.dateTime);
        return bl;
    }

    public void storeDeviceConfiguration(DeviceRegistration deviceRegistration) {
        boolean bl = false;
        if (!this.getCnName().equals(deviceRegistration.name) && this.getIState().equals((Object)BMemberStateEnum.UpToDate)) {
            this.setString(cnName, deviceRegistration.name, BMemberTable.internalChange);
            bl = true;
        }
        if (!this.getIpFlags().equals((Object)deviceRegistration.ipFlags)) {
            this.set(ipFlags, (BValue)deviceRegistration.ipFlags, BMemberTable.internalChange);
            bl = true;
        }
        if (!this.getRouterType().equals((Object)deviceRegistration.routerType)) {
            this.set(routerType, (BValue)deviceRegistration.routerType, BMemberTable.internalChange);
            bl = true;
        }
        if (!this.getCnFlags().equals((Object)deviceRegistration.cnFlags)) {
            this.set(cnFlags, (BValue)deviceRegistration.cnFlags, BMemberTable.internalChange);
            bl = true;
        }
        if (!this.getNodeType().equals((Object)deviceRegistration.nodeType)) {
            this.set(nodeType, (BValue)deviceRegistration.nodeType, BMemberTable.internalChange);
            bl = true;
        }
        this.updateTime(deviceRegistration.dateTime, bl);
    }

    private final void updateTime(BDateTime bDateTime, boolean bl) {
        BDateTime bDateTime2 = this.getConfigTimeStamp();
        if (!bDateTime2.isLaterThan(bDateTime)) {
            this.setConfigTimeStamp(BDateTime.make(bDateTime.getSeconds() + 1L));
            return;
        }
        if (!bl) {
            return;
        }
        BDateTime bDateTime3 = BDateTime.make();
        if (bDateTime2.isLaterThan(bDateTime3)) {
            bDateTime3 = BDateTime.make(bDateTime2.getSeconds() + 1L);
        }
        this.setConfigTimeStamp(bDateTime3);
    }

    public void updateNat(LonIpMessage lonIpMessage) {
        if (lonIpMessage.hasExtendedNat) {
            if (this.getIpUcAddress().equals((Object)lonIpMessage.natAdr)) {
                this.setIpUcAddress(lonIpMessage.ipAdr);
            }
            this.setNatIpAddress(lonIpMessage.natAdr);
        }
    }

    public boolean hasNatIp() {
        return this.getNatIpAddress().equals((Object)BIpAddress.DEFAULT) ^ true;
    }

    public BIpAddress getNetworkIp() {
        if (this.hasNatIp()) {
            return this.getNatIpAddress();
        }
        return this.getIpUcAddress();
    }

    public BIpAddress getSegmentIp(BIpLonNetworkConfig bIpLonNetworkConfig) {
        return this.getSegmentIp(bIpLonNetworkConfig.getMyIpAddress(), bIpLonNetworkConfig.getNatIpAddress());
    }

    public BIpAddress getSegmentIp(BChannelMember bChannelMember) {
        return this.getSegmentIp(bChannelMember.getIpUcAddress(), bChannelMember.getNatIpAddress());
    }

    public BIpAddress getSegmentIp(BIpAddress bIpAddress, BIpAddress bIpAddress2) {
        BIpAddress bIpAddress3 = this.getIpUcAddress();
        BIpAddress bIpAddress4 = this.getNatIpAddress();
        if (bIpAddress.equals((Object)bIpAddress3)) {
            return this.getNetworkIp();
        }
        if (bIpAddress4.equals((Object)bIpAddress2)) {
            return bIpAddress3;
        }
        if (this.hasNatIp()) {
            return bIpAddress4;
        }
        return bIpAddress3;
    }

    public void storeLocalConfiguration(BIpLonNetworkConfig bIpLonNetworkConfig, BLonNetwork bLonNetwork) {
        boolean bl = false;
        if (!bIpLonNetworkConfig.getNatIpAddress().equals((Object)BIpAddress.DEFAULT) && !this.getNatIpAddress().equals((Object)bIpLonNetworkConfig.getNatIpAddress())) {
            this.setNatIpAddress(bIpLonNetworkConfig.getNatIpAddress());
            bl = true;
        }
        if (!this.getIpUcAddress().equals((Object)bIpLonNetworkConfig.getMyIpAddress())) {
            this.setIpUcAddress(bIpLonNetworkConfig.getMyIpAddress());
            bl = true;
        }
        if (!this.getCnName().equals(bIpLonNetworkConfig.getNetName())) {
            this.setCnName(bIpLonNetworkConfig.getNetName());
            bl = true;
        }
        if (!this.getIpFlags().equals((Object)LonIp.NIAGARA_IP_FLAG)) {
            this.setIpFlags(LonIp.NIAGARA_IP_FLAG);
            bl = true;
        }
        if (!this.getRouterType().equals((Object)LonIp.NIAGARA_ROUTER_TYPE)) {
            this.setRouterType(LonIp.NIAGARA_ROUTER_TYPE);
            bl = true;
        }
        if (!this.getCnFlags().equals((Object)LonIp.NIAGARA_FLAG)) {
            this.setCnFlags(LonIp.NIAGARA_FLAG);
            bl = true;
        }
        if (!this.getNodeType().equals((Object)LonIp.NIAGARA_NODE_TYPE)) {
            this.setNodeType(LonIp.NIAGARA_NODE_TYPE);
            bl = true;
        }
        BDeviceData bDeviceData = bLonNetwork.getLocalLonDevice().getDeviceData();
        BSubnetNode bSubnetNode = bDeviceData.getSubnetNodeId();
        if (!this.getSubnetNode().equals((Object)bSubnetNode)) {
            this.setSubnetNode(bSubnetNode);
            bl = true;
        }
        BNeuronId bNeuronId = bDeviceData.getNeuronId();
        if (!this.getNeuronId().equals((Object)bNeuronId)) {
            this.setNeuronId(bNeuronId);
            bl = true;
        }
        BDomainId bDomainId = bLonNetwork.getLonNetmgmt().getDomainId();
        if (!this.getDomainId().equals((Object)bDomainId)) {
            this.setDomainId(bDomainId);
            bl = true;
        }
        if (this.updateLocalRoutes(bLonNetwork.getLocalLonDevice(), false)) {
            bl = true;
        }
        if (bl) {
            this.setConfigTimeStamp(BDateTime.make());
        }
    }

    public boolean updateLocalRoutes(BLocalLonDevice bLocalLonDevice, boolean bl) {
        boolean bl2 = false;
        BDeviceData bDeviceData = bLocalLonDevice.getDeviceData();
        byte[] byArray = new byte[32];
        this.setFlag(0, byArray);
        this.setFlag(bDeviceData.getSubnetNodeId().getSubnetId(), byArray);
        BLonRouteTable bLonRouteTable = BLonRouteTable.make((byte[])byArray);
        if (!this.getSubnetMask().equals((Object)bLonRouteTable)) {
            this.setSubnetMask(bLonRouteTable);
            bl2 = true;
        }
        byte[] byArray2 = new byte[32];
        BAddressEntry[] bAddressEntryArray = bDeviceData.getAddressTable().getAddresses();
        int n = 0;
        while (n < bAddressEntryArray.length) {
            if (bAddressEntryArray[n].isGroupAddress()) {
                this.setFlag(bAddressEntryArray[n].getGroupOrSubnet(), byArray2);
            }
            ++n;
        }
        BLonRouteTable bLonRouteTable2 = BLonRouteTable.make((byte[])byArray2);
        if (!this.getGroupMask().equals((Object)bLonRouteTable2)) {
            this.setGroupMask(bLonRouteTable2);
            bl2 = true;
        }
        this.setRouteTimeStamp(BDateTime.make());
        return bl2;
    }

    private final void setFlag(int n, byte[] byArray) {
        int n2 = n / 8;
        int n3 = n % 8;
        int n4 = n2;
        byArray[n4] = (byte)(byArray[n4] | 1 << n3);
    }

    public void doUpdate() {
        BIpChannel bIpChannel = (BIpChannel)this.getParent().getParent();
        BIpLonNetworkConfig bIpLonNetworkConfig = bIpChannel.getNetworkConfig();
        if (bIpLonNetworkConfig.getIsConfigServer()) {
            bIpChannel.getConfigServer().doUpdateMember(this);
        } else {
            bIpChannel.getChannelMonitor().doUpdateMember(this);
        }
    }

    public void doGetStatistics() {
        MemberAction.getStatus(this, false);
    }

    public void doGetStatusAux(BStatusAuxCommandEnum bStatusAuxCommandEnum) {
        switch (bStatusAuxCommandEnum.getOrdinal()) {
            case 0: {
                MemberAction.getStatus(this, false);
                break;
            }
            case 1: {
                MemberAction.getStatus(this, true);
                break;
            }
            case 2: {
                MemberAction.getDeviceConfig(this);
                break;
            }
            case 3: {
                MemberAction.getChannelMembership(this);
                break;
            }
            case 4: {
                MemberAction.getRoute(this);
                break;
            }
        }
    }

    private final ConfigServer configServer() {
        return this.ipChannel().getConfigServer();
    }

    private final BIpChannel ipChannel() {
        return (BIpChannel)this.getParent().getParent();
    }

    public synchronized int incrementRetryCount() {
        ++this.retryCount;
        return this.retryCount;
    }

    public synchronized void error(String string) {
        this.setIState(BMemberStateEnum.Error);
        this.setFaultCause(string);
    }

    public BStatus getStatus() {
        switch (this.getIState().getOrdinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return BStatus.stale;
            }
            case 4: {
                return BStatus.ok;
            }
            case 5: {
                return BStatus.fault;
            }
        }
        return BStatus.fault;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.retryCount = 0;
    }

    public BChannelMember() {
        this.this();
    }

    public BChannelMember(InetAddress inetAddress, int n) {
        this.this();
        this.setIpUcAddress(BIpAddress.make(inetAddress));
        this.setIpUcPort(n);
    }

    static {
        Class clazz = class$com$tridium$lonIp$datatypes$BChannelMember;
        if (clazz == null) {
            clazz = class$com$tridium$lonIp$datatypes$BChannelMember = BChannelMember.class("[Lcom.tridium.lonIp.datatypes.BChannelMember;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

