/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp;

import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.messages.LonIpMessage;
import java.net.InetAddress;
import javax.baja.sys.BRelTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Statistics {
    public long TimeSinceCounterReset;
    public BDateTime TimeOfLastCounterReset;
    public long NumberOfChannelMembers;
    public long NumberOfMembersSentTo;
    public long LonPacketsRcvdFromLonChan;
    public long LonPacketsRcvdAndDiscarded;
    public long LonTotalBytesReceived;
    public long LonPacktsSentOnLonChan;
    public long LonTotalBytesSent;
    public long LonPacketsSentToIpChan;
    public long LonBytesSentToIpChan;
    public long LonPacketsFromIpChan;
    public long LonBytesFromIpChan;
    public long IPPacketsWithLonToIpChan;
    public long IPPacketsWithLonFromIp;
    public long AverageAggregateToIpChan;
    public long AverageAggregateFromIp;
    public long NumOfUDPPacketsSent;
    public long NumOfTCPPacketsSent;
    public long NumOfMcastPacketsSent;
    public long StaleIpDropped;
    public long TCPConnectionFailures;
    public long TCPHostFailures;
    public long RouterConfigMsgSent;
    public long RouterConfigMsgRcvd;
    public long ConfigurationChanges;
    public long AverageUdpPerSecSent;
    public long AverageUdpPerSecRcvd;
    public long AverageTcpPerSecSent;
    public long AverageTcpPerSecRcvd;
    public long NumOfUDPPacketsRcvd;

    public void sentMsg(LonIpMessage lonIpMessage, InetAddress inetAddress, int n) {
        ++this.NumOfUDPPacketsSent;
        if (lonIpMessage.isDataMessage()) {
            ++this.LonPacketsSentToIpChan;
            this.LonBytesSentToIpChan += (long)n;
            ++this.IPPacketsWithLonToIpChan;
        } else {
            ++this.RouterConfigMsgSent;
        }
    }

    public void receivedMsg(LonIpMessage lonIpMessage, InetAddress inetAddress, int n) {
        ++this.NumOfUDPPacketsRcvd;
        if (lonIpMessage.isDataMessage()) {
            ++this.LonPacketsFromIpChan;
            this.LonBytesFromIpChan += (long)n;
            ++this.IPPacketsWithLonFromIp;
        } else {
            ++this.RouterConfigMsgRcvd;
        }
    }

    public void updateGlobalStats(BIpChannel bIpChannel) {
        this.NumberOfChannelMembers = bIpChannel.getMemberTable().getChannelMembers().length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TimeSinceCounterReset").append(',').append(BRelTime.toString((long)(this.TimeSinceCounterReset * 1000L)));
        stringBuffer.append(",TimeOfLastCounterReset").append(',').append(this.TimeOfLastCounterReset.toString());
        if (this.NumberOfChannelMembers != (long)-1) {
            stringBuffer.append(",NumberOfChannelMembers").append(',').append(String.valueOf(this.NumberOfChannelMembers));
        }
        if (this.NumberOfMembersSentTo != (long)-1) {
            stringBuffer.append(",NumberOfMembersSentTo").append(',').append(String.valueOf(this.NumberOfMembersSentTo));
        }
        if (this.LonPacketsRcvdFromLonChan != (long)-1) {
            stringBuffer.append(",LonPacketsRcvdFromLonChan").append(',').append(String.valueOf(this.LonPacketsRcvdFromLonChan));
        }
        if (this.LonPacketsRcvdAndDiscarded != (long)-1) {
            stringBuffer.append(",LonPacketsRcvdAndDiscarded").append(',').append(String.valueOf(this.LonPacketsRcvdAndDiscarded));
        }
        if (this.LonTotalBytesReceived != (long)-1) {
            stringBuffer.append(",LonTotalBytesReceived").append(',').append(String.valueOf(this.LonTotalBytesReceived));
        }
        if (this.LonPacktsSentOnLonChan != (long)-1) {
            stringBuffer.append(",LonPacktsSentOnLonChan").append(',').append(String.valueOf(this.LonPacktsSentOnLonChan));
        }
        if (this.LonTotalBytesSent != (long)-1) {
            stringBuffer.append(",LonTotalBytesSent").append(',').append(String.valueOf(this.LonTotalBytesSent));
        }
        if (this.LonPacketsSentToIpChan != (long)-1) {
            stringBuffer.append(",LonPacketsSentToIpChan").append(',').append(String.valueOf(this.LonPacketsSentToIpChan));
        }
        if (this.LonBytesSentToIpChan != (long)-1) {
            stringBuffer.append(",LonBytesSentToIpChan").append(',').append(String.valueOf(this.LonBytesSentToIpChan));
        }
        if (this.LonPacketsFromIpChan != (long)-1) {
            stringBuffer.append(",LonPacketsFromIpChan").append(',').append(String.valueOf(this.LonPacketsFromIpChan));
        }
        if (this.LonBytesFromIpChan != (long)-1) {
            stringBuffer.append(",LonBytesFromIpChan").append(',').append(String.valueOf(this.LonBytesFromIpChan));
        }
        if (this.IPPacketsWithLonToIpChan != (long)-1) {
            stringBuffer.append(",IPPacketsWithLonToIpChan").append(',').append(String.valueOf(this.IPPacketsWithLonToIpChan));
        }
        if (this.IPPacketsWithLonFromIp != (long)-1) {
            stringBuffer.append(",IPPacketsWithLonFromIp").append(',').append(String.valueOf(this.IPPacketsWithLonFromIp));
        }
        if (this.AverageAggregateToIpChan != (long)-1) {
            stringBuffer.append(",AverageAggregateToIpChan").append(',').append(String.valueOf(this.AverageAggregateToIpChan));
        }
        if (this.AverageAggregateFromIp != (long)-1) {
            stringBuffer.append(",AverageAggregateFromIp").append(',').append(String.valueOf(this.AverageAggregateFromIp));
        }
        if (this.NumOfUDPPacketsSent != (long)-1) {
            stringBuffer.append(",NumOfUDPPacketsSent").append(',').append(String.valueOf(this.NumOfUDPPacketsSent));
        }
        if (this.NumOfTCPPacketsSent != (long)-1) {
            stringBuffer.append(",NumOfTCPPacketsSent").append(',').append(String.valueOf(this.NumOfTCPPacketsSent));
        }
        if (this.NumOfMcastPacketsSent != (long)-1) {
            stringBuffer.append(",NumOfMcastPacketsSent").append(',').append(String.valueOf(this.NumOfMcastPacketsSent));
        }
        if (this.StaleIpDropped != (long)-1) {
            stringBuffer.append(",StaleIpDropped").append(',').append(String.valueOf(this.StaleIpDropped));
        }
        if (this.TCPConnectionFailures != (long)-1) {
            stringBuffer.append(",TCPConnectionFailures").append(',').append(String.valueOf(this.TCPConnectionFailures));
        }
        if (this.TCPHostFailures != (long)-1) {
            stringBuffer.append(",TCPHostFailures").append(',').append(String.valueOf(this.TCPHostFailures));
        }
        if (this.RouterConfigMsgSent != (long)-1) {
            stringBuffer.append(",RouterConfigMsgSent").append(',').append(String.valueOf(this.RouterConfigMsgSent));
        }
        if (this.RouterConfigMsgRcvd != (long)-1) {
            stringBuffer.append(",RouterConfigMsgRcvd").append(',').append(String.valueOf(this.RouterConfigMsgRcvd));
        }
        if (this.ConfigurationChanges != (long)-1) {
            stringBuffer.append(",ConfigurationChanges").append(',').append(String.valueOf(this.ConfigurationChanges));
        }
        if (this.AverageUdpPerSecSent != (long)-1) {
            stringBuffer.append(",AverageUdpPerSecSent").append(',').append(String.valueOf(this.AverageUdpPerSecSent));
        }
        if (this.AverageUdpPerSecRcvd != (long)-1) {
            stringBuffer.append(",AverageUdpPerSecRcvd").append(',').append(String.valueOf(this.AverageUdpPerSecRcvd));
        }
        if (this.AverageTcpPerSecSent != (long)-1) {
            stringBuffer.append(",AverageTcpPerSecSent").append(',').append(String.valueOf(this.AverageTcpPerSecSent));
        }
        if (this.AverageTcpPerSecRcvd != (long)-1) {
            stringBuffer.append(",AverageTcpPerSecRcvd").append(',').append(String.valueOf(this.AverageTcpPerSecRcvd));
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.TimeSinceCounterReset = -1;
        this.TimeOfLastCounterReset = BDateTime.make();
        this.NumberOfChannelMembers = -1;
        this.NumberOfMembersSentTo = -1;
        this.LonPacketsRcvdFromLonChan = -1;
        this.LonPacketsRcvdAndDiscarded = -1;
        this.LonTotalBytesReceived = -1;
        this.LonPacktsSentOnLonChan = -1;
        this.LonTotalBytesSent = -1;
        this.LonPacketsSentToIpChan = 0L;
        this.LonBytesSentToIpChan = 0L;
        this.LonPacketsFromIpChan = 0L;
        this.LonBytesFromIpChan = 0L;
        this.IPPacketsWithLonToIpChan = 0L;
        this.IPPacketsWithLonFromIp = -1;
        this.AverageAggregateToIpChan = -1;
        this.AverageAggregateFromIp = -1;
        this.NumOfUDPPacketsSent = 0L;
        this.NumOfTCPPacketsSent = -1;
        this.NumOfMcastPacketsSent = -1;
        this.StaleIpDropped = -1;
        this.TCPConnectionFailures = -1;
        this.TCPHostFailures = -1;
        this.RouterConfigMsgSent = 0L;
        this.RouterConfigMsgRcvd = 0L;
        this.ConfigurationChanges = -1;
        this.AverageUdpPerSecSent = -1;
        this.AverageUdpPerSecRcvd = -1;
        this.AverageTcpPerSecSent = -1;
        this.AverageTcpPerSecRcvd = -1;
        this.NumOfUDPPacketsRcvd = 0L;
    }

    public Statistics() {
        this.this();
    }
}

