/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp;

import com.tridium.lonIp.link.LonIpLinkLayer;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryStatusResponse;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.enums.BLonNodeState;

public class NetMangementListener
implements NetMessages {
    private BLonNetwork lonworks;
    private LonComm lonComm;
    private BLocalLonDevice local;
    private LonIpLinkLayer link;

    public boolean receiveLonMessage(NAppBuffer nAppBuffer) {
        switch (nAppBuffer.getMessageCode()) {
            case 81: {
                this.respondToQueryStatus(nAppBuffer);
                return true;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 108: {
                this.sendSuccessResponse(nAppBuffer);
                return true;
            }
            case 82: 
            case 83: 
            case 84: 
            case 97: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 125: {
                this.sendFailedResponse(nAppBuffer);
                return true;
            }
        }
        return false;
    }

    private final void respondToQueryStatus(NAppBuffer nAppBuffer) {
        QueryStatusResponse queryStatusResponse = new QueryStatusResponse();
        queryStatusResponse.nodeState = this.getNodeState(this.local.getDeviceData().getNodeState());
        this.link.sendResponse(nAppBuffer, (LonMessage)queryStatusResponse);
    }

    private final int getNodeState(BLonNodeState bLonNodeState) {
        switch (bLonNodeState.getOrdinal()) {
            case 0: 
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 6;
            }
        }
        return 0;
    }

    private final void sendSuccessResponse(NAppBuffer nAppBuffer) {
        LonMessage lonMessage = new LonMessage();
        lonMessage.setMessageCode(nAppBuffer.getMessageCode() - 64);
        this.link.sendResponse(nAppBuffer, lonMessage);
    }

    private final void sendFailedResponse(NAppBuffer nAppBuffer) {
        LonMessage lonMessage = new LonMessage();
        lonMessage.setMessageCode(nAppBuffer.getMessageCode() - 96);
        this.link.sendResponse(nAppBuffer, lonMessage);
    }

    public NetMangementListener(LonIpLinkLayer lonIpLinkLayer, LonComm lonComm, BLonNetwork bLonNetwork) {
        this.lonComm = lonComm;
        this.lonworks = bLonNetwork;
        this.link = lonIpLinkLayer;
        this.local = bLonNetwork.getLocalLonDevice();
    }
}

