/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp;

import com.tridium.lonIp.Statistics;
import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonIp.enums.BMemberStateEnum;
import com.tridium.lonIp.link.LonIpLinkLayer;
import com.tridium.lonIp.messages.Acknowledge;
import com.tridium.lonIp.messages.ChannelMembership;
import com.tridium.lonIp.messages.ChannelRouting;
import com.tridium.lonIp.messages.DeviceRegistration;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonIp.messages.RequestMessage;
import com.tridium.lonIp.messages.SendList;
import com.tridium.lonIp.messages.StatisticsResp;
import com.tridium.lonworks.util.NmUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import javax.baja.log.Log;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConfigServer
implements Runnable,
LonIp {
    private boolean isConfigServer;
    private boolean useExtendedNat;
    private BDateTime sendlistDt;
    private BDateTime chanMembershipDt;
    private boolean newTime;
    private BLonNetwork lonworks;
    private LonIpLinkLayer link;
    private BIpChannel ipChan;
    private BIpLonNetworkConfig netCfg;
    private BMemberTable memTab;
    private Thread rcvThread;
    private Thread srvThread;
    private boolean enabled;
    private Log log;
    private DatagramSocket udpPort;
    private Statistics stats;

    public void start() throws Exception {
        this.updateListTime(true);
        this.newTime = false;
        this.isConfigServer = this.netCfg.getIsConfigServer();
        this.useExtendedNat = this.netCfg.getUseExtendedNat();
        if (!this.isConfigServer) {
            return;
        }
        InetAddress inetAddress = this.netCfg.getMyIpAddress().getInetAddress();
        this.udpPort = new DatagramSocket(this.netCfg.getConfigServerPort(), inetAddress);
        if (this.udpPort == null) {
            String string = "DatagramSocket is null!  Socket " + this.netCfg.getConfigServerPort() + " may be in use by another process.";
            this.log.error(string);
            throw new LonException(string);
        }
        this.enabled = true;
        this.rcvThread = new Thread((Runnable)this, this.lonworks.getLogName() + ".LonIpConfigSvrRcv");
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        this.srvThread = new Thread((Runnable)new ConfigService(), this.lonworks.getLogName() + ".LonIpConfigSvr");
        this.srvThread.start();
        this.srvThread.setPriority(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateListTime(boolean bl) {
        this.chanMembershipDt = BDateTime.make();
        if (bl) {
            this.sendlistDt = this.chanMembershipDt;
        }
        this.memTab.setTimeStamp(this.chanMembershipDt);
        ConfigServer configServer = this;
        synchronized (configServer) {
            this.newTime = true;
            return;
        }
    }

    public void stop() {
        this.enabled = false;
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
        }
        if (this.srvThread != null) {
            this.srvThread.interrupt();
        }
        if (this.udpPort != null) {
            this.udpPort.close();
        }
    }

    public void run() {
        block7: while (this.enabled) {
            byte[] byArray = new byte[1600];
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, 1600);
                try {
                    this.udpPort.receive(datagramPacket);
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                if (this.log.isTraceOn()) {
                    this.link.writeLinkDebug("CS Rcvd:" + datagramPacket.getAddress() + ':' + datagramPacket.getPort() + "  ", byArray, datagramPacket.getLength());
                }
                int n = datagramPacket.getLength();
                int n2 = 0;
                byte[] byArray2 = byArray;
                while (n2 < n) {
                    LonIpMessage lonIpMessage = LonIpMessage.make(byArray2);
                    lonIpMessage.setSrcAddress(datagramPacket.getAddress());
                    lonIpMessage.setSrcPort(datagramPacket.getPort());
                    this.processIpMessage(lonIpMessage);
                    this.stats.receivedMsg(lonIpMessage, lonIpMessage.getSrcAddress(), lonIpMessage.packetLength);
                    if ((n2 += lonIpMessage.packetLength) >= n) continue;
                    int n3 = ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
                    if (n3 + n2 > n) continue block7;
                    byArray2 = new byte[n3];
                    System.arraycopy(byArray, n2, byArray2, 0, n3);
                }
            }
            catch (SocketException socketException) {
                if (!this.enabled) continue;
                this.log.error("SocketException in ConfigServer!", (Throwable)socketException);
            }
            catch (IOException iOException) {
                this.log.error("Error receiving LonIp packet!", (Throwable)iOException);
            }
            catch (ThreadDeath threadDeath) {
                this.enabled = false;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.log.error("LonIpConfigSvr error", throwable);
            }
        }
    }

    private final void processIpMessage(LonIpMessage lonIpMessage) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        switch (lonIpMessage.packetType) {
            case 3: 
            case 113: {
                this.rcvDeviceRegistration((DeviceRegistration)lonIpMessage);
                break;
            }
            case 8: {
                this.rcvChannelRouting((ChannelRouting)lonIpMessage);
                break;
            }
            case 7: {
                this.rcvAcknowledge((Acknowledge)lonIpMessage);
                break;
            }
            case 100: {
                this.rcvChannelMembershipRequest((RequestMessage)lonIpMessage);
                break;
            }
            case 102: {
                this.rcvSendListRequest((RequestMessage)lonIpMessage);
                break;
            }
            case 104: {
                this.rcvChannelRoutingRequest((RequestMessage)lonIpMessage);
                break;
            }
            case 96: {
                this.rcvStatusRequest((RequestMessage)lonIpMessage);
                break;
            }
            case 4: 
            case 6: 
            case 99: 
            case 112: {
                this.sendAck(lonIpMessage, 5);
                break;
            }
            default: {
                if (!this.log.isTraceOn()) break;
                this.log.trace("cs Packet type not implemented:" + Integer.toString(lonIpMessage.packetType, 16));
            }
        }
    }

    public void networkConfigChanged(Context context) {
        if (!this.lonworks.isRunning()) {
            return;
        }
        boolean bl = this.isConfigServer;
        this.isConfigServer = this.netCfg.getIsConfigServer();
        this.useExtendedNat = this.netCfg.getUseExtendedNat();
        if (this.isConfigServer && !bl) {
            if (this.log.isTraceOn()) {
                this.log.trace("cs enabled");
            }
            try {
                this.start();
            }
            catch (Throwable throwable) {
                this.lonworks.configFail(throwable.toString());
            }
        } else if (!this.isConfigServer && bl) {
            this.stop();
        }
    }

    public void addMember(BChannelMember bChannelMember) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("cs add member " + bChannelMember.getCnName());
        }
        this.updateListTime(true);
        if (this.netCfg.isLocal(bChannelMember)) {
            bChannelMember.storeLocalConfiguration(this.netCfg, this.lonworks);
            bChannelMember.setIState(BMemberStateEnum.UpToDate);
        } else {
            if (this.log.isTraceOn()) {
                this.log.trace("cs new member " + bChannelMember.getCnName() + ": send DEVICE_CONFIGURATION_REQUEST ");
            }
            RequestMessage requestMessage = new RequestMessage(99);
            this.send(requestMessage, bChannelMember.getSegmentIp(this.netCfg).getInetAddress(), bChannelMember.getIpUcPort(), bChannelMember.getSequence());
        }
    }

    public void removeMember(BChannelMember bChannelMember) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("cs remove member " + bChannelMember.getCnName());
        }
        this.updateListTime(true);
    }

    public void updateMember(BChannelMember bChannelMember, boolean bl) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("cs update member " + bChannelMember.getCnName());
        }
        this.updateListTime(bl);
    }

    public void routeChanged(BChannelMember bChannelMember) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("cs routeChanged on " + bChannelMember.getCnName());
        }
        this.updateListTime(false);
    }

    public void doUpdateMember(BChannelMember bChannelMember) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("cs doUpdate member " + bChannelMember.getCnName());
        }
        BDateTime bDateTime = BDateTime.make();
        if (bChannelMember.getConfigTimeStamp().isLaterThan(bDateTime)) {
            bDateTime = BDateTime.make(bChannelMember.getConfigTimeStamp().getSeconds() + 1L);
        }
        bChannelMember.setConfigTimeStamp(bDateTime);
        bChannelMember.setIState(BMemberStateEnum.SentDR);
        this.sendDeviceConfig(bChannelMember);
    }

    private final void updateLocal() {
        BChannelMember bChannelMember = this.ipChan.getLocalMember();
        if (bChannelMember == null) {
            bChannelMember = new BChannelMember();
            bChannelMember.storeLocalConfiguration(this.netCfg, this.lonworks);
            bChannelMember.setIState(BMemberStateEnum.UpToDate);
            this.memTab.addMember(bChannelMember, BMemberTable.internalChange);
        }
        if (bChannelMember.getIState() != BMemberStateEnum.UpToDate) {
            bChannelMember.storeLocalConfiguration(this.netCfg, this.lonworks);
            bChannelMember.setIState(BMemberStateEnum.UpToDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void configDevices() {
        BChannelMember[] bChannelMemberArray = this.memTab.getChannelMembers();
        int n = 0;
        while (n < bChannelMemberArray.length) {
            BChannelMember bChannelMember = bChannelMemberArray[n];
            if (!this.netCfg.isLocal(bChannelMember)) {
                BChannelMember bChannelMember2 = bChannelMember;
                synchronized (bChannelMember2) {
                    bChannelMember.setIState(BMemberStateEnum.SentDRReq);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.sendDeviceConfigReq(bChannelMember);
                }
                NmUtil.wait((int)50);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void updateDevices() {
        BChannelMember[] bChannelMemberArray = this.memTab.getChannelMembers();
        if (this.log.isTraceOn()) {
            this.log.trace("cs updateDevices");
        }
        int n = 0;
        while (n < bChannelMemberArray.length) {
            BChannelMember bChannelMember = bChannelMemberArray[n];
            if (!this.netCfg.isLocal(bChannelMember)) {
                BChannelMember bChannelMember2 = bChannelMember;
                synchronized (bChannelMember2) {
                    bChannelMember.setIState(BMemberStateEnum.SentDR);
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 6, 8] lbl12 : MonitorExitStatement: MONITOREXIT : var4_5
                    this.sendDeviceConfig(bChannelMember);
                }
                NmUtil.wait((int)50);
            }
            ++n;
        }
        ConfigServer configServer = this;
        synchronized (configServer) {
            this.newTime = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void scanDevices() {
        BChannelMember[] bChannelMemberArray = this.memTab.getChannelMembers();
        if (this.log.isTraceOn()) {
            this.log.trace(".");
        }
        int n = 0;
        while (n < bChannelMemberArray.length) {
            BChannelMember bChannelMember = bChannelMemberArray[n];
            if (!this.netCfg.isLocal(bChannelMember)) {
                BMemberStateEnum bMemberStateEnum;
                BChannelMember bChannelMember2 = bChannelMember;
                synchronized (bChannelMember2) {
                    bMemberStateEnum = bChannelMember.getIState();
                }
                switch (bMemberStateEnum.getOrdinal()) {
                    case 0: 
                    case 1: {
                        this.sendDeviceConfigReq(bChannelMember);
                        NmUtil.wait((int)50);
                        break;
                    }
                    case 2: {
                        this.sendDeviceConfig(bChannelMember);
                        NmUtil.wait((int)50);
                        break;
                    }
                    case 3: {
                        this.sendChannelRouteReq(bChannelMember);
                        NmUtil.wait((int)50);
                        break;
                    }
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void rcvDeviceRegistration(DeviceRegistration deviceRegistration) {
        DeviceRegistration deviceRegistration2;
        BChannelMember bChannelMember = this.findChannelMember(deviceRegistration);
        if (bChannelMember == null) {
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("cs rcvDeviceRegistration from " + bChannelMember.getCnName() + '\n' + deviceRegistration.toString());
        }
        bChannelMember.storeDeviceConfiguration(deviceRegistration);
        BChannelMember bChannelMember2 = bChannelMember;
        synchronized (bChannelMember2) {
            bChannelMember.setIState(BMemberStateEnum.SentDR);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
            deviceRegistration2 = this.createDeviceRegistration(bChannelMember);
        }
        if (this.log.isTraceOn()) {
            this.log.trace("cs send DEVICE_CONFIGURATION to " + bChannelMember.getCnName() + '\n' + deviceRegistration2.toString());
        }
        this.sendResponse(deviceRegistration2, deviceRegistration);
    }

    private final DeviceRegistration createDeviceRegistration(BChannelMember bChannelMember) {
        DeviceRegistration deviceRegistration = new DeviceRegistration(113);
        deviceRegistration.dateTime = bChannelMember.getConfigTimeStamp();
        deviceRegistration.ipFlags = bChannelMember.getIpFlags();
        deviceRegistration.routerType = bChannelMember.getRouterType();
        deviceRegistration.cnFlags = bChannelMember.getCnFlags();
        deviceRegistration.nodeType = bChannelMember.getNodeType();
        deviceRegistration.ucIpPort = bChannelMember.getIpUcPort();
        deviceRegistration.ucIpAdr = bChannelMember.getSegmentIp(this.netCfg);
        deviceRegistration.chanMembershipDt = this.chanMembershipDt;
        deviceRegistration.sendlistDt = this.sendlistDt;
        deviceRegistration.configServerIp = this.netCfg.getSegmentConfigServerIp(bChannelMember);
        deviceRegistration.configServerPort = this.udpPort.getLocalPort();
        deviceRegistration.mcIps = new BIpAddress[0];
        deviceRegistration.mcPorts = new int[0];
        deviceRegistration.id = bChannelMember.getNeuronId().getByteArray();
        deviceRegistration.name = bChannelMember.getCnName();
        return deviceRegistration;
    }

    private final void sendDeviceConfigReq(BChannelMember bChannelMember) {
        if (bChannelMember.incrementRetryCount() > 5) {
            bChannelMember.error("Device will not respond to DEVICE_CONFIGURATION_REQUEST ");
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("cs send DEVICE_CONFIGURATION_REQUEST to " + bChannelMember.getCnName());
        }
        RequestMessage requestMessage = new RequestMessage(99);
        this.send(requestMessage, bChannelMember.getSegmentIp(this.netCfg).getInetAddress(), bChannelMember.getIpUcPort(), bChannelMember.getSequence());
    }

    private final void sendDeviceConfig(BChannelMember bChannelMember) {
        if (bChannelMember.incrementRetryCount() > 5) {
            bChannelMember.error("Device will not ack DEVICE_CONFIGURATION ");
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("cs send DEVICE_CONFIGURATION to " + bChannelMember.getCnName());
        }
        DeviceRegistration deviceRegistration = this.createDeviceRegistration(bChannelMember);
        this.send(deviceRegistration, bChannelMember.getSegmentIp(this.netCfg).getInetAddress(), bChannelMember.getIpUcPort(), bChannelMember.getSequence());
    }

    BChannelMember findChannelMember(LonIpMessage lonIpMessage) {
        return this.memTab.findEntry(BIpAddress.make(lonIpMessage.getSrcAddress()), lonIpMessage.getSrcPort());
    }

    BChannelMember findChannelMember(BIpAddress bIpAddress, int n) {
        return this.memTab.findEntry(bIpAddress, n);
    }

    private final void rcvChannelMembershipRequest(RequestMessage requestMessage) {
        BChannelMember bChannelMember;
        String string = this.getName(requestMessage.getSrcAddress(), requestMessage.getSrcPort());
        if (this.log.isTraceOn()) {
            this.log.trace("cs rcvChannelMembershipRequest from " + string);
        }
        if ((bChannelMember = this.findChannelMember(requestMessage)) == null) {
            this.sendAck(requestMessage, 4);
            return;
        }
        ChannelMembership channelMembership = this.createChannelMembership(bChannelMember);
        if (this.log.isTraceOn()) {
            this.log.trace("cs send CHANNEL_MEMBERSHIP to " + string + '\n' + channelMembership.toString());
        }
        this.sendResponse(channelMembership, requestMessage);
    }

    private final ChannelMembership createChannelMembership(BChannelMember bChannelMember) {
        ChannelMembership channelMembership = new ChannelMembership();
        channelMembership.dateTime = this.chanMembershipDt;
        channelMembership.sendlistDt = this.sendlistDt;
        BChannelMember[] bChannelMemberArray = this.memTab.getChannelMembers();
        channelMembership.ips = new BIpAddress[bChannelMemberArray.length];
        channelMembership.ports = new int[bChannelMemberArray.length];
        channelMembership.chanRouteTime = new BDateTime[bChannelMemberArray.length];
        int n = 0;
        while (n < bChannelMemberArray.length) {
            channelMembership.ips[n] = bChannelMemberArray[n].getSegmentIp(bChannelMember);
            channelMembership.ports[n] = bChannelMemberArray[n].getIpUcPort();
            channelMembership.chanRouteTime[n] = bChannelMemberArray[n].getRouteTimeStamp();
            ++n;
        }
        return channelMembership;
    }

    private final void rcvSendListRequest(RequestMessage requestMessage) {
        BChannelMember bChannelMember;
        if (this.log.isTraceOn()) {
            this.log.trace("cs rcvSendListRequest from " + this.getName(requestMessage.getSrcAddress(), requestMessage.getSrcPort()));
        }
        if ((bChannelMember = this.findChannelMember(requestMessage)) == null) {
            this.sendAck(requestMessage, 4);
            return;
        }
        SendList sendList = this.createSendList(bChannelMember);
        if (this.log.isTraceOn()) {
            this.log.trace("cs send SEND_LIST\n" + sendList.toString());
        }
        this.sendResponse(sendList, requestMessage);
    }

    private final SendList createSendList(BChannelMember bChannelMember) {
        SendList sendList = new SendList();
        sendList.dateTime = this.sendlistDt;
        BChannelMember[] bChannelMemberArray = this.memTab.getChannelMembers();
        sendList.ips = new BIpAddress[bChannelMemberArray.length];
        sendList.ports = new int[bChannelMemberArray.length];
        int n = 0;
        while (n < bChannelMemberArray.length) {
            sendList.ips[n] = bChannelMemberArray[n].getSegmentIp(bChannelMember);
            sendList.ports[n] = bChannelMemberArray[n].getIpUcPort();
            ++n;
        }
        return sendList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void rcvChannelRouting(ChannelRouting channelRouting) {
        BChannelMember bChannelMember = this.findChannelMember(channelRouting.ucIpAdr, channelRouting.ucIpPort);
        if (bChannelMember == null) {
            this.log.warning("cs received ChannelRouting msg for unknown ip " + (Object)((Object)channelRouting.ucIpAdr));
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("cs rcvChannelRouting from " + bChannelMember.getCnName() + '\n' + channelRouting);
        }
        if (bChannelMember.storeChannelRoute(channelRouting, this.log)) {
            this.routeChanged(bChannelMember);
        }
        boolean bl = true;
        BChannelMember bChannelMember2 = bChannelMember;
        synchronized (bChannelMember2) {
            if (bChannelMember.getIState() == BMemberStateEnum.SentCRReq) {
                bl = false;
            }
            bChannelMember.setIState(BMemberStateEnum.UpToDate);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl16 : MonitorExitStatement: MONITOREXIT : var4_4
            if (bl) {
                this.sendAck(channelRouting, 0);
            }
            return;
        }
    }

    private final void rcvChannelRoutingRequest(RequestMessage requestMessage) {
        BIpAddress bIpAddress = requestMessage.ipAddress;
        int n = requestMessage.ipUcPort;
        BChannelMember bChannelMember = this.findChannelMember(requestMessage);
        if (bChannelMember == null) {
            this.sendAck(requestMessage, 4);
            return;
        }
        if (bIpAddress.equals((Object)BIpAddress.DEFAULT)) {
            this.sendAck(requestMessage, 5);
            return;
        }
        BChannelMember bChannelMember2 = this.memTab.findSegmentMember(bIpAddress, n, bChannelMember);
        if (this.log.isTraceOn()) {
            this.log.trace("cs rcvChannelRoutingRequest for " + bChannelMember2.getCnName() + " from " + bChannelMember.getCnName());
        }
        ChannelRouting channelRouting = this.createChannelRouting(bChannelMember2, bChannelMember);
        if (this.log.isTraceOn()) {
            this.log.trace("cs send CHANNEL_ROUTING to " + bChannelMember.getCnName() + '\n' + channelRouting.toString());
        }
        this.sendResponse(channelRouting, requestMessage);
    }

    private final ChannelRouting createChannelRouting(BChannelMember bChannelMember, BChannelMember bChannelMember2) {
        ChannelRouting channelRouting = new ChannelRouting();
        channelRouting.dateTime = bChannelMember.getRouteTimeStamp();
        channelRouting.ucIpPort = bChannelMember.getIpUcPort();
        channelRouting.ucIpAdr = bChannelMember.getSegmentIp(bChannelMember2);
        channelRouting.nids = new BNeuronId[]{bChannelMember.getNeuronId()};
        channelRouting.ipFlags = bChannelMember.getIpFlags();
        channelRouting.routerType = bChannelMember.getRouterType();
        channelRouting.cnFlags = bChannelMember.getCnFlags();
        channelRouting.nodeType = bChannelMember.getNodeType();
        ChannelRouting.SubnetNodeRecord subnetNodeRecord = new ChannelRouting.SubnetNodeRecord();
        subnetNodeRecord.sn = bChannelMember.getSubnetNode();
        subnetNodeRecord.domainNdx = 0;
        subnetNodeRecord.nidNdx = 0;
        channelRouting.snRec = new ChannelRouting.SubnetNodeRecord[]{subnetNodeRecord};
        ChannelRouting.DomainRecord domainRecord = new ChannelRouting.DomainRecord();
        domainRecord.domainId = this.lonworks.getLonNetmgmt().getDomainId();
        domainRecord.subnetMask = bChannelMember.getSubnetMask().getByteArrayCopy();
        domainRecord.groupMask = bChannelMember.getGroupMask().getByteArrayCopy();
        channelRouting.domRec = new ChannelRouting.DomainRecord[]{domainRecord};
        return channelRouting;
    }

    private final void sendChannelRouteReq(BChannelMember bChannelMember) {
        if (bChannelMember.incrementRetryCount() > 5) {
            bChannelMember.error("Device will not respond to CHANNEL_ROUTING_REQUEST ");
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("cs send CHANNEL_ROUTING_REQUEST to " + bChannelMember.getCnName());
        }
        RequestMessage requestMessage = new RequestMessage(104);
        requestMessage.ipAddress = bChannelMember.getSegmentIp(this.netCfg);
        this.send(requestMessage, bChannelMember);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void rcvAcknowledge(Acknowledge acknowledge) {
        BChannelMember bChannelMember = this.findChannelMember(acknowledge);
        if (bChannelMember == null) {
            return;
        }
        boolean bl = false;
        BChannelMember bChannelMember2 = bChannelMember;
        synchronized (bChannelMember2) {
            if (bChannelMember.getIState() == BMemberStateEnum.SentDR) {
                bChannelMember.setIState(BMemberStateEnum.SentCRReq);
                bl = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
            if (bl) {
                this.sendChannelRouteReq(bChannelMember);
            }
            return;
        }
    }

    private final void sendAck(LonIpMessage lonIpMessage, int n) {
        Acknowledge acknowledge = new Acknowledge();
        acknowledge.dateTime = BDateTime.make();
        acknowledge.ackType = n;
        if (lonIpMessage instanceof RequestMessage) {
            acknowledge.requestId = ((RequestMessage)lonIpMessage).requestId;
        }
        this.send(acknowledge, lonIpMessage.getSrcAddress(), lonIpMessage.getSrcPort(), lonIpMessage.sequenceNumber);
    }

    private final void rcvStatusRequest(RequestMessage requestMessage) {
        if (this.log.isTraceOn()) {
            this.log.trace("cs rcvStatusRequest : " + this.getName(requestMessage.getSrcAddress(), requestMessage.getSrcPort()));
        }
        this.stats.updateGlobalStats(this.ipChan);
        StatisticsResp statisticsResp = new StatisticsResp(this.stats);
        if (requestMessage.clear) {
            this.stats = new Statistics();
        }
        this.sendResponse(statisticsResp, requestMessage);
    }

    private final void sendResponse(LonIpMessage lonIpMessage, LonIpMessage lonIpMessage2) {
        this.send(lonIpMessage, lonIpMessage2.getSrcAddress(), lonIpMessage2.getSrcPort(), lonIpMessage2.sequenceNumber);
    }

    private final void send(LonIpMessage lonIpMessage, BChannelMember bChannelMember) {
        this.send(lonIpMessage, bChannelMember.getSegmentIp(this.netCfg).getInetAddress(), bChannelMember.getIpUcPort(), bChannelMember.getSequence());
    }

    private final void send(LonIpMessage lonIpMessage, InetAddress inetAddress, int n, int n2) {
        if (this.useExtendedNat) {
            lonIpMessage.addExtendedNat(this.netCfg, true);
        }
        lonIpMessage.sequenceNumber = n2;
        byte[] byArray = lonIpMessage.toNetworkBytes();
        if (this.log.isTraceOn()) {
            System.out.println();
            this.link.writeLinkDebug("CS Send " + inetAddress + ':' + n + ':', byArray, byArray.length);
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        try {
            this.udpPort.send(datagramPacket);
            this.stats.sentMsg(lonIpMessage, inetAddress, byArray.length);
        }
        catch (Exception exception) {
            this.log.warning("Can not send to " + inetAddress + ':' + n);
        }
    }

    private final String getName(InetAddress inetAddress, int n) {
        BChannelMember bChannelMember = this.findChannelMember(BIpAddress.make(inetAddress), n);
        return bChannelMember != null ? bChannelMember.getCnName() : inetAddress.toString();
    }

    private final /* synthetic */ void this() {
        this.isConfigServer = false;
        this.useExtendedNat = false;
        this.sendlistDt = BDateTime.DEFAULT;
        this.chanMembershipDt = BDateTime.DEFAULT;
        this.newTime = false;
        this.rcvThread = null;
        this.srvThread = null;
        this.enabled = false;
        this.log = null;
    }

    public ConfigServer(BLonNetwork bLonNetwork, LonIpLinkLayer lonIpLinkLayer) {
        this.this();
        this.lonworks = bLonNetwork;
        this.link = lonIpLinkLayer;
        this.ipChan = (BIpChannel)bLonNetwork.get("ipChannel");
        this.netCfg = this.ipChan.getNetworkConfig();
        this.memTab = this.ipChan.getMemberTable();
        this.log = Log.getLog((String)(bLonNetwork.getLogName() + ".configServer"));
        this.ipChan.registerConfigServer(this);
        this.stats = new Statistics();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ConfigService
    implements Runnable {
        public void run() {
            ConfigServer.this.updateLocal();
            ConfigServer.this.configDevices();
            while (ConfigServer.this.enabled) {
                if (ConfigServer.this.newTime) {
                    ConfigServer.this.updateDevices();
                } else {
                    ConfigServer.this.scanDevices();
                }
                NmUtil.wait((int)1000);
            }
        }

        private ConfigService() {
        }
    }
}

