/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import org.apache.oro.text.perl.Perl5Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class HtmlTokenizer {
    private static final int TEXT = 0;
    private static final int COMMENT = 1;
    private static final int END_TAG = 2;
    private static final int START_TAG = 3;
    private static final int NAME = 0;
    private static final int BEFORE_EQUALS = 1;
    private static final int EQUALS = 2;
    private static final int AFTER_EQUALS = 3;
    private static final int QUOTED_VALUE = 4;
    private static final int UNQUOTED_VALUE = 5;
    private static final String DOCTYPE = "!DOCTYPE";
    private static Map validTags = new HashMap();
    static Literal[] literals;
    static Perl5Util perl;
    static String literalPattern;
    static Map literalMap;
    private Array text;
    private String source;
    private int offset;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$lang$String;

    public abstract void handleText(String var1);

    public abstract void handleComment(String var1);

    public abstract void handleStartTag(int var1, String var2, Map var3);

    public abstract void handleEndTag(int var1, String var2);

    public final void parse(InputStream inputStream) throws IOException {
        this.parse(inputStream, true);
    }

    public final void parse(InputStream inputStream, boolean bl) throws IOException {
        this.parse(new InputStreamReader(inputStream), bl);
    }

    public final void parse(Reader reader, boolean bl) throws IOException {
        String string;
        Class clazz = class$java$lang$StringBuffer;
        if (clazz == null) {
            clazz = class$java$lang$StringBuffer = HtmlTokenizer.class("[Ljava.lang.StringBuffer;", false);
        }
        this.text = new Array(clazz);
        this.source = null;
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append("\n");
            this.text.add((Object)stringBuffer);
        }
        if (bl) {
            bufferedReader.close();
        }
        this.parseFromList();
    }

    public final void parse(String string) {
        Class clazz = class$java$lang$StringBuffer;
        if (clazz == null) {
            clazz = class$java$lang$StringBuffer = HtmlTokenizer.class("[Ljava.lang.StringBuffer;", false);
        }
        this.text = new Array(clazz);
        this.source = null;
        String[] stringArray = TextUtil.split((String)string, (char)'\n');
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            StringBuffer stringBuffer = new StringBuffer(string2.length() + 1);
            stringBuffer.append(string2).append("\n");
            this.text.add((Object)stringBuffer);
            ++n;
        }
        this.parseFromList();
    }

    public final String getSource() {
        if (this.source == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.text.size()) {
                stringBuffer.append(this.text.get(n).toString());
                ++n;
            }
            this.source = stringBuffer.toString();
        }
        return this.source;
    }

    private final void parseFromList() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.offset = 0;
        int n4 = 0;
        while (n4 < this.text.size()) {
            StringBuffer stringBuffer = (StringBuffer)this.text.get(n4);
            int n5 = 0;
            while (n5 < stringBuffer.length()) {
                switch (n) {
                    case 0: {
                        if (stringBuffer.charAt(n5) == '<' && stringBuffer.charAt(n5 + 1) == '!' && stringBuffer.charAt(n5 + 2) == '-' && stringBuffer.charAt(n5 + 3) == '-') {
                            if (HtmlTokenizer.validElement(n4, n5, n2, n3)) {
                                this.handleText(this.getElement(n4, n5, n2, n3));
                            }
                            n3 = n5;
                            n2 = n4;
                            n = 1;
                            break;
                        }
                        if (stringBuffer.charAt(n5) == '<' && stringBuffer.charAt(n5 + 1) == '/') {
                            if (HtmlTokenizer.validElement(n4, n5, n2, n3)) {
                                this.handleText(this.getElement(n4, n5, n2, n3));
                            }
                            n3 = n5;
                            n2 = n4;
                            n = 2;
                            break;
                        }
                        if (stringBuffer.charAt(n5) != '<') break;
                        if (HtmlTokenizer.validElement(n4, n5, n2, n3)) {
                            this.handleText(this.getElement(n4, n5, n2, n3));
                        }
                        n3 = n5;
                        n2 = n4;
                        n = 3;
                        break;
                    }
                    case 1: {
                        if (stringBuffer.charAt(n5) != '-' || stringBuffer.charAt(n5 + 1) != '-' || stringBuffer.charAt(n5 + 2) != '>') break;
                        if (HtmlTokenizer.validElement(n4, n5, n2, n3)) {
                            this.handleComment(this.getElement(n4, n5, n2, n3 + 4));
                        }
                        n3 = n5 + 3;
                        n2 = n4;
                        n = 0;
                        break;
                    }
                    case 2: {
                        String string;
                        String string2;
                        if (stringBuffer.charAt(n5) != '>') break;
                        if (HtmlTokenizer.validElement(n4, n5, n2, n3) && validTags.containsKey(string2 = HtmlTokenizer.getTagName(string = this.getElement(n4, n5, n2, n3 + 2)))) {
                            this.handleEndTag(n4, string.toUpperCase());
                        }
                        n3 = n5 + 1;
                        n2 = n4;
                        n = 0;
                        break;
                    }
                    case 3: {
                        String string;
                        String string2;
                        if (stringBuffer.charAt(n5) != '>') break;
                        if (HtmlTokenizer.validElement(n4, n5, n2, n3) && ((string = this.getElement(n4, n5, n2, n3 + 1)).length() < DOCTYPE.length() || !string.substring(0, DOCTYPE.length()).equals(DOCTYPE)) && validTags.containsKey(string2 = HtmlTokenizer.getTagName(string))) {
                            this.handleStartTag(n4, HtmlTokenizer.getTagName(string), HtmlTokenizer.getAttributes(string));
                        }
                        n3 = n5 + 1;
                        n2 = n4;
                        n = 0;
                        break;
                    }
                }
                ++this.offset;
                ++n5;
            }
            if (n == 0) {
                if (HtmlTokenizer.validElement(n4, stringBuffer.length(), n2, n3)) {
                    this.handleText(this.getElement(n4, stringBuffer.length(), n2, n3));
                }
                n3 = 0;
                n2 = n4 + 1;
            }
            ++n4;
        }
    }

    private static final boolean validElement(int n, int n2, int n3, int n4) {
        if (n3 < n) {
            return true;
        }
        return n3 == n && n4 < n2;
    }

    private final String getElement(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (n3 == n) {
            String string = ((StringBuffer)this.text.get(n)).substring(n4, n2);
            stringBuffer.append(string);
        } else {
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = HtmlTokenizer.class("[Ljava.lang.String;", false);
            }
            Array array = new Array(clazz);
            String string = ((StringBuffer)this.text.get(n3)).substring(n4);
            if (string.length() > 0) {
                array.add((Object)string);
            }
            int n5 = n3 + 1;
            while (n5 < n) {
                string = ((StringBuffer)this.text.get(n5)).toString();
                if (string.length() > 0) {
                    array.add((Object)string);
                }
                ++n5;
            }
            string = ((StringBuffer)this.text.get(n)).substring(0, n2);
            if (string.length() > 0) {
                array.add((Object)string);
            }
            if (array.size() > 0) {
                n5 = 0;
                while (n5 < array.size()) {
                    stringBuffer.append((String)array.get(n5));
                    ++n5;
                }
            }
        }
        return stringBuffer.toString();
    }

    private static final String getTagName(String string) {
        int n = string.indexOf(32);
        if (n == -1) {
            return string.toUpperCase();
        }
        return string.substring(0, n).toUpperCase();
    }

    private static final Map getAttributes(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = string.indexOf(32);
        if (n != -1) {
            int n2 = ++n;
            int n3 = 0;
            char c = '\"';
            String string2 = "";
            String string3 = "";
            while (n < string.length()) {
                switch (n3) {
                    case 0: {
                        if (string.charAt(n) == '=') {
                            string2 = string.substring(n2, n).trim().toUpperCase();
                            n3 = 2;
                            break;
                        }
                        if (string.charAt(n) != ' ') break;
                        string2 = string.substring(n2, n).trim().toUpperCase();
                        hashMap.put(string2, null);
                        n2 = n + 1;
                        break;
                    }
                    case 2: {
                        if (string.charAt(n) == '\"' || string.charAt(n) == '\'') {
                            c = string.charAt(n);
                            n2 = n + 1;
                            n3 = 4;
                            break;
                        }
                        if (string.charAt(n) == ' ') break;
                        n2 = n;
                        n3 = 5;
                        break;
                    }
                    case 4: {
                        if (string.charAt(n) != c) break;
                        string3 = string.substring(n2, n);
                        hashMap.put(string2, string3);
                        n2 = n + 1;
                        n3 = 0;
                        break;
                    }
                    case 5: {
                        if (string.charAt(n) != ' ') break;
                        string3 = string.substring(n2, n);
                        hashMap.put(string2, string3);
                        n2 = n + 1;
                        n3 = 0;
                        break;
                    }
                }
                ++n;
            }
            if (n3 == 5) {
                string3 = string.substring(n2, n);
                hashMap.put(string2, string3);
            } else if (n3 == 0) {
                string2 = string.substring(n2, n).trim().toUpperCase();
                hashMap.put(string2, null);
            }
        }
        return hashMap;
    }

    protected int getOffset() {
        return this.offset;
    }

    public static String replaceLiterals(String string) {
        if (!perl.match(literalPattern, string)) {
            return string;
        }
        ArrayList arrayList = new ArrayList();
        perl.split(arrayList, literalPattern, string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < arrayList.size()) {
            String string2 = (String)arrayList.get(n);
            String string3 = (String)literalMap.get(string2);
            stringBuffer.append(string3 == null ? string2 : string3);
            ++n;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.text = null;
        this.source = null;
    }

    public HtmlTokenizer() {
        this.this();
    }

    static {
        validTags.put("A", null);
        validTags.put("B", null);
        validTags.put("BODY", null);
        validTags.put("BR", null);
        validTags.put("CODE", null);
        validTags.put("DD", null);
        validTags.put("DL", null);
        validTags.put("DT", null);
        validTags.put("EM", null);
        validTags.put("FONT", null);
        validTags.put("H1", null);
        validTags.put("H2", null);
        validTags.put("H3", null);
        validTags.put("H4", null);
        validTags.put("H5", null);
        validTags.put("HEAD", null);
        validTags.put("HR", null);
        validTags.put("HTML", null);
        validTags.put("I", null);
        validTags.put("IMG", null);
        validTags.put("LI", null);
        validTags.put("LINK", null);
        validTags.put("OL", null);
        validTags.put("P", null);
        validTags.put("PRE", null);
        validTags.put("STRONG", null);
        validTags.put("TABLE", null);
        validTags.put("TD", null);
        validTags.put("TH", null);
        validTags.put("TITLE", null);
        validTags.put("TR", null);
        validTags.put("TT", null);
        validTags.put("UL", null);
        literals = new Literal[]{new Literal("&quot;", "\""), new Literal("&#34;", "\""), new Literal("&amp;", "&"), new Literal("&#38;", "&"), new Literal("&lt;", "<"), new Literal("&#60;", "<"), new Literal("&gt;", ">"), new Literal("&#62;", ">"), new Literal("&ndash;", "-"), new Literal("&#8211;", "-"), new Literal("&mdash;", "--"), new Literal("&#8212;", "--"), new Literal("&lsquo;", "'"), new Literal("&#8216;", "'"), new Literal("&rsquo;", "'"), new Literal("&#8217;", "'"), new Literal("&ldquo;", "\""), new Literal("&#8220;", "\""), new Literal("&rdquo;", "\""), new Literal("&#8221;", "\""), new Literal("&prime;", "'"), new Literal("&#8242;", "'"), new Literal("&Prime;", "\""), new Literal("&#8243;", "\""), new Literal("&trade;", "\u0099"), new Literal("&#8482;", "\u0099"), new Literal("&#x2013;", "-"), new Literal("&#x2014;", "--"), new Literal("&#x2018;", "'"), new Literal("&#x2019;", "'"), new Literal("&#x201c;", "\""), new Literal("&#x201d;", "\""), new Literal("&#x2032;", "'"), new Literal("&#x2033;", "\""), new Literal("&#x2122;", "\u0099"), new Literal("&#9474;", "\u00a6"), new Literal("&bull;", "\u2022"), new Literal("&#8226;", "\u2022"), new Literal("&dagger;", "\u2020"), new Literal("&#8224;", "\u2020"), new Literal("&Dagger;", "\u2021"), new Literal("&#8225;", "\u2021"), new Literal("&lsaquo;", "\u2039"), new Literal("&#8249;", "\u2039"), new Literal("&rsaquo;", "\u203a"), new Literal("&#8250;", "\u203a"), new Literal("&euro;", "\u20ac"), new Literal("&#8364;", "\u20ac"), new Literal("&tilde;", "\u02dc"), new Literal("&#732;", "\u02dc"), new Literal("&circ;", "\u02c6"), new Literal("&#710;", "\u02c6"), new Literal("&#x2022;", "\u2022"), new Literal("&#x2020;", "\u2020"), new Literal("&#x2021;", "\u2021"), new Literal("&#x2039;", "\u2039"), new Literal("&#x203a;", "\u203a"), new Literal("&#x20ac;", "\u20ac"), new Literal("&#x2dc;", "\u02dc"), new Literal("&#x2c6;", "\u02c6"), new Literal("&#124;", "|"), new Literal("&ring;", "\u02da"), new Literal("&#730;", "\u02da"), new Literal("&nbsp;", " "), new Literal("&#160;", " "), new Literal("&iexcl;", "\u00a1"), new Literal("&#161;", "\u00a1"), new Literal("&cent;", "\u00a2"), new Literal("&#162;", "\u00a2"), new Literal("&pound;", "\u00a3"), new Literal("&#163;", "\u00a3"), new Literal("&curren;", "\u00a4"), new Literal("&#164;", "\u00a4"), new Literal("&yen;", "\u00a5"), new Literal("&#165;", "\u00a5"), new Literal("&brvbar;", "\u00a6"), new Literal("&#166;", "\u00a6"), new Literal("&sect;", "\u00a7"), new Literal("&#167;", "\u00a7"), new Literal("&uml;", "\u00a8"), new Literal("&#168;", "\u00a8"), new Literal("&copy;", "\u00a9"), new Literal("&#169;", "\u00a9"), new Literal("&ordf;", "\u00aa"), new Literal("&#170;", "\u00aa"), new Literal("&laquo;", "\u00ab"), new Literal("&#171;", "\u00ab"), new Literal("&not;", "\u00ac"), new Literal("&#172;", "\u00ac"), new Literal("&shy;", "\u00ad"), new Literal("&#173;", "\u00ad"), new Literal("&reg;", "\u00ae"), new Literal("&#174;", "\u00ae"), new Literal("&macr;", "\u00af"), new Literal("&#175;", "\u00af"), new Literal("&deg;", "\u00b0"), new Literal("&#176;", "\u00b0"), new Literal("&plusmn;", "\u00b1"), new Literal("&#177;", "\u00b1"), new Literal("&sup2;", "\u00b2"), new Literal("&#178;", "\u00b2"), new Literal("&sup3;", "\u00b3"), new Literal("&#179;", "\u00b3"), new Literal("&acute;", "\u00b4"), new Literal("&#180;", "\u00b4"), new Literal("&micro;", "\u00b5"), new Literal("&#181;", "\u00b5"), new Literal("&para;", "\u00b6"), new Literal("&#182;", "\u00b6"), new Literal("&middot;", "\u00b7"), new Literal("&#183;", "\u00b7"), new Literal("&cedil;", "\u00b8"), new Literal("&#184;", "\u00b8"), new Literal("&sup1;", "\u00b9"), new Literal("&#185;", "\u00b9"), new Literal("&ordm;", "\u00ba"), new Literal("&#186;", "\u00ba"), new Literal("&raquo;", "\u00bb"), new Literal("&#187;", "\u00bb"), new Literal("&frac14;", "\u00bc"), new Literal("&#188;", "\u00bc"), new Literal("&frac12;", "\u00bd"), new Literal("&#189;", "\u00bd"), new Literal("&frac34;", "\u00be"), new Literal("&#190;", "\u00be"), new Literal("&iquest;", "\u00bf"), new Literal("&#191;", "\u00bf"), new Literal("&Agrave;", "\u00c0"), new Literal("&#192;", "\u00c0"), new Literal("&Aacute;", "\u00c1"), new Literal("&#193;", "\u00c1"), new Literal("&Acirc;", "\u00c2"), new Literal("&#194;", "\u00c2"), new Literal("&Atilde;", "\u00c3"), new Literal("&#195;", "\u00c3"), new Literal("&Auml;", "\u00c4"), new Literal("&#196;", "\u00c4"), new Literal("&Aring;", "\u00c5"), new Literal("&#197;", "\u00c5"), new Literal("&AElig;", "\u00c6"), new Literal("&#198;", "\u00c6"), new Literal("&Ccedil;", "\u00c7"), new Literal("&#199;", "\u00c7"), new Literal("&Egrave;", "\u00c8"), new Literal("&#200;", "\u00c8"), new Literal("&Eacute;", "\u00c9"), new Literal("&#201;", "\u00c9"), new Literal("&Ecirc;", "\u00ca"), new Literal("&#202;", "\u00ca"), new Literal("&Euml;", "\u00cb"), new Literal("&#203;", "\u00cb"), new Literal("&Igrave;", "\u00cc"), new Literal("&#204;", "\u00cc"), new Literal("&Iacute;", "\u00cd"), new Literal("&#205;", "\u00cd"), new Literal("&Icirc;", "\u00ce"), new Literal("&#206;", "\u00ce"), new Literal("&Iuml;", "\u00cf"), new Literal("&#207;", "\u00cf"), new Literal("&ETH;", "\u00d0"), new Literal("&#208;", "\u00d0"), new Literal("&Ntilde;", "\u00d1"), new Literal("&#209;", "\u00d1"), new Literal("&Ograve;", "\u00d2"), new Literal("&#210;", "\u00d2"), new Literal("&Oacute;", "\u00d3"), new Literal("&#211;", "\u00d3"), new Literal("&Ocirc;", "\u00d4"), new Literal("&#212;", "\u00d4"), new Literal("&Otilde;", "\u00d5"), new Literal("&#213;", "\u00d5"), new Literal("&Ouml;", "\u00d6"), new Literal("&#214;", "\u00d6"), new Literal("&times;", "\u00d7"), new Literal("&#215;", "\u00d7"), new Literal("&Oslash;", "\u00d8"), new Literal("&#216;", "\u00d8"), new Literal("&Ugrave;", "\u00d9"), new Literal("&#217;", "\u00d9"), new Literal("&Uacute;", "\u00da"), new Literal("&#218;", "\u00da"), new Literal("&Ucirc;", "\u00db"), new Literal("&#219;", "\u00db"), new Literal("&Uml;", "\u00dc"), new Literal("&#220;", "\u00dc"), new Literal("&Yacute;", "\u00dd"), new Literal("&#221;", "\u00dd"), new Literal("&THORN;", "\u00de"), new Literal("&#222;", "\u00de"), new Literal("&szlig;", "\u00df"), new Literal("&#223;", "\u00df"), new Literal("&agrave;", "\u00e0"), new Literal("&#224;", "\u00e0"), new Literal("&aacute;", "\u00e1"), new Literal("&#225;", "\u00e1"), new Literal("&acirc;", "\u00e2"), new Literal("&#226;", "\u00e2"), new Literal("&atilde;", "\u00e3"), new Literal("&#227;", "\u00e3"), new Literal("&auml;", "\u00e4"), new Literal("&#228;", "\u00e4"), new Literal("&aring;", "\u00e5"), new Literal("&#229;", "\u00e5"), new Literal("&aelig;", "\u00e6"), new Literal("&#230;", "\u00e6"), new Literal("&ccedil;", "\u00e7"), new Literal("&#231;", "\u00e7"), new Literal("&egrave;", "\u00e8"), new Literal("&#232;", "\u00e8"), new Literal("&eacute;", "\u00e9"), new Literal("&#233;", "\u00e9"), new Literal("&ecirc;", "\u00ea"), new Literal("&#234;", "\u00ea"), new Literal("&euml;", "\u00eb"), new Literal("&#235;", "\u00eb"), new Literal("&igrave;", "\u00ec"), new Literal("&#236;", "\u00ec"), new Literal("&iacute;", "\u00ed"), new Literal("&#237;", "\u00ed"), new Literal("&icirc;", "\u00ee"), new Literal("&#238;", "\u00ee"), new Literal("&iuml;", "\u00ef"), new Literal("&#239;", "\u00ef"), new Literal("&eth;", "\u00f0"), new Literal("&#240;", "\u00f0"), new Literal("&ntilde;", "\u00f1"), new Literal("&#241;", "\u00f1"), new Literal("&ograve;", "\u00f2"), new Literal("&#242;", "\u00f2"), new Literal("&oacute;", "\u00f3"), new Literal("&#243;", "\u00f3"), new Literal("&ocirc;", "\u00f4"), new Literal("&#244;", "\u00f4"), new Literal("&otilde;", "\u00f5"), new Literal("&#245;", "\u00f5"), new Literal("&ouml;", "\u00f6"), new Literal("&#246;", "\u00f6"), new Literal("&divide;", "\u00f7"), new Literal("&#247;", "\u00f7"), new Literal("&oslash;", "\u00f8"), new Literal("&#248;", "\u00f8"), new Literal("&ugrave;", "\u00f9"), new Literal("&#249;", "\u00f9"), new Literal("&uacute;", "\u00fa"), new Literal("&#250;", "\u00fa"), new Literal("&ucirc;", "\u00fb"), new Literal("&#251;", "\u00fb"), new Literal("&uuml;", "\u00fc"), new Literal("&#252;", "\u00fc"), new Literal("&yacute;", "\u00fd"), new Literal("&#253;", "\u00fd"), new Literal("&thorn;", "\u00fe"), new Literal("&#254;", "\u00fe"), new Literal("&yuml;", "\u00ff"), new Literal("&#255;", "\u00ff")};
        perl = new Perl5Util();
        literalMap = new HashMap();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/");
        int n = 0;
        while (n < literals.length) {
            Literal literal = literals[n];
            if (n > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("(").append(literal.from).append(")");
            literalMap.put(literal.from, literal.to);
            ++n;
        }
        stringBuffer.append("/");
        literalPattern = stringBuffer.toString();
    }

    static class Literal {
        String from;
        String to;

        Literal(String string, String string2) {
            this.from = string;
            this.to = string2;
        }
    }
}

