/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.glyph;

import com.tridium.gx.awt.AwtGraphics;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.baja.gx.BImage;

class TextAnalyzer {
    private static final Graphics2D FRC;
    private final String text;
    private final Font font;
    private final FontMetrics metrics;
    final int numLetters;
    final int ascent;
    final int width;
    final int height;
    final int yOffset;

    private final int fontAscent(Font font) {
        return FRC.getFontMetrics(font).getAscent();
    }

    void drawText(Graphics2D graphics2D, int n, int n2) {
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        graphics2D.drawString(this.text, n, n2);
        graphics2D.setFont(font);
    }

    float getCharWidth(int n) {
        return this.metrics.charWidth(this.text.charAt(n));
    }

    TextAnalyzer(String string, Font font, boolean bl) {
        this.text = string;
        this.font = bl ? new Font(font.getName(), font.getStyle(), font.getSize() * 2 / 3) : font;
        this.metrics = FRC.getFontMetrics(this.font);
        this.numLetters = string.length();
        this.ascent = this.metrics.getAscent();
        this.height = this.metrics.getHeight();
        this.width = this.metrics.stringWidth(string);
        int n = 0;
        if (bl) {
            n = this.fontAscent(font) - this.ascent;
        }
        this.yOffset = n;
    }

    static {
        BImage bImage = BImage.make((double)10.0, (double)10.0);
        AwtGraphics awtGraphics = (AwtGraphics)bImage.getGraphics();
        FRC = awtGraphics.getAwtGraphics();
    }
}

