/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.glyph;

import com.tridium.html.canvas.glyph.Letter;
import com.tridium.html.canvas.glyph.SelectionPoint;
import com.tridium.html.canvas.glyph.SelectionRange;
import com.tridium.html.canvas.glyph.StyleRun;
import com.tridium.html.canvas.glyph.TextRow;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.ui.text.FindPattern;

public class Text {
    private TextRow[] rows;
    private Contig[] contigs;

    public SelectionPoint get(double d, double d2) {
        return this.get((int)d, (int)d2);
    }

    public SelectionPoint get(int n, int n2) {
        int n3 = 0;
        while (n3 < this.rows.length) {
            if (n2 >= this.rows[n3].getY() && n2 < this.rows[n3].getY() + this.rows[n3].getHeight() && n >= this.rows[n3].getX() && n < this.rows[n3].getX() + this.rows[n3].getWidth()) {
                return this.rows[n3].select(n);
            }
            ++n3;
        }
        return null;
    }

    public SelectionPoint select(double d, double d2) {
        return this.select((int)d, (int)d2);
    }

    public SelectionPoint select(int n, int n2) {
        if (this.rows.length == 0) {
            return null;
        }
        SelectionPoint selectionPoint = this.get(n, n2);
        if (selectionPoint != null) {
            return selectionPoint;
        }
        int n3 = 0;
        while (n3 < this.rows.length) {
            if (n2 >= this.rows[n3].getY() && n2 < this.rows[n3].getY() + this.rows[n3].getHeight()) {
                selectionPoint = this.rows[n3].select(n);
                int n4 = n3 + 1;
                while (n4 < this.rows.length && this.rows[n4].isVisible() && n2 >= this.rows[n4].getY() && n2 < this.rows[n4].getY() + this.rows[n4].getHeight()) {
                    if (n >= this.rows[n4].getX() + this.rows[n4].getWidth()) {
                        selectionPoint = this.rows[n4].select(n);
                    }
                    ++n4;
                }
                return selectionPoint;
            }
            ++n3;
        }
        if (n2 < this.rows[0].getY()) {
            return this.rows[0].getStartSel();
        }
        selectionPoint = null;
        n3 = 0;
        while (n3 < this.rows.length) {
            if (n2 >= this.rows[n3].getY() && n2 >= this.rows[n3].getY() + this.rows[n3].getHeight()) {
                selectionPoint = this.rows[n3].getFinishSel();
            }
            ++n3;
        }
        return selectionPoint;
    }

    public void paint(Graphics2D graphics2D, int n, int n2, SelectionRange selectionRange) {
        int n3 = 0;
        while (n3 < this.rows.length) {
            if (this.rows[n3].getY() + this.rows[n3].getHeight() > n && this.rows[n3].getY() < n2) {
                this.rows[n3].paint(graphics2D, selectionRange);
            }
            ++n3;
        }
    }

    public Rectangle getHighlightRectangle(SelectionRange selectionRange) {
        Rectangle rectangle = null;
        int n = 0;
        while (n < this.rows.length) {
            Rectangle rectangle2 = this.rows[n].getHighlightRectangle(selectionRange);
            if (rectangle2 != null) {
                if (rectangle == null) {
                    rectangle = rectangle2;
                } else {
                    rectangle.add(rectangle2);
                }
            }
            ++n;
        }
        return rectangle;
    }

    public SelectionRange selectWord(SelectionPoint selectionPoint) {
        return selectionPoint.run.getTextRow().selectWord(selectionPoint);
    }

    public String copy(SelectionRange selectionRange) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        int n = 0;
        while (n < this.rows.length) {
            String string2 = this.rows[n].copy(selectionRange);
            if (string2 != null) {
                if (string != null && this.rows[n].getY() > this.rows[n - 1].getY() && this.rows[n - 1].isHardReturn()) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(string2);
            }
            string = string2;
            ++n;
        }
        return stringBuffer.toString();
    }

    public SelectionRange[] findLocations(FindPattern findPattern) {
        ArrayList<SelectionRange> arrayList = new ArrayList<SelectionRange>();
        int n = 0;
        while (n < this.contigs.length) {
            int n2 = findPattern.findNext(this.contigs[n].text, 0);
            while (n2 != -1) {
                arrayList.add(this.createContigRange(this.contigs[n], n2, n2 + findPattern.string.length()));
                n2 = findPattern.findNext(this.contigs[n].text, n2 + 1);
            }
            ++n;
        }
        return arrayList.toArray(new SelectionRange[arrayList.size()]);
    }

    public SelectionRange selectAll() {
        StyleRun styleRun = this.rows[0].getRuns()[0];
        StyleRun[] styleRunArray = this.rows[this.rows.length - 1].getRuns();
        StyleRun styleRun2 = styleRunArray[styleRunArray.length - 1];
        return new SelectionRange(new SelectionPoint(styleRun, new Letter(0, true)), new SelectionPoint(styleRun2, new Letter(styleRun2.getNumLetters(), false)));
    }

    private final SelectionRange createContigRange(Contig contig, int n, int n2) {
        int n3 = contig.getRunAtLetter(n);
        int n4 = contig.getRunAtLetter(n2);
        return new SelectionRange(new SelectionPoint(contig.runs[n3], new Letter(n - contig.runLetter[n3], true)), new SelectionPoint(contig.runs[n4], new Letter(n2 - contig.runLetter[n4], true)));
    }

    public Text(TextRow[] textRowArray, int n, int n2) {
        this.rows = textRowArray;
        ArrayList<Contig> arrayList = new ArrayList<Contig>();
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<StyleRun> arrayList2 = new ArrayList<StyleRun>();
        int n3 = 0;
        while (n3 < textRowArray.length) {
            stringBuffer.append(textRowArray[n3].getText());
            arrayList2.addAll(Arrays.asList(textRowArray[n3].getRuns()));
            if (textRowArray[n3].isHardReturn()) {
                if (stringBuffer.length() > 0) {
                    arrayList.add(new Contig(stringBuffer, arrayList2));
                }
                stringBuffer = new StringBuffer();
                arrayList2 = new ArrayList();
            }
            ++n3;
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(new Contig(stringBuffer, arrayList2));
        }
        this.contigs = arrayList.toArray(new Contig[arrayList.size()]);
    }

    private static class Contig {
        private String text;
        private StyleRun[] runs;
        private int[] runLetter;
        private int numLetters;

        private final int getRunAtLetter(int n) {
            int n2 = this.runs.length - 1;
            int n3 = 0;
            while (n3 < n2) {
                if (n >= this.runLetter[n3] && n < this.runLetter[n3 + 1]) {
                    return n3;
                }
                ++n3;
            }
            if (n >= this.runLetter[n2] && n < this.numLetters) {
                return n2;
            }
            throw new IllegalStateException();
        }

        private Contig(StringBuffer stringBuffer, ArrayList arrayList) {
            this.text = stringBuffer.toString();
            this.runs = arrayList.toArray(new StyleRun[arrayList.size()]);
            this.numLetters = 0;
            this.runLetter = new int[this.runs.length];
            int n = 0;
            while (n < this.runs.length) {
                this.runLetter[n] = this.numLetters;
                this.numLetters += this.runs[n].getNumLetters();
                ++n;
            }
        }
    }
}

