/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.glyph;

import com.tridium.html.canvas.glyph.Letter;
import com.tridium.html.canvas.glyph.TextAnalyzer;
import com.tridium.html.canvas.glyph.TextRow;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StyleRun
implements Comparable {
    private static int indexCounter;
    private int index;
    private String text;
    private Font font;
    private Color color;
    private String href;
    private String target;
    private boolean superscript;
    private TextRow textRow;
    private TextAnalyzer analyzer;
    private boolean shortenUnderline;
    private boolean cached;
    private int[] letterX;

    public String toString() {
        return new String("[" + this.index + ']' + this.text);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this.index == ((StyleRun)object).index) {
            bl = true;
        }
        return bl;
    }

    public int compareTo(Object object) {
        return this.index - ((StyleRun)object).index;
    }

    void paint(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(this.color);
        this.analyzer.drawText(graphics2D, n, n2 -= this.analyzer.yOffset);
        if (this.href != null) {
            int n3 = this.shortenUnderline && this.analyzer.numLetters > 0 ? n + this.getX(this.analyzer.numLetters - 1) : n + this.analyzer.width;
            graphics2D.drawLine(n, n2 + 1, n3, n2 + 1);
        }
    }

    Letter getLetter(int n) {
        int n2;
        int n3 = this.analyzer.numLetters - 1;
        int n4 = 0;
        while (n4 < n3) {
            n2 = this.getX(n4);
            int n5 = this.getX(n4 + 1);
            if (n >= n2 && n < n5) {
                boolean bl = false;
                if (n - n2 < (n5 - n2) / 2) {
                    bl = true;
                }
                return new Letter(n4, bl);
            }
            ++n4;
        }
        n4 = this.getX(n3);
        n2 = this.analyzer.width;
        if (n >= n4 && n < n2) {
            boolean bl = false;
            if (n - n4 < (n2 - n4) / 2) {
                bl = true;
            }
            return new Letter(n3, bl);
        }
        return null;
    }

    int getX(int n) {
        if (n == this.analyzer.numLetters) {
            return this.analyzer.width;
        }
        if (!this.cached) {
            this.cache();
        }
        return this.letterX[n];
    }

    public String getHref() {
        return this.href;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean getSuperscript() {
        return this.superscript;
    }

    String getText() {
        return this.text;
    }

    Font getFont() {
        return this.font;
    }

    Color getColor() {
        return this.color;
    }

    TextRow getTextRow() {
        return this.textRow;
    }

    int getAscent() {
        return this.analyzer.ascent;
    }

    int getWidth() {
        return this.analyzer.width;
    }

    int getHeight() {
        return this.analyzer.height;
    }

    int getNumLetters() {
        return this.analyzer.numLetters;
    }

    void setShortenUnderline(boolean bl) {
        this.shortenUnderline = bl;
    }

    void setTextRow(TextRow textRow) {
        this.textRow = textRow;
    }

    private final void cache() {
        this.letterX = new int[this.analyzer.numLetters];
        float f = 0.0f;
        int n = 0;
        while (n < this.analyzer.numLetters) {
            this.letterX[n] = Math.round(f);
            f += this.analyzer.getCharWidth(n);
            ++n;
        }
        this.cached = true;
    }

    public static void resetIndexCounter() {
        indexCounter = 0;
    }

    private final /* synthetic */ void this() {
        this.shortenUnderline = false;
        this.cached = false;
    }

    StyleRun(String string, Font font, Color color, String string2, String string3, boolean bl) {
        this.this();
        this.text = string;
        this.color = color;
        this.href = string2;
        this.target = string3;
        this.superscript = bl;
        this.font = bl ? new Font(font.getName(), font.getStyle(), font.getSize() * 2 / 3) : font;
        this.analyzer = new TextAnalyzer(string, font, bl);
        this.index = indexCounter++;
    }
}

