/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.glyph;

import com.tridium.html.canvas.glyph.Glyph;
import com.tridium.html.canvas.glyph.GlyphAlign;
import com.tridium.html.canvas.glyph.GlyphFragment;
import com.tridium.html.canvas.glyph.GlyphRoot;
import com.tridium.html.canvas.glyph.StretchDimension;
import com.tridium.html.canvas.glyph.TableUtil;
import com.tridium.html.canvas.glyph.TextRow;
import com.tridium.html.canvas.glyph.VisibleGlyph;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GlyphTable
extends Glyph
implements VisibleGlyph {
    int align;
    int border;
    int cellPadding;
    int cellSpacing;
    StretchDimension stretchWidth;
    Color borderColorLight;
    Color borderColorDark;
    public boolean noWrap;
    int numRows;
    int numCols;
    Cell[][] cells;
    int[][] cellWidths;
    int[][] cellHeights;
    private Rectangle[][] backgrounds;
    private Point outerBorderPen;

    public String toString() {
        return "TABLE";
    }

    public void paint(Graphics2D graphics2D, int n, int n2) {
        if (this.border > 0) {
            this.paintOuterBorder(graphics2D, this.outerBorderPen);
        }
        int n3 = 0;
        while (n3 < this.numRows) {
            int n4 = 0;
            while (n4 < this.numCols) {
                Cell cell = this.cells[n3][n4];
                if (cell != null && cell.root.size() > 0) {
                    Rectangle rectangle = this.backgrounds[n3][n4];
                    this.paintCellBackground(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, cell.bgColor);
                    if (this.border > 0) {
                        this.paintInnerBorder(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                    cell.root.paint(graphics2D, n, n2);
                }
                ++n4;
            }
            ++n3;
        }
    }

    private final void paintOuterBorder(Graphics2D graphics2D, Point point) {
        graphics2D.setColor(this.borderColorLight);
        graphics2D.fillRect(point.x, point.y, this.getWidth(), this.border);
        graphics2D.fillRect(point.x, point.y, this.border, this.getHeight());
        graphics2D.setColor(this.borderColorDark);
        int n = 1;
        while (n <= this.border) {
            graphics2D.drawLine(point.x + this.getWidth() - n, point.y + n, point.x + this.getWidth() - n, point.y + this.getHeight() - 1);
            graphics2D.drawLine(point.x + n, point.y + this.getHeight() - n, point.x + this.getWidth() - 1, point.y + this.getHeight() - n);
            ++n;
        }
    }

    private final void paintInnerBorder(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        graphics2D.setColor(this.borderColorDark);
        graphics2D.drawLine(n, n2, n5, n2);
        graphics2D.drawLine(n, n2, n, n6);
        graphics2D.setColor(this.borderColorLight);
        graphics2D.drawLine(n5, n2, n5, n6);
        graphics2D.drawLine(n, n6, n5, n6);
    }

    private final void paintCellBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color) {
        if (color != null) {
            int n5 = n + n3;
            int n6 = n2 + n4;
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n3, n4);
        }
    }

    public int computeMinimumWidth() {
        return this.computeWidth(true);
    }

    int computeMaximumWidth() {
        return this.computeWidth(false);
    }

    private final int computeWidth(boolean bl) {
        int n;
        int[][] nArray = new int[this.numRows][this.numCols];
        int n2 = 0;
        while (n2 < this.numRows) {
            n = 0;
            while (n < this.numCols) {
                Cell cell = this.cells[n2][n];
                if (cell != null) {
                    int n3 = bl ? TableUtil.getCeiling(cell.root.computeMinimumWidth(), cell.colspan) : TableUtil.getCeiling(cell.root.computeMaximumWidth(), cell.colspan);
                    int n4 = n2;
                    while (n4 < n2 + cell.rowspan) {
                        int n5 = n;
                        while (n5 < n + cell.colspan) {
                            nArray[n4][n5] = n3;
                            ++n5;
                        }
                        ++n4;
                    }
                }
                ++n;
            }
            ++n2;
        }
        int[] nArray2 = TableUtil.getColumnMaximums(nArray, this.numRows, this.numCols);
        n = TableUtil.sumArray(nArray2);
        return n += this.getXMargin();
    }

    public void doLayout(int n, int n2, int n3) {
        this.setX(n);
        this.setY(n2);
        this.setWidth(this.distributeWidth(n3 - this.getXMargin()));
        this.setHeight(this.computeHeight());
        this.layoutCells(new Point(n, n2), n3);
    }

    private final void layoutCells(Point point, int n) {
        this.backgrounds = new Rectangle[this.numRows][this.numCols];
        int n2 = point.y + this.border + this.cellSpacing;
        point.x += GlyphAlign.apply(this.align, n - this.getWidth());
        this.outerBorderPen = new Point(point.x, point.y);
        boolean bl = false;
        if (this.border > 0) {
            bl = true;
        }
        int[] nArray = TableUtil.getColumnMaximums(this.cellWidths, this.numRows, this.numCols);
        int[] nArray2 = TableUtil.getRowMaximums(this.cellHeights, this.numRows, this.numCols);
        int n3 = 0;
        while (n3 < this.numRows) {
            int n4 = point.x + this.border + this.cellSpacing;
            int n5 = 0;
            while (n5 < this.numCols) {
                Cell cell = this.cells[n3][n5];
                if (cell != null) {
                    int n6 = this.getCellWidth(n5, cell.colspan, nArray);
                    int n7 = this.getCellHeight(n3, cell.rowspan, nArray2);
                    if (cell.root.size() > 0) {
                        int n8 = n4 + this.cellPadding;
                        int n9 = n2 + this.cellPadding;
                        n8 += GlyphAlign.apply(cell.align, n6 - cell.root.getWidth() - this.cellPadding - 1);
                        if (bl) {
                            ++n8;
                            ++n9;
                        }
                        this.backgrounds[n3][n5] = new Rectangle(n4, n2, n6, n7);
                        cell.root.doLayout(n8, n9);
                    }
                }
                n4 += nArray[n5];
                if (bl) {
                    n4 += 2;
                }
                n4 += this.cellSpacing;
                n4 += this.cellPadding * 2;
                ++n5;
            }
            n2 += nArray2[n3];
            if (bl) {
                n2 += 2;
            }
            n2 += this.cellSpacing;
            n2 += this.cellPadding * 2;
            ++n3;
        }
    }

    private final int getCellWidth(int n, int n2, int[] nArray) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            n3 += nArray[n4] + 1;
            ++n4;
        }
        n3 += n2 - 1;
        n3 += this.cellSpacing * (n2 - 1);
        return n3 += this.cellPadding * (2 * n2);
    }

    private final int getCellHeight(int n, int n2, int[] nArray) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            n3 += nArray[n4] + 1;
            ++n4;
        }
        n3 += n2 - 1;
        n3 += this.cellSpacing * (n2 - 1);
        return n3 += this.cellPadding * (2 * n2);
    }

    private final int computeHeight() {
        int n;
        int n2;
        this.cellHeights = new int[this.numRows][this.numCols];
        int n3 = 0;
        while (n3 < this.numRows) {
            n2 = 0;
            while (n2 < this.numCols) {
                Cell cell = this.cells[n3][n2];
                if (cell != null) {
                    n = cell.root.doLayout(0, 0);
                    int n4 = n3;
                    while (n4 < n3 + cell.rowspan) {
                        int n5 = n2;
                        while (n5 < n2 + cell.colspan) {
                            this.cellHeights[n4][n5] = n;
                            ++n5;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        n2 = 0;
        while (n2 < this.numRows) {
            int n6 = 0;
            n = 0;
            while (n < this.numCols) {
                n6 = Math.max(n6, this.cellHeights[n2][n]);
                ++n;
            }
            n3 += n6;
            ++n2;
        }
        this.setHeight(n3 += this.getYMargin());
        return n3;
    }

    private final int distributeWidth(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Cell cell;
        int n6;
        if (this.numCols == 0) {
            return this.getXMargin();
        }
        int n7 = 0;
        if (this.stretchWidth != null) {
            n7 = this.stretchWidth.get(n) / this.numCols;
        }
        int[][] nArray = new int[this.numRows][this.numCols];
        int[][] nArray2 = new int[this.numRows][this.numCols];
        int n8 = 0;
        while (n8 < this.numRows) {
            n6 = 0;
            while (n6 < this.numCols) {
                cell = this.cells[n8][n6];
                if (cell != null) {
                    n5 = TableUtil.getCeiling(cell.root.computeMinimumWidth(), cell.colspan);
                    n4 = TableUtil.getCeiling(cell.root.computeMaximumWidth(), cell.colspan);
                    n4 = Math.min(n4, n);
                    if (cell.stretch != null) {
                        n4 = Math.max(n4, cell.stretch.get(n));
                    } else if (this.stretchWidth != null) {
                        n4 = Math.max(n4, n7);
                    }
                    n3 = n8;
                    while (n3 < n8 + cell.rowspan) {
                        n2 = n6;
                        while (n2 < n6 + cell.colspan) {
                            nArray[n3][n2] = n5;
                            nArray2[n3][n2] = n4;
                            ++n2;
                        }
                        ++n3;
                    }
                }
                ++n6;
            }
            ++n8;
        }
        this.cellWidths = TableUtil.distributeWidth(n, this.numRows, this.numCols, nArray, nArray2);
        n8 = 0;
        while (n8 < this.numRows) {
            n6 = 0;
            while (n6 < this.numCols) {
                cell = this.cells[n8][n6];
                if (cell != null) {
                    n5 = 0;
                    n4 = n8;
                    while (n4 < n8 + cell.rowspan) {
                        n3 = 0;
                        n2 = n6;
                        while (n2 < n6 + cell.colspan) {
                            n3 += this.cellWidths[n4][n2];
                            ++n2;
                        }
                        n5 = Math.max(n5, n3);
                        ++n4;
                    }
                    cell.root.setWidth(Math.min(cell.root.computeMaximumWidth(), n5));
                }
                ++n6;
            }
            ++n8;
        }
        int[] nArray3 = TableUtil.getColumnMaximums(this.cellWidths, this.numRows, this.numCols);
        n6 = TableUtil.sumArray(nArray3);
        return n6 + this.getXMargin();
    }

    private final int getXMargin() {
        int n = 0;
        if (this.border > 0) {
            n = 1;
        }
        int n2 = n;
        int n3 = this.border * 2 + n2 * 2 * this.numCols;
        int n4 = this.cellSpacing * (this.numCols + 1);
        int n5 = this.cellPadding * (this.numCols * 2);
        int n6 = n3 + n4 + n5;
        return n6;
    }

    private final int getYMargin() {
        int n = 0;
        if (this.border > 0) {
            n = 1;
        }
        int n2 = n;
        int n3 = this.border * 2 + n2 * 2 * this.numRows;
        int n4 = this.cellSpacing * (this.numRows + 1);
        int n5 = this.cellPadding * (this.numRows * 2);
        int n6 = n3 + n4 + n5;
        return n6;
    }

    public TextRow[] getTextRows() {
        ArrayList<TextRow> arrayList = new ArrayList<TextRow>();
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                Cell cell = this.cells[n][n2];
                if (cell != null) {
                    arrayList.addAll(Arrays.asList(cell.root.getTextRows()));
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new TextRow[arrayList.size()]);
    }

    public GlyphFragment findFragment(String string) {
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                GlyphFragment glyphFragment;
                Cell cell = this.cells[n][n2];
                if (cell != null && (glyphFragment = cell.root.findFragment(string)) != null) {
                    return glyphFragment;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public void setSize(int n, int n2) {
        this.numRows = n;
        this.numCols = n2;
        this.cells = new Cell[n][n2];
    }

    public void setCell(int n, int n2, int n3, int n4, Color color, StretchDimension stretchDimension, int n5, GlyphRoot glyphRoot) {
        if (n + n3 > this.numRows) {
            n3 = this.numRows - n;
        }
        if (n2 + n4 > this.numCols) {
            n4 = this.numCols - n2;
        }
        this.cells[n][n2] = new Cell(n3, n4, color, stretchDimension, n5, glyphRoot);
    }

    private final /* synthetic */ void this() {
        this.cellWidths = null;
        this.cellHeights = null;
        this.backgrounds = null;
        this.outerBorderPen = null;
    }

    public GlyphTable(int n, int n2, int n3, int n4, StretchDimension stretchDimension, Color color, boolean bl) {
        this.this();
        this.border = n;
        this.cellPadding = n2;
        this.cellSpacing = n3;
        this.align = n4;
        this.stretchWidth = stretchDimension;
        this.noWrap = bl;
        if (color == null) {
            this.borderColorLight = Color.lightGray;
            this.borderColorDark = new Color(128, 128, 128);
        } else {
            this.borderColorLight = color;
            this.borderColorDark = color;
        }
    }

    private static class Cell {
        private int rowspan;
        private int colspan;
        private GlyphRoot root;
        private Color bgColor;
        private StretchDimension stretch;
        private int align;

        public String toString() {
            return "Cell " + this.align + ", " + this.stretch;
        }

        private Cell(int n, int n2, Color color, StretchDimension stretchDimension, int n3, GlyphRoot glyphRoot) {
            this.rowspan = n;
            this.colspan = n2;
            this.root = glyphRoot;
            this.bgColor = color;
            this.stretch = stretchDimension;
            this.align = n3;
        }
    }
}

