/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.build;

import com.tridium.html.canvas.build.BuildGlyphs;
import com.tridium.html.canvas.build.GlyphIterator;
import com.tridium.html.canvas.glyph.Glyph;
import com.tridium.html.canvas.glyph.GlyphLF;
import com.tridium.html.canvas.glyph.GlyphRoot;
import com.tridium.html.canvas.glyph.GlyphWord;
import java.util.ArrayList;
import java.util.Collections;

class LinefeedManager {
    private BuildGlyphs builder;

    void ensureLinefeed() {
        if (this.builder.idx < 0) {
            this.builder.linefeed();
        } else {
            GlyphIterator glyphIterator = new GlyphIterator(this.builder.currGlyph, this.builder.idx);
            Glyph glyph = glyphIterator.prev();
            if (!(glyph instanceof GlyphLF)) {
                this.builder.linefeed();
            }
        }
    }

    void ensureDoubleLinefeed() {
        if (this.builder.idx < 0) {
            this.builder.linefeed();
            this.builder.linefeed();
        } else if (this.builder.idx == 0) {
            this.builder.linefeed();
            Glyph glyph = this.builder.currGlyph.getGlyph(0);
            if (glyph instanceof GlyphWord) {
                this.builder.linefeed();
            }
        } else {
            GlyphIterator glyphIterator = new GlyphIterator(this.builder.currGlyph, this.builder.idx);
            Glyph glyph = glyphIterator.prev();
            if (glyph instanceof GlyphLF) {
                glyph = glyphIterator.prev();
                if (glyph instanceof GlyphWord) {
                    this.builder.linefeed();
                }
            } else {
                this.builder.linefeed();
                if (glyph instanceof GlyphWord) {
                    this.builder.linefeed();
                }
            }
        }
    }

    void trim() {
        GlyphRoot glyphRoot = this.builder.glyphRoot;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        GlyphIterator glyphIterator = new GlyphIterator(glyphRoot, 0);
        Glyph glyph = glyphIterator.next();
        while (glyph != null && glyph instanceof GlyphLF) {
            arrayList.add(new Integer(glyphIterator.idx() - 1));
            glyph = glyphIterator.next();
        }
        glyphIterator = new GlyphIterator(glyphRoot, glyphRoot.size() - 1);
        glyph = glyphIterator.prev();
        while (glyph != null && glyph instanceof GlyphLF) {
            Integer n = new Integer(glyphIterator.idx() + 1);
            if (arrayList.indexOf(n) == -1) {
                arrayList.add(new Integer(glyphIterator.idx() + 1));
            }
            glyph = glyphIterator.prev();
        }
        Collections.sort(arrayList);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            Integer n2 = (Integer)arrayList.get(n);
            glyphRoot.remove(n2);
            --n;
        }
    }

    LinefeedManager(BuildGlyphs buildGlyphs) {
        this.builder = buildGlyphs;
    }
}

