/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.build;

import com.tridium.html.canvas.BHtmlCanvas;
import com.tridium.html.canvas.build.BuildGlyphs;
import com.tridium.html.canvas.glyph.GlyphAlign;
import com.tridium.html.canvas.glyph.GlyphRoot;
import com.tridium.html.canvas.glyph.GlyphTable;
import com.tridium.html.canvas.glyph.StretchDimension;
import com.tridium.html.util.HtmlNode;
import com.tridium.html.util.HtmlTag;
import java.awt.Color;
import java.awt.Dimension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BuildTable {
    private BHtmlCanvas canvas;

    public GlyphTable build(HtmlTag htmlTag) {
        int n = htmlTag.getIntegerAttribute("BORDER", 0);
        int n2 = htmlTag.getIntegerAttribute("CELLPADDING", 1);
        int n3 = htmlTag.getIntegerAttribute("CELLSPACING", 2);
        int n4 = GlyphAlign.decode(htmlTag.getAttribute("ALIGN"), 0);
        Color color = htmlTag.getColorAttribute("BORDERCOLOR", null);
        boolean bl = htmlTag.hasAttribute("NOWRAP");
        String string = htmlTag.getAttribute("WIDTH");
        StretchDimension stretchDimension = string == null ? null : new StretchDimension(string);
        GlyphTable glyphTable = new GlyphTable(n, n2, n3, n4, stretchDimension, color, bl);
        Dimension dimension = this.getTableDimension(htmlTag);
        glyphTable.setSize(dimension.height, dimension.width);
        this.loadTable(dimension.height, dimension.width, htmlTag, glyphTable);
        return glyphTable;
    }

    private final int countRowCells(HtmlTag htmlTag) {
        int n = 0;
        int n2 = 0;
        while (n2 < htmlTag.size()) {
            HtmlTag htmlTag2;
            String string;
            HtmlNode htmlNode = htmlTag.get(n2);
            if (htmlNode instanceof HtmlTag && ((string = (htmlTag2 = (HtmlTag)htmlNode).getTagName()).equals("TD") || string.equals("TH"))) {
                int n3 = htmlTag2.getIntegerAttribute("COLSPAN", 1);
                n += n3;
            }
            ++n2;
        }
        return n;
    }

    private final Dimension getTableDimension(HtmlTag htmlTag) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < htmlTag.size()) {
            HtmlTag htmlTag2;
            String string;
            HtmlNode htmlNode = htmlTag.get(n3);
            if (htmlNode instanceof HtmlTag && (string = (htmlTag2 = (HtmlTag)htmlNode).getTagName()).equals("TR")) {
                ++n;
                n2 = Math.max(n2, this.countRowCells(htmlTag2));
            }
            ++n3;
        }
        return new Dimension(n2, n);
    }

    private final void setCell(int n, int n2, int n3, int n4, Color color, StretchDimension stretchDimension, int n5, HtmlTag htmlTag, GlyphTable glyphTable) {
        boolean bl = htmlTag.getTagName().equals("TH");
        boolean bl2 = false;
        if (glyphTable.noWrap || htmlTag.hasAttribute("NOWRAP")) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        BuildGlyphs buildGlyphs = new BuildGlyphs(this.canvas);
        GlyphRoot glyphRoot = buildGlyphs.makeGlyphs(htmlTag, bl, bl3);
        glyphTable.setCell(n, n2, n3, n4, color, stretchDimension, n5, glyphRoot);
    }

    private final void loadTableCells(int n, int n2, HtmlTag htmlTag, int n3, GlyphTable glyphTable, boolean[][] blArray, Color color, int n4) {
        int n5 = 0;
        int n6 = 0;
        while (n6 < htmlTag.size()) {
            HtmlTag htmlTag2;
            String string;
            HtmlNode htmlNode = htmlTag.get(n6);
            if (htmlNode instanceof HtmlTag && ((string = (htmlTag2 = (HtmlTag)htmlNode).getTagName()).equals("TD") || string.equals("TH"))) {
                int n7;
                Color color2 = htmlTag2.getAttribute("BGCOLOR") == null ? color : htmlTag2.getColorAttribute("BGCOLOR", null);
                int n8 = htmlTag2.getIntegerAttribute("COLSPAN", 1);
                int n9 = htmlTag2.getIntegerAttribute("ROWSPAN", 1);
                String string2 = htmlTag2.getAttribute("WIDTH");
                StretchDimension stretchDimension = string2 == null ? null : new StretchDimension(string2);
                int n10 = 0;
                String string3 = htmlTag2.getAttribute("ALIGN");
                if (string3 == null) {
                    n10 = n4;
                } else {
                    n7 = htmlTag2.getTagName().equals("TH");
                    n10 = GlyphAlign.decode(string3, n7);
                }
                n9 = Math.min(n9, n - n3);
                while (n5 <= n2 && blArray[n3][n5]) {
                    ++n5;
                }
                this.setCell(n3, n5, n9, n8, color2, stretchDimension, n10, htmlTag2, glyphTable);
                n7 = n3;
                while (n7 < n3 + n9) {
                    int n11 = n5;
                    while (n11 < n5 + n8) {
                        if (n7 < n && n11 < n2) {
                            blArray[n7][n11] = true;
                        }
                        ++n11;
                    }
                    ++n7;
                }
                ++n5;
            }
            ++n6;
        }
    }

    private final void loadTable(int n, int n2, HtmlTag htmlTag, GlyphTable glyphTable) {
        int n3 = 0;
        boolean[][] blArray = new boolean[n][n2];
        int n4 = 0;
        while (n4 < htmlTag.size()) {
            HtmlTag htmlTag2;
            String string;
            HtmlNode htmlNode = htmlTag.get(n4);
            if (htmlNode instanceof HtmlTag && (string = (htmlTag2 = (HtmlTag)htmlNode).getTagName()).equals("TR")) {
                Color color = htmlTag2.getColorAttribute("BGCOLOR", null);
                int n5 = GlyphAlign.decode(htmlTag2.getAttribute("ALIGN"), 0);
                this.loadTableCells(n, n2, htmlTag2, n3, glyphTable, blArray, color, n5);
                ++n3;
            }
            ++n4;
        }
    }

    private final /* synthetic */ void this() {
        this.canvas = null;
    }

    public BuildTable(BHtmlCanvas bHtmlCanvas) {
        this.this();
        this.canvas = bHtmlCanvas;
    }
}

