/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.ui.terminal;

import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.ui.terminal.BInfinityVirtualTerminal;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.text.TextController;

public class InfinityVt100TextController
extends TextController {
    BInfinityVirtualTerminal manager;

    public void keyPressed(BKeyEvent bKeyEvent) {
        char c = bKeyEvent.getKeyChar();
        if (bKeyEvent.isControlDown() && c == '\u0014') {
            return;
        }
        bKeyEvent.consume();
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        int n = bKeyEvent.getKeyCode();
        char c = bKeyEvent.getKeyChar();
        if (c == (char)-1) {
            if (n == 112) {
                this.manager.exec("\u001bOP");
            }
            if (n == 113) {
                this.manager.exec("\u001bOQ");
            }
            if (n == 114) {
                this.manager.exec("\u001bOR");
            }
            if (n == 115) {
                this.manager.exec("\u001bOS");
            }
            if (n == 123) {
                this.manager.exec(Vt100Const.F12);
            } else if (n == 34) {
                if (this.manager.net.getPageUpPageDown()) {
                    this.manager.exec(String.valueOf("\u001b[6~"));
                } else {
                    this.manager.exec(String.valueOf(Vt100Const.CURSOR_PAGE_DOWN));
                }
            } else if (n == 33) {
                if (this.manager.net.getPageUpPageDown()) {
                    this.manager.exec(String.valueOf("\u001b[5~"));
                } else {
                    this.manager.exec(String.valueOf(Vt100Const.CURSOR_PAGE_UP));
                }
            } else if (n == 37) {
                this.manager.exec("\u001b[D");
            } else if (n == 38) {
                this.manager.exec("\u001b[A");
            } else if (n == 39) {
                this.manager.exec("\u001b[C");
            } else if (n == 40) {
                this.manager.exec("\u001b[B");
            } else if (n == 9 && bKeyEvent.isShiftDown()) {
                this.manager.exec("\u001b\t");
            }
        }
        bKeyEvent.consume();
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
        if (bKeyEvent.isAltDown()) {
            return;
        }
        char c = bKeyEvent.getKeyChar();
        if (bKeyEvent.isControlDown()) {
            if (c == '\u001a') {
                bKeyEvent.consume();
                this.manager.exec("\u001a");
                return;
            }
            if (c == '\u0003' || c == '\u0014') {
                super.keyTyped(bKeyEvent);
                return;
            }
        }
        if (bKeyEvent.isShiftDown() && c == '\t') {
            this.manager.exec("\u001b\t");
            bKeyEvent.consume();
            return;
        }
        this.manager.exec(String.valueOf(c));
        bKeyEvent.consume();
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.getEditor().setMouseCursor(MouseCursor.normal);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.getEditor().setMouseCursor(MouseCursor.normal);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.getEditor().requestFocus();
        this.getEditor().moveCaretPosition(this.manager.getCaretPosition());
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
    }

    public InfinityVt100TextController(BInfinityVirtualTerminal bInfinityVirtualTerminal) {
        this.manager = bInfinityVirtualTerminal;
    }
}

