/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.ui.terminal;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.BInfinityLine;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.ui.terminal.InfinityVt100TextController;
import com.tridium.andoverInfinity.ui.terminal.InfinityVt100TextModel;
import com.tridium.andoverInfinity.ui.terminal.InfinityVt100TextParser;
import com.tridium.util.EscUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.io.ByteBuffer;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.space.BSpace;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BInfinityVirtualTerminal
extends BWbComponentView
implements Vt100Const {
    public static final Type TYPE;
    static final UiLexicon lexicon;
    static BOrd backupDir;
    static BOrd backupFile;
    boolean alive;
    boolean bufferChanged;
    BufferMonitor bufferMonitor;
    Thread bufMonThread;
    BTextEditorPane console;
    StartConsole cmdStartConsole;
    StopConsole cmdStopConsole;
    RestoreCommand cmdRestore;
    BackupCommand cmdBackup;
    AbortCommand cmdAbort;
    BInfinityNetwork net;
    boolean consoleJobComplete;
    String[] lines;
    String[] lineFormats;
    InfinityVt100TextController controller;
    InfinityVt100TextModel model;
    Position caretPosition;
    static /* synthetic */ Class class$com$tridium$andoverInfinity$ui$terminal$BInfinityVirtualTerminal;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.net = (BInfinityNetwork)bObject;
        this.registerForComponentEvents((BComponent)this.net);
        this.net.refresh();
    }

    public void deactivated() {
        if (this.cmdStopConsole.isEnabled()) {
            try {
                this.cmdStopConsole.doInvoke();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.alive = false;
        this.bufMonThread.interrupt();
        this.bufMonThread = null;
    }

    public void exec(String string) {
        string = string.replace('\n', '\r');
        try {
            if (this.net != null) {
                this.net.keystrokesCommand(BString.make((String)string));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        super.handleComponentEvent(bComponentEvent);
        if (bComponentEvent.getSourceComponent() == this.net) {
            bComponentEvent.getId();
            if (bComponentEvent.getId() == 5) {
                if (bComponentEvent.getSlotName() == "backupModeDone") {
                    BBlob bBlob = null;
                    if (bComponentEvent.getValue() instanceof BBlob) {
                        bBlob = (BBlob)bComponentEvent.getValue();
                    }
                    if (bBlob != null) {
                        byte[] byArray = bBlob.copyBytes();
                        System.out.println("blob size is " + byArray.length);
                        System.out.println(new String(byArray));
                        BFileSystem bFileSystem = BFileSystem.INSTANCE;
                        try {
                            BIFile bIFile = bFileSystem.makeFile(BInfinityVirtualTerminal.toFilePath(backupFile));
                            OutputStream outputStream = bIFile.getOutputStream();
                            outputStream.write(byArray);
                            outputStream.close();
                            outputStream = null;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else {
                        System.out.println("backup  blob is null");
                    }
                    System.out.println("backupModeDone");
                    this.setCommandsToNormal();
                } else if (bComponentEvent.getSlotName() == "reloadModeDone") {
                    System.out.println("backupModeDone");
                    this.setCommandsToNormal();
                } else if (bComponentEvent.getSlotName() == "terminalUpdated") {
                    BInfinityLine bInfinityLine = (BInfinityLine)bComponentEvent.getValue();
                    this.caretPosition = new Position(bInfinityLine.getNewLineNumber(), bInfinityLine.getNewColumnNumber());
                    try {
                        this.lines[bInfinityLine.getPreviousLineNumber()] = bInfinityLine.getLineText();
                        this.lineFormats[bInfinityLine.getPreviousLineNumber()] = bInfinityLine.getLineFormat();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.lines[bInfinityLine.getPreviousLineNumber()] = bInfinityLine.getLineText().substring(0, 80);
                        this.lineFormats[bInfinityLine.getPreviousLineNumber()] = bInfinityLine.getLineFormat().substring(0, 80);
                    }
                    this.bufferChanged = true;
                }
            }
        }
    }

    protected void repaintBuffer() {
        this.model.setText(this.lines, this.lineFormats);
        this.console.getEditor().moveCaretPosition(this.caretPosition);
    }

    private final void setCommandsToNormal() {
        this.cmdStartConsole.setEnabled(true);
        this.cmdStopConsole.setEnabled(false);
        this.cmdBackup.setEnabled(true);
        this.cmdRestore.setEnabled(true);
        this.cmdAbort.setEnabled(false);
    }

    public static FilePath toFilePath(BOrd bOrd) {
        OrdQuery[] ordQueryArray = bOrd.parse();
        int n = 0;
        while (n < ordQueryArray.length) {
            if (ordQueryArray[n] instanceof FilePath) {
                return (FilePath)ordQueryArray[n];
            }
            ++n;
        }
        throw new IllegalStateException();
    }

    public Position getCaretPosition() {
        return this.caretPosition;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.alive = false;
        this.bufferChanged = false;
        this.cmdStartConsole = new StartConsole((BWidget)this);
        this.cmdStopConsole = new StopConsole((BWidget)this);
        this.cmdRestore = new RestoreCommand((BWidget)this);
        this.cmdBackup = new BackupCommand((BWidget)this);
        this.cmdAbort = new AbortCommand((BWidget)this);
        this.consoleJobComplete = false;
        this.lines = new String[24];
        this.lineFormats = new String[24];
    }

    public BInfinityVirtualTerminal() {
        this.this();
        int n = 0;
        while (n < 24) {
            this.lines[n] = "                                                                                ";
            this.lineFormats[n] = "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN";
            ++n;
        }
        this.console = new BTextEditorPane("", 24, 80, false);
        this.console.setBorderPolicy(BScrollBarPolicy.always);
        this.console.getEditor().setCaretBlinking(true);
        this.controller = new InfinityVt100TextController(this);
        this.model = new InfinityVt100TextModel();
        this.console.getEditor().setController((TextController)this.controller);
        this.console.getEditor().setModel((TextModel)this.model);
        this.console.getEditor().setParser((TextParser)new InfinityVt100TextParser());
        this.console.getEditor().getOptions().getColorCoding().setForeground(BColor.black);
        this.console.getEditor().getOptions().getColorCoding().setKeyword(BColor.cornflowerBlue);
        this.console.getEditor().getOptions().getColorCoding().setNumberLiteral(BColor.white);
        this.console.getEditor().getOptions().getColorCoding().setBracket(BColor.darkGrey);
        this.setTransferWidget((BTransferWidget)this.console.getEditor());
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnCount(5);
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdStartConsole));
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdStopConsole));
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdBackup));
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdRestore));
        bGridPane.add(null, (BValue)new BButton((Command)this.cmdAbort));
        this.cmdStartConsole.setEnabled(true);
        this.cmdStopConsole.setEnabled(false);
        this.cmdBackup.setEnabled(true);
        this.cmdRestore.setEnabled(true);
        this.cmdAbort.setEnabled(false);
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.console, new BLabel("Infinity VT100 Terminal Interface", BFont.make((String)"bold italic 20pt Times New Roman")), BBorder.DEFAULT);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)bBorderPane);
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, 10.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)bEdgePane);
        this.registerForComponentEvents((BComponent)this.console);
        if (this.bufferMonitor == null) {
            this.bufferMonitor = new BufferMonitor();
        }
        this.bufMonThread = new Thread((Runnable)this.bufferMonitor, "infinBufMon");
        this.alive = true;
        this.bufMonThread.start();
        this.console.getEditor().requestFocus();
    }

    static {
        Class clazz = class$com$tridium$andoverInfinity$ui$terminal$BInfinityVirtualTerminal;
        if (clazz == null) {
            clazz = class$com$tridium$andoverInfinity$ui$terminal$BInfinityVirtualTerminal = BInfinityVirtualTerminal.class("[Lcom.tridium.andoverInfinity.ui.terminal.BInfinityVirtualTerminal;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$andoverInfinity$ui$terminal$BInfinityVirtualTerminal;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$andoverInfinity$ui$terminal$BInfinityVirtualTerminal = BInfinityVirtualTerminal.class("[Lcom.tridium.andoverInfinity.ui.terminal.BInfinityVirtualTerminal;", false);
        }
        lexicon = new UiLexicon(clazz2);
        backupDir = null;
        backupFile = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class StopConsole
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            BInfinityVirtualTerminal.this.net.setTerminalModeActive(BBoolean.FALSE);
            BInfinityVirtualTerminal.this.cmdStartConsole.setEnabled(true);
            this.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdBackup.setEnabled(true);
            BInfinityVirtualTerminal.this.cmdRestore.setEnabled(true);
            BInfinityVirtualTerminal.this.cmdAbort.setEnabled(false);
            return null;
        }

        StopConsole(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "stopVirtualTerminal");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class StartConsole
    extends Command {
        BWidget owner;

        public CommandArtifact doInvoke() throws Exception {
            BInfinityVirtualTerminal.this.net.setTerminalModeActive(BBoolean.TRUE);
            this.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdStopConsole.setEnabled(true);
            BInfinityVirtualTerminal.this.cmdBackup.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdRestore.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdAbort.setEnabled(false);
            this.owner.requestFocus();
            return null;
        }

        StartConsole(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "startVirtualTerminal");
            this.owner = bWidget;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BackupCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            BOrd bOrd;
            backupDir = BInfinityVirtualTerminal.this.net.getRestoreFile();
            BFileChooser bFileChooser = BFileChooser.makeSave((BWidget)this.getOwner());
            bFileChooser.setCurrentDirectory(backupDir);
            bFileChooser.addFilter((IFileFilter)new ExtFileFilter("dmp Files", new String[]{"txt", "TXT", "dmp", "DMP"}));
            BFileSystem bFileSystem = BFileSystem.INSTANCE;
            if (bFileSystem != null) {
                bFileChooser.setSpaces(new BSpace[]{bFileSystem});
            }
            if ((bOrd = bFileChooser.show()) == null) {
                return null;
            }
            backupDir = bFileChooser.getCurrentDirectory();
            backupFile = bOrd;
            BInfinityVirtualTerminal.this.net.backupModeActivate();
            BInfinityVirtualTerminal.this.cmdStopConsole.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdStartConsole.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdRestore.setEnabled(false);
            this.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdAbort.setEnabled(true);
            BInfinityVirtualTerminal.this.net.setRestoreFile(bOrd);
            return null;
        }

        BackupCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "backupControllerCommand");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RestoreCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            BufferedReader bufferedReader;
            ByteBuffer byteBuffer;
            InputStream inputStream;
            Object object;
            BOrd bOrd;
            BFileChooser bFileChooser;
            backupDir = BInfinityVirtualTerminal.this.net.getRestoreFile();
            if (backupDir == null) {
                bFileChooser = new FilePath("!infinity_backups");
                backupDir = BOrd.make((OrdQuery)bFileChooser);
            }
            bFileChooser = BFileChooser.makeSave((BWidget)this.getOwner());
            bFileChooser.setCurrentDirectory(backupDir);
            bFileChooser.setConfirmOverwrite(false);
            bFileChooser.addFilter((IFileFilter)new ExtFileFilter("dmp Files", new String[]{"txt", "TXT", "dmp", "DMP"}));
            BFileSystem bFileSystem = BFileSystem.INSTANCE;
            if (bFileSystem != null) {
                bFileChooser.setSpaces(new BSpace[]{bFileSystem});
            }
            if ((bOrd = bFileChooser.show()) == null) {
                return null;
            }
            BInfinityVirtualTerminal.this.net.getComponentSpace().sync();
            BInfinityVirtualTerminal.this.net.lease(2, 60000L);
            try {
                object = (BIFile)bOrd.resolve().get();
                inputStream = object.getInputStream();
                byteBuffer = new ByteBuffer(inputStream.available());
                byteBuffer.readToEnd(inputStream);
                bufferedReader = new BufferedReader(new InputStreamReader(object.getInputStream()));
            }
            catch (UnresolvedException unresolvedException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            BInfinityVirtualTerminal.this.net.setRestoreFile(bOrd);
            object = this.removeUnneededLines(bufferedReader);
            System.out.println(((StringBuffer)object).toString());
            inputStream = BFileSystem.INSTANCE;
            byteBuffer = BInfinityVirtualTerminal.toFilePath(bOrd);
            BIFile bIFile = inputStream.makeFile(new FilePath(byteBuffer.getBody() + ".scrubbed"));
            this.writeFile(bIFile, ((StringBuffer)object).toString().getBytes());
            BBlob bBlob = BBlob.make((byte[])((StringBuffer)object).toString().getBytes());
            BInfinityVirtualTerminal.this.net.reload(bBlob);
            BInfinityVirtualTerminal.this.cmdStartConsole.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdStopConsole.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdBackup.setEnabled(false);
            this.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdAbort.setEnabled(true);
            return null;
        }

        private final void writeFile(BIFile bIFile, byte[] byArray) {
            try {
                OutputStream outputStream = bIFile.getOutputStream();
                outputStream.write(byArray);
                outputStream.close();
                outputStream = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private final StringBuffer removeUnneededLines(BufferedReader bufferedReader) throws Exception {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String string;
                block2: while ((string = bufferedReader.readLine()) != null) {
                    String string2;
                    StringTokenizer stringTokenizer;
                    if (string.length() == 0) {
                        stringBuffer.append("\n");
                        continue;
                    }
                    if (string.charAt(0) == '\'' || (stringTokenizer = new StringTokenizer(string, ":")).countTokens() < 1) continue;
                    if (string.startsWith("EndOfReload")) {
                        stringBuffer.append(string + '\n');
                        break;
                    }
                    String string3 = EscUtil.slot.escape(stringTokenizer.nextToken().trim());
                    String string4 = lexicon.get("Section." + string3);
                    if (string4 == null) {
                        throw new Exception("lexicon entry missing:Section." + string3);
                    }
                    if (string4.startsWith("Exclude")) {
                        string2 = lexicon.get("Section." + string3 + "End");
                        if (string2 == null) {
                            throw new Exception("lexicon entry missing:Section." + string3 + "End");
                        }
                        this.excludeSection(bufferedReader, string3, string2);
                        continue;
                    }
                    stringBuffer.append(string).append("\n");
                    string2 = lexicon.get("Section." + string3 + "End");
                    if (string2 == null) {
                        throw new Exception("lexicon entry missing:Section." + string3 + "End");
                    }
                    while (true) {
                        if ((string = bufferedReader.readLine()).length() == 0) {
                            stringBuffer.append("\n");
                            continue;
                        }
                        if (string.charAt(0) == '\'') continue;
                        if (string.trim().startsWith(string2)) {
                            stringBuffer.append(string).append("\n");
                            continue block2;
                        }
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string.trim(), ":");
                        if (!stringTokenizer2.hasMoreTokens()) continue;
                        String string5 = EscUtil.slot.escape(stringTokenizer2.nextToken().trim());
                        String string6 = lexicon.get(string3 + '.' + string5);
                        System.out.println(string3 + '.' + string5 + '=' + string6);
                        if (string6 == null || !string6.equalsIgnoreCase("Exclude")) {
                            stringBuffer.append(string).append("\n");
                            if (!string5.equalsIgnoreCase("Code")) continue;
                            while (true) {
                                if ((string = bufferedReader.readLine()).length() == 0) {
                                    stringBuffer.append("\n");
                                    continue;
                                }
                                if (string.charAt(0) == '\'') continue;
                                stringBuffer.append(string).append("\n");
                                if (string.trim().startsWith("EndCode")) break;
                            }
                            continue;
                        }
                        if (!string5.equalsIgnoreCase("Code")) continue;
                        this.excludeSection(bufferedReader, "Code", "EndCode");
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return stringBuffer;
        }

        private final void excludeSection(BufferedReader bufferedReader, String string, String string2) throws IOException {
            String string3;
            System.out.println("exludeSection:" + string + '>' + string2);
            while (!(string3 = bufferedReader.readLine().trim()).startsWith(string2)) {
            }
        }

        RestoreCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "restoreControllerCommand");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class AbortCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            BInfinityVirtualTerminal.this.net.abortReload();
            return null;
        }

        AbortCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)lexicon, "abortCommand");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class BufferMonitor
    implements Runnable {
        public final void run() {
            BInfinityVirtualTerminal.this.alive = true;
            while (BInfinityVirtualTerminal.this.alive) {
                try {
                    if (BInfinityVirtualTerminal.this.bufferChanged) {
                        BInfinityVirtualTerminal.this.bufferChanged = false;
                        BInfinityVirtualTerminal.this.repaintBuffer();
                        continue;
                    }
                    Thread.sleep(100L);
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        BufferMonitor() {
        }
    }
}

