/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.BInfinityCommunicator;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinitySuccessResponse;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import java.io.BufferedReader;
import java.io.IOException;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BInfinityReloadLineRequest
extends BDdfRequest
implements Vt100Const,
RequiresNetworkAccess,
BIDdfCustomRequest {
    public static final Property responseTimeout = BInfinityReloadLineRequest.newProperty((int)0, (BValue)BRelTime.make((long)200L), null);
    public static final Property remainingRetryCount = BInfinityReloadLineRequest.newProperty((int)0, (int)0, null);
    public static final Type TYPE;
    BInfinityNetwork network;
    BufferedReader in;
    String nextLine;
    static /* synthetic */ Class class$com$tridium$andoverInfinity$comm$req$BInfinityReloadLineRequest;

    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime bRelTime) {
        this.set(responseTimeout, (BValue)bRelTime, null);
    }

    public int getRemainingRetryCount() {
        return this.getInt(remainingRetryCount);
    }

    public void setRemainingRetryCount(int n) {
        this.setInt(remainingRetryCount, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        int n = this.network.getScreen().getMode();
        this.network.getLog().trace("BInfinityReloadLineRequest.processReceive(), mode=" + Vt100Const.cursorModes[n]);
        switch (n) {
            case 140: {
                int n2 = this.network.getScreen().getCursorLine() - 1;
                String string = this.network.getScreen().getFullLine(n2);
                this.network.getLog().error(this.nextLine + ':' + string);
                throw new DdfResponseException(this.nextLine + ':' + string);
            }
            case 4: {
                return new BInfinitySuccessResponse();
            }
        }
        this.network.getLog().error("illegal mode on infinet save ,mode=" + Vt100Const.cursorModes[n]);
        throw new DdfResponseException("illegal mode on infinet save ,mode=" + Vt100Const.cursorModes[n]);
    }

    public byte[] toByteArray() {
        return this.nextLine.getBytes();
    }

    public void processErrorResponse(DdfResponseException ddfResponseException) {
        this.network.getLog().error("BInfinityReloadRequest:" + ddfResponseException.getMessage());
        this.processTimeout();
    }

    public void processLateResponse(BIDdfResponse bIDdfResponse) {
    }

    public void processResponse(BIDdfResponse bIDdfResponse) {
        System.out.println("BInfinityReloadRequest:processResponse");
        this.network.setReloadModeActive(false);
        this.network.fireBackupModeDone((BValue)BString.make((String)"done"));
    }

    public void processTimeout() {
        String string;
        int n = this.network.getScreen().getMode();
        switch (n) {
            case 4: {
                System.out.println("BInfinityReloadRequest:processTimeout while CURSOR_IS_IN_COMMAND_LINE_AREA");
                this.network.setReloadModeActive(false);
                this.network.fireBackupModeDone((BValue)BString.make((String)"done"));
                return;
            }
        }
        try {
            string = this.in.readLine();
        }
        catch (IOException iOException) {
            this.network.getLog().error("IOException reading dump file buffer");
            iOException.printStackTrace();
            return;
        }
        if (string == null) {
            this.network.setReloadModeActive(false);
            this.network.fireBackupModeDone((BValue)BString.make((String)"done"));
        } else {
            BInfinityReloadLineRequest bInfinityReloadLineRequest = new BInfinityReloadLineRequest(string + '\n', this.in);
            ((BInfinityCommunicator)this.network.getCommunicator()).communicate((BIDdfRequest)bInfinityReloadLineRequest);
        }
    }

    public void setNetwork(BInfinityNetwork bInfinityNetwork) {
        this.network = bInfinityNetwork;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    BInfinityReloadLineRequest(String string, BufferedReader bufferedReader) {
        this.nextLine = string;
        this.in = bufferedReader;
    }

    static {
        Class clazz = class$com$tridium$andoverInfinity$comm$req$BInfinityReloadLineRequest;
        if (clazz == null) {
            clazz = class$com$tridium$andoverInfinity$comm$req$BInfinityReloadLineRequest = BInfinityReloadLineRequest.class("[Lcom.tridium.andoverInfinity.comm.req.BInfinityReloadLineRequest;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

