/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity;

import com.tridium.andoverInfinity.BInfinetDevice;
import com.tridium.andoverInfinity.BInfinityDeviceFolder;
import com.tridium.andoverInfinity.BInfinityNetworkDevice;
import com.tridium.andoverInfinity.comm.BInfinityCommunicator;
import com.tridium.andoverInfinity.comm.BInfinityLine;
import com.tridium.andoverInfinity.comm.BVt100;
import com.tridium.andoverInfinity.comm.CursorPosition;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.BInfinityInitializeScreenRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityKeystrokeRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityPollForControllerInfoRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityReloadInfinetRequest;
import com.tridium.andoverInfinity.comm.req.BInfinitySaveInfinetRequest;
import com.tridium.andoverInfinity.comm.req.BInfinitySetTimeRequest;
import com.tridium.andoverInfinity.discover.BInfinityDeviceDiscoveryPreferences;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.discover.BDdfDiscoveryPreferences;
import com.tridium.ddfSerial.BDdfSerialNetwork;
import com.tridium.ddfSerial.comm.BDdfSerialCommunicator;
import com.tridium.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BInfinityNetwork
extends BDdfSerialNetwork {
    public static final Property communicator = BInfinityNetwork.newProperty((int)0, (BValue)new BInfinityCommunicator(), null);
    public static final Property discoveryPreferences = BInfinityNetwork.newProperty((int)0, (BValue)new BInfinityDeviceDiscoveryPreferences(), null);
    public static final Property automaticallySetTime = BInfinityNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property syncTimeFrequency = BInfinityNetwork.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1)));
    public static final Property restoreFile = BInfinityNetwork.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property networkDevice = BInfinityNetwork.newProperty((int)0, (BValue)new BInfinityNetworkDevice(), null);
    public static final Property backupModeActive = BInfinityNetwork.newProperty((int)6, (boolean)false, null);
    public static final Property pageUpPageDown = BInfinityNetwork.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"use esc seq", (String)"use control code"));
    public static final Action syncTime = BInfinityNetwork.newAction((int)0, null);
    public static final Action refresh = BInfinityNetwork.newAction((int)0, null);
    public static final Action setTerminalModeActive = BInfinityNetwork.newAction((int)4, (BValue)BBoolean.FALSE, null);
    public static final Action backupModeActivate = BInfinityNetwork.newAction((int)4, null);
    public static final Action reload = BInfinityNetwork.newAction((int)2052, (BValue)BBlob.DEFAULT, null);
    public static final Action abortReload = BInfinityNetwork.newAction((int)4, null);
    public static final Action retrieveNetworkDeviceInfo = BInfinityNetwork.newAction((int)0, null);
    public static final Action dumpScreenBuffer = BInfinityNetwork.newAction((int)0, null);
    public static final Action keystrokesCommand = BInfinityNetwork.newAction((int)2052, (BValue)BString.make((String)""), null);
    public static final Action getMode = BInfinityNetwork.newAction((int)0, null);
    public static final Action loadScreenBufferFromFile = BInfinityNetwork.newAction((int)2052, (BValue)BBlob.DEFAULT, null);
    public static final Action saveScreenBufferToFile = BInfinityNetwork.newAction((int)2052, null);
    public static final Topic terminalUpdated = BInfinityNetwork.newTopic((int)4, null);
    public static final Topic backupModeDone = BInfinityNetwork.newTopic((int)4, null);
    public static final Topic reloadModeDone = BInfinityNetwork.newTopic((int)4, null);
    public static final Type TYPE;
    private boolean connected;
    private BVt100 screen;
    private Object stringLock;
    private String keystrokes;
    private boolean terminalModeActive;
    private boolean reloadModeActive;
    private Clock.Ticket timeSyncTicket;
    private boolean shouldAbortReload;
    static /* synthetic */ Class class$com$tridium$andoverInfinity$BInfinityNetwork;

    public BValue getCommunicator() {
        return this.get(communicator);
    }

    public void setCommunicator(BValue bValue) {
        this.set(communicator, bValue, null);
    }

    public BDdfDiscoveryPreferences getDiscoveryPreferences() {
        return (BDdfDiscoveryPreferences)this.get(discoveryPreferences);
    }

    public void setDiscoveryPreferences(BDdfDiscoveryPreferences bDdfDiscoveryPreferences) {
        this.set(discoveryPreferences, (BValue)bDdfDiscoveryPreferences, null);
    }

    public boolean getAutomaticallySetTime() {
        return this.getBoolean(automaticallySetTime);
    }

    public void setAutomaticallySetTime(boolean bl) {
        this.setBoolean(automaticallySetTime, bl, null);
    }

    public BRelTime getSyncTimeFrequency() {
        return (BRelTime)this.get(syncTimeFrequency);
    }

    public void setSyncTimeFrequency(BRelTime bRelTime) {
        this.set(syncTimeFrequency, (BValue)bRelTime, null);
    }

    public BOrd getRestoreFile() {
        return (BOrd)this.get(restoreFile);
    }

    public void setRestoreFile(BOrd bOrd) {
        this.set(restoreFile, (BValue)bOrd, null);
    }

    public BInfinityNetworkDevice getNetworkDevice() {
        return (BInfinityNetworkDevice)this.get(networkDevice);
    }

    public void setNetworkDevice(BInfinityNetworkDevice bInfinityNetworkDevice) {
        this.set(networkDevice, (BValue)bInfinityNetworkDevice, null);
    }

    public boolean getBackupModeActive() {
        return this.getBoolean(backupModeActive);
    }

    public void setBackupModeActive(boolean bl) {
        this.setBoolean(backupModeActive, bl, null);
    }

    public boolean getPageUpPageDown() {
        return this.getBoolean(pageUpPageDown);
    }

    public void setPageUpPageDown(boolean bl) {
        this.setBoolean(pageUpPageDown, bl, null);
    }

    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    public void refresh() {
        this.invoke(refresh, null, null);
    }

    public void setTerminalModeActive(BBoolean bBoolean) {
        this.invoke(setTerminalModeActive, (BValue)bBoolean, null);
    }

    public void backupModeActivate() {
        this.invoke(backupModeActivate, null, null);
    }

    public void reload(BBlob bBlob) {
        this.invoke(reload, (BValue)bBlob, null);
    }

    public void abortReload() {
        this.invoke(abortReload, null, null);
    }

    public void retrieveNetworkDeviceInfo() {
        this.invoke(retrieveNetworkDeviceInfo, null, null);
    }

    public void dumpScreenBuffer() {
        this.invoke(dumpScreenBuffer, null, null);
    }

    public void keystrokesCommand(BString bString) {
        this.invoke(keystrokesCommand, (BValue)bString, null);
    }

    public void getMode() {
        this.invoke(getMode, null, null);
    }

    public void loadScreenBufferFromFile(BBlob bBlob) {
        this.invoke(loadScreenBufferFromFile, (BValue)bBlob, null);
    }

    public BBlob saveScreenBufferToFile() {
        return (BBlob)this.invoke(saveScreenBufferToFile, null, null);
    }

    public void fireTerminalUpdated(BValue bValue) {
        this.fire(terminalUpdated, bValue, null);
    }

    public void fireBackupModeDone(BValue bValue) {
        this.fire(backupModeDone, bValue, null);
    }

    public void fireReloadModeDone(BValue bValue) {
        this.fire(reloadModeDone, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "andoverInfinity");
    }

    public void started() throws Exception {
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.setFlags((Slot)ping, 4);
        this.screen = new BVt100();
        this.screen.setNetwork(this);
        if (this.getAutomaticallySetTime()) {
            this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSyncTimeFrequency(), (Action)syncTime, null);
        }
        super.started();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.refresh();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.timeSyncTicket != null) {
            this.timeSyncTicket.cancel();
        }
        this.timeSyncTicket = null;
    }

    public void changed(Property property, Context context) {
        if ((property == syncTimeFrequency || property == automaticallySetTime) && this.isRunning()) {
            if (this.timeSyncTicket != null) {
                this.timeSyncTicket.cancel();
            }
            if (this.getAutomaticallySetTime()) {
                this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSyncTimeFrequency(), (Action)syncTime, null);
            }
        }
        super.changed(property, context);
    }

    public final Type getDeviceType() {
        return BInfinetDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BInfinityDeviceFolder.TYPE;
    }

    public void doRefresh() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLog().isTraceOn()) {
            this.getNetwork().getLog().trace("doRefresh");
        }
        BInfinityInitializeScreenRequest bInfinityInitializeScreenRequest = new BInfinityInitializeScreenRequest(this);
        if (this.getDdfCommunicator() == null) {
            System.out.println("communicator is null");
        }
        try {
            this.getDdfCommunicator().communicate((BIDdfRequest)bInfinityInitializeScreenRequest);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doSetTerminalModeActive(BBoolean bBoolean) {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLog().isTraceOn()) {
            this.getNetwork().getLog().trace("doSetTerminalModeActive");
        }
        this.terminalModeActive = bBoolean.getBoolean();
    }

    public void doBackupModeActivate() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLog().isTraceOn()) {
            this.getNetwork().getLog().trace("doBackupModeActivate");
        }
        BInfinitySaveInfinetRequest bInfinitySaveInfinetRequest = new BInfinitySaveInfinetRequest();
        BDdfSerialCommunicator bDdfSerialCommunicator = (BDdfSerialCommunicator)this.getDdfCommunicator();
        bDdfSerialCommunicator.communicate((BIDdfRequest)bInfinitySaveInfinetRequest);
    }

    public void doReload(BBlob bBlob) {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLog().isTraceOn()) {
            this.getNetwork().getLog().trace("doReload");
        }
        System.out.println(new String(bBlob.copyBytes()));
        BInfinityReloadInfinetRequest bInfinityReloadInfinetRequest = new BInfinityReloadInfinetRequest();
        bInfinityReloadInfinetRequest.setFileContents(bBlob);
        this.getDdfCommunicator().communicate((BIDdfRequest)bInfinityReloadInfinetRequest);
    }

    public void doAbortReload() {
        this.setShouldAbortReload(true);
    }

    public void doKeystrokesCommand(BString bString) {
        if (this.getNetwork().getLog().isTraceOn()) {
            this.getNetwork().getLog().trace("doKeystrokesCommand");
        }
        System.out.println("doKeystrokes:" + bString.getString());
        if (this.terminalModeActive || this.getBackupModeActive() || this.reloadModeActive) {
            if (this.terminalModeActive) {
                System.out.println("doKeystrokesCommand:terminalModeActive");
            }
            if (this.getBackupModeActive()) {
                System.out.println("doKeystrokesCommand:backupModeActive");
            }
            if (this.reloadModeActive) {
                System.out.println("doKeystrokesCommand:reloadModeActive");
            }
            this.receiveKeystrokes(bString.getString());
            BInfinityKeystrokeRequest bInfinityKeystrokeRequest = new BInfinityKeystrokeRequest(this.getKeystrokes().getBytes());
            this.getDdfCommunicator().communicate((BIDdfRequest)bInfinityKeystrokeRequest);
        }
    }

    public void doRetrieveNetworkDeviceInfo() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (this.getNetwork().getLog().isTraceOn()) {
            this.getNetwork().getLog().trace("doRetrieveNetworkDeviceInfo");
        }
        this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinityPollForControllerInfoRequest());
    }

    public void doSyncTime() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLog().isTraceOn()) {
            this.getNetwork().getLog().trace("doSyncTime");
        }
        this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinitySetTimeRequest());
    }

    public BBlob doSaveScreenBufferToFile() {
        return BBlob.make((byte[])this.getScreen().screenBufferToString().getBytes());
    }

    public void doLoadScreenBufferFromFile(BBlob bBlob) {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLog().isTraceOn()) {
            this.getNetwork().getLog().trace("doLoadTestBuffer");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bBlob.copyBytes())));
        String[] stringArray = new String[49];
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        while (n3 < 49) {
            if (n3 < 24) {
                try {
                    stringArray[n3] = bufferedReader.readLine().substring(0, 80);
                    this.getScreen().setContentLine(n3, stringArray[n3]);
                }
                catch (IOException iOException) {
                    this.getScreen().setContentLine(n3, " ");
                }
            } else if (n3 < 48) {
                try {
                    stringArray[n3] = bufferedReader.readLine().substring(0, 80);
                    this.getScreen().setFormatLine(n3 - 24, stringArray[n3]);
                }
                catch (IOException iOException) {
                    this.getScreen().setContentLine(n3, " ");
                }
            } else if (n3 == 48) {
                try {
                    stringArray[n3] = bufferedReader.readLine();
                    int n4 = stringArray[n3].indexOf(91);
                    int n5 = stringArray[n3].indexOf(58, n4);
                    int n6 = stringArray[n3].indexOf(93);
                    n = Integer.parseInt(stringArray[n3].substring(n4 + 1, n5));
                    n2 = Integer.parseInt(stringArray[n3].substring(n5 + 1, n6));
                    this.getScreen().setPosition(new CursorPosition(n, n2));
                }
                catch (IOException iOException) {
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < 24) {
            this.fireTerminalUpdated((BValue)new BInfinityLine(n3, n3, n, n2, stringArray[n3], stringArray[n3 + 24]));
            ++n3;
        }
    }

    public BINavNode[] getNavChildren() {
        Object[] objectArray = super.getNavChildren();
        return (BINavNode[])ArrayUtil.addOne((Object[])objectArray, (Object)((Object)this.getNetworkDevice()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void receiveKeystrokes(String string) {
        Object object = this.stringLock;
        synchronized (object) {
            this.keystrokes = this.keystrokes + string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String getKeystrokes() {
        Object object = this.stringLock;
        synchronized (object) {
            String string = this.keystrokes;
            this.keystrokes = "";
            return string;
        }
    }

    public BVt100 getScreen() {
        return this.screen;
    }

    public int getLine() {
        return this.screen.getCursorPosition().getLine();
    }

    public CursorPosition getCursorPosition() {
        return this.screen.getCursorPosition();
    }

    public void doDumpScreenBuffer() {
        this.getScreen().doDumpScreen();
    }

    public void doGetMode() {
        System.out.println("Mode:" + Vt100Const.cursorModes[this.getScreen().getMode()]);
        System.out.println("Insert is " + (this.getScreen().isInsertMode() ? "on" : "off"));
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        if (!this.isRunning()) {
            return;
        }
        if (bl) {
            if (this.isDown()) {
                this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinityPollForControllerInfoRequest());
            }
            this.pingOk();
        } else {
            this.pingFail("not connected");
        }
        this.connected = bl;
    }

    public boolean isTerminalModeActive() {
        return this.terminalModeActive;
    }

    public boolean isReloadModeActive() {
        return this.reloadModeActive;
    }

    public void setReloadModeActive(boolean bl) {
        this.reloadModeActive = bl;
    }

    public Log getLog() {
        return ((BDdfSerialCommunicator)this.getCommunicator()).getLog();
    }

    public boolean isShouldAbortReload() {
        return this.shouldAbortReload;
    }

    public void setShouldAbortReload(boolean bl) {
        this.shouldAbortReload = bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.connected = true;
        this.stringLock = new Object();
        this.keystrokes = "";
        this.terminalModeActive = false;
        this.reloadModeActive = false;
        this.shouldAbortReload = false;
    }

    public BInfinityNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$andoverInfinity$BInfinityNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$andoverInfinity$BInfinityNetwork = BInfinityNetwork.class("[Lcom.tridium.andoverInfinity.BInfinityNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

