/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.ui.device;

import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import com.tridium.bacnetAws.datatypes.BBackupConfig;
import com.tridium.bacnetAws.datatypes.BCommControlConfig;
import com.tridium.bacnetAws.datatypes.BReinitializeDeviceConfig;
import com.tridium.bacnetAws.datatypes.BRestoreConfig;
import com.tridium.bacnetAws.ui.device.BBacnetAwsDeviceManager;
import com.tridium.bacnetOws.ui.device.BBacnetOwsDeviceManager;
import com.tridium.bacnetOws.ui.device.BacnetOwsDeviceController;
import com.tridium.util.TimeFormat;
import java.text.MessageFormat;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrController;

public class BacnetAwsDeviceController
extends BacnetOwsDeviceController {
    public final MgrController.MgrCommand deviceCommunicationControl;
    public final MgrController.MgrCommand reinitializeDevice;
    public final MgrController.MgrCommand backup;
    public final MgrController.MgrCommand restore;

    protected MgrController.IMgrCommand[] makeBacnetCommands() {
        return BacnetAwsDeviceController.append((MgrController.IMgrCommand[])super.makeBacnetCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.deviceCommunicationControl, this.reinitializeDevice, this.backup, this.restore});
    }

    protected void setBacnetCommandsEnable(boolean bl) {
        super.setBacnetCommandsEnable(bl);
        if (bl) {
            BComponent[] bComponentArray = this.getSelectedComponentsWithoutFolders();
            boolean bl2 = false;
            if (bComponentArray.length == 1) {
                bl2 = true;
            }
            this.deviceCommunicationControl.setEnabled(bl2);
            this.reinitializeDevice.setEnabled(bl2);
            this.backup.setEnabled(bl2);
            this.restore.setEnabled(bl2);
        } else {
            this.deviceCommunicationControl.setEnabled(false);
            this.reinitializeDevice.setEnabled(false);
            this.backup.setEnabled(false);
            this.restore.setEnabled(false);
        }
    }

    public CommandArtifact doDeviceCommunicationControl() throws Exception {
        try {
            BCommControlConfig bCommControlConfig = (BCommControlConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)this.lex().get("devCommCtrl.title"), (BObject)new BCommControlConfig());
            if (bCommControlConfig != null) {
                BComponent[] bComponentArray = this.getSelectedComponentsWithoutFolders();
                BBacnetDevice bBacnetDevice = (BBacnetDevice)bComponentArray[0];
                BBacnetNetwork bBacnetNetwork = ((BBacnetDeviceManager)this.getManager()).getNetwork();
                bCommControlConfig.setDeviceAddress((BBacnetAddress)bBacnetDevice.getAddress().newCopy());
                bCommControlConfig.setCharacterSet(bBacnetDevice.getCharacterSet());
                this.setJob(bBacnetNetwork.submitDeviceManagerJob((BValue)bCommControlConfig));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = MessageFormat.format(this.lex().get("devCommCtrl.fail"), exception);
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("devCommCtrl.title"), (Object)string);
        }
        return null;
    }

    public CommandArtifact doReinitializeDevice() throws Exception {
        try {
            BReinitializeDeviceConfig bReinitializeDeviceConfig = (BReinitializeDeviceConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)this.lex().get("reinitDevice.title"), (BObject)new BReinitializeDeviceConfig());
            if (bReinitializeDeviceConfig != null) {
                BComponent[] bComponentArray = this.getSelectedComponentsWithoutFolders();
                BBacnetDevice bBacnetDevice = (BBacnetDevice)bComponentArray[0];
                BBacnetNetwork bBacnetNetwork = ((BBacnetDeviceManager)this.getManager()).getNetwork();
                bReinitializeDeviceConfig.setDeviceAddress((BBacnetAddress)bBacnetDevice.getAddress().newCopy());
                bReinitializeDeviceConfig.setCharacterSet(bBacnetDevice.getCharacterSet());
                this.setJob(bBacnetNetwork.submitDeviceManagerJob((BValue)bReinitializeDeviceConfig));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = MessageFormat.format(this.lex().get("reinitDevice.fail"), exception);
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("reinitDevice.title"), (Object)string);
        }
        return null;
    }

    public CommandArtifact doBackup() throws Exception {
        try {
            BOrd bOrd = BDirectoryChooser.show((BWidget)this.getManager());
            if (bOrd == null) {
                return null;
            }
            BBackupConfig bBackupConfig = new BBackupConfig();
            bBackupConfig.setBaseDirectory(bOrd);
            BComponent[] bComponentArray = this.getSelectedComponentsWithoutFolders();
            BBacnetDevice bBacnetDevice = (BBacnetDevice)bComponentArray[0];
            String string = TimeFormat.format((BAbsTime)Clock.time(), (String)"YYYYMMDD_HHmm");
            bBackupConfig.setDeviceDirectoryName(bBacnetDevice.getName() + string);
            bBackupConfig = (BBackupConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)this.lex().get("backup.title"), (BObject)bBackupConfig);
            if (bBackupConfig != null) {
                BBacnetNetwork bBacnetNetwork = ((BBacnetDeviceManager)this.getManager()).getNetwork();
                bBackupConfig.setDeviceAddress((BBacnetAddress)bBacnetDevice.getAddress().newCopy());
                bBackupConfig.setDeviceId(bBacnetDevice.getConfig().getDeviceObject().getObjectId());
                bBackupConfig.setCharacterSet(bBacnetDevice.getCharacterSet());
                this.learnMode.setSelected(true);
                this.setJob(bBacnetNetwork.submitDeviceManagerJob((BValue)bBackupConfig));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = MessageFormat.format(this.lex().get("backup.fail"), exception);
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("backup.title"), (Object)string);
        }
        return null;
    }

    public CommandArtifact doRestore() throws Exception {
        try {
            BOrd bOrd = BDirectoryChooser.show((BWidget)this.getManager());
            if (bOrd == null) {
                return null;
            }
            BRestoreConfig bRestoreConfig = new BRestoreConfig();
            bRestoreConfig.setDirectory(bOrd);
            BComponent[] bComponentArray = this.getSelectedComponentsWithoutFolders();
            BBacnetDevice bBacnetDevice = (BBacnetDevice)bComponentArray[0];
            bRestoreConfig = (BRestoreConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)this.lex().get("restore.title"), (BObject)bRestoreConfig);
            if (bRestoreConfig != null) {
                BBacnetNetwork bBacnetNetwork = ((BBacnetDeviceManager)this.getManager()).getNetwork();
                bRestoreConfig.setDeviceAddress((BBacnetAddress)bBacnetDevice.getAddress().newCopy());
                bRestoreConfig.setDeviceId(bBacnetDevice.getConfig().getDeviceObject().getObjectId());
                bRestoreConfig.setCharacterSet(bBacnetDevice.getCharacterSet());
                this.learnMode.setSelected(true);
                this.setJob(bBacnetNetwork.submitDeviceManagerJob((BValue)bRestoreConfig));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = MessageFormat.format(this.lex().get("restore.fail"), exception);
            BDialog.message((BWidget)this.getManager(), (String)this.lex().get("restore.title"), (Object)string);
        }
        return null;
    }

    private final UiLexicon lex() {
        return BBacnetAwsDeviceManager.wslex;
    }

    protected BacnetAwsDeviceController(BBacnetAwsDeviceManager bBacnetAwsDeviceManager) {
        super((BBacnetOwsDeviceManager)bBacnetAwsDeviceManager);
        this.deviceCommunicationControl = new DeviceCommunicationControl((BWidget)bBacnetAwsDeviceManager);
        this.reinitializeDevice = new ReinitializeDevice((BWidget)bBacnetAwsDeviceManager);
        this.backup = new Backup((BWidget)bBacnetAwsDeviceManager);
        this.restore = new Restore((BWidget)bBacnetAwsDeviceManager);
        this.deviceCommunicationControl.setFlags(7);
        this.reinitializeDevice.setFlags(7);
        this.backup.setFlags(7);
        this.restore.setFlags(7);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DeviceCommunicationControl
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return BacnetAwsDeviceController.this.doDeviceCommunicationControl();
        }

        DeviceCommunicationControl(BWidget bWidget) {
            super(bWidget, (Lexicon)BacnetAwsDeviceController.this.lex(), "devCommCtrl");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReinitializeDevice
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return BacnetAwsDeviceController.this.doReinitializeDevice();
        }

        ReinitializeDevice(BWidget bWidget) {
            super(bWidget, (Lexicon)BacnetAwsDeviceController.this.lex(), "reinitDevice");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Backup
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return BacnetAwsDeviceController.this.doBackup();
        }

        Backup(BWidget bWidget) {
            super(bWidget, (Lexicon)BacnetAwsDeviceController.this.lex(), "backup");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Restore
    extends MgrController.MgrCommand {
        public CommandArtifact doInvoke() throws Exception {
            return BacnetAwsDeviceController.this.doRestore();
        }

        Restore(BWidget bWidget) {
            super(bWidget, (Lexicon)BacnetAwsDeviceController.this.lex(), "restore");
        }
    }
}

